/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import jsbchart.core.PanelTemplate;
import jsbugs.DialogList;
import jsbugs.DialogPermissions;
import jsbugs.DialogSet;
import jsbugs.DialogTable;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.InternalFrameGroup;
import jsbugs.TableModelPanelTemplates;
import jsbugs.list.RestrictableProjectListCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.SBChart;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TxGroup;
import model3.TxGroupSet;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class JPanelSets
extends JPanel
implements Observer {
    private final FrameTaxaDB parent;
    private final SBdb sbdb;
    private final DefaultListModel setModel = new DefaultListModel();
    private JLabel jLabel1;
    private JList jListSets;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemOpenGroups;
    private JMenuItem jMenuItemPermissions;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane3;
    private JPopupMenu.Separator jSeparator1;

    @Override
    public void update(Observable obs, Object obj) {
        if (obs instanceof TxGroupSet) {
            EventQueue.invokeLater(new Runnable(this){
                final /* synthetic */ JPanelSets this$0;
                {
                    JPanelSets jPanelSets = this$0;
                    Objects.requireNonNull(jPanelSets);
                    this.this$0 = jPanelSets;
                }

                @Override
                public void run() {
                    this.this$0.jListSets.repaint();
                }
            });
        } else if (obj != null && obj instanceof TxGroupSet) {
            EventQueue.invokeLater(new Runnable(this){
                final /* synthetic */ JPanelSets this$0;
                {
                    JPanelSets jPanelSets = this$0;
                    Objects.requireNonNull(jPanelSets);
                    this.this$0 = jPanelSets;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.loadSets();
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error", sql, this.this$0.sbdb);
                    }
                }
            });
        }
    }

    public JPanelSets(FrameTaxaDB parent, SBdb db) throws SQLException {
        this.parent = parent;
        this.sbdb = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.sbdb.addObserver(this);
        this.jListSets.setCellRenderer(new RestrictableProjectListCellRenderer());
        this.jListSets.repaint();
        if (!SBRestrictable.canWrite(this.sbdb)) {
            this.jMenuItemDelete.setEnabled(false);
        }
    }

    void loadSets() throws SQLException {
        this.setModel.clear();
        List<TxGroupSet> sets = this.parent.showAllProjects() ? new ArrayList<TxGroupSet>(this.sbdb.getTxGroupSets()) : this.sbdb.getTxGroupSets(this.parent.getProjID(), this.parent.showGlobal());
        Collections.sort(sets, new TxGroupSetComparator());
        for (TxGroupSet set : sets) {
            this.setModel.addElement(set);
        }
    }

    void addSet() {
        try {
            DialogSet dialog = new DialogSet(this.parent, true, this.sbdb, null);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.set != null) {
                this.loadSets();
                this.jListSets.setSelectedValue(dialog.set, true);
                if (!this.parent.isProjectCurrentlyVisible(dialog.set.getProjID())) {
                    this.parent.setProject(dialog.set.getProjID());
                }
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    void editSet() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            DialogSet dialog = new DialogSet(this.parent, true, this.sbdb, set);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                if (!this.parent.isProjectCurrentlyVisible(set.getProjID())) {
                    this.parent.setProject(set.getProjID());
                }
                this.jListSets.repaint();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showGroups() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (TxGroup group : set.getGroups()) {
                InternalFrameGroup frame = this.parent.getGroupFrame(group);
                if (frame != null) {
                    frame.setIcon(false);
                    frame.setVisible(true);
                    frame.setLocation(50, 50);
                    continue;
                }
                this.parent.createInternalFrameGroup(group);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showLegacyCharts() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList<SBChart> groupSetCharts = new LinkedList<SBChart>();
            LinkedList charts = new LinkedList();
            SBChart.load(this.sbdb, charts, "%");
            for (SBChart chart : charts) {
                chart.loadData();
                if (!chart.hasSet(set.getID())) continue;
                groupSetCharts.add(chart);
            }
            if (!groupSetCharts.isEmpty()) {
                DialogList.displayListDialog(this.parent, "Charts containing set: " + set.toString(), new UserPrefsHelper(this.sbdb), groupSetCharts, null);
            } else {
                JOptionPane.showMessageDialog(this.parent, "Set does not appear in any charts", set.getName(), 1);
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSet() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete set: " + String.valueOf(set) + "?", this.parent.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            if (!this.parent.parent.getChartManager().checkDeleteTxGroupSet(set.getID())) {
                JOptionPane.showMessageDialog(this, "Set is used in charts and cannot be deleted.", "Delete Group Set", 2);
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Check legacy charts for this set?", this.parent.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                LinkedList<SBChart> setCharts = new LinkedList<SBChart>();
                LinkedList charts = new LinkedList();
                SBChart.load(this.sbdb, charts, "%");
                for (SBChart chart : charts) {
                    chart.loadData();
                    if (!chart.hasSet(set.getID())) continue;
                    setCharts.add(chart);
                }
                if (!setCharts.isEmpty()) {
                    DialogList.displayListDialog(this.parent, "Charts containing set: " + set.toString(), new UserPrefsHelper(this.sbdb), setCharts, null);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Set not linked to charts.\nContinue to delete?", this.parent.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            this.sbdb.deleteTxGroupSet(set);
            this.setModel.removeElement(set);
            this.sbdb.commit();
            this.jListSets.repaint();
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public TxGroupSet getSelectedSet() {
        return this.getSelected();
    }

    void showChartUsages() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            List<PanelTemplate> panels = this.parent.parent.getChartManager().getTxGroupSetPanels(set.getID());
            if (panels.isEmpty()) {
                JOptionPane.showMessageDialog(this.parent, "This set is not used in any chart panels.", "Set Usage", 2);
                return;
            }
            TableModelPanelTemplates model = new TableModelPanelTemplates(this.sbdb, this.parent.parent.getChartManager());
            model.setTemplates(panels);
            DialogTable dialog = new DialogTable(this.parent, true, (AbstractTableModel)model, "Chart Panels Using Set : " + set.getName(), false);
            model.setupTable(dialog.getTable());
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemOpenGroups = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemPermissions = new JMenuItem();
        this.jScrollPane3 = new JScrollPane();
        this.jListSets = new JList();
        this.jLabel1 = new JLabel();
        this.jMenuItemOpenGroups.setText("Open groups");
        this.jMenuItemOpenGroups.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelSets this$0;
            {
                JPanelSets jPanelSets = this$0;
                Objects.requireNonNull(jPanelSets);
                this.this$0 = jPanelSets;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemOpenGroupsActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemOpenGroups);
        this.jPopupMenu1.add(this.jSeparator1);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelSets this$0;
            {
                JPanelSets jPanelSets = this$0;
                Objects.requireNonNull(jPanelSets);
                this.this$0 = jPanelSets;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemDelete);
        this.jMenuItemPermissions.setText("Permissions...");
        this.jMenuItemPermissions.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelSets this$0;
            {
                JPanelSets jPanelSets = this$0;
                Objects.requireNonNull(jPanelSets);
                this.this$0 = jPanelSets;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItemPermissionsActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemPermissions);
        this.setMinimumSize(new Dimension(0, 100));
        this.setPreferredSize(new Dimension(100, 429));
        this.jScrollPane3.setMinimumSize(new Dimension(0, 0));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 130));
        this.jListSets.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSets.setModel(this.setModel);
        this.jListSets.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ JPanelSets this$0;
            {
                JPanelSets jPanelSets = this$0;
                Objects.requireNonNull(jPanelSets);
                this.this$0 = jPanelSets;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.this$0.jListSetsMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.this$0.jListSetsMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListSetsMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListSets);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setText("Sets:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 80, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 387, Short.MAX_VALUE).addContainerGap()));
    }

    private TxGroupSet getSelected() {
        TxGroupSet set = (TxGroupSet)this.jListSets.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this.parent, "No set selected", this.parent.getTitle(), 2);
        }
        return set;
    }

    private void jListSetsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemOpenGroupsActionPerformed(ActionEvent evt) {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (TxGroup group : set.getGroups()) {
                InternalFrameGroup frame = this.parent.getGroupFrame(group);
                if (frame != null) {
                    frame.setIcon(false);
                    frame.setVisible(true);
                    frame.setLocation(50, 50);
                    return;
                }
                this.parent.createInternalFrameGroup(group);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jListSetsMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.deleteSet();
    }

    private void jMenuItemPermissionsActionPerformed(ActionEvent evt) {
        this.permissions();
    }

    private void jListSetsMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    void permissions() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            JOptionPane.showMessageDialog(this, "Select one set", this.parent.getTitle(), 2);
            return;
        }
        try {
            DialogPermissions dialog = new DialogPermissions(this.parent, true, this.sbdb, (SBRestrictable)set, null);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private static class TxGroupSetComparator
    implements Comparator<TxGroupSet> {
        private TxGroupSetComparator() {
        }

        @Override
        public int compare(TxGroupSet o1, TxGroupSet o2) {
            if (o1.getProjID() == 0 && o2.getProjID() == 0) {
                return o1.compareTo(o2);
            }
            if (o1.getProjID() == 0) {
                return -1;
            }
            if (o2.getProjID() == 0) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

