/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.wellinterp.LOCNode;
import java.awt.event.MouseMotionListener;
import java.sql.SQLException;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.depthage.DepthAgeTextFieldBuilder;
import jsbugs.table.AlignedHeaderRenderer;
import jsbugs.table.DecimalRenderer;
import jsbugs.table.EditableComboCellRenderer;
import jsbugs.table.PaddingCellRenderer;
import jsbugs.table.SampleDistance;
import jsbugs.table.SampleDistanceRenderer;
import jsbugs.util.SampleUtils;
import model3.IGDIntervalZone;
import model3.LOC;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.table.ColumnHeaderToolTips;

public class LOCTableModel
extends TableModelSB {
    private char units = (char)77;
    char type = (char)87;
    private WellInterp interp;
    private int wellID = -1;
    SBdb db;
    private String[] columnTitles = new String[]{"Depth", "Age", "Style", "Accumulation rate/Disconformity duration", "Nearest Sample"};
    private static final int[] defaultColumnWidths = new int[]{100, 100, 120, 400, 410};
    public static final int COL_DEPTH = 0;
    public static final int COL_AGE = 1;
    public static final int COL_STYLE = 2;
    public static final int COL_LENGTH = 3;
    public static final int COL_DISTANCE = 4;
    JComboBox bndEditor = new JComboBox();
    private AgeFormat ageFormat = AgeFormat.MA;
    private Well well;
    private SampleDistanceRenderer sampleDistanceRenderer;

    @Override
    public int getColumnCount() {
        return this.columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.getLOC() == null) {
            return null;
        }
        LOCNode node = this.getLOC().getNode(row);
        switch (col) {
            case 0: {
                return DepthUtils.convFromM((double)node.getDepth(), (char)this.units, (char)this.type);
            }
            case 1: {
                return node.getAge() * this.ageFormat.getMultiplyer();
            }
            case 2: {
                return node.getBoundaryType();
            }
            case 4: {
                SampleDistance value = null;
                try {
                    double nodeDepth = node.getDepth();
                    Sample closest = SampleUtils.findNearestSample(nodeDepth, this.well.getSamples());
                    if (closest == null) {
                        value = SampleDistance.NoSingleSampleFound();
                    } else {
                        boolean multipleNodes = this.countNodesAtDepth(nodeDepth) > 1;
                        value = new SampleDistance(closest, closest.getDepth() - nodeDepth, multipleNodes);
                    }
                }
                catch (SQLException ex) {
                    System.out.print(ex);
                }
                return value;
            }
            case 3: {
                if (row >= this.getLOC().getSize() - 1) break;
                return this.getLOC().getRateString(node, this.units, this.ageFormat, this.well);
            }
        }
        return "";
    }

    private int countNodesAtDepth(double depth) {
        int count = 0;
        if (this.getLOC() == null) {
            return count;
        }
        for (LOCNode node : this.getLOC().getNodes()) {
            if (node.getDepth() != depth) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.getLOC() == null) {
            return;
        }
        LOCNode node = this.getLOC().getNode(row);
        switch (col) {
            case 0: {
                try {
                    double depth = Double.parseDouble(obj.toString());
                    this.interp.updateLOCNode(node, DepthUtils.convToM((double)depth, (char)this.units, (char)this.type), node.getAge(), node.getBnd(), this.wellID);
                }
                catch (NumberFormatException depth) {
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(null, ife.getMessage(), "Node editor", 2);
                }
                catch (SQLException | SBException sql) {
                    FrameJsbugs.showStackError("Error updating node", (Exception)sql, this.db);
                }
                break;
            }
            case 1: {
                try {
                    double age = Double.parseDouble(obj.toString());
                    this.interp.updateLOCNode(node, node.getDepth(), age /= this.ageFormat.getMultiplyer(), node.getBnd(), this.wellID);
                }
                catch (NumberFormatException age) {
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(null, ife.getMessage(), "Node editor", 2);
                }
                catch (SQLException | SBException sql) {
                    FrameJsbugs.showStackError("Error updating node", (Exception)sql, this.db);
                }
                break;
            }
            case 2: {
                try {
                    String style = obj.toString();
                    this.interp.updateLOCNode(node, node.getDepth(), node.getAge(), IGDIntervalZone.getBoundaryTypeFromString(style), this.wellID);
                    break;
                }
                catch (NumberFormatException style) {
                    break;
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(null, ife.getMessage(), "Node editor", 2);
                    break;
                }
                catch (SQLException | SBException sql) {
                    FrameJsbugs.showStackError("Error updating node", (Exception)sql, this.db);
                }
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.getLOC() == null) {
            return 0;
        }
        return this.getLOC().getSize();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 4: {
                return SampleDistance.class;
            }
            case 0: 
            case 1: {
                return Double.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setupTable(JTable jTableLOC, SBdb sbdb) {
        this.db = sbdb;
        this.init(jTableLOC, this.db);
        TableColumnModel columns = jTableLOC.getColumnModel();
        this.bndEditor.setModel(new DefaultComboBoxModel<String>(IGDIntervalZone.bnds));
        columns.getColumn(2).setCellEditor(new DefaultCellEditor(this.bndEditor));
        columns.getColumn(2).setCellRenderer(new EditableComboCellRenderer(true));
        this.sampleDistanceRenderer = new SampleDistanceRenderer(this.units);
        columns.getColumn(3).setCellRenderer(new PaddingCellRenderer());
        columns.getColumn(4).setCellRenderer(this.sampleDistanceRenderer);
        jTableLOC.getTableHeader().setDefaultRenderer(new AlignedHeaderRenderer(0, jTableLOC.getTableHeader().getDefaultRenderer()));
        String[] tips = new String[this.columnTitles.length];
        tips[3] = "<html>Sedimentation rate (depth units/Ma)<br>or duration of unconformity (Ma)</html>";
        jTableLOC.getTableHeader().addMouseMotionListener((MouseMotionListener)ColumnHeaderToolTips.createColumnHeaderToolTips((String[])tips, (JTable)jTableLOC));
        this.updateCellEditors(jTableLOC);
        this.restoreColumnOrder(jTableLOC);
    }

    public void updateCellEditors(JTable jTableLOC) {
        TableColumnModel columns = jTableLOC.getColumnModel();
        DecimalRenderer ageRenderer = null;
        ageRenderer = this.ageFormat == AgeFormat.MA ? new DecimalRenderer(true, "0.000") : new DecimalRenderer(true, "0");
        ageRenderer.setHorizontalAlignment(4);
        columns.getColumn(1).setCellRenderer(ageRenderer);
        DecimalRenderer depthRenderer = DepthUnits.getUnits((char)this.units) == DepthUnits.F ? new DecimalRenderer(true, "0.00") : new DecimalRenderer(true, "0.00");
        depthRenderer.setHorizontalAlignment(4);
        columns.getColumn(0).setCellRenderer(depthRenderer);
        TableColumnModel tcm = jTableLOC.getColumnModel();
        tcm.getColumn(1).setCellEditor(DepthAgeTextFieldBuilder.BuildNodeAgeCellEditor(this.ageFormat));
        tcm.getColumn(0).setCellEditor(DepthAgeTextFieldBuilder.BuildNodeDepthCellEditor(this.units));
    }

    @Override
    void setDefaultColumnWidths() {
        System.arraycopy(this.getDefaultColumnWidths(), 0, this.getColumnWidths(), 0, this.getDefaultColumnWidths().length);
    }

    public LOC getLOC() {
        if (this.interp == null) {
            return null;
        }
        return this.interp.getLOC();
    }

    public AgeFormat setLOC(WellInterp interp, JTable jTableLOC, int wellID, Well well) throws SQLException, SBException {
        this.interp = interp;
        this.wellID = wellID;
        this.well = well;
        if (interp.getLOC() != null) {
            this.ageFormat = interp.getLOC().getAgeFormatIdeal();
        }
        return this.ageFormat;
    }

    @Override
    public void setUnits(char units) {
        this.units = units;
        if (this.sampleDistanceRenderer != null) {
            this.sampleDistanceRenderer.setUnits(units);
        }
    }

    @Override
    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    public String getPrefString() {
        return "TMLOC";
    }

    @Override
    public String getPrefOrderString() {
        return "TOLOC";
    }

    @Override
    public final String getAutoResizeString() {
        return "TARLOC";
    }

    void setAgeFormat(AgeFormat af) {
        this.ageFormat = af;
    }

    AgeFormat getAgeFormat() {
        return this.ageFormat;
    }
}

