/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.util.ui.table.TableUtils;
import java.sql.SQLException;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.TaxonCount;
import jsbugs.table.ComboRenderer;
import model3.SBdb;
import model3.Taxon;

class MergeTaxonTableModel
extends AbstractTableModel {
    List<TaxonCount> taxa;
    int synSchemeID = 1;
    static final String SPEC_TYPE_DEFAULT = "";
    private static final String[] columnTitles = new String[]{"ID", "Category", "Name", "No. Analyses", "To sub-type/qualifier"};
    private static final int[] columnWidths = new int[]{25, 25, 150, 40, 60, 60};
    private static final int COL_ID = 0;
    private static final int COL_CAT = 1;
    private static final int COL_NAME = 2;
    private static final int COL_NOCCS = 3;
    private static final int COL_QUAL = 4;
    private final JComboBox specTypeCombo = new JComboBox();

    MergeTaxonTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.taxa == null) {
            return SPEC_TYPE_DEFAULT;
        }
        TaxonCount taxon = this.taxa.get(row);
        switch (col) {
            case 0: {
                return taxon.taxon.getSpecID();
            }
            case 1: {
                return taxon.taxon.getCatMnem();
            }
            case 2: {
                Object strg = taxon.taxon.toString(true, false);
                if (!taxon.taxon.getAlphaCode().isEmpty()) {
                    strg = (String)strg + " (" + taxon.taxon.getAlphaCode() + ")";
                }
                return strg;
            }
            case 3: {
                return taxon.nOccs;
            }
            case 4: {
                return taxon.targetSpecType;
            }
        }
        return SPEC_TYPE_DEFAULT;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        TaxonCount taxonCount = this.taxa.get(row);
        switch (col) {
            case 4: {
                taxonCount.targetSpecType = obj;
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.taxa == null) {
            return 0;
        }
        return this.taxa.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: 
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    void setupTable(JTable jTableMerge, SBdb sbdb) throws SQLException {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTableMerge.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            jTableMerge.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        TableUtils.setTableHeaderBold((JTable)jTableMerge);
        this.specTypeCombo.addItem(SPEC_TYPE_DEFAULT);
        this.specTypeCombo.insertItemAt(Taxon.OccType.REWORKED, 1);
        this.specTypeCombo.insertItemAt(Taxon.OccType.CAVED, 2);
        this.specTypeCombo.insertItemAt(Taxon.OccType.QUESTIONABLE, 3);
        for (SpeciesType specType : sbdb.getSpeciesTypeService().getAllSpeciesTypes()) {
            if (specType.specTypeID() <= 0) continue;
            this.specTypeCombo.addItem(specType.description());
        }
        jTableMerge.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(this.specTypeCombo));
        jTableMerge.getColumnModel().getColumn(4).setCellRenderer(new ComboRenderer());
    }
}

