/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import jsbchart.core.BlockTemplate;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationStandard;
import jsbchart.correlation.CorrelationTemplate;

public class SBChartTransfer
implements Transferable {
    private final Object template;
    private DataFlavor[] flavors;

    SBChartTransfer(Object template) {
        this.template = template;
        try {
            if (template instanceof PanelTemplate) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=jsbchart.core.PanelTemplate")};
            } else if (template instanceof BlockTemplate) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=jsbchart.core.BlockTemplate")};
            } else if (template instanceof CorrelationTemplate) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationTemplate")};
            } else if (template instanceof CorrelationStandard) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationStandard")};
            } else {
                System.out.println("Unexpected transfer flavour");
                this.flavors = new DataFlavor[0];
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error setting up data flavor array in SBPanelTemplate");
            this.flavors = new DataFlavor[0];
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (this.template instanceof PanelTemplate && flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.core.PanelTemplate")) {
            return true;
        }
        if (this.template instanceof BlockTemplate && flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.core.BlockTemplate")) {
            return true;
        }
        if (this.template instanceof CorrelationTemplate && flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationTemplate")) {
            return true;
        }
        return this.template instanceof CorrelationStandard && flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationStandard");
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.core.PanelTemplate") || flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.core.BlockTemplate") || flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationTemplate") || flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref;class=jsbchart.correlation.CorrelationStandard")) {
            return this.template;
        }
        return null;
    }

    public boolean isPanelTransfer() {
        return this.template instanceof PanelTemplate;
    }

    public boolean isBlockTransfer() {
        return this.template instanceof BlockTemplate;
    }

    public boolean isCorrTransfer() {
        return this.template instanceof CorrelationTemplate;
    }

    public boolean isCorrStdTransfer() {
        return this.template instanceof CorrelationStandard;
    }
}

