/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.SBEvent;
import model3.Taxon;
import util.SB;

class SBEventsTableModel
extends AbstractTableModel {
    private List<SBEvent> events = null;
    private List<SBEvent> unFilteredEvents = null;
    static final int COLTYPE = 0;
    static final int COLNAME = 1;
    static final int COLABBR = 2;
    static final int COLTAXON = 3;
    static final int COLDISC = 4;
    static final int COLGENERATE = 5;
    static String[] columnHeaders = new String[]{"Type", "Name", "Abbr.", "Taxon", "Disc.", "Use to gen. top/base?"};
    static int[] columnWidths = new int[]{60, 180, 30, 180, 30, 20};

    SBEventsTableModel() {
    }

    void setEvents(List<SBEvent> events) {
        Collections.sort(events);
        this.events = events;
        if (events != null) {
            this.unFilteredEvents = new LinkedList<SBEvent>();
            this.unFilteredEvents.addAll(events);
        }
    }

    List<SBEvent> getEvents() {
        return this.events;
    }

    @Override
    public int getColumnCount() {
        return columnHeaders.length;
    }

    @Override
    public int getRowCount() {
        if (this.events == null) {
            return 0;
        }
        return this.events.size();
    }

    public void setSize(int i) {
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.events == null) {
            return;
        }
        SBEvent event = this.events.get(row);
        switch (col) {
            default: 
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.events == null) {
            return "";
        }
        try {
            switch (col) {
                default: {
                    return "";
                }
                case 0: {
                    return this.events.get(row).getCombinedPrefix();
                }
                case 1: {
                    return this.events.get(row).getName();
                }
                case 2: {
                    return this.events.get(row).getAbr();
                }
                case 3: {
                    return this.events.get(row).getTaxon();
                }
                case 4: {
                    return this.events.get(row).getTaxon() != null ? this.events.get(row).getTaxon().getDisc().getAbr(true) : "";
                }
                case 5: 
            }
            return this.events.get(row).isGenerate();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 3: {
                return Taxon.class;
            }
            case 5: 
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        switch (c) {
            case 5: {
                return true;
            }
        }
        return false;
    }

    void setupTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnHeaders.length; ++i) {
            columnModel.getColumn(i).setHeaderValue(columnHeaders[i]);
            columnModel.getColumn(i).setPreferredWidth(columnWidths[i]);
        }
    }

    void filterClear() {
        if (this.unFilteredEvents != null) {
            this.events.clear();
            this.events.addAll(this.unFilteredEvents);
        }
    }

    void filterEvents(CompositeStandard cmpStd, boolean include) {
        if (this.events == null) {
            return;
        }
        if (this.unFilteredEvents == null) {
            this.unFilteredEvents = new LinkedList<SBEvent>();
            this.unFilteredEvents.addAll(this.events);
        } else {
            this.events.clear();
            this.events.addAll(this.unFilteredEvents);
        }
        if (this.events.isEmpty()) {
            return;
        }
        Iterator<SBEvent> it = this.events.iterator();
        while (it.hasNext()) {
            SBEvent event = it.next();
            boolean found = false;
            for (CompositeStandardEvent cmpStdEv : cmpStd.getEvents(true)) {
                if (cmpStdEv.getEvent() != event) continue;
                found = true;
                break;
            }
            if (!found && include) {
                it.remove();
                continue;
            }
            if (!found || include) continue;
            it.remove();
        }
    }
}

