/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import util.SB;
import util.SBException;

class TableModelCodes
extends AbstractTableModel {
    static final String[] titles = new String[]{"Taxon", "Code"};
    static final int[] widths = new int[]{120, 20};
    List<TableItem> taxa;
    int dict = 0;

    TableModelCodes() {
    }

    @Override
    public int getColumnCount() {
        return titles.length;
    }

    @Override
    public int getRowCount() {
        if (this.taxa == null) {
            return 0;
        }
        return this.taxa.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.taxa.size()) {
            switch (col) {
                case 0: {
                    return this.taxa.get((int)row).taxon.toString(false);
                }
                case 1: {
                    return this.taxa.get((int)row).code;
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (obj == null) {
            return;
        }
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                TableItem item = this.taxa.get(row);
                try {
                    item.code = (Integer)obj;
                    break;
                }
                catch (NumberFormatException e) {
                    System.out.println("number format exception caught");
                }
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 1: 
        }
        return true;
    }

    void initTable(JTable table) {
        SB.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(titles[i]);
            columnModel.getColumn(i).setPreferredWidth(widths[i]);
        }
    }

    void setData(int dict, LinkedList<TxGroup> groups, SBdb sbdb) throws SQLException, SBException {
        if (this.taxa == null || this.dict != dict) {
            this.dict = dict;
            this.taxa = new LinkedList<TableItem>();
            HashSet<Taxon> uniqueSet = new HashSet<Taxon>();
            for (TxGroup group : groups) {
                uniqueSet.addAll(sbdb.getTxGroupTaxa(group));
            }
            LinkedList<Taxon> uniqueList = new LinkedList<Taxon>();
            uniqueList.addAll(uniqueSet);
            Collections.sort(uniqueList);
            for (Taxon taxon : uniqueList) {
                this.taxa.add(new TableItem(this, taxon, dict));
            }
        }
    }

    class TableItem {
        Taxon taxon;
        Integer code;

        TableItem(TableModelCodes this$0, Taxon taxon, int dict) throws SQLException {
            Objects.requireNonNull(this$0);
            this.taxon = taxon;
            this.code = taxon.getSipmCode(dict);
        }
    }
}

