/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.table.AbstractTableModel;
import jsbugs.TableModelSB;
import model3.IGDInterval;
import model3.Intcom;
import model3.Sample;
import util.DepthUtils;
import util.MatchData;
import util.status.DoubleStatus;
import util.status.StringStatus;

class TableModelMatchIntcom
extends AbstractTableModel {
    static final int COL_WS_TOP = 0;
    static final int COL_WS_BASE = 1;
    static final int COL_WS_TYPE = 2;
    static final int COL_WS_TEXT = 3;
    static final int COL_ARROW = 4;
    static final int COL_DB_TOP = 5;
    static final int COL_DB_BASE = 6;
    static final int COL_DB_TYPE = 7;
    static final int COL_DB_TEXT = 8;
    static final String[] colTitles = new String[]{"From", "To", "Type", "Text", "", "From", "To", "Type", "Text"};
    static final int[] colWidths = new int[]{30, 30, 30, 70, 20, 30, 30, 30, 70};
    MatchData data = new MatchData();
    char units = (char)77;
    char wellType = (char)87;

    TableModelMatchIntcom() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        Intcom ws = (Intcom)pair.getWs();
        Intcom db = (Intcom)pair.getDb();
        switch (columnIndex) {
            case 0: {
                return ws == null ? null : new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getTopDepth(), (char)this.units, (char)this.wellType)), ws.getStatus());
            }
            case 1: {
                return ws == null ? null : new DoubleStatus(Double.valueOf(DepthUtils.convFromM((double)ws.getBaseDepth(), (char)this.units, (char)this.wellType)), ws.getStatus());
            }
            case 2: {
                if (ws != null) {
                    String text = ws.getIGDType() > 0 ? IGDInterval.getIGDName(ws.getIGDType()) : "";
                    return new StringStatus(text, ws.getStatus());
                }
                return null;
            }
            case 3: {
                return ws == null ? "" : new StringStatus(ws.getComments(), ws.getStatus());
            }
            case 4: {
                return ws != null && db != null && ws.getStatus() == Sample.STORED ? TableModelSB.linked : TableModelSB.unlinked;
            }
            case 5: {
                return db != null ? Double.valueOf(DepthUtils.convFromM((double)db.getTopDepth(), (char)this.units)) : null;
            }
            case 6: {
                return db != null ? Double.valueOf(DepthUtils.convFromM((double)db.getBaseDepth(), (char)this.units)) : null;
            }
            case 7: {
                return db != null ? (db.getIGDType() > 0 ? IGDInterval.getIGDName(db.getIGDType()) : "") : null;
            }
            case 8: {
                return db != null ? db.getComments() : null;
            }
        }
        return "";
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return DoubleStatus.class;
            }
            case 2: 
            case 3: {
                return StringStatus.class;
            }
            case 4: {
                return Boolean.class;
            }
            case 5: 
            case 6: {
                return Double.class;
            }
        }
        return String.class;
    }
}

