/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.SampleRenderer;
import jsbugs.table.SampleStatusRenderer;
import model3.SBdb;
import model3.Sample;
import model3.WellEvent;
import util.MatchData;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

class TableModelMatchWellEvents
extends AbstractTableModel {
    static final int COL_WS_SAMPLE = 0;
    static final int COL_WS_EVENT = 1;
    static final int COL_WS_TYPE = 2;
    static final int COL_WS_DISC = 3;
    static final int COL_WS_ANALYST = 4;
    static final int COL_ARROW = 5;
    static final int COL_DB_SAMPLE = 6;
    static final int COL_DB_EVENT = 7;
    static final int COL_DB_TYPE = 8;
    static final int COL_DB_DISC = 9;
    static final int COL_DB_ANALYST = 10;
    static final String[] colTitles = new String[]{"Sample", "Event", "Type", "Disc.", "Analyst", "", "Sample", "Event", "Type", "Disc.", "Analyst"};
    static final int[] colWidths = new int[]{30, 60, 20, 20, 20, 20, 30, 60, 20, 20, 20};
    char units = (char)77;
    MatchData<WellEvent> data = new MatchData();

    TableModelMatchWellEvents() {
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MatchData.MatchPair pair = this.data.get(rowIndex);
        if (pair == null) {
            return "";
        }
        WellEvent ws = (WellEvent)pair.getWs();
        WellEvent db = (WellEvent)pair.getDb();
        if (ws != null) {
            ws.getSample().displayUnits = this.units;
        }
        if (db != null) {
            db.getSample().displayUnits = this.units;
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return ws == null ? null : ws.getSample();
                }
                case 1: {
                    return ws == null ? null : new StringStatus(ws.getEvent().toString(), ws.getStatus());
                }
                case 2: {
                    return ws == null ? null : new StringStatus(ws.getType(), ws.getStatus());
                }
                case 3: {
                    return ws == null ? null : new StringStatus(ws.getDiscID() > '\u0000' ? SBdb.getDiscAbr(ws.getDiscID()) : "", ws.getStatus());
                }
                case 4: {
                    return ws == null ? null : new StringStatus(ws.getAnalystString(), ws.getStatus());
                }
                case 5: {
                    return ws != null && db != null && ws.getStatus() == Sample.STORED;
                }
                case 6: {
                    return db != null ? db.getSample() : null;
                }
                case 7: {
                    return db != null ? db.getEvent().toString() : null;
                }
                case 8: {
                    return db != null ? db.getType() : "";
                }
                case 9: {
                    return db != null ? (db.getDiscID() > '\u0000' ? SBdb.getDiscAbr(db.getDiscID()) : "") : null;
                }
                case 10: {
                    return db != null ? db.getAnalystString() : null;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Sample.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return StringStatus.class;
            }
            case 5: {
                return Boolean.class;
            }
            case 6: {
                return Sample.class;
            }
        }
        return String.class;
    }

    void setUpTable(JTable table) {
        TableUtils.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(5).setMaxWidth(colWidths[5]);
        SampleStatusRenderer ssr = new SampleStatusRenderer(this.units);
        ssr.setShowUnits(true);
        ssr.setShowLabels(true);
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)((Object)ssr));
        SampleRenderer sr = new SampleRenderer(this.units);
        sr.setShowUnits(true);
        sr.setShowLabels(true);
        columnModel.getColumn(6).setCellRenderer(sr);
        table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }
}

