/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelTemplate;
import jsbugs.table.DateRenderer;
import jsbugs.table.PanelTypeRenderer;
import jsbugs.table.RestrictableRenderer;
import model3.SBdb;
import util.SB;

class TableModelPanelTemplates
extends AbstractTableModel {
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private static final int COL_DESCR = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_PROJECT = 2;
    private static final int COL_COMMENTS = 3;
    private static final int COL_MODIFIED = 4;
    private static final int COL_MODIFIER = 5;
    private static final int COL_USAGES = 6;
    private static final String[] colNames = new String[]{"Name", "Type", "Project", "Comments", "Modified", "By", "Usages"};
    private static final int[] colWidths = new int[]{50, 40, 20, 30, 20, 5, 5};
    private List<PanelTemplate> templs;

    void setTemplates(List<PanelTemplate> templs) {
        this.templs = templs;
        for (PanelTemplate t : templs) {
            t.resetNusages();
        }
    }

    List<PanelTemplate> getTemplates() {
        return this.templs;
    }

    TableModelPanelTemplates(SBdb sbdb, ChartManager chartManager) {
        this.sbdb = sbdb;
        this.chartManager = chartManager;
    }

    @Override
    public int getRowCount() {
        if (this.templs == null) {
            return 0;
        }
        return this.templs.size();
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.templs == null) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                return this.templs.get(rowIndex).getType();
            }
            case 0: {
                return this.templs.get(rowIndex);
            }
            case 2: {
                try {
                    int projID = this.templs.get(rowIndex).getProjID();
                    if (projID > 0) {
                        return this.sbdb.getProject(projID);
                    }
                    return "Global";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case 3: {
                return this.templs.get(rowIndex).getComments();
            }
            case 4: {
                return this.templs.get(rowIndex).getModified();
            }
            case 5: {
                int userID = this.templs.get(rowIndex).getModifier();
                if (userID > 0) {
                    try {
                        return this.sbdb.getUser(userID).getAbr();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 6: {
                try {
                    return this.templs.get(rowIndex).getNusages(this.chartManager);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 4: {
                return Date.class;
            }
            case 6: {
                return Integer.class;
            }
        }
        return super.getColumnClass(col);
    }

    void setupTable(JTable table) {
        for (int i = 0; i < colNames.length; ++i) {
            table.getColumnModel().getColumn(i).setHeaderValue(colNames[i]);
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
        }
        SB.setTableHeaderBold((JTable)table);
        table.getColumnModel().getColumn(4).setCellRenderer(new DateRenderer());
        table.getColumnModel().getColumn(0).setCellRenderer(new RestrictableRenderer());
        table.getColumnModel().getColumn(1).setCellRenderer(new PanelTypeRenderer());
    }
}

