/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.event.MouseMotionListener;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jsbugs.FloatRenderer;
import jsbugs.SampleLithologyCellRenderer;
import jsbugs.TableModelSB;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.DateRenderer;
import jsbugs.table.DepthCorrectionRenderer;
import jsbugs.table.DepthRenderer;
import model3.SBdb;
import model3.Sample;
import model3.SampleLithology;
import model3.Well;
import model3.WellInterp;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.table.ColumnHeaderToolTips;

class TableModelSamples
extends TableModelSB {
    private char units = (char)77;
    private WellInterp wellInterp = null;
    private Well well = null;
    private List<Sample> hiddenSamples = null;
    SBdb db;
    private boolean simpleDisplay = false;
    private boolean displayCuttingCorrections = true;
    private boolean showTVD = true;
    static final int COLTOP = 0;
    static final int COLTOPTVD = 1;
    static final int COLBASE = 2;
    static final int COLBASETVD = 3;
    static final int COLTYPE = 4;
    static final int COLLABEL = 5;
    static final int COLLOCAGE = 6;
    static final int COL_NANALY = 7;
    static final int COL_CORR = 8;
    static final int COLCREATED = 9;
    static final int COLMODIFIED = 10;
    static final int COLLITH = 11;
    static final int COLSTRAT = 12;
    static String[] columnHeaders = new String[]{"Top Depth", "Top TVD", "Base Depth", "Base TVD", "Type", "Label", "Interp. Age", "No.analy.", "Correction +/-", "Created", "Modified", "Lithology", "Stratigraphy"};
    String[] columnTooltips = new String[]{"Top Depth", "", "Base Depth", "", "Sample Type", "Label", "Calculated age from depth/age curve", "Number of analyses", "Core Correction +/-", "Created Date", "Modified Date", "Lithology % (cuttings log)", "Stratigraphy"};
    static final int[] simpleDisplayColumns = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int[] defaultColumnWidths = new int[]{90, 70, 90, 70, 30, 90, 70, 20, 90, 100, 100, 90, 100};

    public TableModelSamples(boolean simpleDisplay) {
        this.simpleDisplay = simpleDisplay;
    }

    void setSamples(Well well, Observer obs) throws SQLException, SBException {
        this.well = well;
        for (Sample s : well.getSamples()) {
            s.addWeakObserver(obs);
        }
        well.addObserver(obs);
    }

    List<Sample> getSamples() throws SQLException, SBException {
        if (this.well == null) {
            return null;
        }
        if (this.hiddenSamplesPresent()) {
            return this.getVisibleSamples();
        }
        return this.well.getSamples();
    }

    private List<Sample> getVisibleSamples() {
        if (this.well == null) {
            return null;
        }
        List<Sample> samples = null;
        try {
            samples = this.well.getSamples();
        }
        catch (SQLException ex) {
            Logger.getLogger(TableModelSamples.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.hiddenSamplesPresent() && samples != null) {
            for (Sample s : this.hiddenSamples) {
                if (!samples.contains(s)) continue;
                samples.remove(s);
            }
        }
        return samples;
    }

    @Override
    public String getColumnName(int col) {
        return columnHeaders[col] + (String)(switch (col) {
            case 0, 2 -> " (" + DepthUnits.getUnits((char)this.units).getAbr() + ")";
            default -> "";
        });
    }

    @Override
    public int getColumnCount() {
        return this.simpleDisplay ? simpleDisplayColumns.length : columnHeaders.length;
    }

    @Override
    public int getRowCount() {
        if (this.well == null) {
            return 0;
        }
        if (!this.hiddenSamplesPresent()) {
            return this.well.getnSamples();
        }
        List<Sample> visibleSamples = this.getVisibleSamples();
        if (visibleSamples == null) {
            return 0;
        }
        return visibleSamples.size();
    }

    public void setInterp(Well well, WellInterp interp, SBdb db) throws SQLException, SBException {
        this.wellInterp = interp;
        this.well = well;
        this.db = db;
        for (Sample sample : well.getSamples()) {
            sample.getStratigraphy(this.wellInterp, true);
        }
        this.columnTooltips[12] = interp.getHeader().toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int row, int col) {
        if (this.well == null) {
            return "";
        }
        List<Sample> visibleSamples = null;
        if (this.hiddenSamplesPresent()) {
            visibleSamples = this.getVisibleSamples();
        }
        Sample sample = null;
        sample = visibleSamples == null ? this.well.getnthSample(row) : visibleSamples.get(row);
        if (sample == null) {
            return "";
        }
        switch (col) {
            default: {
                return "";
            }
            case 0: {
                if (sample.hasTopDepth()) {
                    return sample.getTopDepth(this.units);
                }
                return null;
            }
            case 1: {
                if (!this.showTVD) {
                    return null;
                }
                if (!sample.hasTopDepth()) {
                    return null;
                }
                if (this.well.getTVDlist(false).getSize() > 0) {
                    return DepthUtils.convFromM((double)this.well.getTVDlist(false).getTVD(sample.getTopDepth()).getTVDepth(), (char)this.units);
                }
                return null;
            }
            case 2: {
                if (sample.hasBaseDepth()) {
                    return sample.getBaseDepth(this.units);
                }
                return null;
            }
            case 3: {
                if (!this.showTVD) {
                    return null;
                }
                if (!sample.hasBaseDepth()) {
                    return null;
                }
                if (this.well.getTVDlist(false).getSize() > 0) {
                    return DepthUtils.convFromM((double)this.well.getTVDlist(false).getTVD(sample.getBaseDepth()).getTVDepth(), (char)this.units);
                }
                return null;
            }
            case 4: {
                return sample.getType().getAbr();
            }
            case 5: {
                return sample.getLabel();
            }
            case 7: {
                return sample.getSmpdtls().size();
            }
            case 8: {
                try {
                    double correctedDepth = this.well.getDepth(sample, true, true);
                    double depth = sample.getDepth();
                    if (sample.getType() == SampleType.CU && !this.displayCuttingCorrections) {
                        return null;
                    }
                    double correction = correctedDepth - depth;
                    if (Math.abs(correction) > (double)0.0029f) {
                        return DepthUtils.convFromM((double)correction, (char)this.units);
                    }
                    return null;
                }
                catch (Exception ex) {
                    return ex.getMessage();
                }
            }
            case 9: {
                return sample.getCreated();
            }
            case 10: {
                Object modified = null;
                if (!sample.getModified().equals(sample.getCreated())) {
                    return sample.getModified();
                }
                return modified;
            }
            case 11: {
                SampleLithology sl = sample.getLithology();
                return sample.getLithology();
            }
            case 6: {
                if (this.wellInterp != null && this.wellInterp.getLOC() != null) {
                    double age = this.wellInterp.getLOC().getAge(sample.getDepth(), false);
                    if (age > 0.0) {
                        return SB.floatString((double)age, (int)3);
                    }
                    return "";
                }
                return "";
            }
            case 12: 
        }
        {
            catch (Exception e) {
                return e.getMessage();
            }
            try {
                return sample.getStratigraphy(this.wellInterp, false);
            }
            catch (Exception ex) {}
            return ex.getMessage();
        }
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: 
            case 6: {
                return String.class;
            }
            case 11: {
                return List.class;
            }
            case 9: 
            case 10: {
                return Date.class;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return Double.class;
            }
            case 7: 
        }
        return Integer.class;
    }

    void setupTable(JTable jTableSamples, boolean tips, SBdb sbdb, boolean hideCorrectionColumns, boolean hideTVD) {
        this.init(jTableSamples, sbdb);
        jTableSamples.getColumnModel().getColumn(0).setCellRenderer(new DepthRenderer());
        jTableSamples.getColumnModel().getColumn(2).setCellRenderer(new DepthRenderer());
        DepthRenderer dr = new DepthRenderer();
        dr.setBackground(ColouredRenderer.GREY);
        jTableSamples.getColumnModel().getColumn(1).setCellRenderer(dr);
        dr = new DepthRenderer();
        dr.setBackground(ColouredRenderer.GREY);
        jTableSamples.getColumnModel().getColumn(3).setCellRenderer(dr);
        jTableSamples.setDefaultRenderer(List.class, new SampleLithologyCellRenderer());
        jTableSamples.setDefaultRenderer(Double.class, new FloatRenderer());
        jTableSamples.setDefaultRenderer(Integer.class, new ColouredRenderer(true, new Color(220, 220, 220)));
        jTableSamples.getColumnModel().getColumn(6).setCellRenderer(new ColouredRenderer(false, new Color(220, 220, 220)));
        if (!this.simpleDisplay) {
            jTableSamples.getColumnModel().getColumn(9).setCellRenderer(new DateRenderer());
            jTableSamples.getColumnModel().getColumn(10).setCellRenderer(new DateRenderer());
            jTableSamples.getColumnModel().getColumn(8).setCellRenderer(new DepthCorrectionRenderer());
            jTableSamples.getColumnModel().getColumn(12).setCellRenderer(new ColouredRenderer(true, new Color(220, 220, 220)));
        }
        if (tips) {
            jTableSamples.getTableHeader().addMouseMotionListener((MouseMotionListener)ColumnHeaderToolTips.createColumnHeaderToolTips((String[])this.columnTooltips, (JTable)jTableSamples));
        }
        if (hideCorrectionColumns) {
            TableUtils.hideColumn((TableColumn)jTableSamples.getColumnModel().getColumn(8));
        }
        if (hideTVD) {
            this.hideTVD(jTableSamples);
        }
        this.restoreColumnOrder(jTableSamples);
    }

    @Override
    void setUnits(char units) {
        this.units = units;
        if (this.well != null) {
            try {
                for (Sample sample : this.well.getSamples()) {
                    sample.displayUnits = units;
                }
            }
            catch (Exception ex) {
                StackError.showStackError((String)ex.toString(), (Throwable)ex);
            }
        }
    }

    char getUnits() {
        return this.units;
    }

    @Override
    public String[] getColumnTitles() {
        return columnHeaders;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    public String getPrefString() {
        return "TMSAMPLES";
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        assert (false);
    }

    @Override
    public String getPrefOrderString() {
        return "TOSAMPLES";
    }

    @Override
    public final String getAutoResizeString() {
        return "TARSAMPLES";
    }

    public void hideSamples(List<Sample> samplesToHide) {
        this.hiddenSamples = samplesToHide;
        this.fireTableDataChanged();
    }

    public void removeHiddenSamples() {
        this.hiddenSamples = null;
    }

    private boolean hiddenSamplesPresent() {
        return this.hiddenSamples != null;
    }

    public boolean getDisplayCuttingCorrections() {
        return this.displayCuttingCorrections;
    }

    public void setDisplayCuttingCorrections(boolean value) {
        this.displayCuttingCorrections = value;
        this.fireTableDataChanged();
    }

    void hideTVD(JTable jTableSamples) {
        this.showTVD = false;
        TableUtils.hideColumn((TableColumn)jTableSamples.getColumnModel().getColumn(1));
        TableUtils.hideColumn((TableColumn)jTableSamples.getColumnModel().getColumn(3));
    }

    void setShowTVD(JTable jTableSamples, boolean b) {
        this.showTVD = b;
        if (!this.showTVD) {
            TableUtils.hideColumn((TableColumn)jTableSamples.getColumnModel().getColumn(1));
            TableUtils.hideColumn((TableColumn)jTableSamples.getColumnModel().getColumn(3));
        } else {
            jTableSamples.getColumnModel().getColumn(1).setMinWidth(15);
            jTableSamples.getColumnModel().getColumn(1).setMaxWidth(Integer.MAX_VALUE);
            jTableSamples.getColumnModel().getColumn(3).setMinWidth(15);
            jTableSamples.getColumnModel().getColumn(3).setMaxWidth(Integer.MAX_VALUE);
            int prefWidth = (int)((double)jTableSamples.getColumnModel().getColumn(0).getWidth() * 0.8);
            jTableSamples.getColumnModel().getColumn(1).setPreferredWidth(prefWidth);
            jTableSamples.getColumnModel().getColumn(3).setPreferredWidth(prefWidth);
            this.fireTableDataChanged();
        }
    }
}

