/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonComparator;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.user.User;
import com.stratadata.model3.user.UserService;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseMotionListener;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import jsbugs.TableModelSB;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.DateRenderer;
import jsbugs.table.TaxonNameRenderer;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.webservices.WebCitationService;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import util.table.ColumnHeaderToolTips;

public class TaxonTableModel
extends TableModelSB
implements TaxonImageService.TaxonImageListener {
    static final int COL_CAT = 0;
    static final int COL_GENUS = 1;
    static final int COL_SPECIES = 2;
    static final int COL_NAME = 3;
    static final int COL_CODE = 4;
    static final int COL_PREF = 5;
    static final int COL_IMAGE = 6;
    static final int COL_MODIFIER = 7;
    static final int COL_MODIFIED = 8;
    static final int COL_REF = 9;
    private static final String[] COLUMN_TITLES = new String[]{"Category", "Genus", "Species", "Name", "Code", "Pref./(syn.)", "Type Image", "Mod. By", "Modified", "Reference"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{null, null, null, null, "Alphanumeric code", null, "If taxon has a type specimen image", null, null};
    private static final int[] COLUMN_WIDTHS = new int[]{10, 20, 20, 120, 20, 20, 20, 15, 25, 0};
    private final TaxonService taxonService;
    private final SynonymService synonymService;
    private final UserService userService;
    private final TaxonImageService taxonImageService;
    private int synSchemeID = 1;
    final List<TaxonRow> taxonList = new CopyOnWriteArrayList<TaxonRow>();

    public TaxonTableModel(TaxonService taxonService, SynonymService synonymService, UserService userService, TaxonImageService taxonImageService) {
        this.taxonService = taxonService;
        this.synonymService = synonymService;
        this.userService = userService;
        this.taxonImageService = taxonImageService;
        taxonImageService.addListener((TaxonImageService.TaxonImageListener)this);
    }

    public void setTaxa(List<Taxon> taxa) {
        this.taxonList.clear();
        this.taxonList.addAll(taxa.stream().map(this::createTaxonRow).toList());
    }

    public void setCitedTaxa(List<WebCitationService.CitedTaxon> taxa) {
        this.taxonList.clear();
        this.taxonList.addAll(taxa.stream().map(citedTaxon -> this.createTaxonRow(citedTaxon.taxon(), citedTaxon.ciation())).toList());
    }

    public boolean addTaxonIfAbsent(Taxon taxon) {
        if (this.taxonList.stream().map(taxonRow -> taxonRow.taxon.getSpecID()).anyMatch(specID -> specID.intValue() == taxon.getSpecID())) {
            return false;
        }
        this.taxonList.add(this.createTaxonRow(taxon));
        return true;
    }

    private TaxonRow createTaxonRow(Taxon taxon) {
        return this.createTaxonRow(taxon, null);
    }

    private TaxonRow createTaxonRow(Taxon taxon, WebCitationService.WebCitation citation) {
        return new TaxonRow(taxon, this.taxonImageService.hasTypeImage(taxon.getSpecID()), this.synonymService.getPrefString(this.synSchemeID, taxon.getSpecID(), this.taxonService), taxon.getAudit().getModifier(this.userService).map(User::getAbr).orElse(""), citation);
    }

    public Taxon getTaxon(int row) {
        return this.taxonList.get(row).taxon();
    }

    public int getIndex(int specID) {
        return this.taxonList.stream().filter(taxonRow -> taxonRow.taxon.getSpecID() == specID).findFirst().map(this.taxonList::indexOf).orElse(-1);
    }

    void remove(List<Taxon> toRemove) {
        for (Taxon taxon : toRemove) {
            this.taxonList.stream().filter(taxonRow -> taxonRow.taxon.equals((Object)taxon)).findFirst().ifPresent(this.taxonList::remove);
        }
    }

    void removeUnmanaged() {
        List<TaxonRow> unmanaged = this.taxonList.stream().filter(taxonRow -> this.taxonService.findTaxon(taxonRow.taxon.getSpecID()).isEmpty()).toList();
        if (!unmanaged.isEmpty()) {
            this.taxonList.removeAll(unmanaged);
            this.fireTableDataChanged();
        }
    }

    void update(Taxon updated) {
        int index = this.getIndex(updated.getSpecID());
        if (index > -1) {
            this.taxonList.set(index, this.createTaxonRow(updated, this.taxonList.get((int)index).webCitation));
        }
    }

    public void imagesForTaxonUpdated(int specID) {
        this.update(specID);
    }

    private void update(int specID) {
        int index = this.getIndex(specID);
        if (index > -1) {
            TaxonRow currentRow = this.taxonList.get(index);
            this.taxonList.set(index, this.createTaxonRow(currentRow.taxon, currentRow.webCitation));
        }
    }

    void updateAll() {
        List<TaxonRow> newList = this.taxonList.stream().map(oldRow -> this.createTaxonRow(oldRow.taxon, oldRow.webCitation)).toList();
        this.taxonList.clear();
        this.taxonList.addAll(newList);
    }

    void setCitation(Taxon taxon, WebCitationService.WebCitation citation) {
        int index = this.getIndex(taxon.getSpecID());
        if (index > -1) {
            TaxonRow taxonRow = this.taxonList.get(index);
            this.taxonList.set(index, new TaxonRow(taxon, taxonRow.typeImage, taxonRow.synString, taxonRow.modifier, citation));
        }
    }

    public int getSynSchemeID() {
        return this.synSchemeID;
    }

    public void setSynSchemeID(int synSchemeID) {
        if (synSchemeID == 0) {
            synSchemeID = 1;
        }
        this.synSchemeID = synSchemeID;
    }

    @Override
    public int[] getDefaultColumnWidths() {
        return COLUMN_WIDTHS;
    }

    @Override
    public String[] getColumnTitles() {
        return COLUMN_TITLES;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_TITLES.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TaxonRow tRow = this.taxonList.get(row);
        return switch (col) {
            case 0 -> tRow.taxon.getGenus().getCategory().getMnemonic();
            case 1 -> tRow.taxon.getGenus().getGenusName();
            case 2 -> tRow.taxon.getSpecies();
            case 3 -> tRow.taxon;
            case 4 -> tRow.taxon.getAlphaCode();
            case 5 -> tRow.synString;
            case 6 -> {
                if (tRow.typeImage) {
                    yield "Y";
                }
                yield "";
            }
            case 8 -> tRow.taxon.getAudit().getModified();
            case 7 -> tRow.modifier;
            case 9 -> {
                if (!StringUtils.isBlank((CharSequence)tRow.taxon.getReference())) {
                    yield tRow.taxon.getReference();
                }
                if (tRow.webCitation != null) {
                    Object webRef;
                    if (!StringUtils.isBlank((CharSequence)tRow.webCitation.source())) {
                        webRef = "<html><strong>" + tRow.webCitation.source() + "</strong>";
                        if (!StringUtils.isBlank((CharSequence)tRow.webCitation.reference())) {
                            webRef = (String)webRef + ": " + tRow.webCitation.reference();
                        }
                        webRef = (String)webRef + "</html>";
                    } else {
                        webRef = tRow.webCitation.reference();
                    }
                    yield webRef;
                }
                yield "";
            }
            default -> "";
        };
    }

    public Class getColumnClass(int col) {
        return switch (col) {
            case 8 -> LocalDate.class;
            case 3 -> Taxon.class;
            default -> String.class;
        };
    }

    @Override
    public int getRowCount() {
        return this.taxonList.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 4;
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        switch (col) {
            case 4: {
                Taxon taxon = this.taxonList.get((int)row).taxon;
                taxon.setAlphaCode(Objects.requireNonNullElse(o, "").toString());
                if (taxon.getSpecID() <= 0) break;
                this.taxonService.updateTaxon(taxon.getSpecID(), taxon);
            }
        }
    }

    @Override
    public final String getPrefString() {
        return "TMTAXON";
    }

    @Override
    public String getPrefOrderString() {
        return "TOTAXON";
    }

    @Override
    public final String getAutoResizeString() {
        return "TARTAXON";
    }

    void setupTable(JTable jTableTaxa, boolean tips, SBdb sbdb) {
        this.init(jTableTaxa, sbdb);
        TableRowSorter<TaxonTableModel> rowSorter = new TableRowSorter<TaxonTableModel>(this);
        rowSorter.setComparator(3, (Comparator<?>)TaxonComparator.compareGenus());
        jTableTaxa.setRowSorter(rowSorter);
        new ColumnSortResetHandler(jTableTaxa).attach();
        if (tips) {
            jTableTaxa.getTableHeader().addMouseMotionListener((MouseMotionListener)ColumnHeaderToolTips.createColumnHeaderToolTips((String[])COLUMN_TOOLTIPS, (JTable)jTableTaxa));
        }
        jTableTaxa.getColumnModel().getColumn(9).setCellRenderer(new CitationRenderer(this, ColouredRenderer.GREY));
        jTableTaxa.getColumnModel().getColumn(9).setMinWidth(0);
        jTableTaxa.getColumnModel().getColumn(9).setMaxWidth(0);
        jTableTaxa.getColumnModel().getColumn(9).setPreferredWidth(0);
        jTableTaxa.setDefaultRenderer(Taxon.class, new TaxonNameRenderer());
        jTableTaxa.setDefaultRenderer(LocalDate.class, new DateRenderer());
        jTableTaxa.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(TextFieldUtils.buildLimitedLengthTextField(30)));
    }

    @Override
    public void setupTable(JTable table, SBdb sbdb) {
        assert (false);
    }

    record TaxonRow(Taxon taxon, boolean typeImage, String synString, String modifier, WebCitationService.WebCitation webCitation) implements Comparable<TaxonRow>
    {
        @Override
        public int compareTo(TaxonRow o) {
            return this.taxon.compareTo(o.taxon);
        }
    }

    private class CitationRenderer
    extends ColouredRenderer {
        private static final Color YELLOW = new Color(255, 255, 204);
        final /* synthetic */ TaxonTableModel this$0;

        public CitationRenderer(TaxonTableModel taxonTableModel, Color colour) {
            TaxonTableModel taxonTableModel2 = taxonTableModel;
            Objects.requireNonNull(taxonTableModel2);
            this.this$0 = taxonTableModel2;
            super(false, colour);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TaxonRow taxonRow = this.this$0.taxonList.get(table.convertRowIndexToModel(row));
            Color colour = !StringUtils.isBlank((CharSequence)taxonRow.taxon.getReference()) ? YELLOW : (taxonRow.webCitation() != null ? ColouredRenderer.GREY : (isSelected ? table.getSelectionBackground() : table.getBackground()));
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setBackground(colour);
            return comp;
        }
    }
}

