/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.Genus;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import jsbugs.TaxonTransferHandler;
import model3.CompositeStandardEvent;
import model3.SBEvent;
import model3.SBdb;
import model3.Taxon;

public class TaxonTransfer
implements Transferable {
    private final List list;
    private final HashSet<Integer> specIDs;
    private final JComponent sourceComponent;
    private DataFlavor[] flavors;
    private final SBdb sbdb;

    public TaxonTransfer(List objects, JComponent sourceComponent, SBdb sbdb) {
        this.list = objects;
        this.sourceComponent = sourceComponent;
        try {
            if (!this.list.isEmpty() && this.list.get(0) instanceof Genus) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=com.stratadata.model3.taxon.Genus"), new DataFlavor("application/x-java-jvm-local-objectref;class=model3.Taxon")};
            } else if (!this.list.isEmpty() && this.list.get(0) instanceof SBEvent) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=model3.Taxon"), new DataFlavor("application/x-java-jvm-local-objectref;class=model3.SBEvent")};
            } else if (!this.list.isEmpty() && this.list.get(0) instanceof CompositeStandardEvent.Builder) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=model3.Taxon"), new DataFlavor("application/x-java-jvm-local-objectref;class=model3.SBEvent"), new DataFlavor("application/x-java-jvm-local-objectref;class=model3.CompositeStandardEvent$Builder")};
            } else if (!this.list.isEmpty() && this.list.get(0) instanceof Taxon) {
                this.flavors = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref;class=model3.Taxon")};
            } else {
                System.out.println("Unexpected transfer flavour");
                this.flavors = new DataFlavor[0];
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error setting up data flavor array in SBPanelTemplate");
            this.flavors = new DataFlavor[0];
        }
        this.sbdb = sbdb;
        this.specIDs = new HashSet();
        for (Object o : objects) {
            if (o instanceof Taxon) {
                Taxon taxon = (Taxon)o;
                this.specIDs.add(taxon.getSpecID());
                continue;
            }
            if (o instanceof SBEvent) {
                SBEvent event = (SBEvent)o;
                if (event.getTaxon() == null) continue;
                this.specIDs.add(event.getTaxon().getSpecID());
                continue;
            }
            if (o instanceof CompositeStandardEvent.Builder) {
                CompositeStandardEvent.Builder event = (CompositeStandardEvent.Builder)o;
                if (event.getEvent() == null || event.getEvent().getTaxon() == null) continue;
                this.specIDs.add(event.getEvent().getTaxon().getSpecID());
                continue;
            }
            if (o instanceof Genus) {
                Genus genus = (Genus)o;
                try {
                    for (Taxon taxon : sbdb.getTaxa(genus.getGenID())) {
                        this.specIDs.add(taxon.getSpecID());
                    }
                    continue;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    continue;
                }
            }
            if (!(o instanceof model3.Genus)) continue;
            model3.Genus modelGen = (model3.Genus)o;
            try {
                for (Taxon taxon : sbdb.getTaxa(modelGen.getGenID())) {
                    this.specIDs.add(taxon.getSpecID());
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
    }

    public JComponent getSource() {
        return this.sourceComponent;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor isThisSupported) {
        for (DataFlavor transferFlavour : this.flavors) {
            if (!transferFlavour.equals(isThisSupported)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(TaxonTransferHandler.componentFlavour)) {
            return this.sourceComponent;
        }
        try {
            if (flavor.equals(TaxonTransferHandler.taxonFlavour)) {
                ArrayList<Taxon> taxa = new ArrayList<Taxon>();
                for (int specID : this.specIDs) {
                    taxa.add(this.sbdb.getTaxon(specID));
                }
                return taxa;
            }
            if (flavor.equals(TaxonTransferHandler.genusFlavour)) {
                HashSet<Genus> genera = new HashSet<Genus>();
                for (int specID : this.specIDs) {
                    genera.add(this.sbdb.getTaxon(specID).getGenus().getGenusCopy());
                }
                return genera;
            }
            if (flavor.equals(TaxonTransferHandler.eventFlavour)) {
                for (Object o : this.list) {
                    if (o instanceof SBEvent) continue;
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.list;
            }
            if (flavor.equals(TaxonTransferHandler.cmpStdEventFlavour)) {
                for (Object o : this.list) {
                    if (o instanceof CompositeStandardEvent.Builder) continue;
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.list;
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return null;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

