/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.EditableImageSet;
import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageSet;
import com.stratadata.model3.taxon.Taxon;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.activation.MimetypesFileTypeMap;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableModel;
import jsbugs.EventsTableModel;
import jsbugs.FrameJsbugs;
import jsbugs.GenusTableModel;
import jsbugs.InternalFrameChart;
import jsbugs.InternalFrameEventDict;
import jsbugs.InternalFrameGenera;
import jsbugs.InternalFrameGroup;
import jsbugs.InternalFrameTaxa;
import jsbugs.JPanelCharts;
import jsbugs.JPanelPicklist;
import jsbugs.SBEventsTableModel;
import jsbugs.SBList;
import jsbugs.TableModelOccurrences;
import jsbugs.TaxonDropTarget;
import jsbugs.TaxonListMember;
import jsbugs.TaxonTableModel;
import jsbugs.TaxonTransfer;
import jsbugs.model2.event.InternalFrameCmpStd;
import jsbugs.model2.event.TableModelCmpStd;
import jsbugs.overlay.OverlayJPanel;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.DontAskMeAgainFactory;
import model3.CompositeStandardEvent;
import model3.Genus;
import model3.Overlay;
import model3.SBEvent;
import model3.SBdb;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.exception.SuppressedSQLException;
import util.SBException;
import util.SBPermissionException;

public class TaxonTransferHandler
extends TransferHandler {
    static final String taxonMimeType = "application/x-java-jvm-local-objectref;class=model3.Taxon";
    static final String genusMimeType = "application/x-java-jvm-local-objectref;class=com.stratadata.model3.taxon.Genus";
    static final String eventMimeType = "application/x-java-jvm-local-objectref;class=model3.SBEvent";
    static final String componentMimeType = "application/x-java-jvm-local-objectref;class=javax.swing.JComponent";
    static final String cmpStdEventMimeType = "application/x-java-jvm-local-objectref;class=model3.CompositeStandardEvent$Builder";
    static final DataFlavor taxonFlavour;
    static final DataFlavor genusFlavour;
    static final DataFlavor eventFlavour;
    static final DataFlavor componentFlavour;
    static final DataFlavor cmpStdEventFlavour;
    static final MimetypesFileTypeMap mtftp;
    private final SBdb sbdb;
    private boolean overlayDrop = false;
    private Point lastDropPoint = null;
    final TxGroup sourceGroup;
    private int[] indices = null;

    public TaxonTransferHandler(SBdb sbdb, TxGroup group) {
        this.sourceGroup = group;
        this.sbdb = sbdb;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        JComponent source;
        Component target = info.getComponent();
        for (DataFlavor flavor : info.getDataFlavors()) {
            if (!flavor.equals(DataFlavor.javaFileListFlavor)) continue;
            if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    Iterable list = (Iterable)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator files = list.iterator();
                    boolean hasImage = false;
                    while (files.hasNext()) {
                        File file = (File)files.next();
                        String mimetype = mtftp.getContentType(file);
                        if (!mimetype.equals("image")) continue;
                        hasImage = true;
                        break;
                    }
                    if (!hasImage) {
                        return false;
                    }
                }
                catch (InvalidDnDOperationException dnde) {
                    System.out.println("Ignoring DnD exception");
                    return true;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (!(target instanceof JTable) || !(((JTable)target).getModel() instanceof TableModelOccurrences)) continue;
            return true;
        }
        try {
            source = (JComponent)info.getTransferable().getTransferData(componentFlavour);
        }
        catch (UnsupportedFlavorException | IOException e) {
            System.out.println("target: " + String.valueOf(target));
            e.printStackTrace();
            return false;
        }
        if (target instanceof InternalFrameCmpStd) {
            return source != target && (info.isDataFlavorSupported(eventFlavour) || info.isDataFlavorSupported(cmpStdEventFlavour));
        }
        if (target instanceof InternalFrameGroup) {
            InternalFrameGroup groupFrame;
            assert (info.getDropAction() == 1 || info.getDropAction() == 2);
            if (!(info.getDropAction() != 2 || source instanceof SBList && ((SBList)source).supportTransferMove)) {
                info.setDropAction(1);
            }
            return !(groupFrame = (InternalFrameGroup)target).hasList(source) && info.isDataFlavorSupported(taxonFlavour) || info.isDataFlavorSupported(genusFlavour);
        }
        if (target instanceof OverlayJPanel) {
            if (info.isDataFlavorSupported(taxonFlavour)) {
                OverlayJPanel ojp = (OverlayJPanel)target;
                if (ojp.isCountMode()) {
                    return false;
                }
                boolean overlayMove = false;
                if (target == source) {
                    info.setDropAction(2);
                    overlayMove = true;
                } else {
                    info.setDropAction(1);
                }
                if (overlayMove) {
                    this.lastDropPoint = info.getDropLocation().getDropPoint();
                    boolean canDrop = false;
                    try {
                        canDrop = ojp.setCellMoveDropRange(this.lastDropPoint, info.getDropLocation().getDropPoint());
                    }
                    catch (SQLException sql) {
                        sql.printStackTrace();
                    }
                    return canDrop;
                }
                try {
                    int nTaxa = ((Collection)info.getTransferable().getTransferData(taxonFlavour)).size();
                    ojp.setCellDropRange(this.lastDropPoint, info.getDropLocation().getDropPoint(), nTaxa);
                }
                catch (UnsupportedFlavorException | IOException | SQLException sql) {
                    sql.printStackTrace();
                }
                this.lastDropPoint = info.getDropLocation().getDropPoint();
                return true;
            }
        } else {
            if (target instanceof InternalFrameTaxa || target instanceof InternalFrameCmpStd || target instanceof JPanelPicklist || target instanceof InternalFrameGenera || target instanceof InternalFrameEventDict) {
                if (source != target) {
                    if (info.getSourceDropActions() == 3) {
                        info.setDropAction(1);
                    }
                    if (!info.isDataFlavorSupported(taxonFlavour)) {
                        System.out.println("flav not supported");
                    }
                    return info.isDataFlavorSupported(taxonFlavour);
                }
                return false;
            }
            if (target.getDropTarget() != null) {
                return info.isDataFlavorSupported(taxonFlavour);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        block44: {
            if (!info.isDrop()) {
                return false;
            }
            if (!this.canImport(info)) {
                info.getComponent().getToolkit().beep();
                return false;
            }
            Component target = info.getComponent();
            try {
                if (target instanceof InternalFrameGroup) {
                    Collection list;
                    String singular;
                    String plural;
                    InternalFrameGroup groupFrame = (InternalFrameGroup)target;
                    TxGroup group = groupFrame.getGroup();
                    if (info.isDataFlavorSupported(genusFlavour)) {
                        Collection genera;
                        plural = "genera";
                        singular = "genus";
                        list = genera = (Collection)info.getTransferable().getTransferData(genusFlavour);
                    } else {
                        Collection taxa;
                        plural = "taxa";
                        singular = "taxon";
                        list = taxa = (Collection)info.getTransferable().getTransferData(taxonFlavour);
                    }
                    int sizeBefore = list.size();
                    try {
                        group.removeMembers(list);
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                        return false;
                    }
                    if (list.isEmpty()) {
                        JOptionPane.showMessageDialog(groupFrame, "All selected " + plural + " are already in this group", "Copy " + plural, 1);
                        return false;
                    }
                    String msg = "<html>Do you want to " + (info.getDropAction() == 1 ? "COPY" : "MOVE") + (list.size() == 1 ? " this " + singular : " these " + list.size() + " " + plural) + " into this group?";
                    if (list.size() < sizeBefore) {
                        msg = msg + "<br>(only " + (String)(list.size() > 1 ? list.size() + " new taxa " : "one new taxon ") + "out of selected " + sizeBefore + " to be added";
                        if (info.getDropAction() == 2) {
                            msg = msg + ", remainder removed from source group only)";
                        }
                    }
                    msg = msg + ".<html>";
                    int opt = DontAskMeAgainFactory.getConfirmOption("TAXON_GROUP_" + info.getDropAction(), (Window)groupFrame.frameTaxa, msg, "Confirm drop action", 0);
                    if (opt != 0) {
                        return false;
                    }
                    try {
                        if (info.isDataFlavorSupported(genusFlavour)) {
                            group.addDomainGenera(list);
                        } else {
                            group.addTaxa(list);
                        }
                        this.sbdb.commit();
                    }
                    catch (SBPermissionException pe) {
                        JOptionPane.showMessageDialog(target, pe.getMessage(), "Drop", 2);
                        return false;
                    }
                    catch (SQLException sql) {
                        this.sbdb.doRollback();
                        FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                        return false;
                    }
                    return true;
                }
                if (target instanceof OverlayJPanel) {
                    OverlayJPanel overlayPanel = (OverlayJPanel)target;
                    Overlay overlay = overlayPanel.getOverlay();
                    this.overlayDrop = true;
                    if (overlay != null) {
                        try {
                            JComponent source = (JComponent)info.getTransferable().getTransferData(componentFlavour);
                            if (source == overlayPanel) {
                                overlayPanel.moveSelectedTaxa(info.getDropLocation().getDropPoint());
                                overlay.clearSelection();
                                overlayPanel.selectedCell = -1;
                            } else {
                                overlayPanel.fillSpecies(info.getDropLocation().getDropPoint(), (Collection)info.getTransferable().getTransferData(taxonFlavour));
                            }
                            overlay.notifyObservers();
                            return true;
                        }
                        catch (SQLException | SBException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    return false;
                }
                if (target instanceof InternalFrameTaxa) {
                    ((InternalFrameTaxa)target).addTaxa((Collection)info.getTransferable().getTransferData(taxonFlavour));
                    break block44;
                }
                if (target instanceof InternalFrameGenera) {
                    ((InternalFrameGenera)target).addGenera((Collection)info.getTransferable().getTransferData(genusFlavour));
                    break block44;
                }
                if (target instanceof InternalFrameCmpStd) {
                    InternalFrameCmpStd cmpStdFrame = (InternalFrameCmpStd)target;
                    if (info.isDataFlavorSupported(cmpStdEventFlavour)) {
                        cmpStdFrame.importCmpStdEvents((Collection)info.getTransferable().getTransferData(cmpStdEventFlavour));
                        break block44;
                    }
                    if (info.isDataFlavorSupported(eventFlavour)) {
                        cmpStdFrame.importEvents((Collection)info.getTransferable().getTransferData(eventFlavour));
                        break block44;
                    }
                    return cmpStdFrame.importTaxa((Collection)info.getTransferable().getTransferData(taxonFlavour));
                }
                if (target instanceof InternalFrameEventDict) {
                    InternalFrameEventDict eventFrame = (InternalFrameEventDict)target;
                    eventFrame.addEventsForTaxa((Collection)info.getTransferable().getTransferData(taxonFlavour));
                    break block44;
                }
                if (target instanceof JPanelPicklist) {
                    ((JPanelPicklist)target).setTaxa((Collection)info.getTransferable().getTransferData(taxonFlavour));
                    return true;
                }
                if (target instanceof JTable) {
                    if (!(((JTable)target).getModel() instanceof TableModelOccurrences)) {
                        return false;
                    }
                    TableModelOccurrences occModel = (TableModelOccurrences)((JTable)target).getModel();
                    Object obj = occModel.getOcc(((JTable)target).getSelectedRow());
                    if (!(obj instanceof TaxonOcc)) {
                        return false;
                    }
                    TaxonOcc occ = (TaxonOcc)obj;
                    if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        Iterable list = (Iterable)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        int opt = JOptionPane.showConfirmDialog(((JTable)target).getTopLevelAncestor(), "Add images to this occurrence?", "Import Images", 0);
                        if (opt != 0) {
                            return false;
                        }
                        Iterator files = list.iterator();
                        try {
                            SwingUtilities.getRootPane(target).setCursor(Cursor.getPredefinedCursor(3));
                            ImageSet occImageSet = new ImageSet(occ.getImageSetID());
                            EditableImageSet editableImageSet = new EditableImageSet(occImageSet, this.sbdb.getImageRecordService(), this.sbdb.getImageLoader());
                            while (files.hasNext()) {
                                File file = (File)files.next();
                                String mimetype = mtftp.getContentType(file);
                                if (!mimetype.equals("image")) continue;
                                editableImageSet.addImageFromFile(file);
                            }
                            if (editableImageSet.getSize() > occImageSet.getSize(this.sbdb.getImageRecordService())) {
                                int storedImageSetID = this.sbdb.getImageRecordService().storeImageSet(editableImageSet.getImageSetID(), editableImageSet.getImageRecords(), (ImageLoader)editableImageSet);
                                occ.updateImageSet(occModel.well.getWellID(), occModel.smpdtl.getAnalyID(), occModel.smpdtl.getSample().getSampID(), storedImageSetID);
                                this.sbdb.commit();
                            }
                        }
                        catch (RuntimeException | SQLException sql) {
                            SbugsExceptionHandler.showStackError(sql);
                        }
                        finally {
                            SwingUtilities.getRootPane(target).setCursor(Cursor.getDefaultCursor());
                        }
                        return true;
                    }
                    return false;
                }
                if (target instanceof TaxonDropTarget) {
                    ((TaxonDropTarget)((Object)target)).acceptTransfer(info.getTransferable());
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (this.overlayDrop) {
            return;
        }
        if (c.getClass() == SBList.class && action == 2) {
            try {
                JList source = (JList)c;
                DefaultListModel listModel = (DefaultListModel)source.getModel();
                for (int i = this.indices.length - 1; i >= 0; --i) {
                    listModel.remove(this.indices[i]);
                }
                ListDataListener[] ldl = listModel.getListDataListeners();
                if (ldl.length > 0) {
                    ldl[0].contentsChanged(null);
                }
                this.indices = null;
                if (this.sourceGroup != null) {
                    LinkedList<model3.Taxon> groupTaxa = new LinkedList<model3.Taxon>(this.sourceGroup.getDatabase().getTxGroupTaxa(this.sourceGroup));
                    LinkedList<model3.Taxon> listTaxa = new LinkedList<model3.Taxon>();
                    Enumeration en = listModel.elements();
                    while (en.hasMoreElements()) {
                        TaxonListMember member = (TaxonListMember)en.nextElement();
                        listTaxa.add((model3.Taxon)member.object);
                    }
                    groupTaxa.removeAll(listTaxa);
                    this.sourceGroup.deleteTaxa(groupTaxa);
                    this.sourceGroup.getDatabase().commit();
                }
            }
            catch (SQLException ex) {
                JOptionPane.showMessageDialog(null, "SQL Exception in deleting cleanup: " + ex.toString(), "Transfer Handler", 0);
                System.out.println("SQL Exception in deleting cleanup: " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception getting source for cleanup: " + e.toString(), "Transfer Handler", 0);
                System.out.println("Exception getting source for cleanup: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JPanelCharts jpc;
        ArrayList<Object> alist = new ArrayList<Object>();
        if (c instanceof JList) {
            JList list = (JList)c;
            this.indices = list.getSelectedIndices();
            for (Object obj : list.getSelectedValuesList()) {
                if (obj instanceof model3.Taxon) {
                    alist.add(obj);
                    continue;
                }
                if (!(obj instanceof TaxonListMember)) continue;
                TaxonListMember txListMember = (TaxonListMember)obj;
                Object object = txListMember.object;
                if (object instanceof Genus) {
                    Genus mGen = (Genus)object;
                    alist.add(mGen.getGenusCopy());
                    continue;
                }
                alist.add(txListMember.object);
            }
        } else if (c instanceof JTable) {
            JTable table = (JTable)c;
            this.indices = table.getSelectedRows();
            TableModel model = ((JTable)c).getModel();
            if (model instanceof TaxonTableModel) {
                TaxonTableModel taxaModel = (TaxonTableModel)model;
                for (int i : this.indices) {
                    Taxon domainTaxon = taxaModel.getTaxon(table.convertRowIndexToModel(i));
                    try {
                        alist.add(this.sbdb.getTaxon(domainTaxon.getSpecID()));
                    }
                    catch (SQLException ex) {
                        throw SuppressedSQLException.withoutRollback(ex);
                    }
                }
            } else if (model instanceof TableModelCmpStd) {
                TableModelCmpStd stdModel = (TableModelCmpStd)model;
                HashSet<CompositeStandardEvent.Builder> evSet = new HashSet<CompositeStandardEvent.Builder>();
                for (int i : this.indices) {
                    evSet.add(stdModel.getEvent(table.convertRowIndexToModel(i)));
                }
                alist.addAll(evSet);
            } else if (model instanceof SBEventsTableModel) {
                SBEventsTableModel evModel = (SBEventsTableModel)model;
                for (int i : this.indices) {
                    alist.add(evModel.getEvents().get(table.convertRowIndexToModel(i)));
                }
            } else if (model instanceof TableModelOccurrences) {
                TableModelOccurrences occModel = (TableModelOccurrences)model;
                for (int i : this.indices) {
                    TaxonOcc occ = occModel.smpdtl.getOccur(table.convertRowIndexToModel(i));
                    if (occ != null) {
                        alist.add(occ.getTaxon());
                        continue;
                    }
                    System.out.println("Occurrence null in TaxonTransferHandler for index: " + i + ", model index: " + table.convertRowIndexToModel(i));
                }
            } else if (model instanceof GenusTableModel) {
                GenusTableModel genusModel = (GenusTableModel)model;
                for (int i : this.indices) {
                    alist.add(genusModel.getGenus(table.convertRowIndexToModel(i)));
                }
            } else if (model instanceof EventsTableModel) {
                EventsTableModel eventsModel = (EventsTableModel)model;
                HashSet<SBEvent> events = new HashSet<SBEvent>();
                for (int i : this.indices) {
                    events.add(eventsModel.events.get(table.convertRowIndexToModel(i)).getEvent());
                }
                alist.addAll(events);
            }
        } else if (c instanceof OverlayJPanel) {
            OverlayJPanel overlayPanel = (OverlayJPanel)c;
            if (!overlayPanel.isCountMode()) {
                try {
                    Overlay overlay = overlayPanel.getOverlay();
                    for (int row = 0; row < overlay.getRows(); ++row) {
                        for (int col = 0; col < overlay.getCols(); ++col) {
                            if (!overlay.getSelection(row, col) || overlay.getTaxon(row, col) == null) continue;
                            alist.add(overlay.getTaxon(row, col));
                        }
                    }
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
            }
        } else if (c instanceof InternalFrameChart) {
            InternalFrameChart cjpr = (InternalFrameChart)c;
            if (cjpr.getTxDragOrigin() != null) {
                alist.add(cjpr.getTxDragOrigin());
            }
        } else if (c instanceof JPanelCharts && (jpc = (JPanelCharts)c).getTxDragOrigin() != null) {
            alist.add(jpc.getTxDragOrigin());
        }
        return new TaxonTransfer(alist, c, this.sbdb);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c.getClass() == JTable.class) {
            return 1;
        }
        return 3;
    }

    static {
        mtftp = new MimetypesFileTypeMap();
        mtftp.addMimeTypes("image tif TIF tiff TIFF jpg JPG jpeg JPEG");
        try {
            taxonFlavour = new DataFlavor(taxonMimeType);
            genusFlavour = new DataFlavor(genusMimeType);
            eventFlavour = new DataFlavor(eventMimeType);
            componentFlavour = new DataFlavor(componentMimeType);
            cmpStdEventFlavour = new DataFlavor(cmpStdEventMimeType);
        }
        catch (ClassNotFoundException e) {
            assert (false);
            throw new IllegalStateException("Error initialising taxon transfer handler: " + e.getMessage());
        }
    }
}

