/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import jsbugs.ZonesTableModel;
import jsbugs.table.CorrectedDepthRenderer;
import jsbugs.table.IGetValue;
import jsbugs.table.SimpleTableColumn;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.Sample;
import model3.SampleDepth;
import model3.Well;

public class ZonesTableModelWithCorrected
extends ZonesTableModel {
    private Well well = null;
    private CorrectedDepthRenderer correctedRenderer = new CorrectedDepthRenderer(DepthUnits.M);
    private boolean displayCuttingSampleCorrections = true;
    SimpleTableColumn<IGDIntervalZone> topCorrectedColumn = new SimpleTableColumn<IGDIntervalZone>("Top Corrected", 55, SampleDepth.class, new IGetValue<IGDIntervalZone>(this){
        final /* synthetic */ ZonesTableModelWithCorrected this$0;
        {
            ZonesTableModelWithCorrected zonesTableModelWithCorrected = this$0;
            Objects.requireNonNull(zonesTableModelWithCorrected);
            this.this$0 = zonesTableModelWithCorrected;
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return this.this$0.getSampleDepth(zone.getTopSample());
        }
    });
    SimpleTableColumn<IGDIntervalZone> baseCorrectedColumn = new SimpleTableColumn<IGDIntervalZone>("Base Corrected", 55, SampleDepth.class, new IGetValue<IGDIntervalZone>(this){
        final /* synthetic */ ZonesTableModelWithCorrected this$0;
        {
            ZonesTableModelWithCorrected zonesTableModelWithCorrected = this$0;
            Objects.requireNonNull(zonesTableModelWithCorrected);
            this.this$0 = zonesTableModelWithCorrected;
        }

        @Override
        public Object getValue(IGDIntervalZone zone) {
            return this.this$0.getSampleDepth(zone.getBaseSample());
        }
    });

    public ZonesTableModelWithCorrected() {
        this("TMZSWC", "TOZSWC", "TARZSWC");
    }

    public ZonesTableModelWithCorrected(String prefString, String prefOrderString, String prefAutoResizeString) {
        super(prefString, prefOrderString, prefAutoResizeString);
        this.columns.add(1, this.topCorrectedColumn);
        this.columns.add(4, this.baseCorrectedColumn);
    }

    private Object getSampleDepth(Sample sample) {
        try {
            if (this.displayCuttingSampleCorrections || !sample.getType().equals((Object)SampleType.CU)) {
                return SampleDepth.BuildCorrectedSampleDepth(this.well, sample);
            }
            return new SampleDepth(sample.getDepth());
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
    }

    @Override
    public void setZones(List<IGDIntervalZone> zones, Well well) {
        super.setZones(zones, well);
        this.well = well;
    }

    @Override
    public void setupTable(JTable jTable, SBdb sbdb) {
        super.setupTable(jTable, sbdb);
        jTable.setDefaultRenderer(SampleDepth.class, this.correctedRenderer);
    }

    @Override
    void setUnits(char units) {
        super.setUnits(units);
        this.correctedRenderer.setUnits(DepthUnits.getUnits((char)units));
    }

    public void setDisplayCuttingCorrections(boolean value) {
        this.displayCuttingSampleCorrections = value;
        this.fireTableDataChanged();
    }
}

