/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.abnsch;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeInformationService;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import jsbugs.abnsch.DialogEditAbundance;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Well;
import util.SBException;

public class DialogAbnSchemeUsage
extends JDialog {
    private final AbundanceScheme abnScheme;
    private final SBdb db;
    private final DefaultListModel<AbundanceSchemeInformationService.Usage> listModel = new DefaultListModel();
    private JLabel jLabel1;
    private JTextField jTextFieldName;
    private JScrollPane jScrollPane1;
    private JList jListWellDis;
    private JButton jButtonEdit;
    private JButton jButtonClose;
    private JButton jButtonHelp;

    public DialogAbnSchemeUsage(JDialog parent, boolean modal, SBdb db, AbundanceScheme scheme) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.abnScheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Abundance Scheme Usage");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jTextFieldName.setText(this.abnScheme.getName());
        List<AbundanceSchemeInformationService.Usage> usages = this.db.getAbundanceSchemeInformationService().getOccs(this.abnScheme.getAbnSchID());
        this.listModel.clear();
        this.listModel.addAll(usages);
        this.jListWellDis.updateUI();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jListWellDis = new JList();
        this.jButtonEdit = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 300));
        Container contentPane = this.getContentPane();
        this.jLabel1.setText("Abundance scheme:");
        this.jTextFieldName.setEditable(false);
        this.jTextFieldName.setBackground(new Color(0xFFFFCC));
        this.jListWellDis.setModel(this.listModel);
        this.jListWellDis.setBorder(new EmptyBorder(0, 1, 0, 1));
        this.jListWellDis.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogAbnSchemeUsage this$0;
            {
                DialogAbnSchemeUsage dialogAbnSchemeUsage = this$0;
                Objects.requireNonNull(dialogAbnSchemeUsage);
                this.this$0 = dialogAbnSchemeUsage;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.this$0.jListWellDisMouseClicked(e);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWellDis);
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(e -> this.jButtonEditActionPerformed(e));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(e -> this.jButtonCloseActionPerformed(e));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed(e));
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 380, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, contentPaneLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName, -1, 279, Short.MAX_VALUE)).addGroup(contentPaneLayout.createSequentialGroup().addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        contentPaneLayout.linkSize(0, this.jButtonClose, this.jButtonEdit, this.jButtonHelp);
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 227, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonEdit).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonEditActionPerformed(ActionEvent evt) {
        int index = this.jListWellDis.getSelectedIndex();
        if (index < 0) {
            JOptionPane.showMessageDialog(this, "Select an analyst suite to edit", "Warning", 2);
            return;
        }
        try {
            AbundanceSchemeInformationService.Usage selection = this.listModel.getElementAt(index);
            this.setCursor(Cursor.getPredefinedCursor(3));
            int wellID = selection.wellID();
            Well well = this.db.getWell(wellID);
            DialogEditAbundance dialog = new DialogEditAbundance(this, true, this.db, well, selection);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.init();
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jListWellDisMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtouseabnschemes.html#usage");
    }
}

