/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.abnsch;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeInformationService;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeService;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jsbugs.abnsch.DialogAbnScheme;
import jsbugs.abnsch.DialogAbnSchemeUsage;
import jsbugs.abnsch.DialogMergeAbn;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBRestrictable;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;

public class DialogAbnSchemes
extends JDialog {
    private final DefaultListModel<AbundanceScheme> abnModel = new DefaultListModel();
    private final SBdb db;
    private final AbundanceSchemeService abundanceSchemeService;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonFindMatch;
    private JButton jButtonHelp;
    private JButton jButtonShowUsage;
    private JList jListAbn;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public DialogAbnSchemes(Frame parent, SBdb db) {
        super(parent, false);
        this.db = db;
        this.abundanceSchemeService = db.getAbundanceSchemeService();
        this.initComponents();
        this.init();
    }

    public DialogAbnSchemes(JDialog parent, SBdb db) {
        super((Dialog)parent, false);
        this.db = db;
        this.abundanceSchemeService = db.getAbundanceSchemeService();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Abundance Schemes");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jListAbn.setSelectionMode(0);
        this.initModel();
        if (!SBRestrictable.canWrite(this.db)) {
            this.jButtonDelete.setEnabled(false);
            this.jButtonDelete.setToolTipText(SBRestrictable.getDeniedReason(false));
        }
    }

    private void initModel() {
        this.abnModel.clear();
        this.abnModel.addAll(this.abundanceSchemeService.getAllAbundanceSchemes());
        this.jListAbn.updateUI();
    }

    private AbundanceScheme getSelectedSchemeOrWarn() {
        int index = this.jListAbn.getSelectedIndex();
        if (index < 0) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return null;
        }
        return this.abnModel.getElementAt(index);
    }

    private void selectScheme(int abnSchID) {
        for (int i = 0; i < this.abnModel.size(); ++i) {
            if (this.abnModel.getElementAt(i).getAbnSchID() != abnSchID) continue;
            this.jListAbn.setSelectedIndex(i);
            break;
        }
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonShowUsage = new JButton();
        this.jButtonFindMatch = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListAbn = new JList();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(410, 300));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowUsage.setText("Show wells...");
        this.jButtonShowUsage.setToolTipText("List the well analysis suites hat have been assigned to the selected scheme");
        this.jButtonShowUsage.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowUsage.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowUsageActionPerformed(evt);
            }
        });
        this.jButtonFindMatch.setText("Find similar");
        this.jButtonFindMatch.setToolTipText("Find schemes where the abbreviations and minimum values match the selected scheme");
        this.jButtonFindMatch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFindMatchActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jListAbn.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.jListAbn.setModel(this.abnModel);
        this.jListAbn.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListAbnMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListAbn);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAbnSchemes this$0;
            {
                DialogAbnSchemes dialogAbnSchemes = this$0;
                Objects.requireNonNull(dialogAbnSchemes);
                this.this$0 = dialogAbnSchemes;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 295, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jSeparator1).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonShowUsage, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonFindMatch, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 278, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonShowUsage).addPreferredGap(0).add((Component)this.jButtonFindMatch).addPreferredGap(0, 71, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonShowUsageActionPerformed(ActionEvent evt) {
        AbundanceScheme abundanceScheme = this.getSelectedSchemeOrWarn();
        if (abundanceScheme == null) {
            return;
        }
        try {
            DialogAbnSchemeUsage dialog = new DialogAbnSchemeUsage(this, true, this.db, abundanceScheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showDialogStackError(e, this);
        }
    }

    private void jButtonFindMatchActionPerformed(ActionEvent evt) {
        AbundanceScheme scheme = this.getSelectedSchemeOrWarn();
        if (scheme == null) {
            return;
        }
        LinkedList<AbundanceScheme> matches = new LinkedList<AbundanceScheme>();
        for (int i = 0; i < this.abnModel.size(); ++i) {
            AbundanceScheme listScheme = this.abnModel.getElementAt(i);
            if (listScheme == scheme || !AbundanceSchemeService.checkEquivalence((AbundanceScheme)scheme, (AbundanceScheme)listScheme)) continue;
            matches.add(listScheme);
        }
        if (!matches.isEmpty()) {
            try {
                DialogMergeAbn dialog = new DialogMergeAbn(this, true, this.db, scheme, matches);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.initModel();
                    this.selectScheme(scheme.getAbnSchID());
                }
            }
            catch (RuntimeException sql) {
                SbugsExceptionHandler.showStackError(sql, this);
            }
        } else {
            JOptionPane.showMessageDialog(this, "There are no similar schemes to: " + String.valueOf(scheme), this.getTitle(), 1);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogAbnScheme dialog = DialogAbnScheme.toAddNewScheme(this, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.initModel();
            this.selectScheme(dialog.getScheme().getAbnSchID());
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        AbundanceScheme domainScheme = this.getSelectedSchemeOrWarn();
        if (domainScheme == null) {
            return;
        }
        try {
            DialogAbnScheme dialog = DialogAbnScheme.toEditScheme(this, this.db, domainScheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.initModel();
                this.selectScheme(domainScheme.getAbnSchID());
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jListAbnMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        AbundanceScheme abnScheme = this.getSelectedSchemeOrWarn();
        if (abnScheme == null) {
            return;
        }
        String title = "Delete Abundance Scheme";
        try {
            int nAnalystHeaderUsages = this.db.getAbundanceSchemeInformationService().countAnalystHeaderUsages(abnScheme.getAbnSchID());
            if (nAnalystHeaderUsages > 0) {
                if (JOptionPane.showConfirmDialog(this, "This scheme is assigned to analyst suites.\nDo you want to check if semi-quantitaive data are used in those wells?", title, 0, 2) != 0) {
                    return;
                }
                List<AbundanceSchemeInformationService.Usage> usages = this.db.getAbundanceSchemeInformationService().getOccs(abnScheme.getAbnSchID());
                if (!usages.isEmpty()) {
                    String msg = "Data are used in these analyst suites:\n" + StringUtils.join(usages, (String)"\n");
                    JOptionPane.showMessageDialog(this, msg, title, 2);
                    return;
                }
                JOptionPane.showMessageDialog(this, "Semi-quantitiave data are not used in any assigned wells.", this.getTitle(), 2);
            }
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete scheme: " + abnScheme.getName() + "?", title, 0, 3) == 0) {
                this.abundanceSchemeService.deleteAbundanceScheme(abnScheme.getAbnSchID());
                this.initModel();
            }
        }
        catch (RuntimeException | SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtouseabnschemes.html");
    }
}

