/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import jsbchart.graphics.Marquee;
import jsbchart.graphics.SBGraphicsConverter;
import jsbugs.chart.BasicMapBlockPanel;
import jsbugs.chart.KeyPressListener;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.uiutil.CursorFactory;

public class BasicMapBlockMouseListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyPressListener {
    private static final Logger LOGGER = Logger.getLogger(BasicMapBlockMouseListener.class.getName());
    private static final float CLICKABLE_POINT_SIZE = 2.5f;
    private final SBGraphicsConverter converter;
    private final KeyboardStatusMonitor ksm;
    private final BasicMapBlockPanel panel;
    private Point2D.Float dragOrigin;
    private boolean zoomDrag;
    private Point2D.Float lastMousePosition = null;
    private final List<ClickableMapObject> clickableObjects = new ArrayList<ClickableMapObject>();
    private BiConsumer<MouseEvent, List<Object>> mapClickHandler = null;

    public BasicMapBlockMouseListener(BasicMapBlockPanel panel, SBGraphicsConverter converter, KeyboardStatusMonitor ksm) {
        this.panel = panel;
        this.converter = converter;
        this.ksm = ksm;
        this.ksm.addListener(this);
    }

    @Override
    public void keyPressed(int keyCode) {
        if (keyCode == 17) {
            this.panel.setCursor(this.getCursorAtPoint(this.lastMousePosition));
        }
    }

    @Override
    public void keyReleased(int keyCode) {
        if (keyCode == 17) {
            this.panel.setCursor(this.getCursorAtPoint(this.lastMousePosition));
        }
    }

    public void clearMapObjects() {
        this.clickableObjects.clear();
    }

    public void addClickableObject(Point2D.Float p, Object object) {
        this.clickableObjects.add(new ClickableMapObject(p, object));
    }

    public void setClickableObjectHandler(BiConsumer<MouseEvent, List<Object>> handler) {
        this.mapClickHandler = handler;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D.Float point = this.converter.getEventPoint(e);
        if (this.mapClickHandler != null && this.isClickableObjectAtPoint(point) && !this.ksm.isCtrlPressed()) {
            this.mapClickHandler.accept(e, this.getClickableDataAtPoint(point));
        } else if (e.getButton() == 1) {
            this.dragOrigin = this.converter.getEventPoint(e);
            this.zoomDrag = this.ksm.isCtrlPressed();
            if (!this.zoomDrag && this.panel.getMapBlock() != null) {
                this.panel.getMapBlock().panOrResizeMapStart(point);
            }
            this.panel.setCursor(this.getCursorAtPoint(point));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point2D.Float point = this.converter.getEventPoint(e);
        if (this.dragOrigin != null && this.zoomDrag) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.setFrameFromDiagonal(this.dragOrigin, point);
            if (rect.width > 0.0f && rect.height > 0.0f && this.panel.getMapBlock() != null && this.panel.getMapBlockBounds() != null) {
                this.panel.getMapBlock().zoomToRect(rect, this.panel.getMapBlockBounds());
            }
            this.panel.clearMarquee();
            this.panel.onMapUpdate();
        } else if (this.dragOrigin != null) {
            if (this.panel.getMapBlock() != null) {
                this.panel.getMapBlock().panOrResizeMapEnd();
            }
        } else if (e.isPopupTrigger() && this.mapClickHandler != null) {
            this.mapClickHandler.accept(e, this.getClickableDataAtPoint(point));
        }
        this.dragOrigin = null;
        this.panel.setCursor(this.getCursorAtPoint(point));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragOrigin != null && this.zoomDrag) {
            Point2D.Float p = this.converter.getEventPoint(e);
            this.panel.setMarquee(new Marquee(this.dragOrigin, p, Color.blue));
            this.panel.onMapUpdate();
        } else if (this.dragOrigin != null) {
            Point2D.Float p = this.converter.getEventPoint(e);
            if (this.panel.getMapBlock() != null) {
                this.panel.getMapBlock().panMap(this.dragOrigin, p);
            }
            this.dragOrigin = p;
            this.panel.onMapUpdate();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point2D.Float p = this.converter.getEventPoint(e);
        if (this.dragOrigin == null) {
            this.panel.setCursor(this.getCursorAtPoint(p));
        }
        this.lastMousePosition = p;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Point2D.Float p = this.converter.getEventPoint(e);
        Rectangle2D.Float bounds = this.panel.getMapBlockBounds();
        if (bounds != null) {
            if (e.getWheelRotation() > 0) {
                this.panel.getMapBlock().zoomInAt(p, bounds);
            } else if (e.getWheelRotation() < 0) {
                this.panel.getMapBlock().zoomOutAt(p, bounds);
            }
        }
        this.panel.onMapUpdate();
    }

    private boolean isClickableObjectAtPoint(Point2D.Float point) {
        return !this.getClickableDataAtPoint(point).isEmpty();
    }

    private List<Object> getClickableDataAtPoint(Point2D.Float point) {
        return this.clickableObjects.stream().filter(o -> o.isAtPoint(point, 2.5f)).map(ClickableMapObject::data).toList();
    }

    private Cursor getCursorAtPoint(Point2D.Float point) {
        Cursor c = point != null && this.dragOrigin == null && this.mapClickHandler != null && this.isClickableObjectAtPoint(point) && !this.ksm.isCtrlPressed() ? new Cursor(12) : this.getCursor();
        return c;
    }

    private Cursor getCursor() {
        Cursor c = this.dragOrigin != null ? (this.zoomDrag ? CursorFactory.getZoomCursor() : new Cursor(13)) : (this.ksm.isCtrlPressed() ? CursorFactory.getZoomCursor() : new Cursor(0));
        return c;
    }

    private record ClickableMapObject(Point2D.Float location, Object data) {
        public ClickableMapObject {
            Objects.requireNonNull(location);
            Objects.requireNonNull(data);
        }

        public boolean isAtPoint(Point2D.Float point, float margin) {
            return point.distance(this.location) < (double)margin;
        }
    }
}

