/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationScope;
import jsbchart.correlation.IGDUnitLine;
import jsbchart.correlation.SurfaceLine;
import jsbchart.panel.spatial.SBLayer;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.Surface;

public class ChartListLabel
extends JLabel
implements ListCellRenderer,
TableCellRenderer {
    private final SBdb sbdb;

    public ChartListLabel(SBdb sbdb) {
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 16));
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.sbdb = sbdb;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return this.getRendererComponent(value, isSelected, list.getForeground(), list.getBackground(), list.getSelectionForeground(), list.getSelectionBackground());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getRendererComponent(value, isSelected, table.getForeground(), table.getBackground(), table.getSelectionForeground(), table.getSelectionBackground());
    }

    private Component getRendererComponent(Object value, boolean isSelected, Color foreground, Color background, Color selectionForeground, Color selectionBackground) {
        if (this.getFont().getStyle() != 0) {
            this.setFont(this.getFont().deriveFont(0));
        }
        Object text = Objects.toString(value, "");
        this.setIcon(null);
        if (value instanceof PanelTemplate) {
            PanelTemplate panelTemplate = (PanelTemplate)value;
            this.setIcon(panelTemplate.getType().getIcon());
            text = panelTemplate.getType().getNoun();
            if (panelTemplate.isVisible()) {
                text = (String)text + " : " + panelTemplate.getName() + " <template>";
            }
        } else if (value instanceof SBLayer) {
            SBLayer layer = (SBLayer)value;
            this.setIcon(layer.getTemplate().getType().getIcon());
            text = layer.getTemplate().getType().getNoun() + " : ";
            text = layer.getTemplate().isVisible() ? (String)text + layer.getTemplate().getName() : (String)text + layer.summaryString();
        } else if (value instanceof Correlation) {
            Correlation corr = (Correlation)value;
            if (corr.getScope() != CorrelationScope.SINGLE) {
                this.setFont(this.getFont().deriveFont(2));
            }
            if (corr.hasDatum()) {
                text = (String)text + " [has datum]";
            }
            this.setIcon(corr.getCorrType().getIcon());
        } else if (value instanceof CorrelationLine) {
            CorrelationLine corrLine = (CorrelationLine)value;
            if (corrLine.getStyle() != null) {
                this.setFont(this.getFont().deriveFont(1));
            }
            int schID = 0;
            if (value instanceof IGDUnitLine) {
                IGDUnitLine igdUnitLine = (IGDUnitLine)value;
                schID = ((IGDUnitBase)igdUnitLine.getObject()).getSchID();
            } else if (value instanceof SurfaceLine) {
                SurfaceLine surfaceLine = (SurfaceLine)value;
                schID = ((Surface)surfaceLine.getObject()).getSchID();
            }
            if (schID > 0) {
                try {
                    text = (String)text + " [" + this.sbdb.getIGDScheme(schID).getName() + "]";
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    text = (String)text + " [ERROR GETTING SCHEME]";
                }
            }
        }
        this.setForeground(isSelected ? selectionForeground : foreground);
        this.setBackground(isSelected ? selectionBackground : background);
        this.setText((String)text);
        return this;
    }
}

