/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.SBDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.DefaultTableModel;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.core.Chart;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNodeListener;
import jsbugs.FrameChart;
import jsbugs.chart.ChartBlockListItem;
import jsbugs.chart.ChartBlockListRenderer;
import jsbugs.chart.ChartBlockSummary;
import jsbugs.chart.properties.BlockPropertiesTableModel;
import jsbugs.chart.properties.MapBlockPropertiesTableModel;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.userconnect.SbugsSession;

public class DialogBlockList
extends SBDialog
implements ChartNodeListener {
    private static final int MIN_NAME_WIDTH = 80;
    private static final int MAX_NAME_WIDTH = 450;
    private static final int NAME_WIDTH_PADDING = 50;
    private static final int TARGET_WIDTH_PADDING = 20;
    private static final int CAPTION_WIDTH_PADDING = 20;
    private final DefaultTableModel nullModel = new DefaultTableModel(0, 0);
    private final BlockPropertiesTableModel blockPropertiesModel;
    private final MapBlockPropertiesTableModel mapPropertiesModel;
    ChartBlockListRenderer renderer = new ChartBlockListRenderer();
    private final FrameChart myParent;
    private final DefaultListModel<ChartBlockSummary> blockListModel = new DefaultListModel();
    private JButton jButtonClose;
    private JButton jButtonMoveLeft;
    private JButton jButtonMoveRight;
    private JButton jButtonRemoveSelectedBlock;
    private JList<ChartBlockSummary> jListBlocks;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JToolBar jToolBar1;

    public DialogBlockList(FrameChart parent, boolean modal) {
        super((Frame)parent, modal);
        this.myParent = parent;
        this.initComponents();
        this.blockPropertiesModel = new BlockPropertiesTableModel(parent, SbugsSession.getDb());
        this.mapPropertiesModel = new MapBlockPropertiesTableModel(parent, SbugsSession.getDb());
        this.jTable1.setModel(this.nullModel);
        this.nullModel.fireTableDataChanged();
        this.jListBlocks.setModel(this.blockListModel);
        this.jListBlocks.setCellRenderer(this.renderer);
        this.renderer.setSelectionBackground(this.jListBlocks.getSelectionBackground());
        this.setButtonsEnabled(false);
        this.jListBlocks.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ DialogBlockList this$0;
            {
                DialogBlockList dialogBlockList = this$0;
                Objects.requireNonNull(dialogBlockList);
                this.this$0 = dialogBlockList;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    this.this$0.jTable1.setModel(this.this$0.nullModel);
                    this.this$0.nullModel.fireTableDataChanged();
                    this.this$0.setButtonsEnabled(false);
                } else {
                    int index = lsm.getMinSelectionIndex();
                    ChartBlockBase block = this.this$0.blockListModel.getElementAt(index).getBlock();
                    if (block instanceof ChartBlock) {
                        ChartBlock chtBlock = (ChartBlock)block;
                        this.this$0.blockPropertiesModel.setBlock((ChartBlock)this.this$0.blockListModel.getElementAt(index).getBlock());
                        this.this$0.jTable1.setModel(this.this$0.blockPropertiesModel);
                        this.this$0.blockPropertiesModel.fireTableDataChanged();
                    } else if (block instanceof MapBlock) {
                        MapBlock mapBlock = (MapBlock)block;
                        this.this$0.mapPropertiesModel.setBlock(mapBlock);
                        this.this$0.jTable1.setModel(this.this$0.mapPropertiesModel);
                        this.this$0.mapPropertiesModel.fireTableDataChanged();
                    }
                    this.this$0.myParent.getSelectedChart().setSelectedBlock(block);
                    this.this$0.setButtonsEnabled(true);
                }
            }
        });
        this.setTitle("Chart Blocks : " + this.myParent.getSelectedChart().getTemplate().getName());
    }

    private void setButtonsEnabled(boolean enabled) {
        this.jButtonRemoveSelectedBlock.setEnabled(enabled);
        this.jButtonMoveLeft.setEnabled(enabled);
        this.jButtonMoveRight.setEnabled(enabled);
    }

    private Chart getSelectedChart() {
        return this.myParent.getSelectedChart();
    }

    private void setChartChanged() {
        this.myParent.setSelectedChartChanged();
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jListBlocks = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new PropertiesTable();
        this.jToolBar1 = new JToolBar();
        this.jButtonMoveLeft = new JButton();
        this.jButtonMoveRight = new JButton();
        this.jButtonRemoveSelectedBlock = new JButton();
        this.setTitle("Chart Blocks List");
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogBlockList this$0;
            {
                DialogBlockList dialogBlockList = this$0;
                Objects.requireNonNull(dialogBlockList);
                this.this$0 = dialogBlockList;
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                this.this$0.formWindowClosed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBlockList this$0;
            {
                DialogBlockList dialogBlockList = this$0;
                Objects.requireNonNull(dialogBlockList);
                this.this$0 = dialogBlockList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(500);
        this.jSplitPane1.setResizeWeight(1.0);
        ((BasicSplitPaneUI)this.jSplitPane1.getUI()).getDivider().setBorder(null);
        this.jListBlocks.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListBlocks);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jToolBar1.setRollover(true);
        this.jButtonMoveLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/moveBlockLeft.png")));
        this.jButtonMoveLeft.setToolTipText("Move left");
        this.jButtonMoveLeft.setBorderPainted(false);
        this.jButtonMoveLeft.setFocusable(false);
        this.jButtonMoveLeft.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBlockList this$0;
            {
                DialogBlockList dialogBlockList = this$0;
                Objects.requireNonNull(dialogBlockList);
                this.this$0 = dialogBlockList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveLeftActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonMoveLeft);
        this.jButtonMoveRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/moveBlockRight.png")));
        this.jButtonMoveRight.setToolTipText("Move right");
        this.jButtonMoveRight.setBorderPainted(false);
        this.jButtonMoveRight.setFocusable(false);
        this.jButtonMoveRight.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBlockList this$0;
            {
                DialogBlockList dialogBlockList = this$0;
                Objects.requireNonNull(dialogBlockList);
                this.this$0 = dialogBlockList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveRightActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonMoveRight);
        this.jButtonRemoveSelectedBlock.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/removeBlock.png")));
        this.jButtonRemoveSelectedBlock.setToolTipText("Remove");
        this.jButtonRemoveSelectedBlock.setFocusable(false);
        this.jButtonRemoveSelectedBlock.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBlockList this$0;
            {
                DialogBlockList dialogBlockList = this$0;
                Objects.requireNonNull(dialogBlockList);
                this.this$0 = dialogBlockList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveSelectedBlockActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRemoveSelectedBlock);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jSplitPane1, -1, 795, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 271, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose).addGap(7, 7, 7)));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonRemoveSelectedBlockActionPerformed(ActionEvent evt) {
        ChartBlockSummary selected = this.jListBlocks.getSelectedValue();
        if (selected != null) {
            selected.getBlock().deleteListener(this);
            Chart c = this.getSelectedChart();
            if (c != null) {
                c.removeBlock(selected.getBlock());
                c.notifyListeners();
            }
            this.blockListModel.removeElement(selected);
            this.setChartChanged();
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        this.removeBlockObservers();
    }

    private void removeBlockObservers() {
        for (int i = 0; i < this.blockListModel.size(); ++i) {
            ChartBlockSummary summary = this.blockListModel.get(i);
            summary.getBlock().deleteListener(this);
        }
    }

    private void jButtonMoveLeftActionPerformed(ActionEvent evt) {
        this.getSelectedChart().moveSelectedBlock(true);
        this.setChartChanged();
        this.updateBlockList();
    }

    private void jButtonMoveRightActionPerformed(ActionEvent evt) {
        this.getSelectedChart().moveSelectedBlock(false);
        this.setChartChanged();
        this.updateBlockList();
    }

    public void updateBlockList() {
        if (!this.blockListModel.isEmpty()) {
            this.removeBlockObservers();
            this.blockListModel.removeAllElements();
        }
        int selectedIndex = 0;
        for (int i = 0; i < this.getSelectedChart().getBlocks().size(); ++i) {
            ChartBlockBase block = this.getSelectedChart().getBlocks().get(i);
            this.blockListModel.addElement(new ChartBlockSummary(block, this.getSelectedChart().getProperties()));
            if (block.isSelected()) {
                selectedIndex = i;
            }
            block.registerListener(this);
        }
        this.renderer.setTargetWidth(this.calculateTargetWidth());
        this.renderer.setNameWidth(this.calculateNameWidth());
        this.renderer.setCaptionWidth(this.calculateCaptionWidth());
        this.jListBlocks.setSelectedIndex(selectedIndex);
        this.jListBlocks.invalidate();
        this.jListBlocks.repaint();
    }

    private int calculateCaptionWidth() {
        String[] captions = new String[this.blockListModel.getSize()];
        for (int i = 0; i < this.blockListModel.getSize(); ++i) {
            ChartBlockSummary blockSummary = this.blockListModel.get(i);
            captions[i] = blockSummary.getCaption();
        }
        return this.calcMaxStringWidth(captions, 80) + 20;
    }

    private int calculateTargetWidth() {
        String[] targetNames = new String[this.blockListModel.getSize()];
        for (int i = 0; i < this.blockListModel.getSize(); ++i) {
            ChartBlockSummary blockSummary = this.blockListModel.get(i);
            targetNames[i] = blockSummary.getTarget();
        }
        return this.calcMaxStringWidth(targetNames, 0) + 20;
    }

    private int calculateNameWidth() {
        String[] templateNames = new String[this.blockListModel.getSize()];
        for (int i = 0; i < this.blockListModel.getSize(); ++i) {
            ChartBlockSummary blockSummary = this.blockListModel.get(i);
            templateNames[i] = blockSummary.getTemplateName();
        }
        return this.calcMaxStringWidth(templateNames, 80) + 50;
    }

    private int calcMaxStringWidth(String[] strings, int minWidth) {
        ChartBlockListItem panel = new ChartBlockListItem();
        int maxWidth = minWidth;
        for (String s : strings) {
            int width = panel.measureTargetText(s);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (maxWidth > 450) {
            maxWidth = 450;
        }
        return maxWidth;
    }

    @Override
    public void onChartEvent(ChartEvent e) {
        this.jListBlocks.invalidate();
        this.jListBlocks.repaint();
    }
}

