/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelType;
import jsbugs.chart.ChartListLabel;
import jsbugs.chart.properties.DialogPanelProperties;
import jsbugs.userconnect.SbugsSession;
import util.SBException;

public class DialogBlockTemplateCompare
extends JDialog {
    private final ChartManager chartManager;
    private final BlockTemplateCompareTableModel model = new BlockTemplateCompareTableModel();
    private JButton jButtonClose;
    private JButton jButtonComparePanels;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogBlockTemplateCompare(Dialog parent, boolean modal, ChartManager chartManager, BlockTemplate ... blockTemplates) {
        super(parent, modal);
        this.chartManager = chartManager;
        this.initComponents();
        this.init(blockTemplates);
    }

    private void init(BlockTemplate ... blockTemplates) {
        this.setTitle("Compare Block Templates");
        this.model.panelRows = this.getPanelRows(blockTemplates);
        this.jTable1.setModel(this.model);
        this.jTable1.setDefaultRenderer(PanelTemplate.class, new ChartListLabel(null));
        this.jTable1.setDefaultRenderer(String.class, this.model.createRenderer());
        for (int i = 0; i < blockTemplates.length; ++i) {
            this.jTable1.getColumnModel().getColumn(i).setHeaderValue(blockTemplates[i].getName());
        }
        this.jTable1.getColumnModel().getColumn(this.model.getColumnCount() - 1).setHeaderValue("Status");
        TableUtils.setTableHeaderBold((JTable)this.jTable1);
    }

    private List<PanelRow> getPanelRows(BlockTemplate ... blocks) {
        ArrayList<PanelRow> panelRows = new ArrayList<PanelRow>();
        for (int blockNo = 0; blockNo < blocks.length; ++blockNo) {
            BlockTemplate block = blocks[blockNo];
            List<PanelTemplate> panels = this.getPanelTemplates(block);
            for (PanelTemplate panel : panels) {
                if (blockNo == 0) {
                    PanelRow panelRow = new PanelRow(blocks.length);
                    panelRow.setPanel(0, panel);
                    panelRows.add(panelRow);
                    continue;
                }
                int startIndex = 0;
                for (int j = panelRows.size() - 1; j >= 0; --j) {
                    if (!((PanelRow)panelRows.get(j)).hasMatch(blockNo)) continue;
                    startIndex = j + 1;
                    break;
                }
                boolean didMatch = false;
                for (int row = startIndex; row < panelRows.size(); ++row) {
                    PanelRow panelRow = (PanelRow)panelRows.get(row);
                    if (panelRow.getPanelType() != panel.getType()) continue;
                    panelRow.panels[blockNo] = panel;
                    didMatch = true;
                    break;
                }
                if (didMatch) continue;
                PanelRow panelRow = new PanelRow(blocks.length);
                panelRow.setPanel(blockNo, panel);
                if (startIndex > 0) {
                    panelRows.add(startIndex, panelRow);
                    continue;
                }
                panelRows.add(0, panelRow);
            }
        }
        panelRows.forEach(PanelRow::computeStatus);
        return panelRows;
    }

    private List<PanelTemplate> getPanelTemplates(BlockTemplate block) {
        try {
            ArrayList<PanelTemplate> panelTemplates = new ArrayList<PanelTemplate>();
            for (PanelOcc panelOcc : block.getPanels()) {
                PanelTemplate panelTemplate = this.chartManager.getPanelTemplate(panelOcc.getPanelID());
                panelTemplates.add(panelTemplate);
            }
            return panelTemplates;
        }
        catch (SQLException | SBException e) {
            throw new RuntimeException(e);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonComparePanels = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBlockTemplateCompare this$0;
            {
                DialogBlockTemplateCompare dialogBlockTemplateCompare = this$0;
                Objects.requireNonNull(dialogBlockTemplateCompare);
                this.this$0 = dialogBlockTemplateCompare;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonComparePanels.setText("Compare panels...");
        this.jButtonComparePanels.setToolTipText("Compare the panel properties for the selected row");
        this.jButtonComparePanels.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBlockTemplateCompare this$0;
            {
                DialogBlockTemplateCompare dialogBlockTemplateCompare = this$0;
                Objects.requireNonNull(dialogBlockTemplateCompare);
                this.this$0 = dialogBlockTemplateCompare;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonComparePanelsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 610, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonComparePanels).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 339, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonComparePanels)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonComparePanelsActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedRowCount() < 1) {
            return;
        }
        PanelRow panelRow = this.model.panelRows.get(this.jTable1.getSelectedRow());
        List<PanelTemplate> panelTemplateList = Arrays.stream(panelRow.panels).filter(Objects::nonNull).toList();
        DialogPanelProperties dialog = new DialogPanelProperties(this, SbugsSession.getSession().getDB(), panelTemplateList);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private static class BlockTemplateCompareTableModel
    extends AbstractTableModel {
        List<PanelRow> panelRows;

        private BlockTemplateCompareTableModel() {
        }

        @Override
        public int getRowCount() {
            if (this.panelRows == null) {
                return 0;
            }
            return this.panelRows.size();
        }

        @Override
        public int getColumnCount() {
            if (this.panelRows != null && !this.panelRows.isEmpty()) {
                return this.panelRows.get((int)0).panels.length + 1;
            }
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == this.getColumnCount() - 1) {
                return Objects.requireNonNullElse(this.panelRows.get((int)rowIndex).status, "");
            }
            return this.panelRows.get((int)rowIndex).panels[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == this.getColumnCount() - 1) {
                return String.class;
            }
            return PanelTemplate.class;
        }

        PanelRowStatusRenderer createRenderer() {
            return new PanelRowStatusRenderer(this);
        }

        class PanelRowStatusRenderer
        extends DefaultTableCellRenderer {
            final /* synthetic */ BlockTemplateCompareTableModel this$0;

            PanelRowStatusRenderer(BlockTemplateCompareTableModel this$0) {
                BlockTemplateCompareTableModel blockTemplateCompareTableModel = this$0;
                Objects.requireNonNull(blockTemplateCompareTableModel);
                this.this$0 = blockTemplateCompareTableModel;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Status c = this.this$0.panelRows.get((int)row).status;
                if (c != null && !isSelected) {
                    label.setBackground(c.colour);
                } else {
                    label.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                }
                return label;
            }
        }
    }

    private static class PanelRow {
        PanelTemplate[] panels;
        Status status;

        PanelRow(int capacity) {
            this.panels = new PanelTemplate[capacity];
        }

        void setPanel(int position, PanelTemplate panel) {
            this.panels[position] = panel;
        }

        PanelType getPanelType() {
            return Arrays.stream(this.panels).filter(Objects::nonNull).findFirst().map(PanelTemplate::getType).orElse(null);
        }

        boolean hasMatch(int i) {
            return this.panels[i] != null;
        }

        void computeStatus() {
            List<PanelTemplate> panelList = Arrays.stream(this.panels).filter(Objects::nonNull).toList();
            if (panelList.size() < 2) {
                this.status = null;
                return;
            }
            Set distinctPanelIDs = panelList.stream().map(PanelTemplate::getID).collect(Collectors.toSet());
            if (distinctPanelIDs.size() == 1) {
                this.status = Status.LINKED;
                return;
            }
            boolean allEqual = true;
            boolean allSimilar = true;
            for (PanelTemplate panel : panelList) {
                for (PanelTemplate panel2 : panelList) {
                    if (panel == panel2) continue;
                    if (!panel.getProperties().equals(panel2.getProperties())) {
                        allEqual = false;
                    }
                    if (panel.getProperties().isSimilarTo(panel2.getProperties())) continue;
                    allSimilar = false;
                }
            }
            this.status = allEqual ? Status.EQUIVALENT : (allSimilar ? Status.SIMILAR : Status.DIFFERENT);
        }
    }

    private static enum Status {
        LINKED("Panels share the same template", new Color(200, 230, 255)),
        EQUIVALENT("Panel properties are exactly the same but use different templates", new Color(255, 255, 200)),
        SIMILAR("Panel properties are similar - minor discrepancies in width, colours etc", new Color(255, 223, 200)),
        DIFFERENT("Panel properties are different", new Color(255, 200, 200));

        final String description;
        final Color colour;

        private Status(String description, Color colour) {
            this.description = description;
            this.colour = colour;
        }

        public String toString() {
            return this.name() + " (" + this.description + ")";
        }
    }
}

