/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import jsbchart.core.CaptionTemplate;
import util.exception.StackError;

public class DialogChartCaption
extends SBDialog {
    private final DefaultListModel model = new DefaultListModel();
    private final Pattern pattern = Pattern.compile("\\<(.*?)\\>");
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonClearCap;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxBlank;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListElements;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTextPane jTextPaneCaption;

    public DialogChartCaption(Frame parent, boolean modal, String caption) {
        super(parent, modal);
        this.initComponents();
        this.init(caption);
    }

    private void init(String caption) {
        this.setTitle("Caption Builder");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (caption != null && caption.isEmpty()) {
            this.jCheckBoxBlank.setSelected(true);
            this.jCheckBoxBlankActionPerformed(null);
        }
        this.jTextPaneCaption.setText(caption);
        for (CaptionTemplate e : CaptionTemplate.values()) {
            this.model.addElement(e);
        }
        StyledDocument styledDoc = this.jTextPaneCaption.getStyledDocument();
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = styledDoc.addStyle("regular", defaultStyle);
        StyleConstants.setBackground(regular, Color.YELLOW);
        styledDoc.addStyle("highlight", regular);
        DocumentFilter filter = new DocumentFilter(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                String text = fb.getDocument().getText(0, fb.getDocument().getLength());
                Matcher m = this.this$0.pattern.matcher(text);
                while (m.find()) {
                    int start = m.start();
                    int end = m.end();
                    if (offset >= start && offset < end) {
                        super.remove(fb, start, end - start);
                        return;
                    }
                    if (end <= offset) continue;
                    break;
                }
                super.remove(fb, offset, length);
                this.this$0.styleCaption();
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
                String text = fb.getDocument().getText(0, fb.getDocument().getLength());
                Matcher m = this.this$0.pattern.matcher(text);
                while (m.find()) {
                    int start = m.start();
                    int end = m.end();
                    if (offset > start && offset < end) {
                        this.this$0.getToolkit().beep();
                        return;
                    }
                    if (end <= offset) continue;
                    break;
                }
                super.replace(fb, offset, length, string, attr);
                this.this$0.styleCaption();
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                super.insertString(fb, offset, string, attr);
                this.this$0.styleCaption();
            }
        };
        ((AbstractDocument)this.jTextPaneCaption.getDocument()).setDocumentFilter(filter);
        this.styleCaption();
    }

    private void styleCaption() {
        StyledDocument styledDoc = this.jTextPaneCaption.getStyledDocument();
        styledDoc.setCharacterAttributes(0, styledDoc.getLength(), styledDoc.getStyle("highlight"), true);
        try {
            Matcher m = this.pattern.matcher(styledDoc.getText(0, styledDoc.getLength()));
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                styledDoc.setCharacterAttributes(start, end - start, styledDoc.getStyle("regular"), true);
            }
        }
        catch (BadLocationException e) {
            StackError.showStackError((String)"Bad Location", (Throwable)e);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListElements = new JList();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPaneCaption = new JTextPane();
        this.jCheckBoxBlank = new JCheckBox();
        this.jButtonClearCap = new JButton();
        this.jButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Caption:");
        this.jListElements.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jListElements.setModel(this.model);
        this.jListElements.setSelectionMode(0);
        this.jListElements.setToolTipText("Double-click on an element to add it to the caption");
        this.jListElements.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListElementsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListElements);
        this.jLabel2.setText("Templates:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextPaneCaption.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextPaneCaptionKeyTyped(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTextPaneCaption);
        this.jCheckBoxBlank.setText("Blank caption");
        this.jCheckBoxBlank.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxBlankActionPerformed(evt);
            }
        });
        this.jButtonClearCap.setText("Clear");
        this.jButtonClearCap.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearCapActionPerformed(evt);
            }
        });
        this.jButton1.setText("Help");
        this.jButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartCaption this$0;
            {
                DialogChartCaption dialogChartCaption = this$0;
                Objects.requireNonNull(dialogChartCaption);
                this.this$0 = dialogChartCaption;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jButtonClearCap).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBlank).addGap(0, 128, Short.MAX_VALUE)).addComponent(this.jSeparator1))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButton1, this.jButtonCancel, this.jButtonClearCap, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane2, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jScrollPane1, -1, 116, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxBlank).addComponent(this.jButtonClearCap)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButton1).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jListElementsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            Object value = this.jListElements.getSelectedValue();
            if (value == null) {
                return;
            }
            CaptionTemplate ce = (CaptionTemplate)((Object)value);
            try {
                this.jTextPaneCaption.getDocument().insertString(this.jTextPaneCaption.getCaretPosition(), ce.toDisplayString(), null);
            }
            catch (BadLocationException e) {
                StackError.showStackError((String)"Bad Location", (Throwable)e);
            }
            this.jTextPaneCaption.requestFocus();
        }
    }

    private void jTextPaneCaptionKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '<' || evt.getKeyChar() == '>') {
            this.getToolkit().beep();
            evt.consume();
        }
    }

    private void jCheckBoxBlankActionPerformed(ActionEvent evt) {
        this.jTextPaneCaption.setEnabled(!this.jCheckBoxBlank.isSelected());
        this.jListElements.setEnabled(!this.jCheckBoxBlank.isSelected());
    }

    private void jButtonClearCapActionPerformed(ActionEvent evt) {
        try {
            do {
                this.jTextPaneCaption.getDocument().remove(0, this.jTextPaneCaption.getDocument().getLength());
            } while (this.jTextPaneCaption.getDocument().getLength() > 0);
        }
        catch (BadLocationException e) {
            StackError.showStackError((String)"Bad Location", (Throwable)e);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogchartcaption.html");
    }

    public String getCaption() {
        if (this.jCheckBoxBlank.isSelected()) {
            return "";
        }
        String cap = this.jTextPaneCaption.getText().trim();
        if (cap.isEmpty()) {
            return null;
        }
        return cap;
    }
}

