/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelWellHeader;
import jsbugs.DialogChartBlockImport;
import jsbugs.DialogChartTemplates;
import jsbugs.DialogList;
import jsbugs.DialogSelectIGDType;
import jsbugs.FrameChart;
import jsbugs.FrameJsbugs;
import jsbugs.chart.DialogChartFont;
import jsbugs.list.RestrictableListRenderer;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.uiutil.EnumCombo;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.InterpHdr;
import model3.SBdb;
import model3.Well;
import model3.project.WellList;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsInputVerifier;
import util.exception.StackError;

public class DialogChartProperties
extends JDialog {
    private static final float CHART_MAX_HEIGHT = 1000000.0f;
    private final ChartProperties cp;
    private final ChartBlock block;
    private final SBdb sbdb;
    private IGDScheme scheme;
    private final DefaultComboBoxModel hierModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel interpModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel fontSizeModel = new DefaultComboBoxModel<ChartProperties.FontSize>(ChartProperties.FontSize.values());
    private char units;
    private BlockProperties.ScaleType scaleType;
    private SbugsInputVerifier ageVerifier;
    private SbugsInputVerifier depthVerifier;
    private Object wellObj;
    private final boolean allowSchemeSetWell;
    private final boolean alwaysEncode;
    private static final int DEPTHLEN = 8;
    private ActionListener applyListener = null;
    private static int tab = 0;
    private boolean isOK = false;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JButton jButtonApply;
    private JButton jButtonCopy;
    private JButton jButtonOK;
    private JButton jButtonHelp;
    private JButton jButtonCancel;
    private JTabbedPane jTabbedPane1;
    private JPanel jPanelBlockProperties;
    private JPanel panel2;
    private JLabel jLabelTopDepth;
    private JTextField jTextFieldTopDepth;
    private JTextField jTextFieldMinAge;
    private JLabel jLabelMinAge;
    private JLabel jLabelLOCMinAge;
    private JLabel jLabelBaseDepth;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldMaxAge;
    private JLabel jLabelMaxAge;
    private JLabel jLabelLOCMaxAge;
    private JLabel jLabelBlockScale;
    private JComboBox jComboBoxVerticalScale;
    private JLabel jLabelScale;
    private JPanel jPanelWellObj;
    private JLabel jLabelWellObj;
    private JTextField jTextFieldWellObj;
    private JButton jButtonWellObj;
    private JButton jButtonWellObjClear;
    private JLabel jLabelBlockVersion;
    private JComboBox jComboBoxVersion;
    private JPanel panel3;
    private JPanel jPanelBlockScaleType;
    private JRadioButton jRadioButtonMD;
    private JRadioButton jRadioButtonTVD;
    private JRadioButton jRadioButtonAGE;
    private JPanel jPanelBlockUnits;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonFeet;
    private JPanel jPanelFonts;
    private JLabel jLabelFontName;
    private JComboBox jComboBoxFont;
    private JLabel jLabelFontSize;
    private JSpinner jSpinnerFontSize;
    private JLabel jLabelFontSizeUnits;
    private JButton jButtonDefaultFont;
    private JPanel jPanelColours;
    private JLabel jLabelForeground;
    private JTextField jTextFieldForeground;
    private JButton jButtonForeground;
    private JCheckBox jCheckBoxGreyscale;
    private JLabel jLabelBackground;
    private JTextField jTextFieldBackground;
    private JButton jButtonBackground;
    private JPanel jPanelBackgroundShading;
    private JLabel jLabelFromScheme;
    private JTextField jTextFieldbgScheme;
    private JButton jButtonSelectScheme;
    private JButton jButtonClearScheme;
    private JLabel jLabelFromLevel;
    private JComboBox jComboBoxHier;
    private JLabel jLabelDensity;
    private JSlider jSliderbgDensity;
    private JCheckBox jCheckBoxbgBlocks;
    private JCheckBox jCheckBoxBgPinchouts;
    private JLabel jLabelIntervalGap;
    private JTextField jTextFieldGapHatchColour;
    private JButton jButtonGapHatchColour;
    private JPanel jPanelDimensions;
    private JPanel jPanelHeaders;
    private JLabel jLabelPanelCaptionHeight;
    private JSpinner jSpinnerCaption;
    private JLabel jLabelExtendedCaptionHeight;
    private JSpinner jSpinnerExtCaption;
    private JLabel jLabelSubHeaderHeight;
    private JSpinner jSpinnerSubHeader;
    private JLabel jLabelTotalPanelHeaderHeight;
    private JTextField jTextFieldTotalHeaderHeight;
    private JPanel jPanelBlockCaptions;
    private JCheckBox jCheckBoxCaptions;
    private JRadioButton jRadioButtonCapTop;
    private JRadioButton jRadioButtonCapBase;
    private JLabel jLabelBlockCaptionsHeight;
    private JSpinner jSpinnerCapHeight;
    private JRadioButton jRadioButtonCapAlignChart;
    private JRadioButton jRadioButtonCapAlignBlocks;
    private JLabel jLabelBlockCaptionsFontSize;
    private JComboBox jComboBoxBlockCapFontSize;
    private JLabel jLabelBlockCaptionsWellNames;
    private JComboBox jComboBoxBCWellNames;
    private JPanel jPanelBlockSpacing;
    private JLabel jLabelSpacingBetweenBlocks;
    private JSpinner jSpinnerBlankSpace;
    private JCheckBox jCheckBoxBlankRelative;
    private JCheckBox jCheckBoxMapAlign;
    private JLabel jLabelChartMargins;
    private JSpinner jSpinnerMargin;
    private JCheckBox jCheckBoxChartBorder;
    private JLabel jLabelNumPanelsToFreeze;
    private JSpinner jSpinnerVfreeze;
    private JPanel jPanelHeader;
    private JPanel panel1;
    private JRadioButton jRadioButtonHdrNone;
    private JRadioButton jRadioButtonHdrWell;
    private JRadioButton jRadioButtonHdrFree;
    private JRadioButton jRadioButtonHdrTop;
    private JRadioButton jRadioButtonHdrBottom;
    private JPanel jPanelHdrCards;
    private JPanel jPanelHdrWell;
    private JCheckBox jCheckBoxWellCode;
    private JCheckBox jCheckBoxOperator;
    private JCheckBox jCheckBoxLocation;
    private JRadioButton jRadioButtonLocDec;
    private JRadioButton jRadioButtonLocDMS;
    private JCheckBox jCheckBoxSpud;
    private JCheckBox jCheckBoxComments;
    private JCheckBox jCheckBoxClientName;
    private JCheckBox jCheckBoxDepthInterval;
    private JCheckBox jCheckBoxTD;
    private JPanel jPanelHdrFree;
    private JLabel jLabelHeaderTitle;
    private JScrollPane scrollPane1;
    private JTextArea jTextAreaHdrTitle;
    private JPanel jPanelHdrNone;
    private JPanel jPanelHeaderHeight;
    private JLabel jLabelHdrHeight;
    private JTextField jTextFieldHdrHeight;
    private JCheckBox jCheckBoxHdrWellList;
    private JCheckBox jCheckBoxHdrTemplName;
    private JCheckBox jCheckBoxHdrTemplDescr;
    private JCheckBox jCheckBoxHdrTemplDate;
    private JCheckBox jCheckBoxLogo;
    private JCheckBox jCheckBoxBorder;
    private JCheckBox jCheckBoxScale;
    private JPanel panel8;
    private JLabel jLabelHdrTitlePos;
    private JRadioButton jRadioButtonWellNameLeft;
    private JRadioButton jRadioButtonWellNameCentre;
    private JLabel jLabelHdrAuthor;
    private JTextField jTextFieldHdrAuthor;
    private JLabel jLabelHdrEnclosure;
    private JTextField jTextFieldHdrEnclosure;
    private JLabel jLabelWellName;
    private JComboBox jComboBoxWellName;
    private JPanel jPanelKey;
    private JCheckBox jCheckBoxKey;
    private JLabel jLabelKeyOrientation;
    private JRadioButton jRadioButtonKeyTop;
    private JRadioButton jRadioButtonKeyBottom;
    private JRadioButton jRadioButtonKeyLeft;
    private JRadioButton jRadioButtonKeyRight;
    private JLabel jLabelKeySize;
    private JTextField jTextFieldKeyHeight;
    private JCheckBox jCheckBoxKeyBorder;
    private JPanel jPanelKeyOptions;
    private JCheckBox jCheckBoxKeyText;
    private JCheckBox jCheckBoxKeyAbn;
    private JCheckBox jCheckBoxKeyBnd;
    private JCheckBox jCheckBoxKeyCorr;
    private JCheckBox jCheckBoxKeyLithBase;
    private JCheckBox jCheckBoxKeyTxGroup;
    private JCheckBox jCheckBoxKeyLithQual;
    private JCheckBox jCheckBoxKeyCats;
    private JCheckBox jCheckBoxKeySamp;
    private JCheckBox jCheckBoxKeyEnvSchs;
    private JPanel jPanelData;
    private JCheckBox jCheckBoxCorrectDepth;
    private JCheckBox jCheckBoxCorrectCuttings;
    private JLabel jLabelDisplayAgesIn;
    private JRadioButton jRadioButtonAFMA;
    private JRadioButton jRadioButtonAFKA;
    private JCheckBox jCheckBoxDrawEmptyPanels;
    private JCheckBox jCheckBoxDrawDisconfs;
    private JCheckBox jCheckBoxDrawDisconfDuration;
    private JCheckBox jCheckBoxCorrTick;
    private JLabel jLabelDefaultChartDatum;
    private EnumCombo enumComboChartDatum;

    public DialogChartProperties(JDialog parent, boolean modal, ChartProperties cp, SBdb sbdb) {
        super((Dialog)parent, modal);
        this.cp = cp;
        this.sbdb = sbdb;
        this.block = null;
        this.allowSchemeSetWell = false;
        this.alwaysEncode = false;
        this.initComponents();
        this.init(cp, true, true);
    }

    public DialogChartProperties(JFrame parent, boolean modal, ChartProperties cp, SBdb sbdb, ChartBlock block, boolean allowSchemeSetWell, boolean allowEdit, boolean canWrite, boolean alwaysEncode) {
        super((Frame)parent, modal);
        this.cp = cp;
        this.sbdb = sbdb;
        this.block = block;
        this.allowSchemeSetWell = allowSchemeSetWell;
        this.alwaysEncode = alwaysEncode;
        this.initComponents();
        this.init(cp, allowEdit, canWrite);
    }

    public DialogChartProperties(JDialog parent, boolean modal, ChartProperties cp, SBdb sbdb, ChartBlock block, boolean allowSchemeSetWell, boolean allowEdit) {
        super((Dialog)parent, modal);
        this.cp = cp;
        this.sbdb = sbdb;
        this.block = block;
        this.allowSchemeSetWell = allowSchemeSetWell;
        this.alwaysEncode = false;
        this.initComponents();
        this.init(cp, allowEdit, true);
    }

    public final void setOK() {
        this.isOK = true;
        this.dispose();
    }

    public final boolean isOK() {
        return this.isOK;
    }

    public final void setIsOK(boolean value) {
        this.isOK = value;
    }

    private void init(ChartProperties cp, boolean allowEdit, boolean canWrite) {
        DefaultComboBoxModel[] models;
        this.setMinimumSize(this.getPreferredSize());
        this.jButtonForeground.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonBackground.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSelectScheme.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonGapHatchColour.putClientProperty("JComponent.sizeVariant", "small");
        this.jComboBoxVersion.setModel(this.interpModel);
        this.jComboBoxVersion.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxVerticalScale.setModel(this.scaleModel);
        this.jComboBoxVerticalScale.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxHier.setModel(this.hierModel);
        this.jComboBoxHier.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxHier.setModel(this.hierModel);
        this.jComboBoxBlockCapFontSize.setModel(this.fontSizeModel);
        this.jComboBoxBlockCapFontSize.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        for (DefaultComboBoxModel model : models = new DefaultComboBoxModel[]{new DefaultComboBoxModel(), new DefaultComboBoxModel()}) {
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.NORMAL, "Use primary well name"));
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.ALTERNATIVE, "Use alternate well name"));
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.BOTH, "Use primary, show both"));
            model.addElement(new ComboboxItem<PanelWellHeader.WellNameDisplay>(PanelWellHeader.WellNameDisplay.CONCAT, "Use primary + alternate"));
        }
        this.jComboBoxWellName.setModel(models[0]);
        this.jComboBoxBCWellNames.setModel(models[1]);
        this.jButtonApply.setVisible(this.applyListener != null);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        this.jComboBoxFont.setModel(new DefaultComboBoxModel<String>(fontFamilies));
        this.jComboBoxFont.setSelectedItem(cp.font);
        this.jSpinnerFontSize.setValue(SB.round((double)(cp.getFontSize() / 0.3527f), (int)1));
        this.jCheckBoxCorrectCuttings.setSelected(cp.correctCuttings);
        this.jCheckBoxCorrectDepth.setSelected(cp.correctDepths);
        this.jCheckBoxDrawEmptyPanels.setSelected(cp.drawEmptyPanels);
        this.jCheckBoxDrawDisconfs.setSelected(cp.drawDisconformities);
        this.jCheckBoxDrawDisconfDuration.setSelected(cp.drawDisconfDuration);
        this.jCheckBoxCorrTick.setSelected(cp.isDrawCorrelationTicks());
        switch (cp.ageFormat) {
            case MA: {
                this.jRadioButtonAFMA.setSelected(true);
                break;
            }
            case KA: {
                this.jRadioButtonAFKA.setSelected(true);
            }
        }
        this.jSpinnerCaption.setValue((int)cp.panelCaptionHeight);
        this.jSpinnerExtCaption.setValue((int)cp.panelExtCaptionHeight);
        this.jSpinnerSubHeader.setValue((int)cp.panelSubHeaderHeight);
        this.setTotalHeaderHeight();
        this.jSpinnerMargin.setValue((int)cp.margin);
        this.jSpinnerBlankSpace.setValue((int)cp.blankPanel);
        this.jCheckBoxBlankRelative.setSelected(cp.blankPanelRelative);
        this.jSpinnerVfreeze.setValue(cp.getnVfreeze());
        this.jCheckBoxChartBorder.setSelected(cp.border);
        this.jCheckBoxMapAlign.setSelected(cp.alignMaps);
        this.jTextFieldForeground.setBackground(cp.foreground);
        this.jTextFieldBackground.setBackground(cp.background);
        this.jTextFieldGapHatchColour.setBackground(cp.gapHatchColour);
        this.jCheckBoxGreyscale.setSelected(cp.greyscale);
        if (cp.bgSchID > 0) {
            try {
                this.scheme = this.sbdb.getIGDScheme(cp.bgSchID);
                if (this.scheme != null) {
                    this.jTextFieldbgScheme.setText(this.scheme.toString());
                    this.fillHierCombo();
                    this.jComboBoxHier.setSelectedIndex(cp.bgHier - 1);
                } else {
                    cp.bgSchID = 0;
                }
            }
            catch (SQLException sql) {
                cp.bgSchID = 0;
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
        this.jCheckBoxbgBlocks.setSelected(cp.bgBlocks);
        this.jSliderbgDensity.setValue((int)(cp.bgDensity * 100.0f));
        this.jCheckBoxBgPinchouts.setSelected(cp.bgPinchouts);
        this.enableBG();
        this.jCheckBoxCaptions.setSelected(cp.plotBlockCaptions);
        if (cp.blockCapTop) {
            this.jRadioButtonCapTop.setSelected(true);
        } else {
            this.jRadioButtonCapBase.setSelected(true);
        }
        this.jSpinnerCapHeight.setValue((int)cp.blockCapHeight);
        if (cp.blockCapAlignChart) {
            this.jRadioButtonCapAlignChart.setSelected(true);
        } else {
            this.jRadioButtonCapAlignBlocks.setSelected(true);
        }
        this.jComboBoxBlockCapFontSize.setSelectedItem((Object)cp.blockcapFontSize);
        ComboboxItem.setComboBoxItemByValue(this.jComboBoxBCWellNames, cp.blockCapWellNameDisplay);
        this.jPanelWellObj.setVisible(false);
        if (this.block != null) {
            this.ageVerifier = new SbugsInputVerifier((float)((double)0.1f / cp.ageFormat.getMultiplyer()), (float)(1000.0 / cp.ageFormat.getMultiplyer()), this.block.getProp().getSingleScale());
            this.depthVerifier = new SbugsInputVerifier(1.0f, 100000.0f, (float)((int)this.block.getProp().getSingleScale()));
            if (this.block instanceof WellBlock) {
                WellBlock wBlock = (WellBlock)this.block;
                double blockMin = DepthUtils.convFromM((float)wBlock.getProp().getMin(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType());
                double blockMax = DepthUtils.convFromM((float)wBlock.getProp().getMax(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType());
                switch (this.block.getProp().getScaleType()) {
                    case AGE: {
                        blockMin = this.block.getInterp().getLOC().getDepth(blockMin, null, null, true);
                        blockMax = this.block.getInterp().getLOC().getDepth(blockMax, null, null, false);
                    }
                }
                this.jTextFieldTopDepth.setText(SB.floatString((double)blockMin, (int)2));
                this.jTextFieldBaseDepth.setText(SB.floatString((double)blockMax, (int)2));
            } else if (this.block instanceof SchemeBlock) {
                this.jLabelTopDepth.setText("Min age:");
                this.jLabelBaseDepth.setText("Max age:");
                this.jTextFieldTopDepth.setText((String)((double)this.block.getProp().getMin() > 999.99 ? SB.floatString((float)this.block.getProp().getMin(), (int)0) : "" + this.block.getProp().getMin()));
                this.jTextFieldBaseDepth.setText((String)((double)this.block.getProp().getMax() > 999.99 ? SB.floatString((float)this.block.getProp().getMax(), (int)0) : "" + this.block.getProp().getMax()));
                this.jPanelBlockScaleType.setVisible(false);
                this.jPanelBlockUnits.setVisible(false);
            }
            if (this.block.getProp().getUnits() == 'F') {
                this.jRadioButtonFeet.setSelected(true);
            } else {
                this.jRadioButtonMetres.setSelected(true);
            }
            this.units = this.block.getProp().getUnits();
            this.scaleType = this.block.getProp().getScaleType();
            switch (this.block.getProp().getScaleType()) {
                case MD: {
                    this.jRadioButtonMD.setSelected(true);
                    break;
                }
                case TVD: {
                    this.jRadioButtonTVD.setSelected(true);
                    break;
                }
                case AGE: {
                    this.jRadioButtonAGE.setSelected(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.block.getWell() != null && !(this.block instanceof SchemeBlock)) {
                this.updateDepthLabels();
            }
            ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)(this.scaleType == BlockProperties.ScaleType.AGE ? this.ageVerifier : this.depthVerifier));
            this.setAgeVisible();
            this.updateAges();
            this.setScaleCombo(false);
            if (this.block.getWell() != null && this.block.getInterp().getLOC() != null) {
                this.jLabelLOCMinAge.setText("(min: " + SB.round((double)this.block.getInterp().getLOC().getMinAge(), (int)2) + ")");
                this.jLabelLOCMaxAge.setText("(max: " + SB.round((double)this.block.getInterp().getLOC().getMaxAge(), (int)2) + ")");
            } else {
                this.jRadioButtonAGE.setSelected(false);
                this.jRadioButtonAGE.setEnabled(false);
            }
            if (this.block instanceof SchemeBlock && this.allowSchemeSetWell) {
                this.wellObj = this.block.getWellList() != null ? this.block.getWellList() : this.block.getWell();
                this.jTextFieldWellObj.setText(this.wellObj != null ? this.wellObj.toString() : "");
                try {
                    for (InterpHdr interp : this.sbdb.getInterps()) {
                        this.interpModel.addElement(interp);
                    }
                    this.jComboBoxVersion.setSelectedItem(this.sbdb.getInterp(this.block.getInterpID()));
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
                this.jPanelWellObj.setVisible(true);
            }
        } else {
            this.jTabbedPane1.remove(this.jPanelBlockProperties);
        }
        PanelWellHeader hdr = cp.header != null ? cp.header : new PanelWellHeader();
        this.jTextFieldHdrHeight.setText("" + Float.valueOf(hdr.height).intValue());
        if (hdr.centreName) {
            this.jRadioButtonWellNameCentre.setSelected(true);
        } else {
            this.jRadioButtonWellNameLeft.setSelected(true);
        }
        this.jCheckBoxWellCode.setSelected(hdr.wellCode);
        this.jCheckBoxLocation.setSelected(hdr.location);
        if (hdr.decimalLocation) {
            this.jRadioButtonLocDec.setSelected(true);
        } else {
            this.jRadioButtonLocDMS.setSelected(true);
        }
        this.jCheckBoxLocationActionPerformed(null);
        this.jCheckBoxOperator.setSelected(hdr.operator);
        this.jCheckBoxSpud.setSelected(hdr.spud);
        this.jCheckBoxLogo.setSelected(hdr.logo);
        this.jCheckBoxBorder.setSelected(hdr.border);
        this.jCheckBoxScale.setSelected(hdr.scale);
        this.jCheckBoxComments.setSelected(hdr.comments);
        this.jCheckBoxDepthInterval.setSelected(hdr.depthInterval);
        this.jCheckBoxTD.setSelected(hdr.td);
        if (cp.header != null) {
            if (cp.header.style == PanelWellHeader.HeaderStyle.WELL) {
                this.jRadioButtonHdrWell.setSelected(true);
                this.jRadioButtonHdrWellActionPerformed(null);
            } else {
                this.jRadioButtonHdrFree.setSelected(true);
                this.jRadioButtonHdrFreeActionPerformed(null);
            }
        } else {
            this.jRadioButtonHdrNone.setSelected(true);
            this.jRadioButtonHdrNoneActionPerformed(null);
        }
        this.jTextAreaHdrTitle.setText(hdr.title);
        switch (hdr.orientation) {
            case TOP: {
                this.jRadioButtonHdrTop.setSelected(true);
                break;
            }
            case BOTTOM: {
                this.jRadioButtonHdrBottom.setSelected(true);
            }
        }
        this.jTextFieldHdrAuthor.setText(hdr.author);
        this.jTextFieldHdrEnclosure.setText(hdr.enclosure);
        this.jCheckBoxHdrTemplName.setSelected(hdr.templName);
        this.jCheckBoxHdrTemplDescr.setSelected(hdr.templDescr);
        this.jCheckBoxHdrTemplDate.setSelected(hdr.templDate);
        this.jCheckBoxClientName.setSelected(hdr.clientName);
        this.jCheckBoxHdrWellList.setSelected(hdr.wellListName);
        ComboboxItem.setComboBoxItemByValue(this.jComboBoxWellName, hdr.wellNameDisplay);
        this.enableHeaderFields(cp.header != null);
        PanelKey key = cp.key != null ? cp.key : new PanelKey();
        this.jCheckBoxKey.setSelected(cp.key != null);
        this.jCheckBoxKeyText.setSelected(key.text);
        this.jCheckBoxKeyBnd.setSelected(key.bndKey);
        this.jTextFieldKeyHeight.setText("" + (int)key.height);
        this.jCheckBoxKeyBorder.setSelected(key.border);
        switch (key.orientation) {
            case TOP: {
                this.jRadioButtonKeyTop.setSelected(true);
                break;
            }
            case BOTTOM: {
                this.jRadioButtonKeyBottom.setSelected(true);
                break;
            }
            case RIGHT: {
                this.jRadioButtonKeyRight.setSelected(true);
                break;
            }
            case LEFT: {
                this.jRadioButtonKeyLeft.setSelected(true);
            }
        }
        this.jCheckBoxKeyLithBase.setSelected(key.lithBase);
        this.jCheckBoxKeyLithQual.setSelected(key.lithQual);
        this.jCheckBoxKeySamp.setSelected(key.sampling);
        this.jCheckBoxKeyAbn.setSelected(key.abnSchemes);
        this.jCheckBoxKeyCorr.setSelected(key.correlationLines);
        this.jCheckBoxKeyTxGroup.setSelected(key.txGroups);
        this.jCheckBoxKeyEnvSchs.setSelected(key.envSchemes);
        this.jCheckBoxKeyCats.setSelected(key.categories);
        this.enableKeyFields(cp.key != null);
        if (!allowEdit) {
            this.jTabbedPane1.remove(this.jPanelData);
            this.jTabbedPane1.remove(this.jPanelColours);
            this.jTabbedPane1.remove(this.jPanelFonts);
            this.jTabbedPane1.remove(this.jPanelDimensions);
            this.jTabbedPane1.remove(this.jPanelHeader);
            this.jTabbedPane1.remove(this.jPanelKey);
            this.jButtonCopy.setEnabled(false);
        }
        this.setTitle("Block Layout Properties");
        if (canWrite) {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        } else {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText("Template is read-only");
        }
        if (this.jTabbedPane1.getTabCount() > tab) {
            this.jTabbedPane1.setSelectedIndex(tab);
        }
        this.enumComboChartDatum.init(ChartProperties.ChartDatum.class);
        this.enumComboChartDatum.setSelectedItem((Object)cp.getChartDatum());
    }

    private void setTotalHeaderHeight() {
        int capHeight = Integer.parseInt(this.jSpinnerCaption.getValue().toString());
        int subHeaderHeight = Integer.parseInt(this.jSpinnerSubHeader.getValue().toString());
        this.jTextFieldTotalHeaderHeight.setText("" + (capHeight + subHeaderHeight));
    }

    public void setApplyActionListener(ActionListener listener) {
        this.applyListener = listener;
        this.jButtonApply.setVisible(listener != null);
    }

    private void enableBG() {
        this.jSliderbgDensity.setEnabled(this.scheme != null);
        this.jCheckBoxbgBlocks.setEnabled(this.scheme != null);
        this.jComboBoxHier.setEnabled(this.scheme != null);
        this.jCheckBoxBgPinchouts.setEnabled(this.scheme != null);
    }

    private void fillHierCombo() {
        this.hierModel.removeAllElements();
        if (this.scheme == null) {
            return;
        }
        int nHier = IGDIntervalZone.getNHier(this.scheme.getIGDType(), true);
        for (int i = 1; i <= nHier; ++i) {
            this.hierModel.addElement(IGDIntervalZone.getHierName(this.scheme.getIGDType(), i));
        }
        this.jComboBoxHier.setSelectedIndex(nHier - 1);
    }

    private void setAgeVisible() {
        boolean b = this.block != null && this.block instanceof WellBlock && this.block.getInterp().getLOC() != null && this.jRadioButtonAGE.isSelected();
        this.jTextFieldMinAge.setVisible(b);
        this.jTextFieldMaxAge.setVisible(b);
        this.jLabelScale.setVisible(b);
        this.jLabelMinAge.setVisible(b);
        this.jLabelMaxAge.setVisible(b);
        this.jLabelLOCMaxAge.setVisible(b);
        this.jLabelLOCMinAge.setVisible(b);
    }

    private void setScaleCombo(boolean change) {
        float scale = 0.0f;
        if (this.jRadioButtonAGE.isSelected()) {
            SchemeBlock.fillScaleCombo(this.scaleModel);
            float minAge = Float.parseFloat(this.jTextFieldTopDepth.getText());
            float maxAge = Float.parseFloat(this.jTextFieldBaseDepth.getText());
            if (change) {
                scale = SchemeBlock.calcIdealScale(minAge, maxAge);
            }
            ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)this.ageVerifier);
        } else {
            try {
                this.sbdb.getChartScales(this.scaleModel);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            float topDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            float baseDepth = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            if (change) {
                scale = (float)WellBlock.getDefaultScale(topDepth, baseDepth, this.units);
            }
            ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)this.depthVerifier);
        }
        if (!change) {
            scale = this.block.getProp().getSingleScale();
        }
        if (this.scaleModel.getIndexOf(Float.valueOf(scale)) < 0) {
            this.scaleModel.addElement(Float.valueOf(scale).intValue());
        }
        this.scaleModel.setSelectedItem(Float.valueOf(scale));
    }

    private void updateAges() {
        if (this.block == null || this.block.getWell() == null || this.block.getInterp().getLOC() == null || !this.jRadioButtonAGE.isSelected()) {
            return;
        }
        double topDepth = Double.parseDouble(this.jTextFieldTopDepth.getText());
        double baseDepth = Double.parseDouble(this.jTextFieldBaseDepth.getText());
        Point2D ageRange = this.block.getInterp().getLOC().getAgeRange(topDepth, baseDepth);
        this.jTextFieldMinAge.setText("" + SB.round((double)ageRange.getX(), (int)2));
        this.jTextFieldMaxAge.setText("" + SB.round((double)ageRange.getY(), (int)2));
    }

    private void enableHeaderFields(boolean b) {
        this.jLabelHdrHeight.setEnabled(b);
        this.jTextFieldHdrHeight.setEnabled(b);
        this.jRadioButtonHdrBottom.setEnabled(b);
        this.jRadioButtonHdrTop.setEnabled(b);
        this.jCheckBoxLogo.setEnabled(b);
        this.jCheckBoxScale.setEnabled(b);
        this.jCheckBoxBorder.setEnabled(b);
        this.jCheckBoxHdrTemplName.setEnabled(b);
        this.jCheckBoxHdrTemplDescr.setEnabled(b);
        this.jCheckBoxHdrTemplDate.setEnabled(b);
        this.jTextFieldHdrAuthor.setEnabled(b);
        this.jTextFieldHdrEnclosure.setEnabled(b);
        this.jLabelHdrTitlePos.setEnabled(b);
        this.jRadioButtonWellNameLeft.setEnabled(b);
        this.jRadioButtonWellNameCentre.setEnabled(b);
        this.jLabelHdrAuthor.setEnabled(b);
        this.jLabelHdrEnclosure.setEnabled(b);
        this.jLabelWellName.setEnabled(b);
        this.jComboBoxWellName.setEnabled(b);
        this.jCheckBoxHdrWellList.setEnabled(b);
    }

    private void enableKeyFields(boolean b) {
        this.jCheckBoxKeyText.setEnabled(b);
        this.jCheckBoxKeyBnd.setEnabled(b);
        this.jRadioButtonKeyTop.setEnabled(b);
        this.jRadioButtonKeyBottom.setEnabled(b);
        this.jRadioButtonKeyLeft.setEnabled(b);
        this.jRadioButtonKeyRight.setEnabled(b);
        this.jLabelKeyOrientation.setEnabled(b);
        this.jLabelKeySize.setEnabled(b);
        this.jTextFieldKeyHeight.setEnabled(b);
        this.jCheckBoxKeyBorder.setEnabled(b);
        this.jCheckBoxKeyLithBase.setEnabled(b);
        this.jCheckBoxKeyLithQual.setEnabled(b);
        this.jCheckBoxKeySamp.setEnabled(b);
        this.jCheckBoxKeyAbn.setEnabled(b);
        this.jCheckBoxKeyCorr.setEnabled(b);
        this.jCheckBoxKeyCats.setEnabled(b);
        this.jCheckBoxKeyTxGroup.setEnabled(b);
        this.jCheckBoxKeyEnvSchs.setEnabled(b);
    }

    private void updateDepthLabels() {
        if (this.jRadioButtonTVD.isSelected()) {
            this.jLabelTopDepth.setText("Top TVD:");
            this.jLabelBaseDepth.setText("Base TVD:");
        } else if (this.jRadioButtonMD.isSelected() || this.jRadioButtonAGE.isSelected()) {
            this.jLabelTopDepth.setText("Top Depth:");
            this.jLabelBaseDepth.setText("Base Depth:");
        } else assert (false);
    }

    private void jTextFieldTopDepthFocusLost(FocusEvent e) {
        this.updateAges();
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent e) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)e, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthFocusLost(FocusEvent e) {
        this.updateAges();
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent e) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)e, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonDefaultFontActionPerformed(ActionEvent e) {
        this.jSpinnerFontSize.setValue(8.5);
    }

    private void jButtonForegroundActionPerformed(ActionEvent e) {
        Color c = JColorChooser.showDialog(this, "Foreground Colour", this.jTextFieldForeground.getBackground());
        if (c != null) {
            this.jTextFieldForeground.setBackground(c);
        }
    }

    private void jButtonBackgroundActionPerformed(ActionEvent e) {
        Color c = JColorChooser.showDialog(this, "Background Colour", this.jTextFieldBackground.getBackground());
        if (c != null) {
            this.jTextFieldBackground.setBackground(c);
        }
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent e) {
        List<IGDScheme> igdSchemes;
        DialogSelectIGDType typeDialog = new DialogSelectIGDType(this, true, false, false, false, false);
        typeDialog.setLocationRelativeTo(this);
        typeDialog.setVisible(true);
        if (!typeDialog.isOK()) {
            return;
        }
        try {
            igdSchemes = this.sbdb.getIGDSchemes(typeDialog.getIgdType());
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError("Error loading schemes", ex, this);
            return;
        }
        Collections.sort(igdSchemes);
        DialogList<IGDScheme> dialog = new DialogList<IGDScheme>(this, true, "Select Scheme", null, igdSchemes, true, false, (ListCellRenderer)new RestrictableListRenderer());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getSelection() != null) {
            this.scheme = dialog.getSelection();
            this.jTextFieldbgScheme.setText(this.scheme.toString());
            this.fillHierCombo();
            this.enableBG();
        }
    }

    private void jButtonClearSchemeActionPerformed(ActionEvent e) {
        this.scheme = null;
        this.jTextFieldbgScheme.setText("");
        this.fillHierCombo();
        this.enableBG();
    }

    private void jButtonGapHatchColourActionPerformed(ActionEvent e) {
        Color c = JColorChooser.showDialog(this, "Interval Sample Gap Colour", this.jTextFieldForeground.getBackground());
        if (c != null) {
            this.jTextFieldGapHatchColour.setBackground(c);
        }
    }

    private void jSpinnerCaptionStateChanged(ChangeEvent e) {
        this.setTotalHeaderHeight();
    }

    private void jSpinnerSubHeaderStateChanged(ChangeEvent e) {
        this.setTotalHeaderHeight();
    }

    private void jCheckBoxLocationActionPerformed(ActionEvent e) {
        this.jRadioButtonLocDMS.setEnabled(this.jCheckBoxLocation.isSelected());
        this.jRadioButtonLocDec.setEnabled(this.jCheckBoxLocation.isSelected());
    }

    private void jButtonWellObjActionPerformed(ActionEvent e) {
        assert (this.block.getBlockType() == BlockType.SCHEME);
        DialogChartBlockImport dialog = new DialogChartBlockImport(this, true, this.sbdb, this.block.getBlockType());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.wellObj = dialog.getObject();
            this.jTextFieldWellObj.setText(this.wellObj != null ? this.wellObj.toString() : "");
        }
    }

    private void jButtonWellObjClearActionPerformed(ActionEvent e) {
        this.wellObj = null;
        this.jTextFieldWellObj.setText("");
    }

    private void jRadioButtonMDActionPerformed(ActionEvent e) {
        this.scaleTypeChange(BlockProperties.ScaleType.MD);
    }

    private void jRadioButtonTVDActionPerformed(ActionEvent e) {
        this.scaleTypeChange(BlockProperties.ScaleType.TVD);
    }

    private void jRadioButtonAGEActionPerformed(ActionEvent e) {
        this.scaleTypeChange(BlockProperties.ScaleType.AGE);
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent e) {
        this.setUnits();
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent e) {
        this.setUnits();
    }

    private void jRadioButtonHdrNoneActionPerformed(ActionEvent e) {
        this.enableHeaderFields(!this.jRadioButtonHdrNone.isSelected());
        ((CardLayout)this.jPanelHdrCards.getLayout()).show(this.jPanelHdrCards, "cardNone");
    }

    private void jRadioButtonHdrWellActionPerformed(ActionEvent e) {
        this.enableHeaderFields(!this.jRadioButtonHdrNone.isSelected());
        ((CardLayout)this.jPanelHdrCards.getLayout()).show(this.jPanelHdrCards, "cardWell");
    }

    private void jRadioButtonHdrFreeActionPerformed(ActionEvent e) {
        this.enableHeaderFields(!this.jRadioButtonHdrNone.isSelected());
        ((CardLayout)this.jPanelHdrCards.getLayout()).show(this.jPanelHdrCards, "cardFree");
    }

    private boolean applyChanges() throws InvalidFieldException {
        ChartProperties.ChartDatum selected;
        boolean hasChanged = false;
        hasChanged |= this.cp.setFont((String)this.jComboBoxFont.getSelectedItem());
        hasChanged |= this.cp.setFontSize(((Double)this.jSpinnerFontSize.getValue()).floatValue());
        if (this.cp.setMargin(((Integer)this.jSpinnerMargin.getValue()).floatValue())) {
            hasChanged = true;
        }
        if (this.cp.setPanelSubHeaderHeight(((Integer)this.jSpinnerSubHeader.getValue()).floatValue())) {
            hasChanged = true;
        }
        hasChanged |= this.cp.setPanelCaptionHeight(((Integer)this.jSpinnerCaption.getValue()).floatValue());
        hasChanged |= this.cp.setPanelExtCaptionHeight(((Integer)this.jSpinnerExtCaption.getValue()).floatValue());
        if (this.cp.setCorrections(this.jCheckBoxCorrectDepth.isSelected(), this.jCheckBoxCorrectCuttings.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setAgeFormat(this.jRadioButtonAFMA.isSelected() ? AgeFormat.MA : AgeFormat.KA)) {
            hasChanged = true;
        }
        if (this.cp.setForeground(this.jTextFieldForeground.getBackground())) {
            hasChanged = true;
        }
        if (this.cp.setBackground(this.jTextFieldBackground.getBackground())) {
            hasChanged = true;
        }
        if (this.cp.setGapHatchColour(this.jTextFieldGapHatchColour.getBackground())) {
            hasChanged = true;
        }
        if (this.cp.setGreyscale(this.jCheckBoxGreyscale.isSelected())) {
            hasChanged = true;
        }
        hasChanged |= this.cp.setBlankPanel(((Integer)this.jSpinnerBlankSpace.getValue()).floatValue(), this.jCheckBoxBlankRelative.isSelected());
        if (this.cp.setSchID(this.scheme == null ? 0 : this.scheme.getID())) {
            hasChanged = true;
        }
        if (this.cp.setHier(this.jComboBoxHier.getSelectedIndex() + 1)) {
            hasChanged = true;
        }
        if (this.cp.setbgDensity((float)this.jSliderbgDensity.getValue() / 100.0f)) {
            hasChanged = true;
        }
        if (this.cp.setbgBlocks(this.jCheckBoxbgBlocks.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setbgPinchouts(this.jCheckBoxBgPinchouts.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setDrawEmptyPanels(this.jCheckBoxDrawEmptyPanels.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setDrawDisconfs(this.jCheckBoxDrawDisconfs.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setDrawDisconfDuration(this.jCheckBoxDrawDisconfDuration.isSelected())) {
            hasChanged = true;
        }
        if (this.enumComboChartDatum.getSelectedItem() instanceof ChartProperties.ChartDatum && (selected = (ChartProperties.ChartDatum)((Object)this.enumComboChartDatum.getSelectedItem())) != this.cp.getChartDatum()) {
            this.cp.setChartDatum(selected);
            hasChanged = true;
        }
        hasChanged |= this.cp.setBorder(this.jCheckBoxChartBorder.isSelected());
        hasChanged |= this.cp.setDrawCorrelationTicks(this.jCheckBoxCorrTick.isSelected());
        hasChanged |= this.cp.setBlockCap(this.jCheckBoxCaptions.isSelected(), ((Integer)this.jSpinnerCapHeight.getValue()).floatValue(), this.jRadioButtonCapTop.isSelected(), this.jRadioButtonCapAlignChart.isSelected(), (ChartProperties.FontSize)((Object)this.jComboBoxBlockCapFontSize.getSelectedItem()));
        ComboboxItem display = (ComboboxItem)this.jComboBoxBCWellNames.getSelectedItem();
        hasChanged |= this.cp.setBlockCapWellNameDisplay((PanelWellHeader.WellNameDisplay)((Object)display.getValue()));
        if (this.cp.setNvFreeze((Integer)this.jSpinnerVfreeze.getValue())) {
            hasChanged = true;
        }
        hasChanged |= this.cp.setMapAlign(this.jCheckBoxMapAlign.isSelected());
        PanelWellHeader hdrPanel = null;
        if (!this.jRadioButtonHdrNone.isSelected()) {
            hdrPanel = new PanelWellHeader();
            float height = Float.parseFloat(this.jTextFieldHdrHeight.getText());
            if (height < 20.0f) {
                height = 20.0f;
            }
            hdrPanel.height = height;
            hdrPanel.centreName = this.jRadioButtonWellNameCentre.isSelected();
            hdrPanel.wellCode = this.jCheckBoxWellCode.isSelected();
            hdrPanel.location = this.jCheckBoxLocation.isSelected();
            hdrPanel.decimalLocation = this.jRadioButtonLocDec.isSelected();
            hdrPanel.operator = this.jCheckBoxOperator.isSelected();
            hdrPanel.spud = this.jCheckBoxSpud.isSelected();
            hdrPanel.logo = this.jCheckBoxLogo.isSelected();
            hdrPanel.border = this.jCheckBoxBorder.isSelected();
            hdrPanel.scale = this.jCheckBoxScale.isSelected();
            hdrPanel.comments = this.jCheckBoxComments.isSelected();
            hdrPanel.depthInterval = this.jCheckBoxDepthInterval.isSelected();
            hdrPanel.td = this.jCheckBoxTD.isSelected();
            hdrPanel.orientation = this.jRadioButtonHdrTop.isSelected() ? PanelWellHeader.Orientation.TOP : PanelWellHeader.Orientation.BOTTOM;
            hdrPanel.style = this.jRadioButtonHdrWell.isSelected() ? PanelWellHeader.HeaderStyle.WELL : PanelWellHeader.HeaderStyle.FREE;
            hdrPanel.title = this.jTextAreaHdrTitle.getText().trim();
            hdrPanel.author = this.jTextFieldHdrAuthor.getText().trim();
            hdrPanel.enclosure = this.jTextFieldHdrEnclosure.getText().trim();
            hdrPanel.templName = this.jCheckBoxHdrTemplName.isSelected();
            hdrPanel.templDescr = this.jCheckBoxHdrTemplDescr.isSelected();
            hdrPanel.templDate = this.jCheckBoxHdrTemplDate.isSelected();
            hdrPanel.clientName = this.jCheckBoxClientName.isSelected();
            hdrPanel.wellListName = this.jCheckBoxHdrWellList.isSelected();
            ComboboxItem item = (ComboboxItem)this.jComboBoxWellName.getSelectedItem();
            hdrPanel.wellNameDisplay = (PanelWellHeader.WellNameDisplay)((Object)item.getValue());
        }
        if (!SB.equal((Object)this.cp.header, (Object)hdrPanel)) {
            hasChanged = true;
        }
        this.cp.header = hdrPanel;
        PanelKey keyPanel = null;
        if (this.jCheckBoxKey.isSelected()) {
            keyPanel = new PanelKey();
            if (this.jRadioButtonKeyLeft.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.LEFT;
            } else if (this.jRadioButtonKeyRight.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.RIGHT;
            } else if (this.jRadioButtonKeyTop.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.TOP;
            } else if (this.jRadioButtonKeyBottom.isSelected()) {
                keyPanel.orientation = PanelKey.Orientation.BOTTOM;
            }
            keyPanel.text = this.jCheckBoxKeyText.isSelected();
            keyPanel.bndKey = this.jCheckBoxKeyBnd.isSelected();
            float height = Float.parseFloat(this.jTextFieldKeyHeight.getText());
            if (height < 20.0f) {
                height = 20.0f;
            }
            keyPanel.height = height;
            keyPanel.border = this.jCheckBoxKeyBorder.isSelected();
            keyPanel.lithBase = this.jCheckBoxKeyLithBase.isSelected();
            keyPanel.lithQual = this.jCheckBoxKeyLithQual.isSelected();
            keyPanel.sampling = this.jCheckBoxKeySamp.isSelected();
            keyPanel.abnSchemes = this.jCheckBoxKeyAbn.isSelected();
            keyPanel.correlationLines = this.jCheckBoxKeyCorr.isSelected();
            keyPanel.txGroups = this.jCheckBoxKeyTxGroup.isSelected();
            keyPanel.envSchemes = this.jCheckBoxKeyEnvSchs.isSelected();
            keyPanel.categories = this.jCheckBoxKeyCats.isSelected();
        }
        if (!SB.equal((Object)this.cp.key, (Object)keyPanel)) {
            hasChanged = true;
        }
        this.cp.key = keyPanel;
        boolean blockChange = false;
        if (this.block != null) {
            float max;
            float min;
            assert (this.units == (this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M'));
            if (this.block.getProp().setUnits(this.units)) {
                blockChange = true;
            }
            if (this.scaleType == BlockProperties.ScaleType.AGE) {
                min = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMinAge : this.jTextFieldTopDepth).getText()), (int)3);
                max = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMaxAge : this.jTextFieldBaseDepth).getText()), (int)3);
            } else {
                min = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
                max = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            }
            float scale = Float.parseFloat(String.valueOf(this.jComboBoxVerticalScale.getSelectedItem()));
            if (this.block.getProp().setLimits(min, max)) {
                blockChange = true;
            }
            if (scale == 0.0f) {
                scale = max - min;
            }
            if (this.block.getProp().setScale(scale)) {
                blockChange = true;
            }
            if (this.block.getProp().setScaleType(this.scaleType)) {
                blockChange = true;
            }
            this.block.setUnits(DepthUnits.getUnits((char)this.units));
            if (this.allowSchemeSetWell) {
                InterpHdr interp;
                Object blockObj;
                Object object = blockObj = this.block.getWellList() != null ? this.block.getWellList() : this.block.getWell();
                if (blockObj != this.wellObj) {
                    blockChange = true;
                    try {
                        Object object2 = this.wellObj;
                        if (object2 instanceof WellList) {
                            WellList wellList = (WellList)((Object)object2);
                            this.sbdb.getWellIterator(wellList.getID());
                            this.block.setWellList(wellList);
                        } else {
                            Well well;
                            List wells = (List)this.wellObj;
                            if (wells != null && !wells.isEmpty()) {
                                well = (Well)wells.get(0);
                                well.loadSamples();
                                well.loadInterps();
                            } else {
                                well = null;
                            }
                            this.block.setWell(well);
                        }
                    }
                    catch (SQLException | SBException sql) {
                        SbugsExceptionHandler.showStackError(sql, this);
                    }
                }
                if ((interp = (InterpHdr)this.jComboBoxVersion.getSelectedItem()).getInterpID() != this.block.getInterpID()) {
                    blockChange = true;
                    try {
                        this.block.setInterpID(interp.getInterpID());
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                    }
                    catch (SBException sbe) {
                        StackError.showStackError((String)"Error", (Throwable)sbe);
                    }
                }
            }
        }
        tab = this.jTabbedPane1.getSelectedIndex();
        if (hasChanged || blockChange || this.alwaysEncode) {
            this.cp.encode(this.sbdb);
            return true;
        }
        return false;
    }

    private void scaleTypeChange(BlockProperties.ScaleType newType) {
        if (newType == this.scaleType) {
            return;
        }
        if (newType == BlockProperties.ScaleType.AGE) {
            this.updateAges();
            this.setScaleCombo(true);
        } else if (this.scaleType == BlockProperties.ScaleType.AGE) {
            this.setScaleCombo(true);
        }
        this.setAgeVisible();
        this.updateDepthLabels();
        this.scaleType = newType;
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldTopDepth.setText("" + DepthUtils.convFromM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + DepthUtils.convFromM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        } else {
            this.units = (char)77;
            try {
                this.jTextFieldTopDepth.setText("" + DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (NumberFormatException e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        }
    }

    private boolean checkBlockAgeValues() {
        if (this.block != null) {
            float max;
            float min;
            assert (this.units == (this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M'));
            if (this.scaleType == BlockProperties.ScaleType.AGE) {
                min = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMinAge : this.jTextFieldTopDepth).getText()), (int)3);
                max = (float)SB.round((double)Double.parseDouble((this.block instanceof WellBlock ? this.jTextFieldMaxAge : this.jTextFieldBaseDepth).getText()), (int)3);
            } else {
                min = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
                max = (float)DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.getWell().getType());
            }
            if (min > max) {
                if (this.block instanceof WellBlock) {
                    if (this.block.getWell().getType() == 'W') {
                        JOptionPane.showMessageDialog(this, "Top depth is greater than base depth", this.getTitle(), 2);
                    } else {
                        JOptionPane.showMessageDialog(this, "Top depth is less than base depth", this.getTitle(), 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Max age must be greater than min age", this.getTitle(), 2);
                }
                return false;
            }
        }
        return true;
    }

    private void jButtonCopyActionPerformed(ActionEvent e) {
        ChartManager cm = null;
        if (this.getParent() instanceof FrameChart) {
            cm = ((FrameChart)this.getParent()).getChartManager();
        }
        DialogChartTemplates dialog = new DialogChartTemplates(this, true, this.sbdb, cm, null, (Boolean)true, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection.size() > 0) {
            ChartTemplateBase b = dialog.selection.get(0);
            Component openTab = this.jTabbedPane1.getSelectedComponent();
            if (b instanceof ChartTemplateBase) {
                if (b.getType() == null) {
                    try {
                        ChartTemplate chart = cm.getChartTemplate(b.getID());
                        if (chart != null) {
                            String props = chart.getProperties();
                            ChartProperties newCp = new ChartProperties(props, this.scheme != null ? this.scheme.getID() : 0);
                            String header = chart.getHeaderProperties();
                            if (StringUtils.isNotBlank((CharSequence)header)) {
                                newCp.header = new PanelWellHeader(header);
                            }
                            this.init(newCp, true, this.jButtonOK.isEnabled());
                            this.jTabbedPane1.setSelectedComponent(openTab);
                        }
                    }
                    catch (SQLException ex) {
                        StackError.showStackError((Exception)ex);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Select a CHART to copy from, not a block template", this.getTitle(), 1);
                }
            }
        }
    }

    private void jButtonApplyActionPerformed(ActionEvent e) {
        boolean valuesOK = this.checkBlockAgeValues();
        if (!valuesOK) {
            return;
        }
        boolean changed = true;
        try {
            changed = this.applyChanges();
        }
        catch (InvalidFieldException ex) {
            Logger.getLogger(DialogChartFont.class.getName()).log(Level.WARNING, null, ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 2);
            return;
        }
        if (this.applyListener != null && changed) {
            this.applyListener.actionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent e) {
        FrameJsbugs.openHelp("dialogchartproperties.html");
    }

    private void jCheckBoxKeyActionPerformed(ActionEvent e) {
        this.enableKeyFields(this.jCheckBoxKey.isSelected());
    }

    private void jTextFieldHdrHeightKeyTyped(KeyEvent e) {
        if (SB.intFieldVal((JTextField)this.jTextFieldKeyHeight, (int)3, (KeyEvent)e, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOkActionPerformed(ActionEvent e) {
        boolean valuesOK = this.checkBlockAgeValues();
        if (!valuesOK) {
            return;
        }
        boolean changed = true;
        try {
            changed = this.applyChanges();
        }
        catch (InvalidFieldException ex) {
            Logger.getLogger(DialogChartFont.class.getName()).log(Level.WARNING, null, ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 2);
            return;
        }
        if (changed) {
            this.setOK();
        }
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("locale.UiText");
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.jButtonApply = new JButton();
        this.jButtonCopy = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelBlockProperties = new JPanel();
        this.panel2 = new JPanel();
        this.jLabelTopDepth = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jTextFieldMinAge = new JTextField();
        this.jLabelMinAge = new JLabel();
        this.jLabelLOCMinAge = new JLabel();
        this.jLabelBaseDepth = new JLabel();
        this.jTextFieldBaseDepth = new JTextField();
        this.jTextFieldMaxAge = new JTextField();
        this.jLabelMaxAge = new JLabel();
        this.jLabelLOCMaxAge = new JLabel();
        this.jLabelBlockScale = new JLabel();
        this.jComboBoxVerticalScale = new JComboBox();
        this.jLabelScale = new JLabel();
        this.jPanelWellObj = new JPanel();
        this.jLabelWellObj = new JLabel();
        this.jTextFieldWellObj = new JTextField();
        this.jButtonWellObj = new JButton();
        this.jButtonWellObjClear = new JButton();
        this.jLabelBlockVersion = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.panel3 = new JPanel();
        this.jPanelBlockScaleType = new JPanel();
        this.jRadioButtonMD = new JRadioButton();
        this.jRadioButtonTVD = new JRadioButton();
        this.jRadioButtonAGE = new JRadioButton();
        this.jPanelBlockUnits = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jPanelFonts = new JPanel();
        this.jLabelFontName = new JLabel();
        this.jComboBoxFont = new JComboBox();
        this.jLabelFontSize = new JLabel();
        this.jSpinnerFontSize = new JSpinner();
        this.jLabelFontSizeUnits = new JLabel();
        this.jButtonDefaultFont = new JButton();
        this.jPanelColours = new JPanel();
        this.jLabelForeground = new JLabel();
        this.jTextFieldForeground = new JTextField();
        this.jButtonForeground = new JButton();
        this.jCheckBoxGreyscale = new JCheckBox();
        this.jLabelBackground = new JLabel();
        this.jTextFieldBackground = new JTextField();
        this.jButtonBackground = new JButton();
        this.jPanelBackgroundShading = new JPanel();
        this.jLabelFromScheme = new JLabel();
        this.jTextFieldbgScheme = new JTextField();
        this.jButtonSelectScheme = new JButton();
        this.jButtonClearScheme = new JButton();
        this.jLabelFromLevel = new JLabel();
        this.jComboBoxHier = new JComboBox();
        this.jLabelDensity = new JLabel();
        this.jSliderbgDensity = new JSlider();
        this.jCheckBoxbgBlocks = new JCheckBox();
        this.jCheckBoxBgPinchouts = new JCheckBox();
        this.jLabelIntervalGap = new JLabel();
        this.jTextFieldGapHatchColour = new JTextField();
        this.jButtonGapHatchColour = new JButton();
        this.jPanelDimensions = new JPanel();
        this.jPanelHeaders = new JPanel();
        this.jLabelPanelCaptionHeight = new JLabel();
        this.jSpinnerCaption = new JSpinner();
        this.jLabelExtendedCaptionHeight = new JLabel();
        this.jSpinnerExtCaption = new JSpinner();
        this.jLabelSubHeaderHeight = new JLabel();
        this.jSpinnerSubHeader = new JSpinner();
        this.jLabelTotalPanelHeaderHeight = new JLabel();
        this.jTextFieldTotalHeaderHeight = new JTextField();
        this.jPanelBlockCaptions = new JPanel();
        this.jCheckBoxCaptions = new JCheckBox();
        this.jRadioButtonCapTop = new JRadioButton();
        this.jRadioButtonCapBase = new JRadioButton();
        this.jLabelBlockCaptionsHeight = new JLabel();
        this.jSpinnerCapHeight = new JSpinner();
        this.jRadioButtonCapAlignChart = new JRadioButton();
        this.jRadioButtonCapAlignBlocks = new JRadioButton();
        this.jLabelBlockCaptionsFontSize = new JLabel();
        this.jComboBoxBlockCapFontSize = new JComboBox();
        this.jLabelBlockCaptionsWellNames = new JLabel();
        this.jComboBoxBCWellNames = new JComboBox();
        this.jPanelBlockSpacing = new JPanel();
        this.jLabelSpacingBetweenBlocks = new JLabel();
        this.jSpinnerBlankSpace = new JSpinner();
        this.jCheckBoxBlankRelative = new JCheckBox();
        this.jCheckBoxMapAlign = new JCheckBox();
        this.jLabelChartMargins = new JLabel();
        this.jSpinnerMargin = new JSpinner();
        this.jCheckBoxChartBorder = new JCheckBox();
        this.jLabelNumPanelsToFreeze = new JLabel();
        this.jSpinnerVfreeze = new JSpinner();
        this.jPanelHeader = new JPanel();
        this.panel1 = new JPanel();
        this.jRadioButtonHdrNone = new JRadioButton();
        this.jRadioButtonHdrWell = new JRadioButton();
        this.jRadioButtonHdrFree = new JRadioButton();
        this.jRadioButtonHdrTop = new JRadioButton();
        this.jRadioButtonHdrBottom = new JRadioButton();
        this.jPanelHdrCards = new JPanel();
        this.jPanelHdrWell = new JPanel();
        this.jCheckBoxWellCode = new JCheckBox();
        this.jCheckBoxOperator = new JCheckBox();
        this.jCheckBoxLocation = new JCheckBox();
        this.jRadioButtonLocDec = new JRadioButton();
        this.jRadioButtonLocDMS = new JRadioButton();
        this.jCheckBoxSpud = new JCheckBox();
        this.jCheckBoxComments = new JCheckBox();
        this.jCheckBoxClientName = new JCheckBox();
        this.jCheckBoxDepthInterval = new JCheckBox();
        this.jCheckBoxTD = new JCheckBox();
        this.jPanelHdrFree = new JPanel();
        this.jLabelHeaderTitle = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.jTextAreaHdrTitle = new JTextArea();
        this.jPanelHdrNone = new JPanel();
        this.jPanelHeaderHeight = new JPanel();
        this.jLabelHdrHeight = new JLabel();
        this.jTextFieldHdrHeight = new JTextField();
        this.jCheckBoxHdrWellList = new JCheckBox();
        this.jCheckBoxHdrTemplName = new JCheckBox();
        this.jCheckBoxHdrTemplDescr = new JCheckBox();
        this.jCheckBoxHdrTemplDate = new JCheckBox();
        this.jCheckBoxLogo = new JCheckBox();
        this.jCheckBoxBorder = new JCheckBox();
        this.jCheckBoxScale = new JCheckBox();
        this.panel8 = new JPanel();
        this.jLabelHdrTitlePos = new JLabel();
        this.jRadioButtonWellNameLeft = new JRadioButton();
        this.jRadioButtonWellNameCentre = new JRadioButton();
        this.jLabelHdrAuthor = new JLabel();
        this.jTextFieldHdrAuthor = new JTextField();
        this.jLabelHdrEnclosure = new JLabel();
        this.jTextFieldHdrEnclosure = new JTextField();
        this.jLabelWellName = new JLabel();
        this.jComboBoxWellName = new JComboBox();
        this.jPanelKey = new JPanel();
        this.jCheckBoxKey = new JCheckBox();
        this.jLabelKeyOrientation = new JLabel();
        this.jRadioButtonKeyTop = new JRadioButton();
        this.jRadioButtonKeyBottom = new JRadioButton();
        this.jRadioButtonKeyLeft = new JRadioButton();
        this.jRadioButtonKeyRight = new JRadioButton();
        this.jLabelKeySize = new JLabel();
        this.jTextFieldKeyHeight = new JTextField();
        this.jCheckBoxKeyBorder = new JCheckBox();
        this.jPanelKeyOptions = new JPanel();
        this.jCheckBoxKeyText = new JCheckBox();
        this.jCheckBoxKeyAbn = new JCheckBox();
        this.jCheckBoxKeyBnd = new JCheckBox();
        this.jCheckBoxKeyCorr = new JCheckBox();
        this.jCheckBoxKeyLithBase = new JCheckBox();
        this.jCheckBoxKeyTxGroup = new JCheckBox();
        this.jCheckBoxKeyLithQual = new JCheckBox();
        this.jCheckBoxKeyCats = new JCheckBox();
        this.jCheckBoxKeySamp = new JCheckBox();
        this.jCheckBoxKeyEnvSchs = new JCheckBox();
        this.jPanelData = new JPanel();
        this.jCheckBoxCorrectDepth = new JCheckBox();
        this.jCheckBoxCorrectCuttings = new JCheckBox();
        this.jLabelDisplayAgesIn = new JLabel();
        this.jRadioButtonAFMA = new JRadioButton();
        this.jRadioButtonAFKA = new JRadioButton();
        this.jCheckBoxDrawEmptyPanels = new JCheckBox();
        this.jCheckBoxDrawDisconfs = new JCheckBox();
        this.jCheckBoxDrawDisconfDuration = new JCheckBox();
        this.jCheckBoxCorrTick = new JCheckBox();
        this.jLabelDefaultChartDatum = new JLabel();
        this.enumComboChartDatum = new EnumCombo();
        this.setTitle(bundle.getString("DialogChartProperties.title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3,gap 3 3", "[fill][fill][grow][fill][fill][fill]", "[fill]"));
        this.jButtonApply.setText(bundle.getString("button.apply"));
        this.jButtonApply.addActionListener(e -> this.jButtonApplyActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonApply, "cell 0 0");
        this.jButtonCopy.setText(bundle.getString("DialogChartProperties.jButtonCopy"));
        this.jButtonCopy.addActionListener(e -> this.jButtonCopyActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonCopy, "cell 1 0");
        this.jButtonOK.setText(bundle.getString("button.ok"));
        this.jButtonOK.addActionListener(e -> this.jButtonOkActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonOK, "cell 3 0");
        this.jButtonHelp.setText(bundle.getString("button.help"));
        this.jButtonHelp.addActionListener(e -> this.jButtonHelpActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonHelp, "cell 4 0");
        this.jButtonCancel.setText(bundle.getString("button.cancel"));
        this.jButtonCancel.addActionListener(e -> this.jButtonCancelActionPerformed(e));
        this.buttonBar.add((Component)this.jButtonCancel, "cell 5 0");
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.jPanelBlockProperties.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "[fill]", "[][][]"));
        this.panel2.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill][fill][fill]", "[][][]"));
        this.jLabelTopDepth.setText(bundle.getString("label.topdepth"));
        this.panel2.add((Component)this.jLabelTopDepth, "cell 0 0");
        this.jTextFieldTopDepth.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogChartProperties this$0;
            {
                DialogChartProperties dialogChartProperties = this$0;
                Objects.requireNonNull(dialogChartProperties);
                this.this$0 = dialogChartProperties;
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.this$0.jTextFieldTopDepthFocusLost(e);
            }
        });
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartProperties this$0;
            {
                DialogChartProperties dialogChartProperties = this$0;
                Objects.requireNonNull(dialogChartProperties);
                this.this$0 = dialogChartProperties;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.this$0.jTextFieldTopDepthKeyTyped(e);
            }
        });
        this.panel2.add((Component)this.jTextFieldTopDepth, "cell 1 0");
        this.jTextFieldMinAge.setEditable(false);
        this.jTextFieldMinAge.setBackground(new Color(0xFFFFCC));
        this.jTextFieldMinAge.setToolTipText(bundle.getString("DialogChartProperties.jTextFieldMinAge.toolTipText"));
        this.panel2.add((Component)this.jTextFieldMinAge, "cell 2 0");
        this.jLabelMinAge.setText(bundle.getString("DialogChartProperties.jLabelMinAge.text"));
        this.panel2.add((Component)this.jLabelMinAge, "cell 3 0");
        this.jLabelLOCMinAge.setText(bundle.getString("DialogChartProperties.jLabelLOCMinAge.text"));
        this.jLabelLOCMinAge.setForeground(new Color(0x999999));
        this.panel2.add((Component)this.jLabelLOCMinAge, "cell 4 0");
        this.jLabelBaseDepth.setText(bundle.getString("label.basedepth"));
        this.panel2.add((Component)this.jLabelBaseDepth, "cell 0 1");
        this.jTextFieldBaseDepth.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogChartProperties this$0;
            {
                DialogChartProperties dialogChartProperties = this$0;
                Objects.requireNonNull(dialogChartProperties);
                this.this$0 = dialogChartProperties;
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.this$0.jTextFieldBaseDepthFocusLost(e);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartProperties this$0;
            {
                DialogChartProperties dialogChartProperties = this$0;
                Objects.requireNonNull(dialogChartProperties);
                this.this$0 = dialogChartProperties;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.this$0.jTextFieldBaseDepthKeyTyped(e);
            }
        });
        this.panel2.add((Component)this.jTextFieldBaseDepth, "cell 1 1");
        this.jTextFieldMaxAge.setEditable(false);
        this.jTextFieldMaxAge.setBackground(new Color(0xFFFFCC));
        this.jTextFieldMaxAge.setToolTipText(bundle.getString("DialogChartProperties.jTextFieldMaxAge.toolTipText"));
        this.panel2.add((Component)this.jTextFieldMaxAge, "cell 2 1");
        this.jLabelMaxAge.setText(bundle.getString("DialogChartProperties.jLabelMaxAge.text"));
        this.panel2.add((Component)this.jLabelMaxAge, "cell 3 1");
        this.jLabelLOCMaxAge.setText(bundle.getString("DialogChartProperties.jLabelLOCMaxAge.text"));
        this.jLabelLOCMaxAge.setForeground(new Color(0x999999));
        this.panel2.add((Component)this.jLabelLOCMaxAge, "cell 4 1");
        this.jLabelBlockScale.setText(bundle.getString("label.scale"));
        this.panel2.add((Component)this.jLabelBlockScale, "cell 0 2");
        this.panel2.add((Component)this.jComboBoxVerticalScale, "cell 1 2");
        this.jLabelScale.setText(bundle.getString("DialogChartProperties.jLabelScale.text"));
        this.panel2.add((Component)this.jLabelScale, "cell 2 2");
        this.jPanelBlockProperties.add((Component)this.panel2, "cell 0 0 2 1");
        this.jPanelWellObj.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill][fill]", "[][]"));
        this.jLabelWellObj.setText(bundle.getString("DialogChartProperties.jLabelWellObj.text"));
        this.jPanelWellObj.add((Component)this.jLabelWellObj, "cell 0 0");
        this.jPanelWellObj.add((Component)this.jTextFieldWellObj, "cell 1 0");
        this.jButtonWellObj.setText(bundle.getString("button.ellipsis"));
        this.jButtonWellObj.addActionListener(e -> this.jButtonWellObjActionPerformed(e));
        this.jPanelWellObj.add((Component)this.jButtonWellObj, "cell 2 0");
        this.jButtonWellObjClear.setText(bundle.getString("button.clear"));
        this.jButtonWellObjClear.addActionListener(e -> this.jButtonWellObjClearActionPerformed(e));
        this.jPanelWellObj.add((Component)this.jButtonWellObjClear, "cell 3 0");
        this.jLabelBlockVersion.setText(bundle.getString("label.version"));
        this.jPanelWellObj.add((Component)this.jLabelBlockVersion, "cell 0 1");
        this.jComboBoxVersion.setMaximumRowCount(30);
        this.jPanelWellObj.add((Component)this.jComboBoxVersion, "cell 1 1");
        this.jPanelBlockProperties.add((Component)this.jPanelWellObj, "cell 0 1 2 1");
        this.panel3.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[]"));
        this.jPanelBlockScaleType.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelBlockScaleType.border")));
        this.jPanelBlockScaleType.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill]", "[][][]"));
        this.jRadioButtonMD.setText(bundle.getString("DialogChartProperties.jRadioButtonMD.text"));
        this.jRadioButtonMD.addActionListener(e -> this.jRadioButtonMDActionPerformed(e));
        this.jPanelBlockScaleType.add((Component)this.jRadioButtonMD, "cell 0 0");
        this.jRadioButtonTVD.setText(bundle.getString("DialogChartProperties.jRadioButtonTVD.text"));
        this.jRadioButtonTVD.addActionListener(e -> this.jRadioButtonTVDActionPerformed(e));
        this.jPanelBlockScaleType.add((Component)this.jRadioButtonTVD, "cell 0 1");
        this.jRadioButtonAGE.setText(bundle.getString("DialogChartProperties.jRadioButtonAGE.text"));
        this.jRadioButtonAGE.addActionListener(e -> this.jRadioButtonAGEActionPerformed(e));
        this.jPanelBlockScaleType.add((Component)this.jRadioButtonAGE, "cell 0 2");
        this.panel3.add((Component)this.jPanelBlockScaleType, "cell 0 0");
        this.jPanelBlockUnits.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelBlockUnits.border")));
        this.jPanelBlockUnits.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[]"));
        this.jRadioButtonMetres.setText(bundle.getString("DialogChartProperties.jRadioButtonMetres.text"));
        this.jRadioButtonMetres.setSelected(true);
        this.jRadioButtonMetres.addActionListener(e -> this.jRadioButtonMetresActionPerformed(e));
        this.jPanelBlockUnits.add((Component)this.jRadioButtonMetres, "cell 0 0");
        this.jRadioButtonFeet.setText(bundle.getString("DialogChartProperties.jRadioButtonFeet.text"));
        this.jRadioButtonFeet.addActionListener(e -> this.jRadioButtonFeetActionPerformed(e));
        this.jPanelBlockUnits.add((Component)this.jRadioButtonFeet, "cell 1 0");
        this.panel3.add((Component)this.jPanelBlockUnits, "cell 1 0,aligny top,growy 0");
        this.jPanelBlockProperties.add((Component)this.panel3, "cell 0 2");
        this.jTabbedPane1.addTab(bundle.getString("DialogChartProperties.jPanelBlockProperties.title"), this.jPanelBlockProperties);
        this.jPanelFonts.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "[fill][fill][fill][fill][grow]", "[][]"));
        this.jLabelFontName.setText(bundle.getString("DialogChartProperties.jLabelFontName.text"));
        this.jPanelFonts.add((Component)this.jLabelFontName, "cell 0 0");
        this.jPanelFonts.add((Component)this.jComboBoxFont, "cell 1 0 4 1");
        this.jLabelFontSize.setText(bundle.getString("DialogChartProperties.jLabelFontSize.text"));
        this.jLabelFontSize.setHorizontalAlignment(4);
        this.jPanelFonts.add((Component)this.jLabelFontSize, "cell 0 1");
        this.jSpinnerFontSize.setModel(new SpinnerNumberModel(8.5, 2.0, 42.0, 0.5));
        this.jPanelFonts.add((Component)this.jSpinnerFontSize, "cell 1 1");
        this.jLabelFontSizeUnits.setText(bundle.getString("DialogChartProperties.jLabelFontSizeUnits.text"));
        this.jPanelFonts.add((Component)this.jLabelFontSizeUnits, "cell 2 1,gapx 0 20,gapy 0 0");
        this.jButtonDefaultFont.setText(bundle.getString("DialogChartProperties.jButtonDefaultFont.text"));
        this.jButtonDefaultFont.addActionListener(e -> this.jButtonDefaultFontActionPerformed(e));
        this.jPanelFonts.add((Component)this.jButtonDefaultFont, "cell 3 1");
        this.jTabbedPane1.addTab(bundle.getString("DialogChartProperties.jPanelFonts.tab.title"), this.jPanelFonts);
        this.jPanelColours.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "[fill][fill][fill][fill,grow][fill]", "[][][][]"));
        this.jLabelForeground.setText(bundle.getString("DialogChartProperties.jLabelForeground.text"));
        this.jLabelForeground.setHorizontalAlignment(11);
        this.jPanelColours.add((Component)this.jLabelForeground, "cell 0 0");
        this.jTextFieldForeground.setEditable(false);
        this.jTextFieldForeground.setEnabled(false);
        this.jTextFieldForeground.setMinimumSize(new Dimension(22, 22));
        this.jTextFieldForeground.setPreferredSize(new Dimension(22, 22));
        this.jPanelColours.add((Component)this.jTextFieldForeground, "cell 1 0");
        this.jButtonForeground.setText(bundle.getString("button.ellipsis"));
        this.jButtonForeground.addActionListener(e -> this.jButtonForegroundActionPerformed(e));
        this.jPanelColours.add((Component)this.jButtonForeground, "cell 2 0");
        this.jCheckBoxGreyscale.setText(bundle.getString("DialogChartProperties.jCheckBoxGreyscale.text"));
        this.jCheckBoxGreyscale.setHorizontalAlignment(4);
        this.jCheckBoxGreyscale.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxGreyscale.toolTipText"));
        this.jPanelColours.add((Component)this.jCheckBoxGreyscale, "cell 4 0");
        this.jLabelBackground.setText(bundle.getString("DialogChartProperties.jLabelBackground.text"));
        this.jLabelBackground.setHorizontalAlignment(11);
        this.jPanelColours.add((Component)this.jLabelBackground, "cell 0 1");
        this.jTextFieldBackground.setEditable(false);
        this.jTextFieldBackground.setEnabled(false);
        this.jTextFieldBackground.setMinimumSize(new Dimension(22, 22));
        this.jTextFieldBackground.setPreferredSize(new Dimension(22, 22));
        this.jPanelColours.add((Component)this.jTextFieldBackground, "cell 1 1");
        this.jButtonBackground.setText(bundle.getString("button.ellipsis"));
        this.jButtonBackground.addActionListener(e -> this.jButtonBackgroundActionPerformed(e));
        this.jPanelColours.add((Component)this.jButtonBackground, "cell 2 1");
        this.jPanelBackgroundShading.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelBackgroundShading.border")));
        this.jPanelBackgroundShading.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "[fill][fill,grow][fill,grow][fill][fill]", "[][][][]"));
        this.jLabelFromScheme.setText(bundle.getString("DialogChartProperties.jLabelFromScheme.text"));
        this.jPanelBackgroundShading.add((Component)this.jLabelFromScheme, "cell 0 0");
        this.jPanelBackgroundShading.add((Component)this.jTextFieldbgScheme, "cell 1 0 2 1");
        this.jButtonSelectScheme.setText(bundle.getString("button.ellipsis"));
        this.jButtonSelectScheme.addActionListener(e -> this.jButtonSelectSchemeActionPerformed(e));
        this.jPanelBackgroundShading.add((Component)this.jButtonSelectScheme, "cell 3 0");
        this.jButtonClearScheme.setText(bundle.getString("button.clear"));
        this.jButtonClearScheme.addActionListener(e -> this.jButtonClearSchemeActionPerformed(e));
        this.jPanelBackgroundShading.add((Component)this.jButtonClearScheme, "cell 4 0");
        this.jLabelFromLevel.setText(bundle.getString("DialogChartProperties.jLabelFromLevel.text"));
        this.jPanelBackgroundShading.add((Component)this.jLabelFromLevel, "cell 0 1");
        this.jPanelBackgroundShading.add((Component)this.jComboBoxHier, "cell 1 1 2 1");
        this.jLabelDensity.setText(bundle.getString("DialogChartProperties.jLabelDensity.text"));
        this.jPanelBackgroundShading.add((Component)this.jLabelDensity, "cell 0 2");
        this.jSliderbgDensity.setValue(30);
        this.jPanelBackgroundShading.add((Component)this.jSliderbgDensity, "cell 1 2 2 1");
        this.jCheckBoxbgBlocks.setText(bundle.getString("DialogChartProperties.jCheckBoxbgBlocks.text"));
        this.jPanelBackgroundShading.add((Component)this.jCheckBoxbgBlocks, "cell 1 3");
        this.jCheckBoxBgPinchouts.setText(bundle.getString("DialogChartProperties.jCheckBoxBgPinchouts.text"));
        this.jPanelBackgroundShading.add((Component)this.jCheckBoxBgPinchouts, "cell 2 3");
        this.jPanelColours.add((Component)this.jPanelBackgroundShading, "cell 0 2 5 1");
        this.jLabelIntervalGap.setText(bundle.getString("DialogChartProperties.jLabelIntervalGap.text"));
        this.jPanelColours.add((Component)this.jLabelIntervalGap, "cell 0 3");
        this.jTextFieldGapHatchColour.setMinimumSize(new Dimension(22, 22));
        this.jTextFieldGapHatchColour.setEditable(false);
        this.jTextFieldGapHatchColour.setEnabled(false);
        this.jTextFieldGapHatchColour.setPreferredSize(new Dimension(22, 22));
        this.jPanelColours.add((Component)this.jTextFieldGapHatchColour, "cell 1 3");
        this.jButtonGapHatchColour.setText(bundle.getString("button.ellipsis"));
        this.jButtonGapHatchColour.addActionListener(e -> this.jButtonGapHatchColourActionPerformed(e));
        this.jPanelColours.add((Component)this.jButtonGapHatchColour, "cell 2 3");
        this.jTabbedPane1.addTab(bundle.getString("DialogChartProperties.jPanelColours.tab.title"), this.jPanelColours);
        this.jPanelDimensions.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill, grow][fill][fill][fill,grow]", "[][][][]"));
        this.jPanelHeaders.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelHeaders.border")));
        this.jPanelHeaders.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill]", "[][][][]"));
        this.jLabelPanelCaptionHeight.setText(bundle.getString("DialogChartProperties.jLabelPanelCaptionHeight.text"));
        this.jPanelHeaders.add((Component)this.jLabelPanelCaptionHeight, "cell 0 0 2 1,alignx right,growx 0");
        this.jSpinnerCaption.setModel(new SpinnerNumberModel(0, 0, 200, 1));
        this.jSpinnerCaption.addChangeListener(e -> this.jSpinnerCaptionStateChanged(e));
        this.jPanelHeaders.add((Component)this.jSpinnerCaption, "cell 2 0");
        this.jLabelExtendedCaptionHeight.setText(bundle.getString("DialogChartProperties.jLabelExtendedCaptionHeight.text"));
        this.jPanelHeaders.add((Component)this.jLabelExtendedCaptionHeight, "cell 0 1 2 1,alignx right,growx 0");
        this.jSpinnerExtCaption.setModel(new SpinnerNumberModel(80, 0, 500, 5));
        this.jPanelHeaders.add((Component)this.jSpinnerExtCaption, "cell 2 1");
        this.jLabelSubHeaderHeight.setText(bundle.getString("DialogChartProperties.jLabelSubHeaderHeight.text"));
        this.jPanelHeaders.add((Component)this.jLabelSubHeaderHeight, "cell 0 2");
        this.jSpinnerSubHeader.setModel(new SpinnerNumberModel(80, 0, 500, 5));
        this.jSpinnerSubHeader.addChangeListener(e -> this.jSpinnerSubHeaderStateChanged(e));
        this.jPanelHeaders.add((Component)this.jSpinnerSubHeader, "cell 1 2 2 1");
        this.jLabelTotalPanelHeaderHeight.setText(bundle.getString("DialogChartProperties.jLabelTotalPanelHeaderHeight.text"));
        this.jPanelHeaders.add((Component)this.jLabelTotalPanelHeaderHeight, "cell 0 3 2 1,alignx right,growx 0");
        this.jTextFieldTotalHeaderHeight.setEnabled(false);
        this.jPanelHeaders.add((Component)this.jTextFieldTotalHeaderHeight, "cell 2 3");
        this.jPanelDimensions.add((Component)this.jPanelHeaders, "cell 0 0 3 1");
        this.jPanelBlockCaptions.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelBlockCaptions.border")));
        this.jPanelBlockCaptions.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill]", "[][][][][][][][]"));
        this.jCheckBoxCaptions.setText(bundle.getString("DialogChartProperties.jCheckBoxCaptions.text"));
        this.jPanelBlockCaptions.add((Component)this.jCheckBoxCaptions, "cell 0 0 2 1");
        this.jRadioButtonCapTop.setText(bundle.getString("button.top"));
        this.jPanelBlockCaptions.add((Component)this.jRadioButtonCapTop, "cell 0 1");
        this.jRadioButtonCapBase.setText(bundle.getString("button.bottom"));
        this.jPanelBlockCaptions.add((Component)this.jRadioButtonCapBase, "cell 1 1");
        this.jLabelBlockCaptionsHeight.setText(bundle.getString("DialogChartProperties.jLabelBlockCaptionsHeight.text"));
        this.jPanelBlockCaptions.add((Component)this.jLabelBlockCaptionsHeight, "cell 0 2");
        this.jPanelBlockCaptions.add((Component)this.jSpinnerCapHeight, "cell 1 2");
        this.jRadioButtonCapAlignChart.setText(bundle.getString("DialogChartProperties.jRadioButtonCapAlignChart.text"));
        this.jPanelBlockCaptions.add((Component)this.jRadioButtonCapAlignChart, "cell 0 3 2 1");
        this.jRadioButtonCapAlignBlocks.setText(bundle.getString("DialogChartProperties.jRadioButtonCapAlignBlocks.text"));
        this.jPanelBlockCaptions.add((Component)this.jRadioButtonCapAlignBlocks, "cell 0 4 2 1");
        this.jLabelBlockCaptionsFontSize.setText(bundle.getString("DialogChartProperties.jLabelBlockCaptionsFontSize.text"));
        this.jPanelBlockCaptions.add((Component)this.jLabelBlockCaptionsFontSize, "cell 0 5");
        this.jPanelBlockCaptions.add((Component)this.jComboBoxBlockCapFontSize, "cell 1 5 2 1");
        this.jLabelBlockCaptionsWellNames.setText(bundle.getString("DialogChartProperties.jLabelBlockCaptionsWellNames.text"));
        this.jPanelBlockCaptions.add((Component)this.jLabelBlockCaptionsWellNames, "cell 0 6 2 1");
        this.jPanelBlockCaptions.add((Component)this.jComboBoxBCWellNames, "cell 0 7 3 1");
        this.jPanelDimensions.add((Component)this.jPanelBlockCaptions, "cell 3 0 3 3,growy");
        this.jPanelBlockSpacing.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelBlockSpacing.border")));
        this.jPanelBlockSpacing.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][]"));
        this.jLabelSpacingBetweenBlocks.setText(bundle.getString("DialogChartProperties.jLabelSpacingBetweenBlocks.text"));
        this.jPanelBlockSpacing.add((Component)this.jLabelSpacingBetweenBlocks, "cell 0 0");
        this.jSpinnerBlankSpace.setModel(new SpinnerNumberModel(100, 10, 1000, 10));
        this.jSpinnerBlankSpace.setToolTipText(bundle.getString("DialogChartProperties.jSpinnerBlankSpace.toolTipText"));
        this.jPanelBlockSpacing.add((Component)this.jSpinnerBlankSpace, "cell 1 0");
        this.jCheckBoxBlankRelative.setText(bundle.getString("DialogChartProperties.jCheckBoxBlankRelative.text"));
        this.jCheckBoxBlankRelative.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxBlankRelative.toolTipText"));
        this.jPanelBlockSpacing.add((Component)this.jCheckBoxBlankRelative, "cell 0 1 2 1");
        this.jCheckBoxMapAlign.setText(bundle.getString("DialogChartProperties.jCheckBoxMapAlign.text"));
        this.jCheckBoxMapAlign.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxMapAlign.toolTipText"));
        this.jPanelBlockSpacing.add((Component)this.jCheckBoxMapAlign, "cell 0 2 2 1");
        this.jPanelDimensions.add((Component)this.jPanelBlockSpacing, "cell 0 1 3 1");
        this.jLabelChartMargins.setText(bundle.getString("DialogChartProperties.jLabelChartMargins.text"));
        this.jPanelDimensions.add((Component)this.jLabelChartMargins, "cell 0 2");
        this.jSpinnerMargin.setToolTipText(bundle.getString("DialogChartProperties.jSpinnerMargin.toolTipText"));
        this.jSpinnerMargin.setModel(new SpinnerNumberModel(3, 0, 20, 1));
        this.jPanelDimensions.add((Component)this.jSpinnerMargin, "cell 1 2");
        this.jCheckBoxChartBorder.setText(bundle.getString("DialogChartProperties.jCheckBoxChartBorder.text"));
        this.jPanelDimensions.add((Component)this.jCheckBoxChartBorder, "cell 0 3");
        this.jLabelNumPanelsToFreeze.setText(bundle.getString("DialogChartProperties.jLabelNumPanelsToFreeze.text"));
        this.jPanelDimensions.add((Component)this.jLabelNumPanelsToFreeze, "cell 3 3");
        this.jSpinnerVfreeze.setModel(new SpinnerNumberModel(1, 1, 8, 1));
        this.jSpinnerVfreeze.setToolTipText(bundle.getString("DialogChartProperties.jSpinnerVfreeze.toolTipText"));
        this.jPanelDimensions.add((Component)this.jSpinnerVfreeze, "cell 4 3");
        this.jTabbedPane1.addTab(bundle.getString("DialogChartProperties.jPanelDimensions.tab.title"), this.jPanelDimensions);
        this.jPanelHeader.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "[fill][fill]", "[][][][]"));
        this.panel1.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill][fill][fill]", "[]"));
        this.jRadioButtonHdrNone.setText(bundle.getString("DialogChartProperties.jRadioButtonHdrNone.text"));
        this.jRadioButtonHdrNone.addActionListener(e -> this.jRadioButtonHdrNoneActionPerformed(e));
        this.panel1.add((Component)this.jRadioButtonHdrNone, "cell 0 0");
        this.jRadioButtonHdrWell.setText(bundle.getString("DialogChartProperties.jRadioButtonHdrWell.text"));
        this.jRadioButtonHdrWell.addActionListener(e -> this.jRadioButtonHdrWellActionPerformed(e));
        this.panel1.add((Component)this.jRadioButtonHdrWell, "cell 1 0");
        this.jRadioButtonHdrFree.setText(bundle.getString("DialogChartProperties.jRadioButtonHdrFree.text"));
        this.jRadioButtonHdrFree.addActionListener(e -> this.jRadioButtonHdrFreeActionPerformed(e));
        this.panel1.add((Component)this.jRadioButtonHdrFree, "cell 2 0");
        this.jRadioButtonHdrTop.setText(bundle.getString("button.top"));
        this.panel1.add((Component)this.jRadioButtonHdrTop, "cell 3 0,gapx 10 0,gapy null 0");
        this.jRadioButtonHdrBottom.setText(bundle.getString("button.bottom"));
        this.jRadioButtonHdrBottom.setSelected(true);
        this.panel1.add((Component)this.jRadioButtonHdrBottom, "cell 4 0");
        this.jPanelHeader.add((Component)this.panel1, "cell 0 0 2 1");
        this.jPanelHdrCards.setLayout(new CardLayout());
        this.jPanelHdrWell.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelHdrWell.border")));
        this.jPanelHdrWell.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill]", "[][][][][]"));
        this.jCheckBoxWellCode.setText(bundle.getString("DialogChartProperties.jCheckBoxWellCode.text"));
        this.jPanelHdrWell.add((Component)this.jCheckBoxWellCode, "cell 0 0 2 1");
        this.jCheckBoxOperator.setText(bundle.getString("DialogChartProperties.jCheckBoxOperator.text"));
        this.jPanelHdrWell.add((Component)this.jCheckBoxOperator, "cell 2 0");
        this.jCheckBoxLocation.setText(bundle.getString("DialogChartProperties.jCheckBoxLocation.text"));
        this.jCheckBoxLocation.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxLocation.toolTipText"));
        this.jCheckBoxLocation.addActionListener(e -> this.jCheckBoxLocationActionPerformed(e));
        this.jPanelHdrWell.add((Component)this.jCheckBoxLocation, "cell 0 1");
        this.jRadioButtonLocDec.setText(bundle.getString("DialogChartProperties.jRadioButtonLocDec.text"));
        this.jPanelHdrWell.add((Component)this.jRadioButtonLocDec, "cell 1 1");
        this.jRadioButtonLocDMS.setText(bundle.getString("DialogChartProperties.jRadioButtonLocDMS.text"));
        this.jPanelHdrWell.add((Component)this.jRadioButtonLocDMS, "cell 2 1");
        this.jCheckBoxSpud.setText(bundle.getString("DialogChartProperties.jCheckBoxSpud.text"));
        this.jPanelHdrWell.add((Component)this.jCheckBoxSpud, "cell 0 2 2 1");
        this.jCheckBoxComments.setText(bundle.getString("DialogChartProperties.jCheckBoxComments.text"));
        this.jCheckBoxComments.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxComments.toolTipText"));
        this.jPanelHdrWell.add((Component)this.jCheckBoxComments, "cell 2 2");
        this.jCheckBoxClientName.setText(bundle.getString("DialogChartProperties.jCheckBoxClientName.text"));
        this.jPanelHdrWell.add((Component)this.jCheckBoxClientName, "cell 0 3 2 1");
        this.jCheckBoxDepthInterval.setText(bundle.getString("DialogChartProperties.jCheckBoxDepthInterval.text"));
        this.jPanelHdrWell.add((Component)this.jCheckBoxDepthInterval, "cell 2 3");
        this.jCheckBoxTD.setText(bundle.getString("DialogChartProperties.jCheckBoxTD.text"));
        this.jPanelHdrWell.add((Component)this.jCheckBoxTD, "cell 0 4 2 1");
        this.jPanelHdrCards.add((Component)this.jPanelHdrWell, "cardWell");
        this.jPanelHdrFree.setLayout((LayoutManager)new MigLayout("fill,hidemode 3,aligny top", "[fill][fill,grow]", "[grow]"));
        this.jLabelHeaderTitle.setText(bundle.getString("label.title"));
        this.jPanelHdrFree.add((Component)this.jLabelHeaderTitle, "cell 0 0,aligny top,growy 0");
        this.jTextAreaHdrTitle.setRows(5);
        this.jTextAreaHdrTitle.setColumns(20);
        this.scrollPane1.setViewportView(this.jTextAreaHdrTitle);
        this.jPanelHdrFree.add((Component)this.scrollPane1, "cell 1 0,aligny top,growy 0");
        this.jPanelHdrCards.add((Component)this.jPanelHdrFree, "cardFree");
        this.jPanelHdrNone.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][]"));
        this.jPanelHdrCards.add((Component)this.jPanelHdrNone, "cardNone");
        this.jPanelHeader.add((Component)this.jPanelHdrCards, "cell 0 1");
        this.jPanelHeaderHeight.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][][][][][][]"));
        this.jLabelHdrHeight.setText(bundle.getString("DialogChartProperties.jLabelHdrHeight.text"));
        this.jPanelHeaderHeight.add((Component)this.jLabelHdrHeight, "cell 0 0");
        this.jPanelHeaderHeight.add((Component)this.jTextFieldHdrHeight, "cell 1 0");
        this.jCheckBoxHdrWellList.setText(bundle.getString("DialogChartProperties.jCheckBoxHdrWellList.text"));
        this.jCheckBoxHdrWellList.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxHdrWellList.toolTipText"));
        this.jPanelHeaderHeight.add((Component)this.jCheckBoxHdrWellList, "cell 0 1 2 1");
        this.jCheckBoxHdrTemplName.setText(bundle.getString("DialogChartProperties.jCheckBoxHdrTemplName.text"));
        this.jPanelHeaderHeight.add((Component)this.jCheckBoxHdrTemplName, "cell 0 2 2 1");
        this.jCheckBoxHdrTemplDescr.setText(bundle.getString("DialogChartProperties.jCheckBoxHdrTemplDescr.text"));
        this.jCheckBoxHdrTemplDescr.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxHdrTemplDescr.toolTipText"));
        this.jPanelHeaderHeight.add((Component)this.jCheckBoxHdrTemplDescr, "cell 0 3 2 1");
        this.jCheckBoxHdrTemplDate.setText(bundle.getString("DialogChartProperties.jCheckBoxHdrTemplDate.text"));
        this.jPanelHeaderHeight.add((Component)this.jCheckBoxHdrTemplDate, "cell 0 4 2 1");
        this.jCheckBoxLogo.setText(bundle.getString("DialogChartProperties.jCheckBoxLogo.text"));
        this.jCheckBoxLogo.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxLogo.toolTipText"));
        this.jPanelHeaderHeight.add((Component)this.jCheckBoxLogo, "cell 0 5 2 1");
        this.jCheckBoxBorder.setText(bundle.getString("DialogChartProperties.jCheckBoxBorder.text"));
        this.jPanelHeaderHeight.add((Component)this.jCheckBoxBorder, "cell 0 6 2 1");
        this.jCheckBoxScale.setText(bundle.getString("DialogChartProperties.jCheckBoxScale.text"));
        this.jPanelHeaderHeight.add((Component)this.jCheckBoxScale, "cell 0 7 2 1");
        this.jPanelHeader.add((Component)this.jPanelHeaderHeight, "cell 1 1 1 2,aligny top,growy 0");
        this.panel8.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "[fill][fill][fill][fill]", "[][][][]"));
        this.jLabelHdrTitlePos.setText(bundle.getString("DialogChartProperties.jLabelHdrTitlePos.text"));
        this.panel8.add((Component)this.jLabelHdrTitlePos, "cell 0 0");
        this.jRadioButtonWellNameLeft.setText(bundle.getString("DialogChartProperties.jRadioButtonWellNameLeft.text"));
        this.panel8.add((Component)this.jRadioButtonWellNameLeft, "cell 1 0");
        this.jRadioButtonWellNameCentre.setText(bundle.getString("DialogChartProperties.jRadioButtonWellNameCentre.text"));
        this.panel8.add((Component)this.jRadioButtonWellNameCentre, "cell 2 0");
        this.jLabelHdrAuthor.setText(bundle.getString("DialogChartProperties.jLabelHdrAuthor.text"));
        this.panel8.add((Component)this.jLabelHdrAuthor, "cell 0 1");
        this.panel8.add((Component)this.jTextFieldHdrAuthor, "cell 1 1 3 1");
        this.jLabelHdrEnclosure.setText(bundle.getString("DialogChartProperties.jLabelHdrEnclosure.text"));
        this.panel8.add((Component)this.jLabelHdrEnclosure, "cell 0 2");
        this.panel8.add((Component)this.jTextFieldHdrEnclosure, "cell 1 2 3 1");
        this.jLabelWellName.setText(bundle.getString("DialogChartProperties.jLabelWellName.text"));
        this.panel8.add((Component)this.jLabelWellName, "cell 0 3");
        this.panel8.add((Component)this.jComboBoxWellName, "cell 1 3 3 1");
        this.jPanelHeader.add((Component)this.panel8, "cell 0 2");
        this.jTabbedPane1.addTab(bundle.getString("DialogChartProperties.jPanelHeader.tab.title"), this.jPanelHeader);
        this.jPanelKey.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3", "[fill][fill][fill][fill][fill][fill, grow]", "[][][][]"));
        this.jCheckBoxKey.setText(bundle.getString("DialogChartProperties.jCheckBoxKey.text"));
        this.jCheckBoxKey.addActionListener(e -> this.jCheckBoxKeyActionPerformed(e));
        this.jPanelKey.add((Component)this.jCheckBoxKey, "cell 0 0 5 1");
        this.jLabelKeyOrientation.setText(bundle.getString("DialogChartProperties.jLabelKeyOrientation.text"));
        this.jPanelKey.add((Component)this.jLabelKeyOrientation, "cell 0 1,alignx right,growx 0");
        this.jRadioButtonKeyTop.setText(bundle.getString("button.top"));
        this.jPanelKey.add((Component)this.jRadioButtonKeyTop, "cell 1 1");
        this.jRadioButtonKeyBottom.setText(bundle.getString("button.bottom"));
        this.jPanelKey.add((Component)this.jRadioButtonKeyBottom, "cell 2 1");
        this.jRadioButtonKeyLeft.setText(bundle.getString("button.left"));
        this.jPanelKey.add((Component)this.jRadioButtonKeyLeft, "cell 3 1");
        this.jRadioButtonKeyRight.setText(bundle.getString("button.right"));
        this.jPanelKey.add((Component)this.jRadioButtonKeyRight, "cell 4 1");
        this.jLabelKeySize.setText(bundle.getString("label.size"));
        this.jPanelKey.add((Component)this.jLabelKeySize, "cell 0 2,alignx right,growx 0");
        this.jTextFieldKeyHeight.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartProperties this$0;
            {
                DialogChartProperties dialogChartProperties = this$0;
                Objects.requireNonNull(dialogChartProperties);
                this.this$0 = dialogChartProperties;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.this$0.jTextFieldHdrHeightKeyTyped(e);
            }
        });
        this.jPanelKey.add((Component)this.jTextFieldKeyHeight, "cell 1 2");
        this.jCheckBoxKeyBorder.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyBorder.text"));
        this.jPanelKey.add((Component)this.jCheckBoxKeyBorder, "cell 2 2");
        this.jPanelKeyOptions.setBorder(new TitledBorder(bundle.getString("DialogChartProperties.jPanelKeyOptions.border")));
        this.jPanelKeyOptions.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill]", "[][][][][]"));
        this.jCheckBoxKeyText.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyText.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyText, "cell 0 0");
        this.jCheckBoxKeyAbn.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyAbn.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyAbn, "cell 1 0");
        this.jCheckBoxKeyBnd.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyBnd.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyBnd, "cell 0 1");
        this.jCheckBoxKeyCorr.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyCorr.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyCorr, "cell 1 1");
        this.jCheckBoxKeyLithBase.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyLithBase.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyLithBase, "cell 0 2");
        this.jCheckBoxKeyTxGroup.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyTxGroup.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyTxGroup, "cell 1 2");
        this.jCheckBoxKeyLithQual.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyLithQual.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyLithQual, "cell 0 3");
        this.jCheckBoxKeyCats.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyCats.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyCats, "cell 1 3");
        this.jCheckBoxKeySamp.setText(bundle.getString("DialogChartProperties.jCheckBoxKeySamp.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeySamp, "cell 0 4");
        this.jCheckBoxKeyEnvSchs.setText(bundle.getString("DialogChartProperties.jCheckBoxKeyEnvSchs.text"));
        this.jPanelKeyOptions.add((Component)this.jCheckBoxKeyEnvSchs, "cell 1 4");
        this.jPanelKey.add((Component)this.jPanelKeyOptions, "cell 0 3 5 1");
        this.jTabbedPane1.addTab(bundle.getString("DialogChartProperties.jPanelKey.tab.title"), this.jPanelKey);
        this.jPanelData.setLayout((LayoutManager)new MigLayout("hidemode 3", "[fill][fill][fill][fill]", "[][][][][][][][]"));
        this.jCheckBoxCorrectDepth.setText(bundle.getString("DialogChartProperties.jCheckBoxCorrectDepth.text"));
        this.jPanelData.add((Component)this.jCheckBoxCorrectDepth, "cell 0 0 4 1");
        this.jCheckBoxCorrectCuttings.setText(bundle.getString("DialogChartProperties.jCheckBoxCorrectCuttings.text"));
        this.jPanelData.add((Component)this.jCheckBoxCorrectCuttings, "cell 0 1 4 1");
        this.jLabelDisplayAgesIn.setText(bundle.getString("DialogChartProperties.jLabelDisplayAgesIn.text"));
        this.jPanelData.add((Component)this.jLabelDisplayAgesIn, "cell 0 2");
        this.jRadioButtonAFMA.setText(bundle.getString("DialogChartProperties.jRadioButtonAFMA.text"));
        this.jPanelData.add((Component)this.jRadioButtonAFMA, "cell 1 2");
        this.jRadioButtonAFKA.setText(bundle.getString("DialogChartProperties.jRadioButtonAFKA.text"));
        this.jPanelData.add((Component)this.jRadioButtonAFKA, "cell 2 2");
        this.jCheckBoxDrawEmptyPanels.setText(bundle.getString("DialogChartProperties.jCheckBoxDrawEmptyPanels.text"));
        this.jPanelData.add((Component)this.jCheckBoxDrawEmptyPanels, "cell 0 3 3 1");
        this.jCheckBoxDrawDisconfs.setText(bundle.getString("DialogChartProperties.jCheckBoxDrawDisconfs.text"));
        this.jCheckBoxDrawDisconfs.setToolTipText(bundle.getString("DialogChartProperties.jCheckBoxDrawDisconfs.toolTipText"));
        this.jPanelData.add((Component)this.jCheckBoxDrawDisconfs, "cell 0 4 4 1");
        this.jCheckBoxDrawDisconfDuration.setText(bundle.getString("DialogChartProperties.jCheckBoxDrawDisconfDuration.text"));
        this.jPanelData.add((Component)this.jCheckBoxDrawDisconfDuration, "cell 0 5 4 1");
        this.jCheckBoxCorrTick.setText(bundle.getString("DialogChartProperties.jCheckBoxCorrTick.text"));
        this.jPanelData.add((Component)this.jCheckBoxCorrTick, "cell 0 6 4 1");
        this.jLabelDefaultChartDatum.setText(bundle.getString("DialogChartProperties.jLabelDefaultChartDatum.text"));
        this.jPanelData.add((Component)this.jLabelDefaultChartDatum, "cell 0 7 2 1");
        this.jPanelData.add((Component)this.enumComboChartDatum, "cell 2 7");
        this.jTabbedPane1.addTab(bundle.getString("DialogChartProperties.jPanelData.tab.title"), this.jPanelData);
        this.dialogPane.add((Component)this.jTabbedPane1, "North");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroupScaleType = new ButtonGroup();
        buttonGroupScaleType.add(this.jRadioButtonMD);
        buttonGroupScaleType.add(this.jRadioButtonTVD);
        buttonGroupScaleType.add(this.jRadioButtonAGE);
        ButtonGroup buttonGroupUnits = new ButtonGroup();
        buttonGroupUnits.add(this.jRadioButtonMetres);
        buttonGroupUnits.add(this.jRadioButtonFeet);
        ButtonGroup buttonGroupCapPos = new ButtonGroup();
        buttonGroupCapPos.add(this.jRadioButtonCapTop);
        buttonGroupCapPos.add(this.jRadioButtonCapBase);
        ButtonGroup buttonGroupCapAlign = new ButtonGroup();
        buttonGroupCapAlign.add(this.jRadioButtonCapAlignChart);
        buttonGroupCapAlign.add(this.jRadioButtonCapAlignBlocks);
        ButtonGroup buttonGroupHeader = new ButtonGroup();
        buttonGroupHeader.add(this.jRadioButtonHdrNone);
        buttonGroupHeader.add(this.jRadioButtonHdrWell);
        buttonGroupHeader.add(this.jRadioButtonHdrFree);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonHdrTop);
        buttonGroup1.add(this.jRadioButtonHdrBottom);
        ButtonGroup buttonGroupHdrLocation = new ButtonGroup();
        buttonGroupHdrLocation.add(this.jRadioButtonLocDec);
        buttonGroupHdrLocation.add(this.jRadioButtonLocDMS);
        ButtonGroup buttonGroupTitlePos = new ButtonGroup();
        buttonGroupTitlePos.add(this.jRadioButtonWellNameLeft);
        buttonGroupTitlePos.add(this.jRadioButtonWellNameCentre);
        ButtonGroup buttonGroupKeyPlacement = new ButtonGroup();
        buttonGroupKeyPlacement.add(this.jRadioButtonKeyTop);
        buttonGroupKeyPlacement.add(this.jRadioButtonKeyBottom);
        buttonGroupKeyPlacement.add(this.jRadioButtonKeyLeft);
        buttonGroupKeyPlacement.add(this.jRadioButtonKeyRight);
        ButtonGroup buttonGroupAgeFormat = new ButtonGroup();
        buttonGroupAgeFormat.add(this.jRadioButtonAFMA);
        buttonGroupAgeFormat.add(this.jRadioButtonAFKA);
    }
}

