/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import jsbchart.panel.PanelTaxonOcc;
import jsbugs.DialogList;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectTaxa;
import jsbugs.FrameJsbugs;
import jsbugs.chart.properties.taxon.DialogCategorySelect;
import jsbugs.list.RestrictableProjectListCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.CompositeStandard;
import model3.Lastval;
import model3.SBdb;
import model3.TxGroup;
import model3.TxGroupSet;
import org.apache.commons.lang3.StringUtils;

public class DialogPanelTaxonFilter
extends SBDialog {
    private final Discipline disc;
    private final SBdb sbdb;
    private final TxGroupSet outerFilter;
    private final int projID;
    private final boolean innerPanel;
    private TxGroupSet filter_set = null;
    private TxGroup filter_group = null;
    private final List<Category> filter_cat = new LinkedList<Category>();
    private model3.Taxon filter_spec = null;
    private CompositeStandard filter_std = null;
    private PanelTaxonOcc.Filter selectedFilter;
    private final Frame myParent;
    private ButtonGroup buttonGroup1;
    private Box.Filler filler1;
    private JButton jButtonCancel;
    private JButton jButtonCat;
    private JButton jButtonCmpStd;
    private JButton jButtonGroup;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSet;
    private JButton jButtonSpec;
    private JCheckBox jCheckBoxSubCats;
    private JRadioButton jRadioButtonCat;
    private JRadioButton jRadioButtonCatForEach;
    private JRadioButton jRadioButtonCmpStd;
    private JRadioButton jRadioButtonGroup;
    private JRadioButton jRadioButtonGroupForEach;
    private JRadioButton jRadioButtonNone;
    private JRadioButton jRadioButtonSet;
    private JRadioButton jRadioButtonSpec;
    private JSeparator jSeparator1;
    private JTextField jTextFieldCat;
    private JTextField jTextFieldCmpStd;
    private JTextField jTextFieldGroup;
    private JTextField jTextFieldSet;
    private JTextField jTextFieldSpec;

    public DialogPanelTaxonFilter(Frame parent, boolean modal, PanelTaxonOcc.Filter filter, String noFilterString, TxGroupSet outerFilter, Discipline disc, int projID, boolean innerPanel) {
        super(parent, modal);
        this.initComponents();
        this.myParent = parent;
        this.sbdb = SbugsSession.getDb();
        this.outerFilter = outerFilter;
        if (disc == null) {
            throw new IllegalArgumentException("Discipline null for filter selector");
        }
        this.disc = disc;
        this.projID = projID;
        this.innerPanel = innerPanel;
        this.init(filter, noFilterString);
    }

    private void init(PanelTaxonOcc.Filter filter, String noFilterString) {
        this.setTitle("Restrict " + (this.innerPanel ? "Inner" : "Outer") + " Panel Data");
        this.jRadioButtonNone.setText(noFilterString);
        if (filter != null) {
            if (filter.getFilter() instanceof model3.Taxon) {
                this.filter_spec = (model3.Taxon)filter.getFilter();
                this.jRadioButtonSpec.setSelected(true);
            } else if (filter.getFilter() instanceof TxGroupSet) {
                this.filter_set = (TxGroupSet)filter.getFilter();
                this.jRadioButtonSet.setSelected(true);
            } else if (filter.getFilter() instanceof TxGroup) {
                this.filter_group = (TxGroup)filter.getFilter();
                this.jRadioButtonGroup.setSelected(true);
            } else if (filter.getFilter() instanceof Category) {
                this.filter_cat.add((Category)filter.getFilter());
                this.jRadioButtonCat.setSelected(true);
            } else if (filter.getFilter() instanceof Category[]) {
                this.filter_cat.addAll(Arrays.asList((Category[])filter.getFilter()));
                this.jRadioButtonCat.setSelected(true);
            } else if (filter.getFilter() instanceof Integer) {
                this.jRadioButtonCatForEach.setSelected(filter.getFilter() == PanelTaxonOcc.Filter.FOR_EACH_CAT);
                this.jRadioButtonGroupForEach.setSelected(filter.getFilter() == PanelTaxonOcc.Filter.FOR_EACH_GROUP);
            } else if (filter.getFilter() instanceof CompositeStandard) {
                this.filter_std = (CompositeStandard)filter.getFilter();
                this.jRadioButtonCmpStd.setSelected(true);
            }
        }
        this.setFilterFields();
        if (!this.innerPanel) {
            this.jRadioButtonSpec.setVisible(false);
            this.jTextFieldSpec.setVisible(false);
            this.jButtonSpec.setVisible(false);
            this.jRadioButtonGroup.setVisible(false);
            this.jTextFieldGroup.setVisible(false);
            this.jButtonGroup.setVisible(false);
            this.jRadioButtonGroupForEach.setVisible(false);
            this.jRadioButtonCmpStd.setVisible(false);
            this.jTextFieldCmpStd.setVisible(false);
            this.jButtonCmpStd.setVisible(false);
            this.jRadioButtonCatForEach.setVisible(false);
            this.jCheckBoxSubCats.setVisible(false);
            this.jRadioButtonCat.setText("Categories");
            this.jRadioButtonCat.setHorizontalTextPosition(11);
            this.pack();
        }
    }

    private void setFilterFields() {
        this.jTextFieldCat.setText(!this.filter_cat.isEmpty() && this.jRadioButtonCat.isSelected() ? StringUtils.join(this.filter_cat, (String)", ") : "");
        this.jTextFieldGroup.setText(this.filter_group != null && this.jRadioButtonGroup.isSelected() ? this.filter_group.toString() : "");
        this.jTextFieldSet.setText(this.filter_set != null && this.jRadioButtonSet.isSelected() ? this.filter_set.toString() : "");
        this.jTextFieldSpec.setText(this.filter_spec != null && this.jRadioButtonSpec.isSelected() ? this.filter_spec.toString(false, true) : "");
        this.jCheckBoxSubCats.setEnabled(this.jRadioButtonCat.isSelected());
        this.jTextFieldCmpStd.setText(this.filter_std != null && this.jRadioButtonCmpStd.isSelected() ? this.filter_std.toString() : "");
    }

    private void selectFilterCat() {
        DialogCategorySelect dialog = null;
        try {
            List categoryList = this.sbdb.getCategoryService().getCategoryList().stream().filter(c -> c.getDiscipline() == this.disc).collect(Collectors.toCollection(ArrayList::new));
            dialog = new DialogCategorySelect(this.myParent, true, !this.innerPanel);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setCategories(categoryList, this.sbdb.getCategoryService().getCategoryList());
            if (this.filter_cat != null && !this.filter_cat.isEmpty()) {
                dialog.setSelectedCategories(new ArrayList<Category>(this.filter_cat));
            }
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jRadioButtonCat.setSelected(true);
                this.filter_cat.clear();
                this.filter_cat.addAll(dialog.getCategories());
            }
        }
        finally {
            if (dialog != null) {
                dialog.dispose();
            }
        }
    }

    private void selectFilterGroup() {
        try {
            ArrayList<TxGroup> groups = this.outerFilter != null ? new ArrayList<TxGroup>(this.outerFilter.getGroups()) : new ArrayList<TxGroup>(this.sbdb.getTxGroups(this.projID, true));
            Collections.sort(groups);
            DialogList<TxGroup> dialog = new DialogList<TxGroup>((JDialog)((Object)this), true, "Select Group", null, groups, true, false, (ListCellRenderer)new RestrictableProjectListCellRenderer());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.jRadioButtonGroup.setSelected(true);
                this.filter_group = dialog.getSelection();
            }
        }
        catch (SQLException sqle) {
            SbugsExceptionHandler.showStackError(sqle, (Component)((Object)this));
        }
    }

    private void selectFilterSet() {
        try {
            List<TxGroupSet> txGroupSets = this.sbdb.getTxGroupSets(this.projID, true);
            Collections.sort(txGroupSets);
            DialogList<TxGroupSet> dialog = new DialogList<TxGroupSet>((JDialog)((Object)this), true, "Select Group Set", null, txGroupSets, true, false, (ListCellRenderer)new RestrictableProjectListCellRenderer());
            dialog.setLocation(this.getX() + this.getWidth() / 2, this.getY());
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.jRadioButtonSet.setSelected(true);
                this.filter_set = dialog.getSelection();
            }
        }
        catch (SQLException sqle) {
            SbugsExceptionHandler.showStackError(sqle, (Component)((Object)this));
        }
    }

    private void selectFilterSpec() {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)((Object)this), true, this.sbdb, Lastval.getInt(this.sbdb, "SYNSCHID", 1), true, (Taxon)Optional.ofNullable(this.filter_spec).map(model3.Taxon::getTaxonCopy).orElse(null));
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelectedItem() != null) {
                this.jRadioButtonSpec.setSelected(true);
                this.filter_spec = this.sbdb.getTaxon(((Taxon)dialog.getSelectedItem()).getSpecID());
            }
        }
        catch (SQLException e) {
            SbugsExceptionHandler.showDialogStackError(e, (Component)((Object)this));
        }
    }

    private void selectFilterStd() {
        try {
            DialogSelectCmpStd dialog = new DialogSelectCmpStd((JDialog)((Object)this), true, this.sbdb);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.jRadioButtonCmpStd.setSelected(true);
                this.filter_std = dialog.getSelection();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButtonSet = new JRadioButton();
        this.jTextFieldSet = new JTextField();
        this.jButtonSet = new JButton();
        this.jRadioButtonGroup = new JRadioButton();
        this.jTextFieldGroup = new JTextField();
        this.jButtonGroup = new JButton();
        this.jRadioButtonGroupForEach = new JRadioButton();
        this.jRadioButtonSpec = new JRadioButton();
        this.jTextFieldSpec = new JTextField();
        this.jButtonSpec = new JButton();
        this.jRadioButtonCat = new JRadioButton();
        this.jTextFieldCat = new JTextField();
        this.jButtonCat = new JButton();
        this.jRadioButtonCatForEach = new JRadioButton();
        this.jCheckBoxSubCats = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jRadioButtonNone = new JRadioButton();
        this.jRadioButtonCmpStd = new JRadioButton();
        this.jTextFieldCmpStd = new JTextField();
        this.jButtonCmpStd = new JButton();
        this.filler1 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.buttonGroup1.add(this.jRadioButtonSet);
        this.jRadioButtonSet.setText("Group set:");
        this.jRadioButtonSet.setHorizontalAlignment(11);
        this.jRadioButtonSet.setHorizontalTextPosition(10);
        this.jRadioButtonSet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSetActionPerformed(evt);
            }
        });
        this.jTextFieldSet.setEditable(false);
        this.jTextFieldSet.setBackground(new Color(255, 255, 204));
        this.jButtonSet.setText("...");
        this.jButtonSet.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSetActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonGroup);
        this.jRadioButtonGroup.setText("Group:");
        this.jRadioButtonGroup.setHorizontalAlignment(11);
        this.jRadioButtonGroup.setHorizontalTextPosition(10);
        this.jRadioButtonGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonGroupActionPerformed(evt);
            }
        });
        this.jTextFieldGroup.setEditable(false);
        this.jTextFieldGroup.setBackground(new Color(255, 255, 204));
        this.jButtonGroup.setText("...");
        this.jButtonGroup.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGroupActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonGroupForEach);
        this.jRadioButtonGroupForEach.setText("Each available");
        this.buttonGroup1.add(this.jRadioButtonSpec);
        this.jRadioButtonSpec.setText("Species:");
        this.jRadioButtonSpec.setHorizontalAlignment(11);
        this.jRadioButtonSpec.setHorizontalTextPosition(10);
        this.jRadioButtonSpec.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSpecActionPerformed(evt);
            }
        });
        this.jTextFieldSpec.setEditable(false);
        this.jTextFieldSpec.setBackground(new Color(255, 255, 204));
        this.jButtonSpec.setText("...");
        this.jButtonSpec.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSpec.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSpecActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonCat);
        this.jRadioButtonCat.setText("Category:");
        this.jRadioButtonCat.setHorizontalAlignment(11);
        this.jRadioButtonCat.setHorizontalTextPosition(10);
        this.jRadioButtonCat.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonCatActionPerformed(evt);
            }
        });
        this.jTextFieldCat.setEditable(false);
        this.jTextFieldCat.setBackground(new Color(255, 255, 204));
        this.jButtonCat.setText("...");
        this.jButtonCat.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonCat.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCatActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonCatForEach);
        this.jRadioButtonCatForEach.setText("Each available");
        this.jCheckBoxSubCats.setText("Include sub-categories");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonNone);
        this.jRadioButtonNone.setSelected(true);
        this.jRadioButtonNone.setText("No filter");
        this.buttonGroup1.add(this.jRadioButtonCmpStd);
        this.jRadioButtonCmpStd.setText("Composite Standard:");
        this.jRadioButtonCmpStd.setHorizontalAlignment(11);
        this.jRadioButtonCmpStd.setHorizontalTextPosition(10);
        this.jRadioButtonCmpStd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonCmpStdActionPerformed(evt);
            }
        });
        this.jTextFieldCmpStd.setBackground(new Color(255, 255, 204));
        this.jButtonCmpStd.setText("...");
        this.jButtonCmpStd.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonCmpStd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogPanelTaxonFilter this$0;
            {
                DialogPanelTaxonFilter dialogPanelTaxonFilter = this$0;
                Objects.requireNonNull(dialogPanelTaxonFilter);
                this.this$0 = dialogPanelTaxonFilter;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCmpStdActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonSet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSet, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSet, -2, 30, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jRadioButtonSpec, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSpec)).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonGroup, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGroup, -2, 156, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonGroup, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonGroupForEach)).addComponent(this.jButtonSpec, -2, 30, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCat, -2, 156, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCat, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCatForEach)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jRadioButtonCmpStd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCmpStd, -2, 202, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCmpStd, -2, 30, -2))).addComponent(this.jCheckBoxSubCats, GroupLayout.Alignment.TRAILING, -2, 312, -2).addComponent(this.jRadioButtonNone, -2, 271, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.filler1, -2, 6, -2)));
        layout.linkSize(0, this.jRadioButtonCat, this.jRadioButtonGroup, this.jRadioButtonSet, this.jRadioButtonSpec);
        layout.linkSize(0, this.jTextFieldCat, this.jTextFieldGroup, this.jTextFieldSet, this.jTextFieldSpec);
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jRadioButtonNone).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonSet).addComponent(this.jTextFieldSet, -2, -1, -2).addComponent(this.jButtonSet)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonSpec).addComponent(this.jTextFieldSpec, -2, -1, -2).addComponent(this.jButtonSpec)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldGroup, -2, -1, -2).addComponent(this.jButtonGroup).addComponent(this.jRadioButtonGroupForEach).addComponent(this.jRadioButtonGroup)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonCat).addComponent(this.jTextFieldCat, -2, -1, -2).addComponent(this.jButtonCat).addComponent(this.jRadioButtonCatForEach)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSubCats).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonCmpStd).addComponent(this.jTextFieldCmpStd, -2, -1, -2).addComponent(this.jButtonCmpStd)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()).addComponent(this.filler1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jRadioButtonSetActionPerformed(ActionEvent evt) {
        this.selectFilterSet();
        this.setFilterFields();
    }

    private void jRadioButtonSpecActionPerformed(ActionEvent evt) {
        this.selectFilterSpec();
        this.setFilterFields();
    }

    private void jRadioButtonGroupActionPerformed(ActionEvent evt) {
        this.selectFilterGroup();
        this.setFilterFields();
    }

    private void jRadioButtonCatActionPerformed(ActionEvent evt) {
        this.selectFilterCat();
        this.setFilterFields();
    }

    private void jButtonSetActionPerformed(ActionEvent evt) {
        this.selectFilterSet();
        this.setFilterFields();
    }

    private void jButtonSpecActionPerformed(ActionEvent evt) {
        this.selectFilterSpec();
        this.setFilterFields();
    }

    private void jButtonGroupActionPerformed(ActionEvent evt) {
        this.selectFilterGroup();
        this.setFilterFields();
    }

    private void jButtonCatActionPerformed(ActionEvent evt) {
        this.selectFilterCat();
        this.setFilterFields();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!this.jRadioButtonNone.isSelected()) {
            if (this.jRadioButtonCat.isSelected() && this.filter_cat.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a filter category", this.getTitle(), 2);
                return;
            }
            if (this.jRadioButtonGroup.isSelected() && this.filter_group == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a filter group", this.getTitle(), 2);
                return;
            }
            if (this.jRadioButtonSet.isSelected() && this.filter_set == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a filter group set", this.getTitle(), 2);
                return;
            }
            if (this.jRadioButtonSpec.isSelected() && this.filter_spec == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a filter species", this.getTitle(), 2);
                return;
            }
            if (this.jRadioButtonCmpStd.isSelected() && this.filter_std == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a filter composite standard", this.getTitle(), 2);
                return;
            }
            if (this.jRadioButtonGroupForEach.isSelected() && this.outerFilter == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The outer panel filter must be a group set", this.getTitle(), 2);
                return;
            }
            Object filterObj = null;
            if (this.jRadioButtonSpec.isSelected()) {
                filterObj = this.filter_spec;
            } else if (this.jRadioButtonGroup.isSelected()) {
                filterObj = this.filter_group;
            } else if (this.jRadioButtonSet.isSelected()) {
                filterObj = this.filter_set;
            } else if (this.jRadioButtonCat.isSelected()) {
                filterObj = this.innerPanel ? this.filter_cat.get(0) : this.filter_cat.toArray(new Category[this.filter_cat.size()]);
            } else if (this.jRadioButtonCatForEach.isSelected()) {
                filterObj = PanelTaxonOcc.Filter.FOR_EACH_CAT;
            } else if (this.jRadioButtonGroupForEach.isSelected()) {
                filterObj = PanelTaxonOcc.Filter.FOR_EACH_GROUP;
            } else if (this.jRadioButtonCmpStd.isSelected()) {
                filterObj = this.filter_std;
            }
            if (filterObj != null) {
                this.selectedFilter = new PanelTaxonOcc.Filter(filterObj, this.jCheckBoxSubCats.isSelected());
            }
        } else {
            this.selectedFilter = null;
        }
        this.setOK();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogpaneltaxon.html");
    }

    private void jRadioButtonCmpStdActionPerformed(ActionEvent evt) {
        if (this.filter_std == null) {
            this.selectFilterStd();
        }
        this.setFilterFields();
    }

    private void jButtonCmpStdActionPerformed(ActionEvent evt) {
        this.selectFilterStd();
        this.setFilterFields();
    }

    public PanelTaxonOcc.Filter getSelectedFilter() {
        return this.selectedFilter;
    }
}

