/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import jsbchart.core.BlockTemplateChild;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelType;
import jsbugs.table.PanelTypeRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import model3.Well;
import org.apache.commons.lang3.StringUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class DialogTemplateChildren
extends SBDialog {
    private final BlockTemplateParent parent;
    private final DefaultListModel<Well> wellListModel = new DefaultListModel();
    private final TableModelOverrides tableModel = new TableModelOverrides(this);
    private Well selectedWell;
    private final List<PanelOverride> panelOverrides = new ArrayList<PanelOverride>();
    private static final int COL_NO = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_PROPS = 2;
    private static final int COL_ACTION = 3;
    private static final String[] COL_TITLES = new String[]{"Panel no.", "Type", "Overridden properties", ""};
    private static final int[] COL_WIDTHS = new int[]{15, 50, 100, 15};
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JLabel jLabelAudit;
    private JList<Well> jListWells;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableOverrides;

    public DialogTemplateChildren(Window parent, BlockTemplateParent parentTemplate) throws SQLException, SBException {
        super(parent, true);
        this.parent = parentTemplate;
        this.initComponents();
        this.init();
        this.initWellList();
        this.tableModel.setupTable(this.jTableOverrides);
    }

    private void init() {
        this.setTitle("Overrides for '" + this.parent.getName() + "'");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jLabelAudit.setText("");
    }

    private void initWellList() throws SQLException, SBException {
        this.wellListModel.removeAllElements();
        LinkedList<Well> list = new LinkedList<Well>();
        for (Integer wellID : this.parent.getChildWellIDs()) {
            Well well = SbugsSession.getDb().getWell(wellID);
            list.add(well);
        }
        Collections.sort(list);
        this.wellListModel.addAll(list);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListWells = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTableOverrides = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jLabelAudit = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jListWells.setModel(this.wellListModel);
        this.jListWells.setSelectionMode(0);
        this.jListWells.addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ DialogTemplateChildren this$0;
            {
                DialogTemplateChildren dialogTemplateChildren = this$0;
                Objects.requireNonNull(dialogTemplateChildren);
                this.this$0 = dialogTemplateChildren;
            }

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                this.this$0.jListWellsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWells);
        this.jTableOverrides.setModel(this.tableModel);
        this.jScrollPane2.setViewportView(this.jTableOverrides);
        this.jButtonDelete.setText("Delete all panel overrides for this well");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTemplateChildren this$0;
            {
                DialogTemplateChildren dialogTemplateChildren = this$0;
                Objects.requireNonNull(dialogTemplateChildren);
                this.this$0 = dialogTemplateChildren;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogTemplateChildren this$0;
            {
                DialogTemplateChildren dialogTemplateChildren = this$0;
                Objects.requireNonNull(dialogTemplateChildren);
                this.this$0 = dialogTemplateChildren;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jLabelAudit.setForeground(new Color(102, 102, 102));
        this.jLabelAudit.setText("Audit info");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane2, -1, 415, Short.MAX_VALUE).addComponent(this.jLabelAudit, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 195, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabelAudit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDelete).addComponent(this.jButtonClose)).addGap(4, 4, 4))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jListWellsValueChanged(ListSelectionEvent evt) {
        if (this.jListWells.getSelectedIndex() < 0) {
            return;
        }
        this.selectedWell = this.wellListModel.getElementAt(this.jListWells.getSelectedIndex());
        this.resetTable();
        this.resetAuditInfo();
    }

    private void resetTable() {
        this.panelOverrides.clear();
        BlockTemplateChild childBlockTemplate = this.parent.getChild(this.selectedWell.getWellID());
        ChartManager chartManager = SbugsSession.getSession().getChartManager();
        try {
            List<PanelOcc> parentPanelOccs = this.parent.getPanels();
            List<PanelOcc> childPanelOccs = childBlockTemplate.getPanels();
            if (parentPanelOccs.size() != childPanelOccs.size()) {
                throw new IllegalStateException("Corrupted template: n parent panels: " + parentPanelOccs.size() + ", n child panels: " + childPanelOccs.size());
            }
            for (int i = 0; i < parentPanelOccs.size(); ++i) {
                int n;
                PanelOcc childPanelOcc;
                PanelOcc parentPanelOcc = parentPanelOccs.get(i);
                if (parentPanelOcc.equals((Object)(childPanelOcc = childPanelOccs.get(i)))) continue;
                PanelTemplate parentTemplate = chartManager.getPanelTemplate(parentPanelOcc.getPanelID());
                PanelTemplate childTemplate = chartManager.getPanelTemplate(childPanelOcc.getPanelID());
                LinkedList<Object> overriddenPropertyNames = new LinkedList<Object>();
                for (n = 0; n < 6; ++n) {
                    if (Objects.equals(parentPanelOcc.getProperty(n), childPanelOcc.getProperty(n))) continue;
                    overriddenPropertyNames.add(PanelOcc.getPropertyName(n).toLowerCase());
                }
                if (parentTemplate.getProperties().getnProps() != childTemplate.getProperties().getnProps()) {
                    overriddenPropertyNames.add("Different number of properties: " + parentTemplate.getName() + "/" + childTemplate.getName());
                } else {
                    for (n = 0; n < parentTemplate.getProperties().getnProps(); ++n) {
                        if (Objects.equals(parentTemplate.getProperties().getProperty(n), childTemplate.getProperties().getProperty(n))) continue;
                        overriddenPropertyNames.add(parentTemplate.getProperties().getPropertyName(n).toLowerCase());
                    }
                    if (parentTemplate.isTaxonPanelTemplate()) {
                        LinkedList<PanelTaxonOcc> parentInnerPanels = ((PanelTaxonGroupProperties)parentTemplate.getProperties()).getInnerPanels();
                        if (!childTemplate.isTaxonPanelTemplate()) {
                            overriddenPropertyNames.add("Not a taxon panel: " + childTemplate.getName());
                        } else {
                            LinkedList<PanelTaxonOcc> childInnerPanels = ((PanelTaxonGroupProperties)childTemplate.getProperties()).getInnerPanels();
                            if (!parentInnerPanels.equals(childInnerPanels)) {
                                overriddenPropertyNames.add("Inner panels");
                            }
                        }
                    }
                }
                String overrideDescription = StringUtils.join(overriddenPropertyNames, (String)", ");
                this.panelOverrides.add(new PanelOverride(i, parentTemplate.getType(), overrideDescription));
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error creating table", e);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void resetAuditInfo() {
        BlockTemplateChild childBlockTemplate;
        String auditText = "";
        if (this.selectedWell != null && (childBlockTemplate = this.parent.getChild(this.selectedWell.getWellID())) != null) {
            auditText = childBlockTemplate.getAuditString(true);
        }
        this.jLabelAudit.setText(auditText);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListWells.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No well selected!", "Delete", 2);
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to delete all overrides for " + this.selectedWell.getWellName() + "?", "Delete Overrides", 0);
        if (opt != 0) {
            return;
        }
        try {
            SbugsSession.getSession().getChartManager().deleteBlockChild(this.parent, this.selectedWell.getWellID());
            SbugsSession.getDb().commit();
            this.selectedWell = null;
            this.panelOverrides.clear();
            this.resetAuditInfo();
            this.initWellList();
            this.tableModel.fireTableDataChanged();
        }
        catch (SQLException | SBException | SBPermissionException ex) {
            SbugsSession.getDb().doRollback();
            SbugsExceptionHandler.showStackError("Error deleting override template", ex);
        }
    }

    private void deletePanelOverride(int row) {
        PanelOverride override = this.panelOverrides.get(row);
        if (override == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Really delete override for panel " + (override.panelIndex + 1) + "?", "Reset Overriden Panel", 0);
        if (opt != 0) {
            return;
        }
        try {
            SbugsSession.getSession().getChartManager().resetBlockChildPanel(this.parent, this.selectedWell.getWellID(), override.panelIndex);
            BlockTemplateChild child = this.parent.getChild(this.selectedWell.getWellID());
            SbugsSession.getDb().commit();
            if (child != null) {
                this.parent.getChild(this.selectedWell.getWellID()).notifyObservers();
                this.resetTable();
            } else {
                this.selectedWell = null;
                this.panelOverrides.clear();
                this.resetAuditInfo();
                this.initWellList();
                this.tableModel.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException | SBPermissionException ex) {
            SbugsSession.getDb().doRollback();
            SbugsExceptionHandler.showStackError("Error deleting panel override", ex);
        }
    }

    private class TableModelOverrides
    extends AbstractTableModel {
        final /* synthetic */ DialogTemplateChildren this$0;

        private TableModelOverrides(DialogTemplateChildren dialogTemplateChildren) {
            DialogTemplateChildren dialogTemplateChildren2 = dialogTemplateChildren;
            Objects.requireNonNull(dialogTemplateChildren2);
            this.this$0 = dialogTemplateChildren2;
        }

        @Override
        public int getRowCount() {
            return this.this$0.panelOverrides.size();
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PanelOverride override = this.this$0.panelOverrides.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return "" + (override.panelIndex + 1);
                }
                case 1: {
                    return override.type;
                }
                case 2: {
                    return override.description;
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        void setupTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableColumn column = table.getColumnModel().getColumn(table.convertColumnIndexToView(i));
                column.setHeaderValue(COL_TITLES[i]);
                column.setPreferredWidth(COL_WIDTHS[i]);
            }
            table.getColumnModel().getColumn(1).setCellRenderer(new PanelTypeRenderer());
            table.getColumnModel().getColumn(3).setCellRenderer(new DeleteButtonRenderer());
            table.getColumnModel().getColumn(3).setCellEditor(new DeleteButtonEditor(this.this$0));
        }
    }

    private static class PanelOverride {
        final int panelIndex;
        final PanelType type;
        final String description;

        public PanelOverride(int panelIndex, PanelType type, String description) {
            this.panelIndex = panelIndex;
            this.type = type;
            this.description = description;
        }
    }

    private static class DeleteButtonRenderer
    extends DefaultTableCellRenderer {
        private final JPanel panel = new JPanel();
        private final JButton button;

        private DeleteButtonRenderer() {
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.button = new JButton("Reset");
            this.button.setMaximumSize(new Dimension(100, 17));
            this.panel.add(this.button);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.panel;
        }

        JButton getButton() {
            return this.button;
        }
    }

    private class DeleteButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private final DeleteButtonRenderer renderer;
        private int row;
        final /* synthetic */ DialogTemplateChildren this$0;

        DeleteButtonEditor(DialogTemplateChildren dialogTemplateChildren) {
            DialogTemplateChildren dialogTemplateChildren2 = dialogTemplateChildren;
            Objects.requireNonNull(dialogTemplateChildren2);
            this.this$0 = dialogTemplateChildren2;
            this.renderer = new DeleteButtonRenderer();
            this.init();
        }

        private void init() {
            this.renderer.getButton().addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.this$0.deletePanelOverride(this.row);
        }
    }
}

