/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jsbugs.chart.KeyPressListener;

public class KeyboardStatusMonitor {
    private boolean ctrlPressed = false;
    private boolean altPressed = false;
    private boolean shiftPressed = false;
    private final List<KeyPressListener> listeners = new ArrayList<KeyPressListener>();
    private KeyEventDispatcher keyEventDispatcher;

    public void addListener(KeyPressListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(KeyPressListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public KeyboardStatusMonitor setUp() {
        this.keyEventDispatcher = new KeyEventDispatcher(this){
            final /* synthetic */ KeyboardStatusMonitor this$0;
            {
                KeyboardStatusMonitor keyboardStatusMonitor = this$0;
                Objects.requireNonNull(keyboardStatusMonitor);
                this.this$0 = keyboardStatusMonitor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                Class<KeyboardStatusMonitor> clazz = KeyboardStatusMonitor.class;
                synchronized (KeyboardStatusMonitor.class) {
                    switch (ke.getID()) {
                        case 401: {
                            if (ke.getKeyCode() == 17 && !this.this$0.ctrlPressed) {
                                this.this$0.ctrlPressed = true;
                                this.this$0.onKeyPress(ke.getKeyCode());
                            }
                            if (ke.getKeyCode() == 18 && !this.this$0.altPressed) {
                                this.this$0.altPressed = true;
                                this.this$0.onKeyPress(ke.getKeyCode());
                            }
                            if (ke.getKeyCode() != 16 || this.this$0.shiftPressed) break;
                            this.this$0.shiftPressed = true;
                            this.this$0.onKeyPress(ke.getKeyCode());
                            break;
                        }
                        case 402: {
                            if (ke.getKeyCode() == 17 && this.this$0.ctrlPressed) {
                                this.this$0.ctrlPressed = false;
                                this.this$0.onKeyRelease(ke.getKeyCode());
                            }
                            if (ke.getKeyCode() == 18 && this.this$0.altPressed) {
                                this.this$0.altPressed = false;
                                this.this$0.onKeyRelease(ke.getKeyCode());
                            }
                            if (ke.getKeyCode() != 16 || !this.this$0.shiftPressed) break;
                            this.this$0.shiftPressed = false;
                            this.this$0.onKeyRelease(ke.getKeyCode());
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        return this;
    }

    public void tearDown() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
    }

    private void onKeyPress(int keyCode) {
        if (!this.listeners.isEmpty()) {
            for (KeyPressListener listener : this.listeners) {
                listener.keyPressed(keyCode);
            }
        }
    }

    private void onKeyRelease(int keyCode) {
        if (!this.listeners.isEmpty()) {
            for (KeyPressListener listener : this.listeners) {
                listener.keyReleased(keyCode);
            }
        }
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed;
    }

    public boolean isAltPressed() {
        return this.altPressed;
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public void clearKeyboardStatus() {
        this.ctrlPressed = false;
        this.altPressed = false;
        this.shiftPressed = false;
    }
}

