/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.SBGraphicsConverter;
import jsbchart.util.CompassDirection;

public class OutsideMarkerPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(OutsideMarkerPanel.class.getName());
    private static final int PIXEL_BORDER = 10;
    private static final double GRAPHICS_SCALE = 0.028346456587314606;
    private final SBGraphicsConverter sbConverter;
    private final List<Point2D.Float> points = new ArrayList<Point2D.Float>();
    private final List<Point2D.Float> selectedPoints = new ArrayList<Point2D.Float>();
    private Color pointColour = Color.RED;
    private Color selectedPointColour = Color.BLUE;
    private JPanel innerPanel;
    private int outsidePointsDrawn = 0;

    public OutsideMarkerPanel() {
        this.sbConverter = new SBGraphicsConverter(0.028346456587314606);
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    public void clearAllMarkers() {
        this.points.clear();
        this.selectedPoints.clear();
    }

    public int getOutsidePointsDrawn() {
        return this.outsidePointsDrawn;
    }

    public void addMarker(Point2D.Float p) {
        this.points.add(p);
    }

    public void addSelectedMarker(Point2D.Float p) {
        this.selectedPoints.add(p);
    }

    public void addInnerPanel(JPanel panel) {
        if (this.innerPanel != null) {
            this.remove(this.innerPanel);
        }
        this.innerPanel = panel;
        this.add((Component)panel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        AffineTransform saveTransform = g2d.getTransform();
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.sbConverter.getTransformFactor(), this.sbConverter.getTransformFactor());
        g2d.transform(tnf);
        try {
            SBGraphics sg = new SBGraphics(g2d, null, true, true);
            Rectangle2D.Float drawArea = this.sbConverter.makeRectFromPixels(this.innerPanel.getWidth(), this.innerPanel.getHeight());
            float border = this.sbConverter.convertUnscaledPixelsToFloat(10);
            this.drawOutsideMarkers(sg, border, drawArea);
        }
        finally {
            g2d.setTransform(saveTransform);
        }
    }

    public Color getPointColour() {
        return this.pointColour;
    }

    public Color getSelectedPointColour() {
        return this.selectedPointColour;
    }

    public void setPointColour(Color c) {
        this.pointColour = c;
    }

    public void setSelectedPointColour(Color c) {
        this.selectedPointColour = c;
    }

    private void drawOutsideMarkers(SBGraphics sg, float border, Rectangle2D.Float drawArea) {
        this.outsidePointsDrawn = 0;
        this.drawOutsideMarkerPoints(sg, border, drawArea, this.points, this.getPointColour(), 2.0f);
        this.drawOutsideMarkerPoints(sg, border, drawArea, this.selectedPoints, this.getSelectedPointColour(), 3.0f);
    }

    private void drawOutsideMarkerPoints(SBGraphics sg, float border, Rectangle2D.Float drawArea, List<Point2D.Float> pointsToDraw, Color colour, float size) {
        for (Point2D.Float p : pointsToDraw) {
            if (p == null) continue;
            if (p.x < 0.0f && p.y < 0.0f) {
                sg.drawTriangle(border, border, CompassDirection.SOUTHEAST, size, colour);
            } else if (p.x < 0.0f && (double)p.y > drawArea.getHeight()) {
                sg.drawTriangle(border, border + (float)drawArea.getHeight(), CompassDirection.NORTHEAST, size, colour);
            } else if (p.y < 0.0f && (double)p.x > drawArea.getWidth()) {
                sg.drawTriangle(border + (float)drawArea.getWidth(), border, CompassDirection.SOUTHWEST, size, colour);
            } else if ((double)p.x > drawArea.getWidth() && (double)p.y > drawArea.getHeight()) {
                sg.drawTriangle(border + (float)drawArea.getWidth(), border + (float)drawArea.getHeight(), CompassDirection.NORTHWEST, size, colour);
            } else if (p.x < 0.0f) {
                sg.drawTriangle(border, border + p.y, CompassDirection.EAST, size, colour);
            } else if (p.y < 0.0f) {
                sg.drawTriangle(border + p.x, border, CompassDirection.SOUTH, size, colour);
            } else if ((double)p.x > drawArea.getWidth()) {
                sg.drawTriangle((float)drawArea.getWidth() + border, border + p.y, CompassDirection.WEST, size, colour);
            } else if ((double)p.y > drawArea.getHeight()) {
                sg.drawTriangle(border + p.x, (float)drawArea.getHeight() + border, CompassDirection.NORTH, size, colour);
            }
            if (!(p.x < 0.0f || p.y < 0.0f || (double)p.x > drawArea.getWidth()) && !((double)p.y > drawArea.getHeight())) continue;
            ++this.outsidePointsDrawn;
        }
    }
}

