/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.JPanel;
import jsbchart.block.MapBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.Marquee;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.SBGraphicsConverter;
import jsbugs.chart.BasicMapBlockMouseListener;
import jsbugs.chart.BasicMapBlockPanel;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.chart.MapUpdateListner;
import org.geotools.referencing.operation.matrix.AffineTransform2D;
import util.RectUtils;
import util.SBException;

public class StretchyMapBlockPanel
extends JPanel
implements BasicMapBlockPanel,
Chart.Listener {
    private static Logger LOGGER = Logger.getLogger(StretchyMapBlockPanel.class.getName());
    private static float BORDER = 0.0f;
    private static double GRAPHICS_SCALE = 0.028346456587314606;
    private final SBGraphicsConverter converter = new SBGraphicsConverter(GRAPHICS_SCALE);
    private final KeyboardStatusMonitor ksm = new KeyboardStatusMonitor();
    private BasicMapBlockMouseListener defaultListener;
    private Rectangle2D.Float mapBlockBounds = null;
    private Chart chart = null;
    public MapBlock mb = null;
    private Marquee marquee = null;
    private MapUpdateListner updateListener = null;
    private BufferedImage image;
    AffineTransform lastTransform = null;

    public StretchyMapBlockPanel() {
        this.ksm.setUp();
        this.init();
    }

    public void setMapBlock(MapBlock mapBlock) throws SQLException, SBException, IOException {
        if (this.mb != null) {
            this.chart.removeBlock(this.mb);
            this.mb.dispose();
        }
        this.mb = mapBlock;
        this.chart.addBlock(mapBlock);
        this.chart.setData();
        this.chart.doLayout();
    }

    public ChartProperties getChartProperties() {
        return this.chart.getProperties();
    }

    public BasicMapBlockMouseListener getMouseListener() {
        return this.defaultListener;
    }

    public void setMapUpdateListener(MapUpdateListner updateListener) {
        this.updateListener = updateListener;
    }

    private void init() {
        this.chart = new Chart();
        this.chart.getProperties().setPanelHeaderHeight(0.0f);
        this.chart.getProperties().plotBlockCaptions = false;
        this.chart.getProperties().setMargin(BORDER);
        this.chart.getProperties().setFontSize(12.0f);
        this.chart.addListener(this);
        this.chart.notifyListeners();
        this.defaultListener = new BasicMapBlockMouseListener(this, this.converter, this.ksm);
        this.addMouseListener(this.defaultListener);
        this.addMouseMotionListener(this.defaultListener);
        this.addMouseWheelListener(this.defaultListener);
        this.setPreferredSize(new Dimension(300, 300));
        this.setMinimumSize(new Dimension(200, 200));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseMapUpdates() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.lastTransform != null) {
            width = (int)((double)width * this.lastTransform.getScaleX());
            height = (int)((double)height * this.lastTransform.getScaleY());
        }
        this.image = new BufferedImage(width, height, 1);
        Graphics canvasGraphics = null;
        try {
            canvasGraphics = this.image.getGraphics();
            if (this.lastTransform != null) {
                AffineTransform2D transform = new AffineTransform2D();
                transform.setToScale(this.lastTransform.getScaleX(), this.lastTransform.getScaleY());
                ((Graphics2D)canvasGraphics).transform((AffineTransform)transform);
            }
            canvasGraphics.setColor(Color.white);
            canvasGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            canvasGraphics.setColor(Color.black);
            this.drawMap(canvasGraphics, this.getWidth(), this.getHeight());
        }
        finally {
            if (canvasGraphics != null) {
                canvasGraphics.dispose();
            }
        }
    }

    public void resumeMapUpdates() {
        this.image = null;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        long start = System.currentTimeMillis();
        if (this.image != null) {
            Graphics2D g2d = (Graphics2D)g;
            g.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
        } else {
            this.drawMap(g, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMap(Graphics g, int width, int height) {
        AffineTransform saveTransform;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.lastTransform = saveTransform = g2d.getTransform();
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.converter.getTransformFactor(), this.converter.getTransformFactor());
        g2d.transform(tnf);
        try {
            Rectangle2D.Float mapDrawArea = this.converter.makeRectFromPixels(width, height);
            this.mapBlockBounds = RectUtils.makeSmallerRect((Rectangle2D.Float)mapDrawArea, (float)BORDER);
            SBGraphics sg = new SBGraphics(g2d, null, true, true);
            sg.setOriginalTransform(saveTransform);
            sg.setClip(this.mapBlockBounds.x, this.mapBlockBounds.y, this.mapBlockBounds.width, this.mapBlockBounds.height);
            if (this.chart != null && this.mb != null) {
                this.chart.getProperties().setPanelHeaderHeight(0.0f);
                this.chart.getProperties().plotBlockCaptions = false;
                this.mb.getProp().setWidth(this.mapBlockBounds.width);
                this.mb.getProp().setHeight(this.mapBlockBounds.height);
                this.mb.setMapViewport();
                this.chart.doLayout();
                this.chart.draw(sg, Chart.Mode.NORMAL, Chart.Mode.NORMAL);
            }
            if (this.marquee != null) {
                this.marquee.draw(sg);
            }
            sg.clearClip();
        }
        finally {
            g2d.setTransform(saveTransform);
        }
    }

    public void updateMapBlockViewport() {
        Rectangle2D.Float mapDrawArea = this.converter.makeRectFromPixels(this.getWidth(), this.getHeight());
        this.mapBlockBounds = RectUtils.makeSmallerRect((Rectangle2D.Float)mapDrawArea, (float)BORDER);
        this.mb.getProp().setWidth(this.mapBlockBounds.width);
        this.mb.getProp().setHeight(this.mapBlockBounds.height);
        this.mb.setMapViewport();
    }

    public Point2D.Float getPositionOnMap(float lat, float lon) {
        if (this.mb != null) {
            return this.mb.getMMPositionFromLonLat(lon, lat);
        }
        return null;
    }

    @Override
    public void setMarquee(Marquee marquee) {
        this.marquee = marquee;
    }

    @Override
    public void clearMarquee() {
        this.marquee = null;
    }

    @Override
    public Rectangle2D.Float getMapBlockBounds() {
        return this.mapBlockBounds;
    }

    @Override
    public MapBlock getMapBlock() {
        return this.mb;
    }

    @Override
    public void onMapUpdate() {
        this.repaint();
        if (this.updateListener != null) {
            this.updateListener.onMapUpdate();
        }
    }

    @Override
    public void chartChanged() {
        this.repaint();
    }
}

