/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateInfo;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateDescr;
import jsbchart.correlation.CorrelationStandard;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.panel.PanelType;
import jsbugs.uiutil.RunWithCursorDecorator;
import util.SB;
import util.SBException;

public class TreeModelChart
implements TreeModel {
    private final ChartManager root;
    private Integer projID;
    private final ChartManager.TemplateComparator comparator = new ChartManager.TemplateComparator();
    private boolean includeGlobal = true;
    private static final String[] TEMPLATE_STRINGS = new String[]{"Block Templates", "Correlation Templates"};
    private static final int BLOCKS_INDEX = 0;
    private static final int CORR_INDEX = 1;
    private BlockType blockType;
    private RunWithCursorDecorator runnableDecorator;
    private final List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();

    public TreeModelChart(ChartManager root) {
        this.root = root;
    }

    public void setRunnableDecorator(RunWithCursorDecorator decorator) {
        this.runnableDecorator = decorator;
    }

    public void setMode(BlockType blockType) {
        if (blockType != this.blockType) {
            this.blockType = blockType;
            this.fireTreeStructureChanged();
        }
    }

    public boolean setProjID(Integer projID) {
        if (SB.equal((Object)this.projID, (Object)projID)) {
            return false;
        }
        this.projID = projID;
        this.fireTreeStructureChanged();
        return true;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.blockType == null) {
            if (parent == this.root) {
                return TEMPLATE_STRINGS[index];
            }
            if (parent instanceof String) {
                if (parent == TEMPLATE_STRINGS[0]) {
                    return BlockType.values()[index];
                }
                assert (parent == TEMPLATE_STRINGS[1]);
                return CorrelationType.values()[index];
            }
            if (parent instanceof BlockType) {
                BlockType parentBlockType = (BlockType)parent;
                try {
                    return this.getBlocks(parentBlockType).get(index);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
            if (parent instanceof CorrelationType) {
                CorrelationType parentCorrelationType = (CorrelationType)parent;
                CorrelationStandard[] corrStds = ChartManager.corrStds.get(parentCorrelationType);
                if (index < corrStds.length) {
                    return corrStds[index];
                }
                try {
                    return this.root.getCorrTemplates(parentCorrelationType, this.projID, this.includeGlobal, this.comparator).get(index - corrStds.length);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
        } else {
            if (parent == this.root) {
                return this.blockType;
            }
            if (parent instanceof BlockType) {
                return PanelType.getPanelTypes(this.blockType).get(index);
            }
            if (parent instanceof PanelType) {
                PanelType parentPanelType = (PanelType)parent;
                try {
                    return this.root.getPanels(parentPanelType, this.projID, this.includeGlobal, this.comparator).get(index);
                }
                catch (SQLException | SBException e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
        }
        return "Object" + index;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            if (this.blockType != null) {
                return 1;
            }
            return TEMPLATE_STRINGS.length;
        }
        if (parent instanceof String) {
            assert (this.blockType == null);
            if (parent == TEMPLATE_STRINGS[0]) {
                return BlockType.values().length;
            }
            if (parent == TEMPLATE_STRINGS[1]) {
                return CorrelationType.values().length;
            }
        } else {
            if (parent instanceof BlockType) {
                BlockType parentBlockType = (BlockType)parent;
                if (this.blockType != null) {
                    return PanelType.getnPanels(this.blockType);
                }
                try {
                    return this.getBlocks(parentBlockType).size();
                }
                catch (Exception e) {
                    return 1;
                }
            }
            if (parent instanceof PanelType) {
                PanelType parentPanelType = (PanelType)parent;
                try {
                    return this.root.getPanels(parentPanelType, this.projID, this.includeGlobal).size();
                }
                catch (SQLException | SBException e) {
                    return 1;
                }
            }
            if (parent instanceof CorrelationType) {
                CorrelationType parentCorrelationType = (CorrelationType)parent;
                int nstd = ChartManager.CORR_STD_LENGTH;
                try {
                    return this.root.getCorrTemplates(parentCorrelationType, this.projID, this.includeGlobal).size() + nstd;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return nstd;
                }
            }
        }
        return 0;
    }

    private List<BlockTemplateInfo> getBlocks(BlockType type) throws Exception {
        Callable<List> c = () -> this.root.getBlockInfo(type, this.projID, this.includeGlobal, this.comparator);
        if (this.runnableDecorator != null) {
            c = this.runnableDecorator.getRunnableWithCursor(c);
        }
        return c.call();
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof PanelType) && !(node instanceof ChartManager) && !(node instanceof BlockType) && !(node instanceof String) && !(node instanceof CorrelationType);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            if (child instanceof BlockType) {
                assert (this.blockType != null);
                return 0;
            }
            if (child instanceof String) {
                for (int i = 0; i < TEMPLATE_STRINGS.length; ++i) {
                    if (!TEMPLATE_STRINGS[i].equals(child)) continue;
                    return i;
                }
            }
            assert (false);
        } else {
            if (parent instanceof String) {
                assert (this.blockType == null);
                if (child instanceof BlockType) {
                    assert (parent == TEMPLATE_STRINGS[0]);
                    return ((BlockType)child).ordinal();
                }
                assert (parent == TEMPLATE_STRINGS[1]);
                return ((CorrelationType)child).ordinal();
            }
            if (parent instanceof CorrelationType) {
                if (child instanceof CorrelationStandard) {
                    CorrelationStandard corrStd = (CorrelationStandard)child;
                    return Arrays.asList(ChartManager.corrStds.get(corrStd.type)).indexOf(corrStd);
                }
                try {
                    return this.root.getCorrTemplates((CorrelationType)parent, this.projID, this.includeGlobal, this.comparator).indexOf(child) + ChartManager.CORR_STD_LENGTH;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    return -1;
                }
            }
            if (parent instanceof BlockType && (child instanceof BlockTemplate || child instanceof BlockTemplateInfo)) {
                try {
                    return this.getBlocks((BlockType)parent).indexOf(child);
                }
                catch (Exception sql) {
                    return -1;
                }
            }
            if (parent instanceof BlockType && child instanceof PanelType) {
                return PanelType.getPanelTypes(this.blockType).indexOf(child);
            }
            if (parent instanceof PanelType && child instanceof PanelTemplate) {
                try {
                    return this.root.getPanels((PanelType)parent, this.projID, this.includeGlobal, this.comparator).indexOf((PanelTemplate)child);
                }
                catch (SQLException | SBException sql) {
                    sql.printStackTrace();
                    return -1;
                }
            }
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void fireTreeStructureChanged() {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.root});
        for (TreeModelListener tml : this.treeModelListeners) {
            tml.treeStructureChanged(e);
        }
    }

    public void fireTreeNodeChanged(Object changedNode) {
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPath(changedNode));
        for (TreeModelListener tml : this.treeModelListeners) {
            tml.treeNodesChanged(e);
        }
    }

    public void templateInsertedOrRemoved(TemplateDescr node, boolean inserted) {
        if (node.getType() == null) {
            return;
        }
        if (node instanceof PanelTemplate ? this.blockType == null || !((PanelTemplate)node).getType().canPlot(this.blockType) : (node instanceof BlockTemplate || node instanceof CorrelationTemplate) && this.blockType != null) {
            return;
        }
        int index = this.getIndexOfChild(node.getType(), node);
        if (index < 0) {
            return;
        }
        TreePath pathToParent = node.getType() == null ? this.getPath(this.root) : this.getPath(node.getType());
        TreeModelEvent e = new TreeModelEvent((Object)this, pathToParent, new int[]{index}, new Object[]{node});
        for (TreeModelListener tml : this.treeModelListeners) {
            if (inserted) {
                tml.treeNodesInserted(e);
                continue;
            }
            tml.treeNodesRemoved(e);
        }
    }

    public TreePath getPath(Object node) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (node instanceof BlockTemplate) {
            BlockTemplate template = (BlockTemplate)node;
            try {
                Optional<BlockTemplateInfo> optionalInfo = this.getBlocks(template.getType()).stream().filter(t -> t.getBlockID() == template.getID()).findAny();
                if (optionalInfo.isPresent()) {
                    node = optionalInfo.get();
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error getting block template info", e);
            }
        }
        while (node != null) {
            list.add(node);
            node = this.getParent(node);
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    private Object getParent(Object child) {
        if (child instanceof PanelTemplate) {
            PanelTemplate panelTemplate = (PanelTemplate)child;
            return panelTemplate.getType();
        }
        if (child instanceof BlockTemplate) {
            BlockTemplate blockTemplate = (BlockTemplate)child;
            return blockTemplate.getType();
        }
        if (child instanceof BlockTemplateInfo) {
            BlockTemplateInfo blockTemplateInfo = (BlockTemplateInfo)child;
            return blockTemplateInfo.getType();
        }
        if (child instanceof PanelType) {
            return this.blockType;
        }
        if (child instanceof BlockType) {
            if (this.blockType != null) {
                return this.root;
            }
            return TEMPLATE_STRINGS[0];
        }
        if (child instanceof CorrelationStandard) {
            CorrelationStandard correlationStandard = (CorrelationStandard)child;
            return correlationStandard.type;
        }
        if (child instanceof CorrelationType) {
            return TEMPLATE_STRINGS[1];
        }
        if (child instanceof CorrelationTemplate) {
            CorrelationTemplate correlationTemplate = (CorrelationTemplate)child;
            return correlationTemplate.getType();
        }
        if (child instanceof String) {
            return this.root;
        }
        return null;
    }

    public boolean allowCollapse(TreePath path) {
        return this.blockType == null || path.getLastPathComponent() != this.blockType;
    }

    public String convertValueToText(Object o) {
        if (o instanceof BlockType) {
            BlockType oType = (BlockType)o;
            if (this.blockType != null) {
                return oType.toString() + " " + oType.memberTypeString() + " Types";
            }
            return o.toString() + " Templates";
        }
        return o.toString();
    }

    public void setComparatorSort(ChartManager.TemplateComparator.Sort sort) {
        this.comparator.setSort(sort);
    }

    public boolean setShowGlobal(boolean showGlobal) {
        if (showGlobal != this.includeGlobal) {
            this.includeGlobal = showGlobal;
            return true;
        }
        return false;
    }

    public boolean isShowingGlobal() {
        return this.includeGlobal;
    }
}

