/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.PanelOcc;
import jsbchart.graphics.map.CrsCode;
import jsbchart.graphics.map.DefaultMapLayerBuilder;
import jsbchart.graphics.map.SelectedWellIdsFilter;
import jsbchart.graphics.map.WellEnvelopeHelper;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.spatial.LayerWellLocationWithSelection;
import jsbchart.panel.spatial.LayerWellLocationWithSelectionProperties;
import jsbugs.chart.DialogMapBlockSelect;
import jsbugs.chart.OutsideMarkerPanel;
import jsbugs.chart.StretchyMapBlockPanel;
import jsbugs.uiutil.UIColours;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.UserPrefsHelper;
import model3.SBdb;
import model3.Well;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import util.SBException;

public class WellSelectionMapJPanel
extends JPanel
implements LayerWellLocationWithSelectionProperties.PropertyChangeListener {
    private int MAX_WELLS_TO_SHOW_LABELS = 500;
    private static final Logger LOGGER = Logger.getLogger(WellSelectionMapJPanel.class.getName());
    private final List<Well> wells = new ArrayList<Well>();
    private final List<Well> wellsSelected = new ArrayList<Well>();
    private SelectedWellIdsFilter selectedWellIdsFilter = new SelectedWellIdsFilter();
    private StretchyMapBlockPanel scjp;
    private OutsideMarkerPanel outsideMarkerPanel;
    private ListSelectionModel selectionModel;
    private JPopupMenu mapPopupMenu;
    private Consumer<MouseEvent> wellPopupMenuHandler = null;
    private Consumer<List<Well>> wellDoubleClickHandler = null;
    private LayerWellLocationWithSelection wellLocLayer;
    private ListModel<Well> listModel;
    private UserPrefsHelper helper;
    private SBdb sbdb;
    private ChartManager cm;
    private boolean showLabels = false;
    private boolean enableUpdates = true;
    private Integer projID = null;

    public void setup(Integer projID) throws SQLException, SBException, IOException {
        UserPrefsHelper h = null;
        SBdb sbdb = SbugsSession.getDb();
        if (sbdb != null && sbdb.isConnected()) {
            h = new UserPrefsHelper(sbdb);
        }
        this.projID = projID;
        this.setup(sbdb, SbugsSession.getSession().getChartManager(), h);
    }

    public void setMaxWellsToShowLabels(int maxWellsToShowLabels) {
        this.MAX_WELLS_TO_SHOW_LABELS = maxWellsToShowLabels;
    }

    public int getMaxWellsToShowLabels() {
        return this.MAX_WELLS_TO_SHOW_LABELS;
    }

    public void setProject(Integer projID) {
        Integer mapTemplateID;
        if (projID != null && projID != this.projID && this.helper != null && (mapTemplateID = this.helper.getWellSelectionMapBackgroundTemplateId(projID)) != null && mapTemplateID > 0) {
            try {
                BlockTemplate t = this.cm.getBlockTemplate(mapTemplateID);
                if (t != null) {
                    this.setBackgroundMap(t);
                }
            }
            catch (IOException | SQLException | SBException e) {
                LOGGER.log(Level.WARNING, "Error loading background map block for ID: " + mapTemplateID + ". ", e);
            }
        }
        this.projID = projID;
    }

    public void setup(SBdb sbdb, ChartManager cm, UserPrefsHelper helper) throws SQLException, SBException, IOException {
        this.sbdb = sbdb;
        this.cm = cm;
        this.helper = helper;
        this.scjp = new StretchyMapBlockPanel();
        this.scjp.setBackground(Color.white);
        this.scjp.setMapUpdateListener(this::onMapUpdate);
        this.scjp.getMouseListener().setClickableObjectHandler(this::onWellClick);
        this.outsideMarkerPanel = new OutsideMarkerPanel();
        this.outsideMarkerPanel.setBackground(Color.white);
        this.outsideMarkerPanel.addInnerPanel(this.scjp);
        this.setLayout(new BorderLayout());
        this.add((Component)this.outsideMarkerPanel, "Center");
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ WellSelectionMapJPanel this$0;
            {
                WellSelectionMapJPanel wellSelectionMapJPanel = this$0;
                Objects.requireNonNull(wellSelectionMapJPanel);
                this.this$0 = wellSelectionMapJPanel;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                this.this$0.scjp.updateMapBlockViewport();
                this.this$0.onMapUpdate();
            }
        });
        this.loadInitialMapBackground();
        this.setInitialMapProjection();
        this.setupPopupMenu();
    }

    private void loadInitialMapBackground() {
        Integer templateId = null;
        if (this.helper != null) {
            templateId = this.helper.getWellSelectionMapBackgroundTemplateId(this.projID);
        }
        try {
            BlockTemplate backgroundTemplate = null;
            if (templateId != null) {
                backgroundTemplate = this.cm.getBlockTemplate(templateId);
            }
            if (backgroundTemplate != null) {
                this.setBackgroundMap(backgroundTemplate);
            } else {
                this.loadDefaultMap();
            }
        }
        catch (Exception ex) {
            this.loadDefaultMap();
            LOGGER.log(Level.WARNING, "Failed to restore shape store with ID " + templateId + " as well selection map background.", ex);
            String message = "An error occurred while loading the selected background map, a default map has been loaded instead. Please see log for details.";
            JOptionPane.showMessageDialog(null, message, "Error loading map", 2);
        }
    }

    private void setInitialMapProjection() {
        CrsCode code;
        if (this.helper != null && (code = this.helper.getWellSelectionMapProjection(this.projID)) != null) {
            try {
                this.setMapCRS(code);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error setting initial selection map background to " + String.valueOf((Object)code), e);
            }
        }
    }

    public void setWellsListModel(ListModel<Well> listModelWells) {
        this.listModel = listModelWells;
        this.listModel.addListDataListener(new ListDataListener(this){
            final /* synthetic */ WellSelectionMapJPanel this$0;
            {
                WellSelectionMapJPanel wellSelectionMapJPanel = this$0;
                Objects.requireNonNull(wellSelectionMapJPanel);
                this.this$0 = wellSelectionMapJPanel;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                if (this.this$0.enableUpdates) {
                    this.this$0.updateWellList();
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (this.this$0.enableUpdates) {
                    this.this$0.updateWellList();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (this.this$0.enableUpdates) {
                    this.this$0.updateWellList();
                }
            }
        });
    }

    public void updateWellList() {
        this.wells.clear();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            this.wells.add(this.listModel.getElementAt(i));
        }
        if (this.showLabels) {
            this.wellLocLayer.getProperties().setShowLabels(this.wells.size() <= this.MAX_WELLS_TO_SHOW_LABELS);
        }
        this.setDataOnMapBlock(this.scjp.getMapBlock());
        this.addMapClickPointsForWells();
        this.updateWellMarkers();
        this.repaint();
    }

    private void setMapBlockDataRange() {
        double top = 0.0;
        double base = 0.0;
        try {
            for (Well w : this.wells) {
                top = Math.min(top, w.getTopSampleDepth());
                base = Math.max(base, w.getBaseSampleDepth());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Exception while getting top and base samples.", e);
        }
        this.scjp.getMapBlock().setPropDataRangeStyle(MapBlockProperties.DataRangeStyle.BOUNDARIES);
        this.scjp.getMapBlock().setPropDataScaleLimit(IBlockProperties.ScaleLimitType.MIN, (float)top);
        this.scjp.getMapBlock().setPropDataScaleLimit(IBlockProperties.ScaleLimitType.MAX, (float)base);
        this.scjp.getMapBlock().setScaleType(BlockProperties.ScaleType.MD);
    }

    public void setWellPopupMenuHandler(Consumer<MouseEvent> handler) {
        this.wellPopupMenuHandler = handler;
    }

    public void setWellDoubleClickHandler(Consumer<List<Well>> handler) {
        this.wellDoubleClickHandler = handler;
    }

    public void setInitialWellMapPositions() {
        this.scjp.updateMapBlockViewport();
        this.onMapUpdate();
    }

    public void clearCursor() {
        this.outsideMarkerPanel.setCursor(null);
        this.scjp.setCursor(null);
        this.setCursor(null);
    }

    private void setupPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem resetMap = new JMenuItem("Reset map");
        resetMap.addActionListener(e -> this.resetMapBounds());
        menu.add(resetMap);
        this.mapPopupMenu = menu;
    }

    private void onWellClick(MouseEvent e, List<Object> objList) {
        List<Well> wells = objList.stream().filter(o -> o instanceof Well).map(o -> (Well)o).toList();
        this.setSelectedWells(wells);
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e, wells);
        } else if (e.getButton() == 1 && e.getClickCount() > 1 && this.wellDoubleClickHandler != null && !wells.isEmpty()) {
            this.wellDoubleClickHandler.accept(wells);
        }
    }

    private void showPopupMenu(MouseEvent evt, List<Well> wells) {
        if (!wells.isEmpty() && this.wellPopupMenuHandler != null) {
            this.setSelectedWells(wells);
            this.wellPopupMenuHandler.accept(evt);
        } else if (this.mapPopupMenu != null) {
            this.mapPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void resetMapBounds() {
        this.setMapBoundsToFitWells();
        this.repaint();
    }

    private void setMapBoundsToFitWells() {
        ReferencedEnvelope wellEnvelope = WellEnvelopeHelper.getWellEnvelope(this.wells);
        if (this.scjp.getMapBlock() != null) {
            this.scjp.getMapBlock().setMapExtent(wellEnvelope);
            this.scjp.getMapBlock().notifyListeners();
        }
    }

    private void onMapUpdate() {
        this.updateWellMarkers();
        this.addMapClickPointsForWells();
        this.checkNumberOfWellsAndSetLabelsIfNeeded();
    }

    public void checkNumberOfWellsAndSetLabelsIfNeeded() {
        boolean redrawNeeded = false;
        int wellsOnMap = this.wells.size() - this.outsideMarkerPanel.getOutsidePointsDrawn();
        if (wellsOnMap > this.MAX_WELLS_TO_SHOW_LABELS && this.wellLocLayer.getProperties().showLabels()) {
            this.wellLocLayer.getProperties().setShowLabels(false);
            redrawNeeded = true;
        } else if (this.showLabels && !this.wellLocLayer.getProperties().showLabels() && wellsOnMap <= this.MAX_WELLS_TO_SHOW_LABELS) {
            this.wellLocLayer.getProperties().setShowLabels(true);
            redrawNeeded = true;
        }
        if (redrawNeeded) {
            this.scjp.getMapBlock().clearCachedLayers();
            this.setDataOnMapBlock(this.scjp.getMapBlock());
            this.repaint();
        }
    }

    private void setSelectedWells(List<Well> wellsToSelect) {
        this.selectionModel.clearSelection();
        for (Well w : wellsToSelect) {
            if (!this.wells.contains(w)) continue;
            int i = this.wells.indexOf(w);
            this.selectionModel.addSelectionInterval(i, i);
        }
    }

    private void updateWellMarkers() {
        this.outsideMarkerPanel.clearAllMarkers();
        if (this.scjp.getMapBlock() != null) {
            MapBlock block = this.scjp.getMapBlock();
            this.wells.stream().filter(w -> w.getHeader().hasLocation()).filter(w -> !this.wellsSelected.contains(w)).forEach(w -> {
                Coordinate c = WellEnvelopeHelper.getWellCoordinate(w);
                Point2D.Float p = block.getMMPositionFromLatLon(c);
                this.outsideMarkerPanel.addMarker(p);
            });
            this.wellsSelected.stream().filter(w -> w.getHeader().hasLocation()).forEach(w -> {
                Coordinate c = WellEnvelopeHelper.getWellCoordinate(w);
                Point2D.Float p = block.getMMPositionFromLatLon(c);
                this.outsideMarkerPanel.addSelectedMarker(p);
            });
        }
        this.outsideMarkerPanel.repaint();
    }

    private void addMapClickPointsForWells() {
        this.scjp.getMouseListener().clearMapObjects();
        MapBlock block = this.scjp.getMapBlock();
        if (block != null) {
            this.wells.stream().filter(w -> w.getHeader().hasLocation()).forEach(w -> {
                Coordinate c = WellEnvelopeHelper.getWellCoordinate(w);
                Point2D.Float p = block.getMMPositionFromLatLon(c);
                if (p != null) {
                    this.scjp.getMouseListener().addClickableObject(p, w);
                }
            });
        }
    }

    private List<Well> getWells() {
        return this.wells;
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        selectionModel.addListSelectionListener(e -> this.updateSelectedWells());
    }

    public void updateSelectedWells() {
        int[] selectedIndices = this.selectionModel.getSelectedIndices();
        this.wellsSelected.clear();
        for (int i = 0; i < selectedIndices.length; ++i) {
            int index = selectedIndices[i];
            if (index < 0 || index >= this.wells.size()) continue;
            this.wellsSelected.add(this.wells.get(index));
        }
        this.scjp.getMapBlock().setSelectedWells(this.wellsSelected);
        this.updateWellMarkers();
        this.setDataOnMapBlock(this.scjp.getMapBlock());
    }

    public void showBackgroundSelectDialog() {
        Integer lastTemplateId = null;
        if (this.helper != null) {
            lastTemplateId = this.helper.getWellSelectionMapBackgroundTemplateId(this.projID);
        }
        this.showBackgroundSelectDialog(lastTemplateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showBackgroundSelectDialog(Integer id) {
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            return;
        }
        DialogMapBlockSelect dialog = new DialogMapBlockSelect(null, true, this.cm, this.sbdb);
        try {
            dialog.setWellSupplier(this::getWells);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.isOK() && dialog.getSelectedTemplate() != null) {
                this.setBackgroundMap(dialog.getSelectedTemplate());
                if (this.helper != null) {
                    this.helper.setWellSelectionMapBackgroundTemplateId(dialog.getSelectedTemplate().getID(), this.projID);
                }
            }
        }
        catch (Exception e) {
            SbugsExceptionHandler.showStackError(e, null);
            this.resetMapBackground();
        }
        finally {
            dialog.dispose();
        }
    }

    private void setBackgroundMap(BlockTemplate template) throws SQLException, SBException, IOException {
        if (template.getType() == BlockType.MAP) {
            MapBlock newBlock = (MapBlock)ChartFactory.createBlock(this.sbdb, template, null);
            newBlock.disableWellDataPreload();
            newBlock.setPropLegendOrientation(MapBlockProperties.LegendOrientation.NONE);
            PanelOcc panelOcc = new PanelOcc(-1);
            if (this.wellLocLayer != null) {
                this.wellLocLayer.getProperties().clearPropertyChangeListener();
            }
            this.wellLocLayer = new LayerWellLocationWithSelection(null, panelOcc, newBlock);
            this.wellLocLayer.getProperties().setPropertyChangeListener(this);
            newBlock.clearDataLayers();
            newBlock.addLocationWithSelectionPanel(this.wellLocLayer);
            this.showLabels = this.wellLocLayer.getProperties().showLabels();
            this.wellLocLayer.getProperties().notifyListenerOfPropertyChanged();
            this.scjp.setMapBlock(newBlock);
            newBlock.setChartWellsSupplier(this::getWells);
            this.setDataOnMapBlock(newBlock);
            this.setMapBoundsToFitWells();
            this.scjp.updateMapBlockViewport();
            this.updateOutsideMarkerColours();
            this.onMapUpdate();
            this.repaint();
        }
    }

    public MapBlock getBlock() {
        return this.scjp.getMapBlock();
    }

    public void resetMapBackground() {
        if (this.helper != null) {
            this.helper.setWellSelectionMapBackgroundTemplateId(null, null);
        }
        this.loadDefaultMap();
        this.setDataOnMapBlock(this.scjp.getMapBlock());
        this.repaint();
    }

    private void loadDefaultMap() {
        try {
            this.setupDefaultBackgroundMapBlock();
        }
        catch (IOException | SQLException | SBException e) {
            LOGGER.log(Level.SEVERE, "Error resetting well selection panel to default map", e);
        }
    }

    private void setupDefaultBackgroundMapBlock() throws SQLException, SBException, IOException {
        MapBlock block = new MapBlock(this.sbdb, null, null);
        block.disableWellDataPreload();
        PanelOcc p2 = new PanelOcc(-1);
        if (this.wellLocLayer != null) {
            this.wellLocLayer.getProperties().clearPropertyChangeListener();
        }
        this.wellLocLayer = new LayerWellLocationWithSelection(null, p2, block);
        this.wellLocLayer.getProperties().setPropertyChangeListener(this);
        this.showLabels = true;
        block.addMember(this.wellLocLayer);
        block.getProp().setLegendOrientation(MapBlockProperties.LegendOrientation.NONE);
        block.addMember(DefaultMapLayerBuilder.buildDefaultMapLayerShape(block, UIColours.DEFAULT_MAP_FILL));
        this.scjp.setMapBlock(block);
        block.setChartWellsSupplier(this::getWells);
        this.setDataOnMapBlock(block);
        this.updateOutsideMarkerColours();
    }

    private void setDataOnMapBlock(MapBlock b) {
        if (b == null) {
            return;
        }
        try {
            b.setData(this.scjp.getChartProperties());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error setting data on well selection map block", e);
        }
    }

    private void updateOutsideMarkerColours() {
        this.outsideMarkerPanel.setPointColour(this.wellLocLayer.getProperties().pinColour());
        this.outsideMarkerPanel.setSelectedPointColour(this.wellLocLayer.getProperties().selectedPinColour());
        this.outsideMarkerPanel.repaint();
    }

    @Override
    public void onPropertyChanged() {
        this.updateOutsideMarkerColours();
    }

    public void setMapCRS(CrsCode code) throws SQLException, SBException, IOException {
        this.scjp.getMapBlock().getProp().setCrsCode(code);
        this.scjp.getMapBlock().setData(ChartEvent.createPropertyChangeChartEvent(null), new ChartUpdate(this.scjp.getChartProperties()));
        if (this.helper != null) {
            this.helper.setWellSelectionMapProjection(code, this.projID);
        }
    }

    public boolean isWGS84Projection() {
        if (this.scjp != null && this.scjp.getMapBlock() != null) {
            return this.scjp.getMapBlock().getProp().getCrsCode() == CrsCode.WGS84;
        }
        return true;
    }

    public void disableUpdates() {
        this.enableUpdates = false;
    }

    public void enableUpdates() {
        this.enableUpdates = true;
    }
}

