/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.component;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelTaxonBase;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.SBPanel;
import jsbchart.tag.ChartTag;
import jsbugs.ChartJPanel;
import jsbugs.FrameJsbugs;
import jsbugs.GUI;
import jsbugs.chart.ZoomListener;
import jsbugs.chart.component.ChartToolTipUtils;
import net.java.balloontip.BalloonTip;

public class JScrollPaneChartBase
extends JScrollPane {
    public static final float ZOOM_INCREMENT = 1.25f;
    public final ChartJPanel view;
    private boolean xHairs;
    private BalloonTip magnifier;

    public JScrollPaneChartBase(ChartJPanel view) {
        super(view);
        this.getViewport().setScrollMode(0);
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.getHorizontalScrollBar().setUnitIncrement(20);
        if (FrameJsbugs.isMacPlatform()) {
            this.setHorizontalScrollBarPolicy(32);
            this.setVerticalScrollBarPolicy(22);
        }
        this.xHairs = false;
        this.view = view;
        view.addListener(this);
    }

    public void initListeners() {
        this.initXHairListeners();
        this.initMarqueeZoomListener();
        this.initMouseWheelZoomListener();
        this.initTooltipListener();
        this.initResolutionZoomListener();
    }

    public ChartJPanel getView() {
        return this.view;
    }

    public Chart getChart() {
        return this.view.chart;
    }

    public void refreshView() {
        if (this.view.chart.calcChartSize()) {
            GUI.setScrollPaneSize(this.view, this.view.getZoom(), 1.25f);
        }
        this.view.setBackground(this.view.chart.getProperties().background);
    }

    public void terminate() {
        this.view.terminate();
    }

    public void addJPanelMouseMotionListener(MouseMotionListener l) {
        this.view.addMouseMotionListener(l);
    }

    public void addJPanelMouseListener(MouseListener l) {
        this.view.addMouseListener(l);
    }

    public void addJPanelMouseWheelListener(MouseWheelListener l) {
        this.view.addMouseWheelListener(l);
    }

    public float getZoom() {
        return this.view.getZoom();
    }

    public void zoom(boolean in) {
        if (in) {
            this.view.getZoomManager().zoomIn();
        } else {
            this.view.getZoomManager().zoomOut();
        }
    }

    public void zoomAt(boolean in, int x, int y) {
        if (in) {
            this.view.getZoomManager().zoomInAt(x, y);
        } else {
            this.view.getZoomManager().zoomOutAt(x, y);
        }
    }

    public void zoomToNatural() {
        this.view.getZoomManager().resetZoom();
    }

    public void fitToScreen() {
        this.view.chart.calcChartSize();
        this.view.getZoomManager().fitToScreen(this.getViewport().getSize(), this.view.chart.getMMwidth(), this.view.chart.getMMheight());
    }

    public void zoomToRect(Rectangle2D.Float rect) {
        this.view.getZoomManager().zoomToRect(rect);
    }

    public void initMarqueeZoomListener() {
        MouseAdapter marqueeAdapter = new MouseAdapter(this){
            private Point2D.Float origin;
            final /* synthetic */ JScrollPaneChartBase this$0;
            {
                JScrollPaneChartBase jScrollPaneChartBase = this$0;
                Objects.requireNonNull(jScrollPaneChartBase);
                this.this$0 = jScrollPaneChartBase;
                this.origin = null;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && e.isAltDown() && !e.isControlDown() && !e.isShiftDown()) {
                    this.origin = this.this$0.view.getPoint(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.this$0.view.clearMarquee();
                if (this.origin != null) {
                    Rectangle2D.Float rect = new Rectangle2D.Float();
                    rect.setFrameFromDiagonal(this.origin, this.this$0.view.getPoint(e.getPoint()));
                    this.this$0.zoomToRect(rect);
                    this.origin = null;
                    this.this$0.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.origin != null) {
                    Point2D.Float p = this.this$0.view.getPoint(e.getPoint());
                    this.this$0.view.setMarquee(this.origin, p);
                    this.this$0.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.this$0.view.clearMarquee();
                this.origin = null;
                this.this$0.repaint();
            }
        };
        this.addJPanelMouseListener(marqueeAdapter);
        this.addJPanelMouseMotionListener(marqueeAdapter);
    }

    public void initMouseWheelZoomListener() {
        this.setWheelScrollingEnabled(false);
        MouseAdapter mouseWheelZoomAdapter = new MouseAdapter(this){
            final /* synthetic */ JScrollPaneChartBase this$0;
            {
                JScrollPaneChartBase jScrollPaneChartBase = this$0;
                Objects.requireNonNull(jScrollPaneChartBase);
                this.this$0 = jScrollPaneChartBase;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                if (evt.isControlDown()) {
                    if (evt.getWheelRotation() > 0) {
                        this.this$0.zoomAt(false, evt.getPoint().x, evt.getPoint().y);
                    } else if (evt.getWheelRotation() < 0) {
                        this.this$0.zoomAt(true, evt.getPoint().x, evt.getPoint().y);
                    }
                    return;
                }
                JScrollBar scrollBar = (evt.getModifiersEx() & 0x40) > 0 ? this.this$0.horizontalScrollBar : this.this$0.verticalScrollBar;
                int iScrollAmount = evt.getScrollAmount();
                if (evt.getWheelRotation() >= 1) {
                    int iNewValue = scrollBar.getValue() + scrollBar.getBlockIncrement() * iScrollAmount * Math.abs(evt.getWheelRotation());
                    if (iNewValue > scrollBar.getMaximum()) {
                        iNewValue = scrollBar.getMaximum();
                    }
                    scrollBar.setValue(iNewValue);
                } else if (evt.getWheelRotation() <= -1) {
                    int iNewValue = scrollBar.getValue() - scrollBar.getBlockIncrement() * iScrollAmount * Math.abs(evt.getWheelRotation());
                    if (iNewValue < 0) {
                        iNewValue = 0;
                    }
                    scrollBar.setValue(iNewValue);
                }
            }
        };
        this.addJPanelMouseWheelListener(mouseWheelZoomAdapter);
    }

    public void initResolutionZoomListener() {
        this.view.getZoomManager().addZoomListener(new ZoomListener(this){
            final /* synthetic */ JScrollPaneChartBase this$0;
            {
                JScrollPaneChartBase jScrollPaneChartBase = this$0;
                Objects.requireNonNull(jScrollPaneChartBase);
                this.this$0 = jScrollPaneChartBase;
            }

            @Override
            public void zoomChanged(float zoom) {
                this.this$0.view.chart.getProperties().requestHighResolution = zoom > 5.0f;
            }
        });
    }

    public void initXHairListeners() {
        this.addJPanelMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ JScrollPaneChartBase this$0;
            {
                JScrollPaneChartBase jScrollPaneChartBase = this$0;
                Objects.requireNonNull(jScrollPaneChartBase);
                this.this$0 = jScrollPaneChartBase;
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                if (this.this$0.xHairs) {
                    this.this$0.drawXHair(evt);
                }
            }
        });
        this.addJPanelMouseListener(new MouseAdapter(this){
            final /* synthetic */ JScrollPaneChartBase this$0;
            {
                JScrollPaneChartBase jScrollPaneChartBase = this$0;
                Objects.requireNonNull(jScrollPaneChartBase);
                this.this$0 = jScrollPaneChartBase;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.this$0.xHairs) {
                    this.this$0.drawXHair(null);
                }
            }
        });
    }

    public void drawXHair(MouseEvent evt) {
        this.view.drawCrosshair(evt, true, evt == null ? null : ChartJPanel.EvtOrigin.VIEW);
    }

    public void setXHairs(boolean xHairs) {
        this.xHairs = xHairs;
        if (!xHairs) {
            this.drawXHair(null);
        }
    }

    public boolean showingXHairs() {
        return this.xHairs;
    }

    public void initTooltipListener() {
        this.view.addMouseMotionListener(new MouseAdapter(this){
            final /* synthetic */ JScrollPaneChartBase this$0;
            {
                JScrollPaneChartBase jScrollPaneChartBase = this$0;
                Objects.requireNonNull(jScrollPaneChartBase);
                this.this$0 = jScrollPaneChartBase;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.this$0.setToolTipText(e);
            }
        });
    }

    protected void setToolTipText(MouseEvent evt) {
        this.view.setToolTipText(this.view.getTooltip(evt));
    }

    public ChartBlockBase getSelectedBlock(MouseEvent evt) {
        return this.getSelectedBlock(evt.getPoint());
    }

    public ChartBlockBase getSelectedBlock(Point point) {
        Point2D.Float mmPoint = this.view.getPoint(point);
        return this.view.chart.getBlock(mmPoint, this.view.hMode(), this.view.vMode());
    }

    public ChartPanel getSelectedPanel(MouseEvent evt) {
        return this.getSelectedPanel(evt.getPoint());
    }

    public ChartPanel getSelectedPanel(Point point) {
        Point2D.Float pTemp = this.view.getPoint(point);
        Point2D.Float mmPoint = new Point2D.Float((float)((Point2D)pTemp).getX(), (float)((Point2D)pTemp).getY());
        return this.view.chart.getPanel(mmPoint, this.view.hMode(), this.view.vMode());
    }

    public PanelTaxonBase getSelectedInnerPanel(MouseEvent evt) {
        return this.getSelectedInnerPanel(evt.getPoint());
    }

    public PanelTaxonBase getSelectedInnerPanel(Point point) {
        Point2D.Float mmPoint = this.view.getPoint(point);
        Point2D.Float pointInPanel = new Point2D.Float();
        ChartPanel panel = this.view.chart.getPanel(mmPoint, this.view.hMode(), this.view.vMode(), pointInPanel);
        if (panel instanceof PanelTaxonGroup) {
            PanelTaxonGroup ptg = (PanelTaxonGroup)panel;
            return ptg.getPanel(pointInPanel.x);
        }
        return null;
    }

    public ChartTag getSelectedTag(MouseEvent evt) {
        Point2D.Float mmPoint = this.view.getPoint(evt.getPoint());
        return this.view.chart.getTag(mmPoint);
    }

    public Point2D.Float getPointInPanel(Point point) {
        Point2D.Float mmPoint = this.view.getPoint(point);
        Point2D.Float pointInPanel = new Point2D.Float();
        ChartPanel panel = this.view.chart.getPanel(mmPoint, this.view.hMode(), this.view.vMode(), pointInPanel);
        if (panel instanceof SBPanel) {
            return pointInPanel;
        }
        return null;
    }

    public ChartPanel getSelectedPanel() {
        return Optional.ofNullable(this.view.chart.getBlockSingle()).flatMap(ChartBlockBase::getSelectedPanel).orElse(null);
    }

    public Point2D.Float getSelectedPanelOrigin() {
        ChartPanel panel = this.getSelectedPanel();
        if (panel == null) {
            return null;
        }
        return this.view.chart.getMmPanelOrigin((SBPanel)panel, this.view.hMode(), this.view.vMode(), 0.0f);
    }

    public Point getPosition(Point2D.Float mmPoint) {
        return this.view.getPosition(mmPoint);
    }

    public boolean pointIsInChart(Point p) {
        Point2D.Float mmPoint = this.view.getPoint(p);
        return ((Point2D)mmPoint).getX() <= (double)this.view.chart.getMMwidth() && ((Point2D)mmPoint).getY() <= (double)this.view.chart.getMMheight();
    }

    public double getDepth(Point popupPoint) {
        WellBlock wBlock;
        Point2D.Float pTemp = this.view.getPoint(popupPoint);
        Point2D.Float mmPoint = new Point2D.Float((float)((Point2D)pTemp).getX(), (float)((Point2D)pTemp).getY());
        Point2D.Float pInPanel = new Point2D.Float();
        ChartPanel panel = this.view.chart.getPanel(mmPoint, this.view.hMode(), this.view.vMode(), pInPanel);
        ChartBlock chartBlock = ((SBPanel)panel).getBlock();
        WellBlock wellBlock = chartBlock instanceof WellBlock ? (wBlock = (WellBlock)chartBlock) : this.view.chart.getWellBlock();
        return wellBlock.getDepth(pInPanel.y);
    }

    public Object getObject(Point point) {
        return this.view.getObject(point);
    }

    public void setShowCentre(boolean show) {
        this.view.setShowCentre(show);
    }

    public void centreViewOnPoint(int x, int y) {
        Rectangle r = this.view.getVisibleRect();
        this.view.scrollRectToVisible(new Rectangle(x - r.width / 2, y - r.height / 2, r.width, r.height));
    }

    public void initMagnifier() {
        if (this.magnifier != null) {
            return;
        }
        this.magnifier = ChartToolTipUtils.initChartToolTip(this);
    }

    public void decommissionMagnifier() {
        if (this.magnifier == null) {
            return;
        }
        this.magnifier.setVisible(false);
        ChartToolTipUtils.removeListeners(this.view);
        this.magnifier = null;
    }

    public boolean hasMagnifier() {
        return this.magnifier != null;
    }
}

