/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.mouse;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jsbugs.ChartJPanel;
import jsbugs.chart.KeyPressListener;
import jsbugs.chart.KeyboardStatusMonitor;
import jsbugs.chart.mouse.IMouseBehaviour;
import jsbugs.chart.mouse.MapBlockMarqueeZoomBehaviour;
import jsbugs.chart.mouse.MapBlockMoveResizeBehaviour;
import jsbugs.chart.mouse.MapBlockZoomBehaviour;
import jsbugs.chart.mouse.MarqueeZoomBehaviour;
import jsbugs.chart.mouse.PanningAndZoomingMouseBehaviour;
import jsbugs.chart.tag.ChartTagButtonBehaviour;
import jsbugs.chart.tag.ChartTagMoveResizeBehaviour;
import jsbugs.chart.tag.ChartTagTargetBehaviour;

public class ChartMouseListenerManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyPressListener {
    private static final Logger LOGGER = Logger.getLogger(ChartMouseListenerManager.class.getName());
    private Point lastMousePosition;
    private final ChartJPanel target;
    private final List<IMouseBehaviour> allBehaviours;
    private final List<IMouseBehaviour> activeBehaviours = new ArrayList<IMouseBehaviour>();
    private IMouseBehaviour currentBehaviour;
    private final KeyboardStatusMonitor keyboardStatusMonitor = new KeyboardStatusMonitor();

    public ChartMouseListenerManager(ChartJPanel target) {
        this.target = target;
        this.allBehaviours = Arrays.asList(new ChartTagButtonBehaviour(target), new ChartTagTargetBehaviour(target), new ChartTagMoveResizeBehaviour(target), new MapBlockZoomBehaviour(target, this.keyboardStatusMonitor), new MapBlockMoveResizeBehaviour(target, this.keyboardStatusMonitor), new MapBlockMarqueeZoomBehaviour(target, this.keyboardStatusMonitor), new PanningAndZoomingMouseBehaviour(target, this.keyboardStatusMonitor), new MarqueeZoomBehaviour(target, this.keyboardStatusMonitor));
        this.keyboardStatusMonitor.addListener(this);
        this.keyboardStatusMonitor.setUp();
    }

    public void terminate() {
        this.keyboardStatusMonitor.tearDown();
    }

    public void setChartChangeNotifyRunnable(Runnable notificationRunnable) {
        for (IMouseBehaviour b : this.allBehaviours) {
            b.setChartChangeNotifyRunnable(notificationRunnable);
        }
    }

    private void setCursor(Point p) {
        if (p == null) {
            return;
        }
        IMouseBehaviour b = this.getBehaviourForPoint(p);
        if (b != null) {
            this.target.setCursor(b.getCursor(p));
        } else {
            this.target.setCursor(new Cursor(0));
        }
    }

    private IMouseBehaviour getBehaviourForPoint(Point p) {
        if (this.currentBehaviour != null) {
            return this.currentBehaviour;
        }
        for (IMouseBehaviour b : this.activeBehaviours) {
            if (!b.activeAt(p)) continue;
            return b;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null) {
            b.mouseClicked(e);
        }
        this.setCurrentBehaviour(b);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null) {
            b.mousePressed(e);
        }
        this.setCurrentBehaviour(b);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null) {
            b.mouseReleased(e);
        }
        this.setCurrentBehaviour(b);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null) {
            b.mouseEntered(e);
        }
        this.setCurrentBehaviour(b);
        this.setCursor(this.lastMousePosition);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null) {
            b.mouseExited(e);
        }
        this.setCurrentBehaviour(b);
        this.keyboardStatusMonitor.clearKeyboardStatus();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null) {
            b.mouseDragged(e);
        }
        this.setCurrentBehaviour(b);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastMousePosition = e.getPoint();
        this.setCursor(e.getPoint());
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null) {
            b.mouseMoved(e);
        }
        this.setCurrentBehaviour(b);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        IMouseBehaviour b = this.getBehaviourForPoint(e.getPoint());
        if (b != null && b instanceof MouseWheelListener) {
            ((MouseWheelListener)((Object)b)).mouseWheelMoved(e);
            this.setCurrentBehaviour(b);
        } else {
            JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.target);
            scrollPane.dispatchEvent(SwingUtilities.convertMouseEvent(this.target, e, scrollPane));
            this.setCurrentBehaviour(null);
        }
    }

    private void setCurrentBehaviour(IMouseBehaviour b) {
        this.currentBehaviour = b != null && b.isCurrent() ? b : null;
    }

    public void activateBehavioursForSelection(Object selection) {
        this.activeBehaviours.clear();
        this.activeBehaviours.addAll(this.allBehaviours.stream().filter(b -> b.isActiveForSelection(selection)).collect(Collectors.toList()));
    }

    public boolean hasCurrentBehaviour() {
        return this.currentBehaviour != null;
    }

    @Override
    public void keyPressed(int keyCode) {
        this.setCursor(this.lastMousePosition);
    }

    @Override
    public void keyReleased(int keyCode) {
        this.setCursor(this.lastMousePosition);
    }
}

