/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockType;
import jsbchart.core.Chart;
import jsbugs.FrameChart;
import jsbugs.chart.properties.BlockPropertyRow;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.chart.properties.PropertiesTableModel;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.project.Project;
import model3.project.WellList;
import util.InvalidFieldException;
import util.SBException;

abstract class AbstractBlockPropertiesTableModel
extends PropertiesTableModel {
    private final Frame parent;
    final HashMap<Integer, BlockPropertyRow> rowMap = new HashMap();

    public AbstractBlockPropertiesTableModel(Frame parent, SBdb sbdb) {
        super(sbdb);
        this.parent = parent;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.rowMap.get(rowIndex).getTitle();
        }
        return this.rowMap.get(rowIndex).getValue();
    }

    @Override
    String getToolTipText(int rowIndex) {
        if (this.rowMap.get(rowIndex) != null) {
            return this.rowMap.get(rowIndex).getToolTip();
        }
        return null;
    }

    @Override
    protected TableCellRenderer getCellRenderer(int row, int column) {
        return this.rowMap.get(row).getCellRenderer(column);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return this.rowMap.get(row).isTitleEditable();
        }
        return this.rowMap.get(row).isValueEditable();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column != 1) {
            return;
        }
        try {
            this.rowMap.get(row).setValue(value, this.sbdb);
        }
        catch (SQLException | InvalidFieldException | SBException e) {
            SbugsExceptionHandler.showStackError(e);
        }
        Frame frame = this.parent;
        if (frame instanceof FrameChart) {
            FrameChart frameChart = (FrameChart)frame;
            frameChart.fireChartMightHaveChanged();
        }
    }

    @Override
    protected boolean allowNull(int row) {
        return this.rowMap.get(row).allowNull();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    protected boolean isTitleRow(int row) {
        return this.rowMap.get(row).isTitleRow();
    }

    @Override
    protected boolean isTitleInnerRow(int row) {
        return false;
    }

    @Override
    protected boolean isTitleButtonRow(int row) {
        return false;
    }

    Chart getSelectedChart() {
        if (this.parent instanceof FrameChart) {
            return ((FrameChart)this.parent).getSelectedChart();
        }
        return null;
    }

    Project getChartProject() {
        Project chartProject = null;
        if (this.getSelectedChart() != null && this.getSelectedChart().getTemplate().getProjID() > 0) {
            try {
                chartProject = this.sbdb.getProject(this.getSelectedChart().getTemplate().getProjID());
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        return chartProject;
    }

    WellList getChartDefaultWellList() {
        WellList chartDefaultWellList = null;
        if (this.getSelectedChart() != null && this.getSelectedChart().getTemplate().getProjID() > 0 && this.getSelectedChart().getTemplate().getWellListID() > 0) {
            chartDefaultWellList = (WellList)this.sbdb.getWellListService().getWellList(this.getSelectedChart().getTemplate().getWellListID());
        }
        return chartDefaultWellList;
    }

    abstract BlockType getBlockType();

    BlockPropertyRow getBlockPropertyRow(int row) {
        return this.rowMap.get(row);
    }

    class LinkAction
    implements ActionListener {
        private Integer row;
        private LinkEditor linkEditor;
        private final LinkRenderer linkRenderer;
        final /* synthetic */ AbstractBlockPropertiesTableModel this$0;

        public LinkAction(AbstractBlockPropertiesTableModel this$0, LinkRenderer linkRenderer) {
            AbstractBlockPropertiesTableModel abstractBlockPropertiesTableModel = this$0;
            Objects.requireNonNull(abstractBlockPropertiesTableModel);
            this.this$0 = abstractBlockPropertiesTableModel;
            this.linkRenderer = linkRenderer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int opt;
            if (this.row == null) {
                throw new NullPointerException("Action performed on null row");
            }
            LinkedBlockPropertyRow propRow = (LinkedBlockPropertyRow)this.this$0.getBlockPropertyRow(this.row);
            boolean link = (Boolean)this.linkEditor.getCellEditorValue();
            if (propRow.isLinked() == link) {
                return;
            }
            if (!link) {
                propRow.setUnlinked();
                return;
            }
            if (Boolean.TRUE.equals(propRow.checkLink())) {
                try {
                    propRow.setLinked(this.this$0.sbdb);
                    return;
                }
                catch (SQLException | InvalidFieldException | SBException ex) {
                    SbugsExceptionHandler.showStackError(ex, this.this$0.parent);
                }
            }
            String msg = "Set " + propRow.getTitle().trim().toLowerCase() + " to " + String.valueOf(this.this$0.getValueAt(this.row, 1)) + " in all ";
            if (propRow.linkOnlyBlocksOfType()) {
                msg = msg + this.this$0.getBlockType().getShortDescr() + " ";
            }
            if ((opt = JOptionPane.showConfirmDialog(this.this$0.parent, msg = msg + "blocks?", "Link Property", 0)) == 1) {
                this.linkRenderer.setLinked(false, propRow.getLinkBlockType());
                this.linkEditor.setLinked(false, propRow.getLinkBlockType());
                return;
            }
            try {
                propRow.setLinked(this.this$0.sbdb);
            }
            catch (SQLException | InvalidFieldException | SBException ex) {
                SbugsExceptionHandler.showStackError(ex, this.this$0.parent);
            }
        }

        void setRow(int row, LinkEditor editor) {
            this.row = row;
            this.linkEditor = editor;
        }
    }
}

