/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import com.stratadata.model3.well.SectionType;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.BlockTypeHelper;
import jsbchart.block.ChartBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.ChartTemplate;
import jsbugs.FrameChart;
import jsbugs.chart.properties.AbstractBlockPropertiesTableModel;
import jsbugs.chart.properties.BlockPropertyRow;
import jsbugs.chart.properties.BlockPropertyRowCaption;
import jsbugs.chart.properties.BlockPropertyRowInterp;
import jsbugs.chart.properties.BlockPropertyRowLabelScaleType;
import jsbugs.chart.properties.BlockPropertyRowScale;
import jsbugs.chart.properties.BlockPropertyRowScaleType;
import jsbugs.chart.properties.BlockPropertyRowTitleDynamic;
import jsbugs.chart.properties.BlockPropertyRowTitleTemplate;
import jsbugs.chart.properties.BlockPropertyRowUnits;
import jsbugs.chart.properties.BlockPropertyRowWell;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.CaptionEditor;
import jsbugs.table.ChartBlockWellEditor;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.CheckBoxRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.EnumEditor;
import jsbugs.table.FloatEditor;
import jsbugs.table.InterpEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import jsbugs.table.ScaleEditor;
import jsbugs.table.ScaleTypeEditor;
import jsbugs.table.StandardRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.WellInterp;
import model3.project.Project;
import model3.project.WellList;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;

public class BlockPropertiesTableModel
extends AbstractBlockPropertiesTableModel {
    private static final int ROW_TITLE = 0;
    private static final int ROW_WELL = 1;
    public static final int ROW_INTERP = 2;
    private static final int ROW_CAPTION = 3;
    private static final int ROW_UNITS = 4;
    private static final int ROW_SCALETYPE = 5;
    private static final int ROW_LABELSCALETYPE = 6;
    private static final int ROW_SCALETITLE = 7;
    private static final int N_ROWS = 8;
    private static final int N_SCALE_ROWS = 3;
    private static final int N_ALT_ROWS = 5;
    private static final int ROW_SCALE_MIN = 0;
    private static final int ROW_SCALE_MAX = 1;
    private static final int ROW_SCALE_SCALE = 2;
    private static final int ALT_ROW_TITLE = 0;
    private static final int ALT_ROW_MIN = 1;
    private static final int ALT_ROW_MAX = 2;
    private static final int ALT_ROW_SCALE = 3;
    private static final int ALT_ROW_AGELTR = 4;
    private ChartBlock block;
    private final Frame parent;
    private LinkedBlockPropertyRow scaleRow;
    private final ComboRenderer comboRenderer = new ComboRenderer();
    private final ButtonRenderer buttonRenderer = new ButtonRenderer();
    private final LinkRenderer linkRenderer = new LinkRenderer();
    private final CheckBoxRenderer booleanRenderer = new CheckBoxRenderer();
    private final StandardRenderer newScaleRowRenderer = new StandardRenderer(Color.LIGHT_GRAY);
    private final InterpEditor interpEditor = new InterpEditor(this.sbdb);
    private final EnumEditor depthUnitsEditor = new EnumEditor(new JComboBox(), DepthUnits.class, null);
    private final ScaleTypeEditor scaleTypeEditor = new ScaleTypeEditor(new JComboBox(), "Inherited");
    private final ChartBlockWellEditor wellEditor;
    private final ScaleEditor scaleEditor = new ScaleEditor(new JComboBox());
    private final AbstractBlockPropertiesTableModel.LinkAction linkAction = new AbstractBlockPropertiesTableModel.LinkAction(this, this.linkRenderer);
    private final LinkEditor linkEditor = new LinkEditor(this.linkAction);
    private final CaptionEditor captionEditor;
    private final CheckBoxEditor booleanEditor = new CheckBoxEditor();
    private final FloatEditor scaleLimitEditor = new FloatEditor(true);

    public BlockPropertiesTableModel(Frame parent, SBdb sbdb) {
        super(parent, sbdb);
        this.parent = parent;
        this.interpEditor.allowNullValue(false);
        this.wellEditor = new ChartBlockWellEditor(this.parent, sbdb);
        this.captionEditor = new CaptionEditor(this.parent);
        this.initRows();
    }

    private void initRows() {
        this.rowMap.clear();
        this.rowMap.put(0, new BlockPropertyRowTitleTemplate("Chart Block"));
        this.rowMap.put(1, new BlockPropertyRowWell(this.linkRenderer, this.linkEditor, this.buttonRenderer, this.wellEditor));
        this.rowMap.put(2, new BlockPropertyRowInterp(this.sbdb, this.linkRenderer, this.linkEditor, this.comboRenderer, this.interpEditor));
        this.rowMap.put(3, new BlockPropertyRowCaption(this.linkRenderer, this.linkEditor, new ButtonRenderer("<default>"), this.captionEditor));
        this.rowMap.put(4, new BlockPropertyRowUnits(this.linkRenderer, this.linkEditor, (TableCellRenderer)new ComboRenderer(), this.depthUnitsEditor));
        this.rowMap.put(5, new BlockPropertyRowScaleType(this.linkRenderer, this.linkEditor, this.comboRenderer, this.scaleTypeEditor, new ScaleTypeWarningAction(this)));
        this.rowMap.put(6, new BlockPropertyRowLabelScaleType(this.linkRenderer, this.linkEditor, this.comboRenderer, this.scaleTypeEditor, new ScaleTypeWarningAction(this)));
        this.rowMap.put(7, new BlockPropertyRowTitleDynamic("Scale", true, () -> this.block.getProp().getnScaleSections() > 1 ? "Scale Sections" : "Scale"));
        this.scaleRow = new BlockPropertyRowScale(this.linkRenderer, this.linkEditor, this.comboRenderer, this.scaleEditor, this.sbdb);
    }

    @Override
    BlockPropertyRow getBlockPropertyRow(int row) {
        if (row > 8 && this.isLinkedScaleSectionRow(this.identifyRow(row))) {
            return this.scaleRow;
        }
        return super.getBlockPropertyRow(row);
    }

    @Override
    String getToolTipText(int rowIndex) {
        if (rowIndex > 8) {
            return null;
        }
        return super.getToolTipText(rowIndex);
    }

    public void setBlock(ChartBlock block) {
        if (block == null || block == this.block) {
            return;
        }
        this.block = block;
        this.wellEditor.allowNullValue(BlockTypeHelper.canSetNullWells(block.getBlockType()));
        Project chartProject = this.getChartProject();
        WellList defaultWellList = this.getChartDefaultWellList();
        this.rowMap.entrySet().forEach(e -> ((BlockPropertyRow)e.getValue()).init(block, this.getSelectedChart(), chartProject, defaultWellList));
        this.scaleRow.init(block, this.getSelectedChart(), chartProject, defaultWellList);
    }

    @Override
    public int getRowCount() {
        if (this.block == null) {
            return 0;
        }
        return 8 + this.getnScaleRows() + this.block.getProp().nAltProp() * 5;
    }

    private int getnScaleRows() {
        return this.block.getProp().getnScaleSections() * 3 + 1;
    }

    @Override
    public Object getValueAt(int row, int columnIndex) {
        if (row < 8) {
            return super.getValueAt(row, columnIndex);
        }
        if (columnIndex == 0) {
            return this.getRowName(row);
        }
        RowIdent rowIdent = this.identifyRow(row);
        if (rowIdent.type == RowIdent.Type.SCALE) {
            switch (rowIdent.row) {
                case 0: 
                case 1: {
                    float val = rowIdent.row == 0 ? this.block.getProp().getMin(rowIdent.scaleSection) : this.block.getProp().getMax(rowIdent.scaleSection);
                    switch (this.block.getProp().getScaleType()) {
                        case AGE: {
                            return Float.valueOf(val);
                        }
                    }
                    char sectionType = this.block.getWell() != null ? this.block.getWell().getSectionType().getCharType() : SectionType.WELL.getCharType();
                    return Float.valueOf(DepthUtils.convFromM((float)val, (char)this.block.getProp().getUnits(), (char)sectionType));
                }
                case 2: {
                    return Float.valueOf(this.block.getProp().getScale(rowIdent.scaleSection));
                }
            }
            return null;
        }
        if (rowIdent.type == RowIdent.Type.ALT) {
            BlockProperties altProp = this.block.getProp().getAltProp(rowIdent.altPropType);
            switch (rowIdent.row) {
                case 0: {
                    return null;
                }
                case 1: 
                case 2: {
                    float altVal = rowIdent.row == 1 ? altProp.getMin() : altProp.getMax();
                    switch (altProp.getScaleType()) {
                        case AGE: {
                            return Float.valueOf(altVal);
                        }
                    }
                    return Float.valueOf(DepthUtils.convFromM((float)altVal, (char)this.block.getProp().getUnits(), (char)'W'));
                }
                case 3: {
                    return Float.valueOf(altProp.getSingleScale());
                }
                case 4: {
                    return altProp.getAgeLeftToRight();
                }
            }
            assert (false);
            return null;
        }
        return null;
    }

    @Override
    BlockType getBlockType() {
        return this.block.getBlockType();
    }

    private RowIdent identifyRow(int row) {
        if (row < 8) {
            return null;
        }
        if ((row -= 8) < this.getnScaleRows()) {
            if (row == this.getnScaleRows() - 1) {
                return RowIdent.newScaleSectionRow();
            }
            int section = 0;
            while (row >= 3) {
                row -= 3;
                ++section;
            }
            return RowIdent.scaleRow(row, section);
        }
        row -= this.getnScaleRows();
        for (BlockProperties.ScaleType scaleType : BlockProperties.ScaleType.values()) {
            if (!this.block.getProp().hasAltProp(scaleType)) continue;
            if (row >= 5) {
                row -= 5;
                continue;
            }
            return RowIdent.altPropRow(row, scaleType);
        }
        return null;
    }

    private boolean isLinkedScaleSectionRow(RowIdent iRow) {
        return iRow.type == RowIdent.Type.SCALE && iRow.row == 2 && iRow.scaleSection == this.block.getProp().getLongestSection();
    }

    private boolean isNewScaleSectionRow(RowIdent iRow) {
        return iRow.type == RowIdent.Type.SCALE && iRow.row < 0;
    }

    @Override
    protected boolean showRow(int row) {
        if (this.block instanceof WellBlock && this.block.getWell() == null) {
            switch (row) {
                case 0: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
        RowIdent rowIdent = this.identifyRow(row);
        if (rowIdent != null && rowIdent.type == RowIdent.Type.ALT && rowIdent.row == 4) {
            return rowIdent.altPropType == BlockProperties.ScaleType.AGE;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row < 8) {
            super.setValueAt(value, row, column);
            if (this.parent instanceof FrameChart && row == 1) {
                ((FrameChart)this.parent).selectedChartWellMightHaveChanged();
            }
            return;
        }
        if (column != 1) {
            return;
        }
        rowIdent = this.identifyRow(row);
        if (rowIdent.type == RowIdent.Type.SCALE) {
            v0 = val = value instanceof Float != false ? ((Float)value).floatValue() : Float.parseFloat(value.toString());
            if (rowIdent.row < 0) {
                this.block.getProp().addScaleSection(val);
                this.fireTableDataChanged();
                return;
            }
            nScaleSections = this.block.getProp().getnScaleSections();
            switch (rowIdent.row) {
                case 0: 
                case 1: {
                    switch (1.$SwitchMap$jsbchart$block$BlockProperties$ScaleType[this.block.getProp().getScaleType().ordinal()]) {
                        case 1: {
                            break;
                        }
                        default: {
                            sectionType = this.block.getWell() != null ? this.block.getWell().getSectionType().getCharType() : SectionType.WELL.getCharType();
                            val = (float)DepthUtils.convToM((float)val, (char)this.block.getProp().getUnits(), (char)sectionType);
                        }
                    }
                    try {
                        switch (rowIdent.row) {
                            case 0: {
                                this.block.setMin(val, rowIdent.scaleSection);
                                ** break;
                            }
                            case 1: {
                                this.block.setMax(val, rowIdent.scaleSection);
                                ** break;
                            }
                        }
                        if (!BlockPropertiesTableModel.$assertionsDisabled) {
                            throw new AssertionError();
                        }
lbl34:
                        // 4 sources

                    }
                    catch (InvalidFieldException ife) {
                        JOptionPane.showMessageDialog(this.parent, ife.getMessage(), "Set value", 2);
                    }
                    break;
                }
                case 2: {
                    if (rowIdent.scaleSection == this.block.getProp().getLongestSection()) {
                        try {
                            this.scaleRow.setValue(value, this.sbdb);
                        }
                        catch (SQLException | InvalidFieldException | SBException e) {
                            SbugsExceptionHandler.showStackError(e, this.parent);
                        }
                        break;
                    }
                    scale = val;
                    this.block.setScale(scale, rowIdent.scaleSection);
                    break;
                }
                default: {
                    if (!BlockPropertiesTableModel.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            if (nScaleSections != this.block.getProp().getnScaleSections()) {
                this.fireTableDataChanged();
            }
        }
        if (rowIdent.type == RowIdent.Type.ALT) {
            switch (rowIdent.row) {
                case 1: 
                case 2: {
                    altVal = Float.parseFloat(value.toString());
                    switch (1.$SwitchMap$jsbchart$block$BlockProperties$ScaleType[rowIdent.altPropType.ordinal()]) {
                        case 1: {
                            break;
                        }
                        default: {
                            altVal = DepthUtils.convToM((float)altVal, (char)this.block.getProp().getUnits());
                        }
                    }
                    try {
                        if (rowIdent.row == 1) {
                            this.block.setAltMin(altVal, rowIdent.altPropType);
                            break;
                        }
                        this.block.setAltMax(altVal, rowIdent.altPropType);
                    }
                    catch (InvalidFieldException ife) {
                        JOptionPane.showMessageDialog(this.parent, ife.getMessage(), "Set value", 2);
                    }
                    break;
                }
                case 3: {
                    this.block.setAltScale(Float.parseFloat(value.toString()), rowIdent.altPropType);
                    break;
                }
                case 4: {
                    this.block.setAltAgeLTR((Boolean)value, rowIdent.altPropType);
                    break;
                }
                default: {
                    if (!BlockPropertiesTableModel.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
        if (this.parent instanceof FrameChart) {
            ((FrameChart)this.parent).fireChartMightHaveChanged();
        }
    }

    private String getRowName(int rowIndex) {
        RowIdent rowIdent = this.identifyRow(rowIndex);
        if (rowIdent.type == RowIdent.Type.SCALE) {
            if (rowIdent.row < 0) {
                return "<new section...>";
            }
            return this.getScaleRowName(rowIdent.row, this.block.getProp());
        }
        if (rowIdent.type == RowIdent.Type.ALT) {
            switch (rowIdent.row) {
                case 0: {
                    return "Horizontal Scale" + (String)(rowIdent.altPropType == BlockProperties.ScaleType.TVD ? "" : " (" + String.valueOf((Object)rowIdent.altPropType) + ")");
                }
                case 1: {
                    if (rowIdent.altPropType == BlockProperties.ScaleType.TVD) {
                        return "Min horz. offset";
                    }
                    return this.getScaleRowName(0, this.block.getProp().getAltProp(rowIdent.altPropType));
                }
                case 2: {
                    if (rowIdent.altPropType == BlockProperties.ScaleType.TVD) {
                        return "Max horz. offset";
                    }
                    return this.getScaleRowName(1, this.block.getProp().getAltProp(rowIdent.altPropType));
                }
                case 3: {
                    return this.getScaleRowName(2, this.block.getProp().getAltProp(rowIdent.altPropType));
                }
                case 4: {
                    return "Age left to right";
                }
            }
            assert (false);
        }
        throw new IllegalArgumentException("Unrecognised row index");
    }

    private String getScaleRowName(int row, BlockProperties bp) {
        switch (row) {
            case 0: {
                switch (bp.getScaleType()) {
                    case AGE: {
                        return "Youngest";
                    }
                    case TVD: {
                        return "Top TVD";
                    }
                    case TWT: {
                        return "Top TWT";
                    }
                }
                return "Top depth";
            }
            case 1: {
                switch (bp.getScaleType()) {
                    case AGE: {
                        return "Oldest";
                    }
                    case TVD: {
                        return "Base TVD";
                    }
                    case TWT: {
                        return "Base TWT";
                    }
                }
                return "Base depth";
            }
            case 2: {
                return "   Scale";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            ChartTemplate chartTemplate;
            if (this.getSelectedChart() != null && (chartTemplate = this.getSelectedChart().getTemplate()) != null && !chartTemplate.canWrite(this.sbdb, null)) {
                return false;
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            return false;
        }
        if (row < 8) {
            return super.isCellEditable(row, col);
        }
        if (col == 0 && this.isLinkedScaleSectionRow(this.identifyRow(row))) {
            return true;
        }
        return col == 1;
    }

    @Override
    public boolean isTitleRow(int row) {
        switch (row) {
            case 0: 
            case 7: {
                return true;
            }
        }
        if (row >= 8) {
            row -= 8;
            row -= this.getnScaleRows();
            while (row >= 5) {
                row -= 5;
            }
            return row == 0;
        }
        return false;
    }

    @Override
    protected boolean isTitleInnerRow(int row) {
        return row == 7;
    }

    @Override
    public boolean allowNull(int row) {
        if (row < 8) {
            return super.allowNull(row);
        }
        return false;
    }

    @Override
    protected TableCellRenderer getCellRenderer(int row, int column) {
        if (row < 8) {
            return super.getCellRenderer(row, column);
        }
        RowIdent rowIdent = this.identifyRow(row);
        if (this.isLinkedScaleSectionRow(rowIdent)) {
            return this.scaleRow.getCellRenderer(column);
        }
        if (column == 0 && this.isNewScaleSectionRow(rowIdent)) {
            return this.newScaleRowRenderer;
        }
        if (column == 1) {
            if (rowIdent.type == RowIdent.Type.SCALE && rowIdent.row == 2) {
                this.comboRenderer.setEnabled(true);
                return this.comboRenderer;
            }
            if (rowIdent.type == RowIdent.Type.ALT && rowIdent.row == 4) {
                return this.booleanRenderer;
            }
        }
        return null;
    }

    @Override
    protected TableCellEditor getCellEditor(int row, int column) {
        if (row < 8) {
            if (column == 0) {
                this.linkAction.setRow(row, this.linkEditor);
            }
            return ((BlockPropertyRow)this.rowMap.get(row)).getCellEditor(column);
        }
        RowIdent rowIdent = this.identifyRow(row);
        if (this.isLinkedScaleSectionRow(rowIdent)) {
            this.linkAction.setRow(row, this.linkEditor);
            return this.scaleRow.getCellEditor(column);
        }
        if (column == 1) {
            if (rowIdent.type == RowIdent.Type.SCALE) {
                switch (rowIdent.row) {
                    case 2: {
                        try {
                            this.scaleEditor.setScale(this.block.getProp().getScale(rowIdent.scaleSection), this.sbdb, this.block.getProp().getScaleType());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        return this.scaleEditor;
                    }
                    case -1: 
                    case 0: 
                    case 1: {
                        return this.scaleLimitEditor;
                    }
                }
            }
            if (rowIdent.type == RowIdent.Type.ALT) {
                switch (rowIdent.row) {
                    case 3: {
                        try {
                            this.scaleEditor.setScale(this.block.getProp().getAltProp(rowIdent.altPropType).getScale(), this.sbdb, rowIdent.altPropType);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        return this.scaleEditor;
                    }
                    case 1: 
                    case 2: {
                        return this.scaleLimitEditor;
                    }
                    case 4: {
                        return this.booleanEditor;
                    }
                }
            }
        }
        return null;
    }

    private class ScaleTypeWarningAction
    implements ActionListener {
        final /* synthetic */ BlockPropertiesTableModel this$0;

        private ScaleTypeWarningAction(BlockPropertiesTableModel blockPropertiesTableModel) {
            BlockPropertiesTableModel blockPropertiesTableModel2 = blockPropertiesTableModel;
            Objects.requireNonNull(blockPropertiesTableModel2);
            this.this$0 = blockPropertiesTableModel2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BlockProperties.ScaleType newScaleType = BlockProperties.ScaleType.valueOf(e.getActionCommand());
            if (this.this$0.block.getWell() == null || this.this$0.block.getProp().getScaleType() == newScaleType) {
                return;
            }
            try {
                switch (newScaleType) {
                    case AGE: {
                        WellInterp interp = this.this$0.block.getWell().getInterp(this.this$0.block.getInterpID());
                        if (interp == null) break;
                        interp.loadLOC(this.this$0.block.getWell().getWellID());
                        if (interp.getLOC() != null) break;
                        JOptionPane.showMessageDialog(this.this$0.parent, "WARNING: the current version has no depth/age curve.\nNo data will be plotted.", "Set scale type", 2);
                        break;
                    }
                    case TVD: {
                        if (this.this$0.block.getWell().getTVDlist(false) != null) break;
                        JOptionPane.showMessageDialog(this.this$0.parent, "WARNING: the current well has no deviation survey.\nData will be plotted by MD.", "Set scale type", 2);
                        break;
                    }
                    case TWT: {
                        if (this.this$0.block.getWell().getTWTlist() != null) break;
                        JOptionPane.showMessageDialog(this.this$0.parent, "WARNING: the current well has no Two-way time loaded.\nData will be plotted by MD.", "Set scale type", 2);
                        break;
                    }
                }
            }
            catch (SQLException | SBException ex) {
                SbugsExceptionHandler.showStackError(ex, this.this$0.parent);
            }
        }
    }

    private static class RowIdent {
        final Type type;
        final int row;
        final int scaleSection;
        final BlockProperties.ScaleType altPropType;

        private RowIdent(Type type, int row, int scaleSection, BlockProperties.ScaleType altPropType) {
            this.type = type;
            this.row = row;
            this.scaleSection = scaleSection;
            this.altPropType = altPropType;
        }

        static RowIdent newScaleSectionRow() {
            return new RowIdent(Type.SCALE, -1, 0, null);
        }

        static RowIdent scaleRow(int row, int scaleSection) {
            if (row < 0 || row > 2) {
                throw new IllegalStateException("Wrongly identified row");
            }
            return new RowIdent(Type.SCALE, row, scaleSection, null);
        }

        static RowIdent altPropRow(int row, BlockProperties.ScaleType altPropType) {
            if (row < 0 || row > 4) {
                throw new IllegalStateException("Wrongly identified row");
            }
            return new RowIdent(Type.ALT, row, 0, altPropType);
        }

        static enum Type {
            SCALE,
            ALT;

        }
    }
}

