/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import java.util.Objects;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.CaptionEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowCaption
extends LinkedBlockPropertyRow {
    public BlockPropertyRowCaption(LinkRenderer titleRenderer, LinkEditor linkEditor, ButtonRenderer captionRenderer, CaptionEditor captionEditor) {
        super(titleRenderer, linkEditor, captionRenderer, captionEditor);
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.captionsEqual();
        }
        return newLink;
    }

    public boolean captionsEqual() {
        return this.blocksOfType().allMatch(b -> Objects.equals(b.getCaption(), this.block.getCaption()));
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        String caption = (String)value;
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().forEach(b -> {
                b.setCaption(caption);
                b.notifyListeners();
            });
            return;
        }
        this.block.setCaption(caption);
        this.block.notifyListeners();
    }

    @Override
    String getTitle() {
        return "Caption";
    }

    @Override
    Object getValue() {
        return this.block.getCaption();
    }
}

