/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowEnableSymbolScalingWithThickness
extends LinkedBlockPropertyRow {
    public BlockPropertyRowEnableSymbolScalingWithThickness(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer valueRenderer, CheckBoxEditor valueEditor) {
        super(titleRenderer, linkEditor, valueRenderer, valueEditor);
    }

    @Override
    String getTitle() {
        return "Symbol size is unit thickness";
    }

    @Override
    Object getValue() {
        return ((MapBlock)this.block).getProp().getScaleSymbolWithIntervalThickness();
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.allScalingEnabled();
        }
        return newLink;
    }

    private boolean allScalingEnabled() {
        boolean enabled = ((MapBlock)this.block).getProp().getScaleSymbolWithIntervalThickness();
        return this.blocksOfType().map(b -> (MapBlock)b).allMatch(b -> b.getProp().getScaleSymbolWithIntervalThickness() == enabled);
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        Boolean boolValue = Boolean.parseBoolean(value.toString());
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (MapBlock)b).forEach(b -> b.setChartScaleByIntervalThickness(boolValue));
            return;
        }
        ((MapBlock)this.block).setChartScaleByIntervalThickness(boolValue);
    }
}

