/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import javax.swing.table.TableCellEditor;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.ComboRenderer;
import jsbugs.table.InterpEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.InterpHdr;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowInterp
extends LinkedBlockPropertyRow {
    private final SBdb sbdb;
    private final InterpEditor interpEditor;

    public BlockPropertyRowInterp(SBdb sbdb, LinkRenderer titleRenderer, LinkEditor linkEditor, ComboRenderer valueRenderer, InterpEditor valueEditor) {
        super(titleRenderer, linkEditor, valueRenderer, valueEditor);
        this.sbdb = sbdb;
        this.interpEditor = valueEditor;
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.chart.getBlocks().size() > 1) {
            newLink = this.interpsEqual();
        }
        return newLink;
    }

    public boolean interpsEqual() {
        return this.chart.getBlocks().stream().allMatch(b -> b.getInterpID() == this.block.getInterpID());
    }

    @Override
    boolean linkOnlyBlocksOfType() {
        return false;
    }

    @Override
    BlockType getLinkBlockType() {
        return null;
    }

    @Override
    TableCellEditor getCellEditor(int column) {
        if (column == 1 && this.chartProject != null) {
            try {
                this.interpEditor.restrictCombo(this.sbdb.getVersionsInProject(this.chartProject.getID()));
            }
            catch (SQLException | SBException e) {
                e.printStackTrace();
            }
        }
        return super.getCellEditor(column);
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        int interpID;
        if (value instanceof InterpHdr) {
            InterpHdr interpHdr = (InterpHdr)value;
            interpID = interpHdr.getInterpID();
        } else if (value instanceof Integer) {
            Integer intVal = (Integer)value;
            interpID = intVal;
        } else {
            interpID = 0;
        }
        if (this.chart != null && this.isLinked()) {
            for (ChartBlockBase b : this.chart.getBlocks()) {
                b.setInterpID(interpID);
            }
            return;
        }
        this.block.setInterpID(interpID);
    }

    @Override
    String getTitle() {
        return "Version";
    }

    @Override
    Object getValue() {
        try {
            return this.sbdb.getInterp(this.block.getInterpID());
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return null;
        }
    }
}

