/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.FloatEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowSymbolSize
extends LinkedBlockPropertyRow {
    public BlockPropertyRowSymbolSize(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer valueRenderer, FloatEditor valueEditor) {
        super(titleRenderer, linkEditor, valueRenderer, valueEditor);
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && this.blocksOfType().count() > 1L) {
            newLink = this.symbolSizeEqual();
        }
        return newLink;
    }

    private boolean symbolSizeEqual() {
        return this.blocksOfType().map(b -> (MapBlock)b).allMatch(b -> b.getProp().getSymbolSize() - ((MapBlock)this.block).getProp().getSymbolSize() < 1.0f);
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        Float f = Float.valueOf(Float.parseFloat(value.toString()));
        if (this.chart != null && this.isLinked()) {
            this.blocksOfType().map(b -> (MapBlock)b).forEach(b -> b.setPropSymbolSize(f.floatValue()));
            return;
        }
        ((MapBlock)this.block).setPropSymbolSize(f.floatValue());
    }

    @Override
    String getTitle() {
        return "Data symbol size";
    }

    @Override
    Object getValue() {
        return Float.valueOf(((MapBlock)this.block).getProp().getSymbolSize());
    }
}

