/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockType;
import jsbchart.block.BlockTypeHelper;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbugs.chart.properties.LinkedBlockPropertyRow;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.ChartBlockWellEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import model3.Well;
import model3.project.WellList;
import util.InvalidFieldException;
import util.SBException;

class BlockPropertyRowWell
extends LinkedBlockPropertyRow {
    private final ChartBlockWellEditor wellEditor;
    private final ButtonRenderer valueRenderer;

    public BlockPropertyRowWell(LinkRenderer titleRenderer, LinkEditor linkEditor, ButtonRenderer valueRenderer, ChartBlockWellEditor wellEditor) {
        super(titleRenderer, linkEditor, valueRenderer, wellEditor);
        this.wellEditor = wellEditor;
        this.valueRenderer = valueRenderer;
    }

    @Override
    Boolean checkLink() {
        Boolean newLink = null;
        if (this.chart != null && BlockTypeHelper.canLinkWellOrProject(this.block.getBlockType()) && this.blocksOfType().count() > 1L) {
            newLink = this.wellsEqual();
        }
        return newLink;
    }

    public boolean wellsEqual() {
        return this.blocksOfType().allMatch(b -> b.getWells().equals(this.block.getWells()));
    }

    @Override
    TableCellRenderer getCellRenderer(int column) {
        if (column == 1) {
            if (!this.isValueEditable()) {
                return null;
            }
            this.valueRenderer.canClear(this.allowNull());
        }
        return super.getCellRenderer(column);
    }

    @Override
    TableCellEditor getCellEditor(int column) {
        if (column == 1) {
            this.wellEditor.setBlockType(this.block.getBlockType(), this.chartProject, this.chartDefaultWellList);
            return this.wellEditor;
        }
        return super.getCellEditor(column);
    }

    @Override
    void setLinked(SBdb sbdb) throws SQLException, SBException {
        if (Boolean.TRUE.equals(this.link)) {
            return;
        }
        this.link = true;
        if (!Boolean.TRUE.equals(this.checkLink())) {
            if (this.block.getWellList() != null) {
                this.setWellList(this.block.getWellList());
            } else {
                this.setWell(this.block.getWell());
            }
        }
    }

    private void setWell(Well well) throws SQLException, SBException {
        if (this.chart != null && Boolean.TRUE.equals(this.link)) {
            this.chart.getBlocks().stream().filter(b -> b.getBlockType() == this.block.getBlockType()).forEachOrdered(b -> {
                b.setWell(well);
                b.notifyListeners();
            });
            return;
        }
        this.block.setWell(well);
        this.block.notifyListeners();
    }

    private void setWellList(WellList wellList) {
        if (this.chart != null && Boolean.TRUE.equals(this.link)) {
            this.chart.getBlocks().stream().filter(b -> b.getBlockType() == this.block.getBlockType()).forEachOrdered(b -> {
                b.setWellList(wellList);
                b.notifyListeners();
            });
            return;
        }
        this.block.setWellList(wellList);
        this.block.notifyListeners();
    }

    @Override
    String getTitle() {
        return "Well/Project";
    }

    @Override
    Object getValue() {
        MapBlock mapBlock;
        if (this.block.getWellList() != null) {
            return this.block.getWellList();
        }
        ChartBlockBase chartBlockBase = this.block;
        if (chartBlockBase instanceof MapBlock && !(mapBlock = (MapBlock)chartBlockBase).isSingleWellSet()) {
            return null;
        }
        return this.block.getWell();
    }

    @Override
    void setValue(Object value, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        Well well;
        if (value instanceof WellList) {
            WellList wellList = (WellList)((Object)value);
            Iterator<Well> it = sbdb.getWellIterator(wellList.getID());
            while (it.hasNext()) {
                this.initWell(it.next());
            }
            this.setWellList(wellList);
            return;
        }
        if (value != null && value instanceof Well) {
            well = (Well)value;
            if (this.chartProject != null && !this.block.getDb().getWellListService().isWellProjectMember(this.chartProject.getID(), well.getWellID())) {
                throw new InvalidFieldException("Cannot set well: '" + well.getWellName() + "' is not a member of chart project '" + String.valueOf((Object)this.chartProject) + "'.");
            }
        }
        if (value instanceof List) {
            List list = (List)value;
            well = (Well)list.get(0);
        } else {
            well = (Well)value;
        }
        this.initWell(well);
        this.setWell(well);
    }

    private void initWell(Well well) throws SQLException, SBException {
        if (well == null) {
            return;
        }
        well.loadInterps();
        well.loadSamples();
    }

    @Override
    boolean allowNull() {
        return BlockTypeHelper.canSetNullWells(this.block.getBlockType());
    }

    @Override
    boolean isValueEditable() {
        return this.chart != null && (this.block.getBlockType() != BlockType.PROJECT || this.chart.getTemplate().getProjID() <= 0);
    }
}

