/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.sql.SQLException;
import java.util.stream.Stream;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlockBase;
import jsbugs.chart.properties.BlockPropertyRow;
import jsbugs.table.AbledRenderer;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import model3.SBdb;
import util.InvalidFieldException;
import util.SBException;

abstract class LinkedBlockPropertyRow
extends BlockPropertyRow {
    private final LinkRenderer titleRenderer;
    private final LinkEditor linkEditor;
    private final TableCellRenderer valueRenderer;
    private final TableCellEditor valueEditor;
    Boolean link;

    public LinkedBlockPropertyRow(LinkRenderer titleRenderer, LinkEditor linkEditor, TableCellRenderer valueRenderer, TableCellEditor valueEditor) {
        this.titleRenderer = titleRenderer;
        this.linkEditor = linkEditor;
        this.valueRenderer = valueRenderer;
        this.valueEditor = valueEditor;
    }

    @Override
    boolean isTitleEditable() {
        return this.isValueEditable();
    }

    @Override
    void initLink() {
        this.link = this.checkLink();
    }

    abstract Boolean checkLink();

    boolean isLinked() {
        return this.link != null && this.link != false;
    }

    void setUnlinked() {
        this.link = false;
    }

    void setLinked(SBdb sbdb) throws SQLException, SBException, InvalidFieldException {
        this.link = true;
        if (Boolean.TRUE.equals(this.checkLink())) {
            return;
        }
        this.setValue(this.getValue(), sbdb);
    }

    boolean linkOnlyBlocksOfType() {
        return true;
    }

    BlockType getLinkBlockType() {
        if (this.chart == null || !this.chart.hasDifferentBlockTypes() || this.blocksOfType().count() < 2L) {
            return null;
        }
        if (this.isLinked()) {
            return this.block.getBlockType();
        }
        return null;
    }

    @Override
    TableCellRenderer getCellRenderer(int column) {
        if (column == 1) {
            TableCellRenderer tableCellRenderer = this.valueRenderer;
            if (tableCellRenderer instanceof AbledRenderer) {
                AbledRenderer abledRenderer = (AbledRenderer)((Object)tableCellRenderer);
                abledRenderer.setEnabled(this.isValueEditable());
            }
            return this.valueRenderer;
        }
        if (column == 0) {
            this.titleRenderer.setLinked(this.link, this.getLinkBlockType());
            return this.titleRenderer;
        }
        return null;
    }

    @Override
    TableCellEditor getCellEditor(int column) {
        if (column == 0) {
            this.linkEditor.setLinked(this.link, this.getLinkBlockType());
            return this.linkEditor;
        }
        if (column == 1) {
            return this.valueEditor;
        }
        return null;
    }

    Stream<ChartBlockBase> blocksOfType() {
        return this.chart.getBlocks().stream().filter(b -> b.getBlockType() == this.block.getBlockType());
    }
}

