/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import java.awt.Frame;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockType;
import jsbchart.block.BlockTypeHelper;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.graphics.map.CrsCode;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNodeListener;
import jsbugs.chart.properties.AbstractBlockPropertiesTableModel;
import jsbugs.chart.properties.BlockPropertyRow;
import jsbugs.chart.properties.BlockPropertyRowCRS;
import jsbugs.chart.properties.BlockPropertyRowCaption;
import jsbugs.chart.properties.BlockPropertyRowDataRangeExclude;
import jsbugs.chart.properties.BlockPropertyRowDataRangeStyle;
import jsbugs.chart.properties.BlockPropertyRowDeriveChronoAge;
import jsbugs.chart.properties.BlockPropertyRowEnableShowScale;
import jsbugs.chart.properties.BlockPropertyRowEnableSymbolScalingWithThickness;
import jsbugs.chart.properties.BlockPropertyRowInterp;
import jsbugs.chart.properties.BlockPropertyRowLithostratScheme;
import jsbugs.chart.properties.BlockPropertyRowLithostratUnit;
import jsbugs.chart.properties.BlockPropertyRowMapBounds;
import jsbugs.chart.properties.BlockPropertyRowMapDimension;
import jsbugs.chart.properties.BlockPropertyRowMapFillLegend;
import jsbugs.chart.properties.BlockPropertyRowMapLegend;
import jsbugs.chart.properties.BlockPropertyRowMapScaleLimit;
import jsbugs.chart.properties.BlockPropertyRowScaleType;
import jsbugs.chart.properties.BlockPropertyRowSymbolSize;
import jsbugs.chart.properties.BlockPropertyRowTitle;
import jsbugs.chart.properties.BlockPropertyRowTitleTemplate;
import jsbugs.chart.properties.BlockPropertyRowWell;
import jsbugs.list.IGDUnitListRenderer;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.CaptionEditor;
import jsbugs.table.ChartBlockWellEditor;
import jsbugs.table.CheckBoxEditor;
import jsbugs.table.CheckBoxRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.EnumEditor;
import jsbugs.table.FloatEditor;
import jsbugs.table.IGDSchEditor;
import jsbugs.table.InterpEditor;
import jsbugs.table.LinkEditor;
import jsbugs.table.LinkRenderer;
import jsbugs.table.ListEditor;
import jsbugs.table.ScaleTypeEditor;
import model3.SBdb;
import model3.project.Project;

public class MapBlockPropertiesTableModel
extends AbstractBlockPropertiesTableModel
implements ChartNodeListener {
    private static final int ROW_TITLE = 0;
    private static final int ROW_WELLS = 1;
    private static final int ROW_INTERP = 2;
    private static final int ROW_CAPTION = 3;
    private static final int ROW_CRS = 4;
    private static final int ROW_SYMBOL_SIZE = 5;
    private static final int ROW_ENABLE_SYMBOL_SCALING_WITH_THICKNESS = 6;
    private static final int ROW_SHOW_SCALE_BAR = 7;
    private static final int ROW_LEGEND = 8;
    private static final int ROW_FILL_LEGEND = 9;
    private static final int ROW_SIZE_TITLE = 10;
    private static final int ROW_SIZE_WIDTH = 11;
    private static final int ROW_SIZE_HEIGHT = 12;
    private static final int ROW_BOUNDS_TITLE = 13;
    private static final int ROW_BOUNDS_LONG_MIN = 14;
    private static final int ROW_BOUNDS_LONG_MAX = 15;
    private static final int ROW_BOUNDS_LAT_MIN = 16;
    private static final int ROW_BOUNDS_LAT_MAX = 17;
    private static final int ROW_DATA_RANGE_TITLE = 18;
    private static final int ROW_DATA_RANGE_STYLE = 19;
    private static final int ROW_SCALE_TYPE = 20;
    private static final int ROW_SCALE_MIN = 21;
    private static final int ROW_SCALE_MAX = 22;
    private static final int ROW_LITHOSTRAT_SCHEME = 23;
    private static final int ROW_LITHOSTRAT_UPPER_UNIT = 24;
    private static final int ROW_LITHOSTRAT_LOWER_UNIT = 25;
    private static final int ROW_DATA_RANGE_EXCLUDE = 26;
    private static final int ROW_DERIVE_AGE_FROM_CHRONO = 27;
    private static final int N_ROWS = 28;
    private final ButtonRenderer buttonRenderer = new ButtonRenderer();
    private final ComboRenderer comboRenderer = new ComboRenderer();
    private final ButtonRenderer captionRenderer = new ButtonRenderer("<default>");
    private final LinkRenderer linkRenderer = new LinkRenderer();
    private final CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
    private final ChartBlockWellEditor wellEditor;
    private final AbstractBlockPropertiesTableModel.LinkAction linkAction = new AbstractBlockPropertiesTableModel.LinkAction(this, this.linkRenderer);
    private final LinkEditor linkEditor = new LinkEditor(this.linkAction);
    private final CaptionEditor captionEditor;
    private final EnumEditor crsEditor = new EnumEditor(new JComboBox(), CrsCode.class, null);
    private final EnumEditor dataRangeStyleEditor = new EnumEditor(new JComboBox(), MapBlockProperties.DataRangeStyle.class, null);
    private final FloatEditor dimensionEditor = new FloatEditor(0.0f, 5000.0f);
    private final FloatEditor symbolSizeEditor = new FloatEditor(3.0f, 500.0f);
    private final FloatEditor longitudeEditor = new FloatEditor(-180.0f, 180.0f);
    private final FloatEditor latitudeEditor = new FloatEditor(-90.0f, 90.0f);
    private final FloatEditor scaleLimitEditor = new FloatEditor(false);
    private final CheckBoxEditor thicknessScalingEditor = new CheckBoxEditor();
    private final CheckBoxEditor showScaleBarEditor = new CheckBoxEditor();
    private final ScaleTypeEditor scaleTypeEditor = new ScaleTypeEditor(new JComboBox());
    private final IGDSchEditor lithostratSchEditor = new IGDSchEditor(this.sbdb, 2, true);
    private final ListEditor lithostratUnitEditor;
    private final CheckBoxEditor checkBoxEditor = new CheckBoxEditor();
    private final EnumEditor legendEditor = new EnumEditor(new JComboBox(), MapBlockProperties.LegendOrientation.class, null);
    private final InterpEditor interpEditor = new InterpEditor(this.sbdb);
    private final Frame parent;
    private MapBlock block;

    public MapBlockPropertiesTableModel(Frame parent, SBdb sbdb) {
        super(parent, sbdb);
        this.parent = parent;
        this.wellEditor = new ChartBlockWellEditor(parent, sbdb);
        this.wellEditor.allowNullValue(true);
        this.interpEditor.allowNullValue(false);
        this.captionEditor = new CaptionEditor(this.parent);
        this.lithostratUnitEditor = new ListEditor(this.parent, "Select Lithostratigraphy Unit", new IGDUnitListRenderer());
        this.initRows();
    }

    private void initRows() {
        this.rowMap.clear();
        this.rowMap.put(0, new BlockPropertyRowTitleTemplate("Map"));
        this.rowMap.put(1, new BlockPropertyRowWell(this.linkRenderer, this.linkEditor, this.buttonRenderer, this.wellEditor));
        this.rowMap.put(2, new BlockPropertyRowInterp(this.sbdb, this.linkRenderer, this.linkEditor, this.comboRenderer, this.interpEditor));
        this.rowMap.put(3, new BlockPropertyRowCaption(this.linkRenderer, this.linkEditor, this.captionRenderer, this.captionEditor));
        this.rowMap.put(4, new BlockPropertyRowCRS(this.linkRenderer, this.linkEditor, this.comboRenderer, this.crsEditor));
        this.rowMap.put(5, new BlockPropertyRowSymbolSize(this.linkRenderer, this.linkEditor, null, this.symbolSizeEditor));
        this.rowMap.put(6, new BlockPropertyRowEnableSymbolScalingWithThickness(this.linkRenderer, this.linkEditor, (TableCellRenderer)this.checkBoxRenderer, this.thicknessScalingEditor));
        this.rowMap.put(7, new BlockPropertyRowEnableShowScale(this.linkRenderer, this.linkEditor, (TableCellRenderer)this.checkBoxRenderer, this.showScaleBarEditor));
        this.rowMap.put(8, new BlockPropertyRowMapLegend(this.linkRenderer, this.linkEditor, this.comboRenderer, this.legendEditor));
        this.rowMap.put(9, new BlockPropertyRowMapFillLegend(this.linkRenderer, this.linkEditor, this.checkBoxRenderer, this.checkBoxEditor));
        this.rowMap.put(10, BlockPropertyRowTitle.innerTitleRow("Block Size (mm)"));
        this.rowMap.put(11, BlockPropertyRowMapDimension.widthRow(this.linkRenderer, this.linkEditor, null, this.dimensionEditor));
        this.rowMap.put(12, BlockPropertyRowMapDimension.heightRow(this.linkRenderer, this.linkEditor, null, this.dimensionEditor));
        this.rowMap.put(13, BlockPropertyRowTitle.innerTitleRow("Map Bounds"));
        this.rowMap.put(14, new BlockPropertyRowMapBounds(0, this.linkRenderer, this.linkEditor, null, this.longitudeEditor));
        this.rowMap.put(15, new BlockPropertyRowMapBounds(1, this.linkRenderer, this.linkEditor, null, this.longitudeEditor));
        this.rowMap.put(16, new BlockPropertyRowMapBounds(2, this.linkRenderer, this.linkEditor, null, this.latitudeEditor));
        this.rowMap.put(17, new BlockPropertyRowMapBounds(3, this.linkRenderer, this.linkEditor, null, this.latitudeEditor));
        this.rowMap.put(18, BlockPropertyRowTitle.innerTitleRow("Data Range"));
        this.rowMap.put(19, new BlockPropertyRowDataRangeStyle(this.comboRenderer, this.dataRangeStyleEditor));
        this.rowMap.put(20, new BlockPropertyRowScaleType(this.linkRenderer, this.linkEditor, this.comboRenderer, this.scaleTypeEditor, null));
        this.rowMap.put(21, new BlockPropertyRowMapScaleLimit(IBlockProperties.ScaleLimitType.MIN, this.scaleLimitEditor));
        this.rowMap.put(22, new BlockPropertyRowMapScaleLimit(IBlockProperties.ScaleLimitType.MAX, this.scaleLimitEditor));
        this.rowMap.put(23, new BlockPropertyRowLithostratScheme(this.comboRenderer, this.lithostratSchEditor));
        this.rowMap.put(24, BlockPropertyRowLithostratUnit.upperUnitRow(new ButtonRenderer(""), this.lithostratUnitEditor));
        this.rowMap.put(25, BlockPropertyRowLithostratUnit.lowerUnitRow(new ButtonRenderer(""), this.lithostratUnitEditor));
        this.rowMap.put(26, new BlockPropertyRowDataRangeExclude(this.linkRenderer, this.linkEditor, (TableCellRenderer)this.checkBoxRenderer, this.checkBoxEditor));
        this.rowMap.put(27, new BlockPropertyRowDeriveChronoAge(this.linkRenderer, this.linkEditor, (TableCellRenderer)this.checkBoxRenderer, this.checkBoxEditor));
    }

    public void setBlock(MapBlock block) {
        if (block == this.block) {
            return;
        }
        if (this.block != null) {
            this.block.deleteListener(this);
        }
        this.block = block;
        this.wellEditor.allowNullValue(BlockTypeHelper.canSetNullWells(block.getBlockType()));
        Project chartProject = this.getChartProject();
        this.rowMap.entrySet().forEach(e -> ((BlockPropertyRow)e.getValue()).init(block, this.getSelectedChart(), chartProject, this.getChartDefaultWellList()));
        this.lithostratSchEditor.fill(this.sbdb, block.getProp().getLithostratScheme());
        block.registerListener(this);
    }

    @Override
    protected TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            this.linkAction.setRow(row, this.linkEditor);
        }
        return ((BlockPropertyRow)this.rowMap.get(row)).getCellEditor(column);
    }

    @Override
    public int getRowCount() {
        return 28;
    }

    @Override
    protected boolean showRow(int row) {
        switch (row) {
            case 20: 
            case 21: 
            case 22: 
            case 27: {
                return this.block.getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.BOUNDARIES;
            }
            case 23: 
            case 24: 
            case 25: {
                return this.block.getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.LITHOSTRAT;
            }
            case 9: {
                return this.block.getProp().getLegendOrientation() != MapBlockProperties.LegendOrientation.NONE;
            }
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        super.setValueAt(value, row, column);
        if (row == 19) {
            this.fireTableStructureChanged();
        }
    }

    @Override
    BlockType getBlockType() {
        return this.block.getBlockType();
    }

    @Override
    public void onChartEvent(ChartEvent e) {
        if (e.getSource() == this.block) {
            this.fireTableDataChanged();
        }
    }
}

