/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jsbchart.block.BlockProperties;
import jsbchart.block.SchemeBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelAgeCurveProperties;
import jsbchart.panel.PanelEventsProperties;
import jsbchart.panel.PanelIntcomsProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelRangeProperties;
import jsbchart.panel.PanelScaleProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelWellVSProperties;
import jsbchart.panel.spatial.MapLabelAttribute;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.util.ImageFit;
import jsbchart.util.LogInfo;
import jsbchart.util.colour.ColourScale;
import jsbchart.util.colour.ColourSpectrum;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.chart.properties.PropertiesTableModel;
import jsbugs.table.AbledRenderer;
import jsbugs.table.AnalystRenderer;
import jsbugs.table.ButtonRenderer;
import jsbugs.table.ButtonRendererNoClear;
import jsbugs.table.CheckBoxRenderer;
import jsbugs.table.ColourButtonRenderer;
import jsbugs.table.ColourScaleRenderer;
import jsbugs.table.ColumnWidthRendererEditor;
import jsbugs.table.ComboRenderer;
import jsbugs.table.FileRenderer;
import jsbugs.table.HierarchyRenderer;
import jsbugs.table.LogDefRenderer;
import jsbugs.table.SpectrumRenderer;
import jsbugs.table.StandardRenderer;
import jsbugs.table.SynonymSchemeRenderer;
import jsbugs.table.TitleRenderer;
import model3.AgeCurve;
import model3.CompositeStandard;
import model3.DataType;
import model3.EnvScheme;
import model3.IGDColMap;
import model3.IGDScheme;
import model3.LogDef;
import model3.SBEvent;
import model3.SBdb;
import model3.SynonymScheme;
import model3.TxGroupSet;
import util.DepthUnits;

class PanelPropertiesTableModelBase
extends PropertiesTableModel {
    private final List<PanelTemplate> panelTemplates;
    private final HashMap<Class<?>, TableCellRenderer> renderers = new HashMap();
    private DefaultTableCellRenderer boldRenderer;
    private final TitleRenderer titleRenderer = new TitleRenderer(PropertiesTable.TITLE_COLOUR, Color.WHITE);

    PanelPropertiesTableModelBase(SBdb sbdb, List<PanelTemplate> panelTemplates) {
        super(sbdb);
        this.initRenderers();
        this.panelTemplates = panelTemplates;
        if (panelTemplates != null) {
            PanelType type = null;
            for (PanelTemplate templ : panelTemplates) {
                if (type == null) {
                    type = templ.getType();
                    continue;
                }
                if (type == templ.getType()) continue;
                throw new IllegalArgumentException("Mismatch in PanelProperties types");
            }
        }
    }

    private void initRenderers() {
        this.renderers.put(ChartProperties.FontSize.class, new ComboRenderer());
        this.renderers.put(Discipline[].class, new ButtonRendererNoClear());
        this.renderers.put(Category.class, new ButtonRendererNoClear(null));
        this.renderers.put(Userdef[].class, new AnalystRenderer());
        this.renderers.put(IGDScheme.class, new ComboRenderer("<none>"));
        this.renderers.put(IGDScheme[].class, new ButtonRenderer("<none>"));
        this.renderers.put(CompositeStandard.class, new ComboRenderer("<none>"));
        this.renderers.put(PanelProperties.ColumnWidth.class, new ColumnWidthRendererEditor());
        this.renderers.put(Color.class, new ColourButtonRenderer());
        this.renderers.put(Boolean.class, new CheckBoxRenderer());
        this.renderers.put(Discipline.class, new ComboRenderer("<all>"));
        this.renderers.put(CaptionTemplate.class, new ButtonRendererNoClear("<default>"));
        this.renderers.put(BlockProperties.ScaleType.class, new ComboRenderer());
        this.renderers.put(SchemeBlock.class, new ComboRenderer("<none>"));
        this.renderers.put(EnvScheme.class, new ComboRenderer("<none>"));
        this.renderers.put(SampleType.class, new ButtonRenderer("<all>"));
        this.renderers.put(SynonymScheme.class, new SynonymSchemeRenderer(this.sbdb));
        this.renderers.put(TxGroupSet.class, new ComboRenderer("<none>"));
        this.renderers.put(PanelWellVSProperties.EventLabelStyle.class, new ComboRenderer());
        this.renderers.put(PanelWellVSProperties.VSInterpretationType.class, new ComboRenderer());
        this.renderers.put(PanelEventsProperties.EventFilter.class, new ComboRenderer());
        this.renderers.put(IGDColMap.class, new HierarchyRenderer());
        this.renderers.put(PanelRangeProperties.RangeSort.class, new ComboRenderer());
        this.renderers.put(PanelRangeProperties.EventSelection.class, new ComboRenderer());
        this.renderers.put(AgeCurve.class, new ComboRenderer());
        this.renderers.put(ImageFit.class, new ComboRenderer());
        this.renderers.put(DepthUnits.class, new ComboRenderer());
        this.renderers.put(com.stratadata.util.depth.DepthUnits.class, new ComboRenderer());
        this.renderers.put(File.class, new FileRenderer());
        this.renderers.put(Integer[].class, new ButtonRenderer("<all>"));
        this.renderers.put(LogDef[].class, new ButtonRendererNoClear("<all available>"));
        this.renderers.put(LogDef.class, new LogDefRenderer());
        this.renderers.put(LogInfo.class, new ButtonRenderer(""));
        this.renderers.put(PanelScaleProperties.ScaleType.class, new ComboRenderer("Inherited"));
        this.renderers.put(Confidence.class, new ComboRenderer());
        this.renderers.put(ColourSpectrum.class, new SpectrumRenderer());
        this.renderers.put(ColourScale.class, new ColourScaleRenderer());
        this.renderers.put(PanelTaxonOcc.Filter.class, new ButtonRendererNoClear("<not restricted>"));
        this.renderers.put(BlockTemplate.CaptionOrientation.class, new ComboRenderer());
        this.renderers.put(PanelIntcomsProperties.TextAligmnet.class, new ComboRenderer());
        this.renderers.put(PanelAgeCurveProperties.Smoothing.class, new ComboRenderer());
        this.renderers.put(SBShapeStore.class, new ButtonRenderer("None selected"));
        this.renderers.put(MapLabelAttribute.class, new ButtonRenderer(""));
        this.renderers.put(Taxon.class, new ButtonRenderer("<select>"));
        this.renderers.put(SBEvent.class, new ButtonRenderer("<select>"));
        this.boldRenderer = new StandardRenderer(this){
            final /* synthetic */ PanelPropertiesTableModelBase this$0;
            {
                PanelPropertiesTableModelBase panelPropertiesTableModelBase = this$0;
                Objects.requireNonNull(panelPropertiesTableModelBase);
                this.this$0 = panelPropertiesTableModelBase;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setFont(c.getFont().deriveFont(1));
                return c;
            }
        };
    }

    public void setCellRenderer(Class<?> klass, TableCellRenderer renderer) {
        this.renderers.put(klass, renderer);
    }

    public PanelProperties getProperties(int n) {
        return this.panelTemplates.get(n).getProperties();
    }

    @Override
    protected TableCellRenderer getCellRenderer(int row, int column) {
        if (this.panelTemplates != null && row == 0 && column > 0) {
            return this.titleRenderer;
        }
        if (column == 0 && this.panelTemplates != null && !this.panelTemplates.isEmpty()) {
            Object value = null;
            for (int i = 0; i < this.panelTemplates.size(); ++i) {
                if (i == 0) {
                    value = this.getValueAt(row, 1);
                    continue;
                }
                if (Objects.equals(value, this.getValueAt(row, i + 1))) continue;
                return this.boldRenderer;
            }
            return null;
        }
        switch (row) {
            default: 
        }
        TableCellRenderer r = this.renderers.get(this.getCellClass(row, column));
        if (r != null && r instanceof ButtonRenderer) {
            ((ButtonRenderer)r).canClear(this.allowNull(row));
        }
        if (r != null && r instanceof AbledRenderer) {
            ((AbledRenderer)((Object)r)).setEnabled(this.isCellEditable(row, column));
        }
        if (r instanceof HierarchyRenderer && this.getProperties(column - 1).getDataType() != null) {
            ((HierarchyRenderer)r).setIGDType(DataType.getIGDType(this.getProperties(column - 1).getDataType()));
        }
        if (r instanceof ColourButtonRenderer && this.allowNull(row)) {
            ((ColourButtonRenderer)r).setNullString(this.getProperties(column - 1).getNullText(this.convertRowIndexToPanelProperties(row)));
        }
        return r;
    }

    public Class<?> getCellClass(int row, int col) {
        switch (col) {
            case 0: {
                return this.getColumnClass(col);
            }
        }
        if (row == 0 || this.isTitleRow(row) || this.getnTitleRow(row) > -1) {
            return String.class;
        }
        return this.getProperties(col - 1).getPropertyClass(this.convertRowIndexToPanelProperties(row));
    }

    @Override
    public int getRowCount() {
        if (this.panelTemplates.isEmpty()) {
            return 0;
        }
        return this.getProperties(0).getnProps() + 1;
    }

    @Override
    public int getColumnCount() {
        return this.panelTemplates.size() + 1;
    }

    private int getnTitleRow(int row) {
        if (row == 0) {
            return -1;
        }
        int[] titleRows = this.getProperties(0).getTitleRows();
        if (titleRows == null) {
            return -1;
        }
        for (int i = 0; i < titleRows.length; ++i) {
            if (row != titleRows[i]) continue;
            return i;
        }
        return -1;
    }

    int convertRowIndexToPanelProperties(int propRow) {
        --propRow;
        if (this.getProperties(0).getTitleRows() != null) {
            int nTitles = 0;
            for (int titleRow : this.getProperties(0).getTitleRows()) {
                if (titleRow > propRow) continue;
                ++nTitles;
            }
            return propRow - nTitles;
        }
        return propRow;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.panelTemplates.isEmpty()) {
            return null;
        }
        if (row == 0) {
            if (col > 0) {
                return this.panelTemplates.get(col - 1).getName();
            }
            return "";
        }
        int nTitleRow = this.getnTitleRow(row);
        if (nTitleRow > -1) {
            if (col == 0) {
                return this.getProperties(0).getTitleName(nTitleRow);
            }
            return null;
        }
        row = this.convertRowIndexToPanelProperties(row);
        switch (col) {
            case 0: {
                return this.getProperties(0).getPropertyName(row);
            }
        }
        return this.getProperties(col - 1).getProperty(row);
    }

    @Override
    protected boolean showRow(int row) {
        if (this.getnTitleRow(row) > -1) {
            return true;
        }
        boolean show = false;
        for (PanelTemplate panelTemplate : this.panelTemplates) {
            PanelProperties prop = panelTemplate.getProperties();
            show = show || prop.showRow(this.convertRowIndexToPanelProperties(row));
        }
        return show;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    protected boolean isTitleRow(int row) {
        return this.getnTitleRow(row) > -1;
    }

    @Override
    protected boolean isTitleInnerRow(int row) {
        return this.getnTitleRow(row) > -1;
    }

    @Override
    protected boolean isTitleButtonRow(int row) {
        return false;
    }

    @Override
    protected TableCellEditor getCellEditor(int row, int column) {
        return null;
    }

    @Override
    protected boolean allowNull(int row) {
        return this.getProperties(0).allowNull(this.convertRowIndexToPanelProperties(row));
    }
}

