/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties.taxon;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbugs.chart.properties.taxon.PanelTaxonGroupDisplay;
import jsbugs.chart.properties.taxon.PanelTaxonGroupDisplaySelectionListener;
import jsbugs.chart.properties.taxon.PanelTaxonGroupPropertiesRenderer;
import jsbugs.chart.properties.taxon.PanelTaxonPropertiesPanel;
import util.ColourUtils;

class JListPTG
extends JList
implements PanelTaxonGroupDisplay {
    private final PanelTaxonPropertiesPanel parent;
    private boolean isSettingList;

    JListPTG(PanelTaxonPropertiesPanel parent) {
        super(new DefaultListModel());
        this.parent = parent;
        this.setSelectionBackground(ColourUtils.getLighterColour((Color)this.getSelectionBackground(), (float)0.2f));
        this.setCellRenderer(new PanelTaxonGroupPropertiesRenderer(parent));
    }

    @Override
    public void clearData() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.clear();
    }

    @Override
    public void initData() {
        this.isSettingList = true;
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.clear();
        PanelTaxonGroupProperties ptgProp = this.parent.getPanelProperties();
        if (ptgProp == null) {
            return;
        }
        for (PanelTaxonOcc occ : ptgProp.getInnerPanels()) {
            model.addElement(occ);
        }
        this.isSettingList = false;
    }

    @Override
    public boolean isInitialising() {
        return this.isSettingList;
    }

    @Override
    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else if (anObject != this.getSelectedValue()) {
            ListModel dm = this.getModel();
            for (int i = 0; i < dm.getSize(); ++i) {
                if (anObject != dm.getElementAt(i)) continue;
                this.setSelectedIndex(i);
                if (shouldScroll) {
                    this.ensureIndexIsVisible(i);
                }
                this.repaint();
                return;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    @Override
    public void setSelectedValue(Object anObject) {
        this.setSelectedValue(anObject, true);
    }

    @Override
    public void setSelectedAtLocationOfEvent(MouseEvent evt) {
        this.setSelectedIndex(this.locationToIndex(evt.getPoint()));
    }

    @Override
    public PanelTaxonOcc getSelection() {
        return (PanelTaxonOcc)this.getSelectedValue();
    }

    @Override
    public void addSelectionListener(final PanelTaxonGroupDisplaySelectionListener listener) {
        this.addListSelectionListener(new ListSelectionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                listener.valueChanged();
            }
        });
    }

    @Override
    public void setSelection(PanelTaxonOcc selected) {
        if (selected != null) {
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                PanelTaxonOcc occ = (PanelTaxonOcc)this.getModel().getElementAt(i);
                if (occ != selected && !occ.wasCopiedFrom(selected) && !selected.wasCopiedFrom(occ)) continue;
                this.setSelectedIndex(i);
                break;
            }
        }
    }
}

