/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.properties.taxon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbugs.chart.properties.taxon.PanelTaxonPropertiesPanel;
import jsbugs.uiutil.icon.IconFactory;
import util.ColourUtils;

class PanelTaxonGroupPropertiesRenderer
extends JPanel
implements ListCellRenderer,
TreeCellRenderer {
    private static final Logger LOGGER = Logger.getLogger(PanelTaxonGroupPropertiesRenderer.class.getName());
    private final PanelTaxonPropertiesPanel outer;
    private final JLabel label = new JLabel();
    private final JButton linkButton = new JButton();
    private final JButton overplotButton = new JButton();
    private final Color treeBackgroundNonSelectionColour;
    private final Color treeBackgroundSelectionColour;

    PanelTaxonGroupPropertiesRenderer(PanelTaxonPropertiesPanel outer) {
        JButton[] buttons;
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        for (JButton button : buttons = new JButton[]{this.linkButton, this.overplotButton}) {
            button.setMaximumSize(new Dimension(20, 100));
            button.setMinimumSize(new Dimension(20, 100));
            button.setPreferredSize(new Dimension(20, 10));
            button.setContentAreaFilled(false);
            button.setBorderPainted(false);
        }
        this.overplotButton.setIcon(IconFactory.getIcon("/icon/panel/", "pt_overplot.png"));
        this.add(this.label);
        this.add(Box.createHorizontalGlue());
        this.add(this.linkButton);
        DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
        this.treeBackgroundNonSelectionColour = defaultRenderer.getBackgroundNonSelectionColor();
        this.treeBackgroundSelectionColour = ColourUtils.getLighterColour((Color)defaultRenderer.getBackgroundSelectionColor(), (float)0.2f);
        this.outer = outer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.initForValue(value);
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        return this;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.initForValue(value);
        this.setBackground(isSelected ? this.treeBackgroundSelectionColour : this.treeBackgroundNonSelectionColour);
        return this;
    }

    private void initForValue(Object node) {
        Object value = ((DefaultMutableTreeNode)node).getUserObject();
        if (value instanceof PanelTaxonGroupProperties) {
            this.label.setText("Outer panel");
            this.label.setIcon(null);
            this.remove(this.overplotButton);
            this.linkButton.setIcon(null);
            return;
        }
        if (value instanceof PanelTaxonOcc) {
            PanelTaxonOcc occ = (PanelTaxonOcc)value;
            PanelTaxonGroupProperties ptgProp = this.outer.getPanelProperties();
            if (this.label.getFont().getStyle() != 0) {
                this.label.setFont(this.getFont().deriveFont(0));
            }
            this.label.setText(ptgProp.getOccCaption(occ));
            this.label.setIcon(occ.isOverplot() ? null : occ.getIcon());
            this.linkButton.setIcon(!occ.isOverplot() && ptgProp.hasOtherPanelsLike(occ) && !PanelTaxonGroupProperties.isOverplotBase(ptgProp.getInnerPanels(), occ) ? (occ.isDefault() ? IconFactory.getLockedIcon() : IconFactory.getUnlockedIcon()) : null);
            if (occ.isOverplot()) {
                if (this.getComponent(0) != this.overplotButton) {
                    this.add((Component)this.overplotButton, 0);
                }
            } else {
                this.remove(this.overplotButton);
            }
        }
    }
}

