/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.spatial;

import com.stratadata.util.ui.DialogBase;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeDataStoreException;
import jsbchart.panel.spatial.ShapeDataStoreProvider;
import jsbchart.panel.spatial.ShapeStoreService;
import jsbugs.userconnect.SbugsSession;
import model3.Lastval;
import net.miginfocom.swing.MigLayout;
import org.geotools.api.data.DataStore;
import util.SbugsFileFilter;

public class DialogSBShapeStore
extends DialogBase
implements ActionListener {
    private final ShapeStoreService shapeStoreService;
    private SBShapeStore shapeStore;
    private JRadioButton jRadioButtonTypeWFS;
    private JRadioButton jRadioButtonTypeShapefile;
    private JCheckBox jCheckBoxLongitudeFirst;
    private JPanel jPanelCards;
    private JLabel jLabel2;
    private JTextField jTextFieldName;
    private JButton jButtonTest;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaTest;
    private JPanel jPanelWFS;
    private JLabel jLabel1;
    private JTextField jTextFieldWFSURL;
    private JPanel jPanelShapefile;
    private JButton jButtonShapefileImport;
    private JLabel jLabel3;
    private JTextField jTextFieldShapefilePath;
    private ButtonGroup buttonGroup1;

    public DialogSBShapeStore(Window parent, boolean modal, ShapeStoreService shapeStoreService, SBShapeStore shapeStore) {
        super(parent);
        this.initComponents();
        super.addOkButtonActionListener(this::jButtonOKActionPerformed);
        this.shapeStoreService = shapeStoreService;
        this.shapeStore = shapeStore;
        this.init();
    }

    public DialogSBShapeStore(Window parent, boolean modal, ShapeStoreService shapeStoreService) {
        this(parent, modal, shapeStoreService, null);
    }

    private void init() {
        this.setTitle("Shape Data Source" + (this.shapeStore != null ? " : Edit" : " : New"));
        this.jPanelCards.add(SBShapeStore.StoreType.WFS.name(), this.jPanelWFS);
        this.jPanelCards.add(SBShapeStore.StoreType.FILE.name(), this.jPanelShapefile);
        SBShapeStore.StoreType initialStoreType = this.shapeStore != null ? this.shapeStore.getStoreType() : SBShapeStore.StoreType.WFS;
        this.onShapeStoreTypeSelect(initialStoreType);
        if (this.shapeStore != null) {
            this.jRadioButtonTypeShapefile.setEnabled(false);
            this.jRadioButtonTypeWFS.setEnabled(false);
            this.jTextFieldShapefilePath.setEnabled(false);
            this.jButtonShapefileImport.setEnabled(false);
            this.jTextFieldWFSURL.setEnabled(false);
            this.jTextFieldName.setText(this.shapeStore.getName());
            this.jCheckBoxLongitudeFirst.setSelected(this.shapeStore.isLongitudeFirst());
            switch (this.shapeStore.getStoreType()) {
                case FILE: {
                    this.jRadioButtonTypeShapefile.setSelected(true);
                    this.jTextFieldShapefilePath.setText(this.shapeStore.getUrl());
                    break;
                }
                case WFS: {
                    this.jRadioButtonTypeWFS.setSelected(true);
                    this.jTextFieldWFSURL.setText(this.shapeStore.getUrl());
                }
            }
        }
        this.jRadioButtonTypeWFS.addActionListener(this);
        this.jRadioButtonTypeShapefile.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.onShapeStoreTypeSelect(SBShapeStore.StoreType.valueOf(e.getActionCommand()));
    }

    private void onShapeStoreTypeSelect(SBShapeStore.StoreType storeType) {
        this.jButtonTest.setEnabled(storeType == SBShapeStore.StoreType.WFS);
        this.selectCard(storeType);
    }

    private void jRadioButtonTypeWFSActionPerformed(ActionEvent e) {
    }

    private void jRadioButtonTypeShapefileActionPerformed(ActionEvent e) {
    }

    private void selectCard(SBShapeStore.StoreType storeType) {
        ((CardLayout)this.jPanelCards.getLayout()).show(this.jPanelCards, storeType.name());
    }

    private void initComponents() {
        JPanel jPanelType = new JPanel();
        this.jRadioButtonTypeWFS = new JRadioButton();
        this.jRadioButtonTypeShapefile = new JRadioButton();
        this.jCheckBoxLongitudeFirst = new JCheckBox();
        this.jPanelCards = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonTest = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaTest = new JTextArea();
        this.jPanelWFS = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldWFSURL = new JTextField();
        this.jPanelShapefile = new JPanel();
        this.jButtonShapefileImport = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldShapefilePath = new JTextField();
        this.buttonGroup1 = new ButtonGroup();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 350));
        this.setPreferredSize(new Dimension(400, 350));
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fill,insets dialog,hidemode 3,gap 5 5", "[fill][grow]", "[fill]rel[fill]rel[fill][fill]unrel[fill]rel[grow,fill]"));
        jPanelType.setBorder(new TitledBorder("Data source type"));
        jPanelType.setLayout((LayoutManager)new MigLayout("insets panel,hidemode 3,gap 3 3", "[fill][fill]", "[fill]"));
        this.jRadioButtonTypeWFS.setActionCommand(SBShapeStore.StoreType.WFS.name());
        this.jRadioButtonTypeWFS.setSelected(true);
        this.jRadioButtonTypeWFS.setText("URL (web feature source)");
        this.jRadioButtonTypeWFS.addActionListener(e -> this.jRadioButtonTypeWFSActionPerformed(e));
        jPanelType.add((Component)this.jRadioButtonTypeWFS, "cell 0 0");
        this.jRadioButtonTypeShapefile.setActionCommand(SBShapeStore.StoreType.FILE.name());
        this.jRadioButtonTypeShapefile.setText("Shapefile");
        this.jRadioButtonTypeShapefile.addActionListener(e -> this.jRadioButtonTypeShapefileActionPerformed(e));
        jPanelType.add((Component)this.jRadioButtonTypeShapefile, "cell 1 0");
        contentPanel.add((Component)jPanelType, "cell 0 1 2 1");
        this.jCheckBoxLongitudeFirst.setSelected(true);
        this.jCheckBoxLongitudeFirst.setText("Coordinates are longitude first");
        contentPanel.add((Component)this.jCheckBoxLongitudeFirst, "cell 0 3 2 1");
        this.jPanelCards.setLayout(new CardLayout());
        contentPanel.add((Component)this.jPanelCards, "cell 0 2 2 1");
        this.jLabel2.setText("Name:");
        contentPanel.add((Component)this.jLabel2, "cell 0 0");
        contentPanel.add((Component)this.jTextFieldName, "cell 1 0, growx");
        this.jButtonTest.setText("Test connection");
        this.jButtonTest.addActionListener(e -> this.jButtonTestActionPerformed(e));
        contentPanel.add((Component)this.jButtonTest, "cell 0 4 2 1,width 180:180:180");
        this.jTextAreaTest.setEditable(false);
        this.jTextAreaTest.setColumns(20);
        this.jTextAreaTest.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaTest);
        contentPanel.add((Component)this.jScrollPane1, "cell 0 5 2 1");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.jPanelWFS.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3,gap 3 3", "[fill][grow]", "[fill]"));
        this.jLabel1.setText("URL:");
        this.jPanelWFS.add((Component)this.jLabel1, "cell 0 0");
        this.jPanelWFS.add((Component)this.jTextFieldWFSURL, "cell 1 0, growx");
        this.jPanelShapefile.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 3,gap 3 3", "[fill][grow][fill]", "[fill]"));
        this.jButtonShapefileImport.setText("...");
        this.jButtonShapefileImport.addActionListener(e -> this.jButtonShapefileImportActionPerformed(e));
        this.jPanelShapefile.add((Component)this.jButtonShapefileImport, "cell 2 0");
        this.jLabel3.setText("File:");
        this.jPanelShapefile.add((Component)this.jLabel3, "cell 0 0");
        this.jTextFieldShapefilePath.setEditable(false);
        this.jTextFieldShapefilePath.setToolTipText("Choose the .shp file. This file and required associated files will be stored to your database.");
        this.jPanelShapefile.add((Component)this.jTextFieldShapefilePath, "cell 1 0, growx");
        this.buttonGroup1.add(this.jRadioButtonTypeWFS);
        this.buttonGroup1.add(this.jRadioButtonTypeShapefile);
    }

    private SBShapeStore createShapeStoreFromFieldValues(boolean blockEmptyName) {
        String URL2;
        String name = this.jTextFieldName.getText().trim();
        if (blockEmptyName && name.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a name for this shape data source", this.getTitle(), 0);
            return null;
        }
        SBShapeStore.StoreType type = SBShapeStore.StoreType.valueOf(this.buttonGroup1.getSelection().getActionCommand());
        boolean longitudeFirst = this.jCheckBoxLongitudeFirst.isSelected();
        switch (type) {
            case WFS: {
                URL2 = this.jTextFieldWFSURL.getText().trim();
                if (!URL2.isEmpty()) break;
                JOptionPane.showMessageDialog((Component)((Object)this), "Please enter the data source URL, e.g. \"https://example.com/mapserver\"", this.getTitle(), 0);
                return null;
            }
            case FILE: {
                URL2 = this.jTextFieldShapefilePath.getText();
                if (!URL2.isEmpty()) break;
                JOptionPane.showMessageDialog((Component)((Object)this), "Please choose a shapefile to import", this.getTitle(), 0);
                return null;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return SBShapeStore.createShapeStore(type, name, URL2, longitudeFirst);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        SBShapeStore ss = this.createShapeStoreFromFieldValues(true);
        if (ss == null) {
            return;
        }
        this.shapeStore = this.shapeStore == null ? this.shapeStoreService.storeShapeStore(ss) : this.shapeStoreService.updateShapeStore(this.shapeStore, ss);
        super.returnWithCode(DialogBase.ReturnCode.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonTestActionPerformed(ActionEvent evt) {
        this.jTextAreaTest.setText("");
        SBShapeStore ss = this.createShapeStoreFromFieldValues(false);
        if (ss == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Color textColor = new Color(33, 182, 168);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DataStore dataStore = ShapeDataStoreProvider.testDataStore(ss);
            sb.append("Connection successful.\n");
            try {
                String[] typeNames = dataStore.getTypeNames();
                sb.append("Source has ").append(typeNames.length).append(" feature types.");
            }
            catch (IOException ioe) {
                sb.append("Error reading data source:");
                sb.append(ioe.getMessage());
                ioe.printStackTrace();
                textColor = Color.RED;
            }
            dataStore.dispose();
        }
        catch (ShapeDataStoreException ex) {
            sb.append("Connection failed.");
            sb.append("\n\n");
            sb.append(ex.getMessage());
            if (ex.getCause() != null) {
                sb.append("\nCaused by: ").append(ex.getCause().toString());
            }
            ex.printStackTrace();
            textColor = Color.RED;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.jTextAreaTest.setText(sb.toString());
        this.jTextAreaTest.setForeground(textColor);
    }

    private void jButtonShapefileImportActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(SbugsSession.getDb(), "SHPFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("shp");
        jFileChooser.setFileFilter((FileFilter)filter);
        jFileChooser.setMultiSelectionEnabled(false);
        if (jFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            String filePath = file.getPath();
            this.jTextFieldShapefilePath.setText(filePath);
            try {
                Lastval.putString(SbugsSession.getDb(), "SHPFILE", filePath);
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
        }
    }

    public SBShapeStore getShapeStore() {
        return this.shapeStore;
    }
}

