/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.spatial;

import com.stratadata.util.delete.RelatedRecordException;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeStoreService;
import jsbugs.chart.spatial.DialogSBShapeStore;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.RelatedRecordExceptionHandler;
import util.SB;

public class DialogSBShapeStores
extends SBDialog {
    private static final String[] COL_TITLES = new String[]{"Name", "Type", "URL"};
    private static final int[] COL_WIDTHS = new int[]{40, 20, 250};
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_URL = 2;
    private final ShapeStoreService service;
    private final TableModelShapeStores model = new TableModelShapeStores(this);
    private List<SBShapeStore> shapeStores;
    private SBShapeStore selectedShapeStore;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonNew;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public DialogSBShapeStores(Frame parent, boolean modal, ShapeStoreService service) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.service = service;
        this.init();
    }

    private void init() throws SQLException {
        block2: {
            this.setTitle("Shape Data Sources");
            this.getRootPane().setDefaultButton(this.jButtonOK);
            try {
                this.shapeStores = this.service.getAllShapeStores();
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof SQLException)) break block2;
                throw (SQLException)e.getCause();
            }
        }
        this.model.setupTable(this.jTable1);
        this.jTable1.setRowSorter(new TableRowSorter<TableModelShapeStores>(this.model));
        new ColumnSortResetHandler(this.jTable1).attach();
        this.model.fireTableDataChanged();
    }

    public void loadOnlyFILEShapeStores() throws SQLException {
        block2: {
            try {
                this.shapeStores = this.service.getAllShapeStores().stream().filter(s -> s.getStoreType() == SBShapeStore.StoreType.FILE).toList();
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof SQLException)) break block2;
                throw (SQLException)e.getCause();
            }
        }
        this.model.fireTableDataChanged();
    }

    public void hideNewEditDeleteButtons() {
        this.jButtonDelete.setVisible(false);
        this.jButtonEdit.setVisible(false);
        this.jButtonNew.setVisible(false);
    }

    private SBShapeStore getSelectedShapeStore() {
        int selectedRow = this.jTable1.getSelectedRow();
        if (selectedRow < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a row", this.getTitle(), 2);
            return null;
        }
        return this.shapeStores.get(this.jTable1.convertRowIndexToModel(selectedRow));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButtonNew = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTable1.setModel(this.model);
        this.jTable1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButtonNew.setText("New...");
        this.jButtonNew.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBShapeStores this$0;
            {
                DialogSBShapeStores dialogSBShapeStores = this$0;
                Objects.requireNonNull(dialogSBShapeStores);
                this.this$0 = dialogSBShapeStores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBShapeStores this$0;
            {
                DialogSBShapeStores dialogSBShapeStores = this$0;
                Objects.requireNonNull(dialogSBShapeStores);
                this.this$0 = dialogSBShapeStores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBShapeStores this$0;
            {
                DialogSBShapeStores dialogSBShapeStores = this$0;
                Objects.requireNonNull(dialogSBShapeStores);
                this.this$0 = dialogSBShapeStores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBShapeStores this$0;
            {
                DialogSBShapeStores dialogSBShapeStores = this$0;
                Objects.requireNonNull(dialogSBShapeStores);
                this.this$0 = dialogSBShapeStores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBShapeStores this$0;
            {
                DialogSBShapeStores dialogSBShapeStores = this$0;
                Objects.requireNonNull(dialogSBShapeStores);
                this.this$0 = dialogSBShapeStores;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 523, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonNew, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 147, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(0, 0, 0))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        SBShapeStore shapeStore = this.getSelectedShapeStore();
        if (shapeStore == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to delete this shape data source?", "Delete Data Source", 0);
        if (opt != 0) {
            return;
        }
        try {
            this.service.deleteShapeStore(shapeStore);
        }
        catch (RelatedRecordException rre) {
            RelatedRecordExceptionHandler.handle(rre, (Component)((Object)this), "shape data source");
            return;
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e);
        }
        this.refreshTable();
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        DialogSBShapeStore dialogShapeStore = new DialogSBShapeStore((Window)((Object)this), true, this.service);
        dialogShapeStore.setLocationRelativeTo((Component)((Object)this));
        dialogShapeStore.setVisible(true);
        if (dialogShapeStore.isOK()) {
            this.refreshTable();
            int index = this.jTable1.convertRowIndexToView(this.shapeStores.indexOf(dialogShapeStore.getShapeStore()));
            this.jTable1.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selectedShapeStore = this.getSelectedShapeStore();
        if (this.selectedShapeStore == null) {
            return;
        }
        this.setOK();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        SBShapeStore selection = this.getSelectedShapeStore();
        if (selection == null) {
            return;
        }
        DialogSBShapeStore dialog = new DialogSBShapeStore((Window)((Object)this), true, this.service, selection);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.refreshTable();
            int index = this.jTable1.convertRowIndexToView(this.shapeStores.indexOf(dialog.getShapeStore()));
            this.jTable1.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    private void refreshTable() {
        this.shapeStores = this.service.getAllShapeStores();
        this.model.fireTableDataChanged();
    }

    public SBShapeStore getSelected() {
        return this.selectedShapeStore;
    }

    private class TableModelShapeStores
    extends AbstractTableModel {
        final /* synthetic */ DialogSBShapeStores this$0;

        private TableModelShapeStores(DialogSBShapeStores dialogSBShapeStores) {
            DialogSBShapeStores dialogSBShapeStores2 = dialogSBShapeStores;
            Objects.requireNonNull(dialogSBShapeStores2);
            this.this$0 = dialogSBShapeStores2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.shapeStores == null) {
                return 0;
            }
            return this.this$0.shapeStores.size();
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SBShapeStore shapeStore = this.this$0.shapeStores.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return shapeStore.getName();
                }
                case 1: {
                    return shapeStore.getStoreType();
                }
                case 2: {
                    return shapeStore.getUrl();
                }
            }
            return null;
        }

        void setupTable(JTable jTable) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < COL_TITLES.length; ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(COL_TITLES[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(COL_WIDTHS[i]);
            }
        }
    }
}

