/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.spatial;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jsbchart.graphics.FillType;
import jsbchart.graphics.text.MapFill;
import jsbchart.panel.spatial.CategoryFillEntry;
import jsbchart.panel.spatial.CategoryFillList;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeDataStoreException;
import jsbchart.panel.spatial.ShapeDataStoreProvider;
import jsbugs.table.MapFillButtonEditor;
import jsbugs.table.MapFillButtonRenderer;
import jsbugs.uiutil.ComboboxItem;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import util.SB;

public class DialogShapeFill
extends SBDialog {
    private SBShapeStore store = null;
    private HashMap<String, TreeSet<Object>> propValuesHash = null;
    private JComboBox<ComboboxItem<String>> propertyComboBox;
    private DefaultComboBoxModel<ComboboxItem<String>> propertyComboBoxModel;
    private JTable table;
    private MatchTableModel tableModel;

    public DialogShapeFill(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.init();
    }

    private void init() {
        this.setTitle("Category fill");
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel();
        JLabel label = new JLabel("Property Name:");
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        labelPanel.add(label);
        topPanel.add((Component)labelPanel, "West");
        topPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.propertyComboBox = new JComboBox();
        this.propertyComboBoxModel = new DefaultComboBoxModel();
        this.propertyComboBox.setModel(this.propertyComboBoxModel);
        this.propertyComboBox.addActionListener(e -> this.onPropertyComboBoxSelect());
        topPanel.add(this.propertyComboBox, "Center");
        this.add(topPanel, "North");
        JScrollPane jsp = new JScrollPane();
        jsp.setBorder(new EmptyBorder(0, 4, 0, 4));
        this.table = new JTable();
        SB.setTableHeaderBold((JTable)this.table);
        this.tableModel = new MatchTableModel(this);
        this.table.setModel(this.tableModel);
        this.table.setRowSorter(new TableRowSorter<MatchTableModel>(this.tableModel));
        this.table.setDefaultRenderer(MapFill.class, new MapFillButtonRenderer());
        TableColumn fillColumn = this.table.getColumnModel().getColumn(0);
        fillColumn.setCellEditor(new MapFillButtonEditor());
        this.table.setSelectionMode(1);
        this.table.setRowSelectionAllowed(true);
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.setRowHeight(48);
        this.add(this.table, "Center");
        new ColumnSortResetHandler(this.table).attach();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        buttonPanel.setLayout(new FlowLayout(0));
        BoxLayout bl = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(bl);
        JButton addButton = new JButton("Add");
        addButton.addActionListener(e -> this.onAddButtonPress());
        buttonPanel.add(addButton);
        JButton removeButton = new JButton("Remove");
        removeButton.addActionListener(e -> this.onRemoveButtonPress());
        buttonPanel.add(removeButton);
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.onOKPress());
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.onCancelPress());
        buttonPanel.add(cancelButton);
        jsp.setViewportView(this.table);
        this.add(jsp, "Center");
        this.add(buttonPanel, "South");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    public CategoryFillList getCategoryList() {
        return this.tableModel.getFillList();
    }

    private void onAddButtonPress() {
        String value;
        if (this.getSelectedProperty() == null) {
            return;
        }
        if (this.tableModel.getFillList() == null) {
            this.tableModel.setFillList(new CategoryFillList(this.getSelectedProperty()));
        }
        if ((value = this.findFirstUnusedValue()) != null) {
            MapFill f = new MapFill(FillType.SOLID, Color.RED, 10.0f, 1.0f, Color.black, 0.5f, Color.RED, 0.5f, Color.black);
            this.tableModel.getFillList().addEntry(new CategoryFillEntry(value, f));
            this.tableModel.fireTableDataChanged();
        }
    }

    private String findFirstUnusedValue() {
        ArrayList<String> usedValues = new ArrayList<String>();
        if (this.tableModel.getFillList() != null) {
            for (int i = 0; i < this.tableModel.getFillList().getSize(); ++i) {
                usedValues.add(this.tableModel.getFillList().getEntry(i).getValue());
            }
        }
        Set values = this.propValuesHash.get(this.getSelectedProperty());
        for (Object value : values) {
            String v = value.toString();
            if (usedValues.contains(v)) continue;
            return v;
        }
        return null;
    }

    private void onRemoveButtonPress() {
        if (this.tableModel.getFillList() != null) {
            ArrayList<CategoryFillEntry> toRemove = new ArrayList<CategoryFillEntry>();
            for (int i : this.table.getSelectedRows()) {
                int rowNum = this.table.convertRowIndexToModel(i);
                if (rowNum >= this.tableModel.getFillList().getSize()) continue;
                toRemove.add(this.tableModel.getFillList().getEntry(rowNum));
            }
            Object object = toRemove.iterator();
            while (object.hasNext()) {
                CategoryFillEntry entry = (CategoryFillEntry)object.next();
                this.tableModel.getFillList().removeEntry(entry);
            }
            this.tableModel.fireTableDataChanged();
        }
    }

    private void onPropertyComboBoxSelect() {
        if (this.propertyComboBoxModel.getSelectedItem() != null) {
            this.updateValueEditor();
        }
    }

    private void updateValueEditor() {
        if (this.getSelectedProperty() != null && this.propValuesHash.keySet().contains(this.getSelectedProperty())) {
            Set values = this.propValuesHash.get(this.getSelectedProperty());
            TableColumn valueColumn = this.table.getColumnModel().getColumn(1);
            String[] items = (String[])values.stream().map(v -> v.toString()).sorted().toArray(String[]::new);
            JComboBox<String> comboBox1 = new JComboBox<String>(items);
            DefaultCellEditor dce1 = new DefaultCellEditor(comboBox1);
            valueColumn.setCellEditor(dce1);
        }
    }

    private String getSelectedProperty() {
        if (this.propertyComboBox.getSelectedItem() == null) {
            return null;
        }
        ComboboxItem item = (ComboboxItem)this.propertyComboBox.getSelectedItem();
        return (String)item.getValue();
    }

    private void onOKPress() {
        boolean isValid = this.validateInputs();
        if (isValid) {
            this.setIsOK(true);
            this.setVisible(false);
        }
    }

    private boolean validateInputs() {
        if (this.tableModel.getFillList() == null) {
            return true;
        }
        List<String> duplicates = this.tableModel.getFillList().findDuplicateEntryValues();
        if (duplicates.isEmpty()) {
            return true;
        }
        String message = "Duplicate fill selections found for values " + String.join((CharSequence)",", duplicates) + ". Please remove duplicate values.";
        JOptionPane.showMessageDialog(null, message, "Validation error", 2);
        return false;
    }

    private void onCancelPress() {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(2);
        buttonPanel.setLayout(fl);
        JButton okJButton = new JButton("OK");
        okJButton.addActionListener(e -> this.onOKPress());
        JButton cancelJButton = new JButton("Cancel");
        cancelJButton.addActionListener(e -> this.onCancelPress());
        buttonPanel.add(okJButton);
        buttonPanel.add(cancelJButton);
        return buttonPanel;
    }

    public void setShapeStore(SBShapeStore shapeStore) throws ShapeDataStoreException {
        this.store = shapeStore;
        DataStore store = ShapeDataStoreProvider.getDataStore(shapeStore);
        String featureTypeName = null;
        try {
            featureTypeName = store.getTypeNames()[0];
            SimpleFeatureSource featureSource = store.getFeatureSource(featureTypeName);
            HashMap values = new HashMap();
            SimpleFeatureIterator iterator = featureSource.getFeatures().features();
            while (iterator.hasNext()) {
                SimpleFeature sf = (SimpleFeature)iterator.next();
                assert (featureTypeName.equals(sf.getFeatureType().getTypeName()));
                for (Property p : sf.getProperties()) {
                    Object att = sf.getAttribute(p.getName());
                    if (this.isGeometryType(att)) continue;
                    String propName = p.getName().getLocalPart();
                    if (!values.keySet().contains(propName)) {
                        values.put(propName, new TreeSet());
                    }
                    ((TreeSet)values.get(propName)).add(sf.getAttribute(propName));
                }
            }
            this.propValuesHash = values;
            this.updatePropertyCombo();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isGeometryType(Object obj) {
        Class<?> klass = obj.getClass();
        return Polygon.class.isAssignableFrom(klass) || MultiPolygon.class.isAssignableFrom(klass) || LineString.class.isAssignableFrom(klass) || MultiLineString.class.isAssignableFrom(klass) || Point.class.isAssignableFrom(klass) || MultiPoint.class.isAssignableFrom(klass);
    }

    private void updatePropertyCombo() {
        this.propertyComboBoxModel.removeAllElements();
        if (this.propValuesHash != null) {
            String[] keys;
            this.propertyComboBoxModel.addElement(new ComboboxItem<Object>(null, "<Select Property>"));
            for (String key : keys = (String[])this.propValuesHash.keySet().stream().sorted().toArray(String[]::new)) {
                this.propertyComboBoxModel.addElement(new ComboboxItem<String>(key, key));
            }
            this.propertyComboBoxModel.setSelectedItem(null);
        }
    }

    private class MatchTableModel
    extends AbstractTableModel {
        private CategoryFillList fillList;
        private String[] columnNames;
        private Class[] columnClasses;
        final /* synthetic */ DialogShapeFill this$0;

        private MatchTableModel(DialogShapeFill dialogShapeFill) {
            DialogShapeFill dialogShapeFill2 = dialogShapeFill;
            Objects.requireNonNull(dialogShapeFill2);
            this.this$0 = dialogShapeFill2;
            this.fillList = null;
            this.columnNames = new String[]{"Fill", "Value"};
            this.columnClasses = new Class[]{MapFill.class, String.class};
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.fillList == null) {
                return 0;
            }
            return this.fillList.getSize();
        }

        public void setFillList(CategoryFillList list) {
            this.fillList = list;
        }

        public CategoryFillList getFillList() {
            return this.fillList;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object value = null;
            if (this.fillList != null && row < this.fillList.getSize()) {
                CategoryFillEntry e = this.fillList.getEntry(row);
                value = col == 0 ? e.getFill() : e.getValue();
            }
            return value;
        }

        public Class getColumnClass(int c) {
            return this.columnClasses[c];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.fillList != null && row < this.fillList.getSize()) {
                CategoryFillEntry e = this.fillList.getEntry(row);
                if (col == 0) {
                    e.setFill((MapFill)value);
                } else {
                    e.setValue((String)value);
                }
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

