/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.tag;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.tag.ChartTag;
import jsbugs.ChartJPanel;
import jsbugs.chart.mouse.MouseBehaviourAdapter;

public class ChartTagTargetBehaviour
extends MouseBehaviourAdapter {
    private boolean isCurrent = false;
    private boolean targetHasMoved = false;

    public ChartTagTargetBehaviour(ChartJPanel panel) {
        super(panel);
    }

    @Override
    public boolean isCurrent() {
        return this.isCurrent;
    }

    @Override
    public boolean isActiveForSelection(Object selection) {
        return selection instanceof ChartTag;
    }

    @Override
    public Cursor getCursor(Point p) {
        return new Cursor(13);
    }

    @Override
    public boolean activeAt(Point pixelPoint) {
        Point2D.Float p = this.panel.getPoint(pixelPoint);
        return this.intersectsSelectedTagTargetArea(p);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        if (this.intersectsSelectedTagTargetArea(p)) {
            this.getSelectedTag().setTarget(p);
            this.getSelectedTag().setActive(true);
            this.targetHasMoved = false;
        }
        this.isCurrent = true;
        this.panel.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        ChartTag t = this.getSelectedTag();
        if (t != null) {
            if (t.contains(p)) {
                t.setTarget(null);
                this.targetHasMoved = true;
            }
            t.setActive(false);
            if (this.targetHasMoved) {
                ChartBlockBase anchor = t.getAnchorBlock();
                if (anchor != null && anchor instanceof MapBlock) {
                    t.setAnchorBlock(null);
                }
                this.notifyChartChange();
            }
        }
        this.isCurrent = false;
        this.panel.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point2D.Float p = this.panel.getPoint(e.getPoint());
        ChartTag t = this.getActiveTag();
        if (t != null) {
            t.setTarget(p);
            ChartBlockBase anchor = t.getAnchorBlock();
            if (anchor != null && anchor instanceof MapBlock) {
                t.setAnchorBlock(null);
            }
            this.targetHasMoved = true;
        }
        this.panel.repaint();
    }

    private boolean intersectsSelectedTagTargetArea(Point2D.Float p) {
        ChartTag t = this.getSelectedTag();
        if (t != null && t.getTarget() != null) {
            return t.getTargetArea().contains(p);
        }
        return false;
    }

    private ChartTag getSelectedTag() {
        for (ChartTag t : this.panel.chart.getTags()) {
            if (!t.isSelected()) continue;
            return t;
        }
        return null;
    }

    private ChartTag getActiveTag() {
        for (ChartTag t : this.panel.chart.getTags()) {
            if (!t.isActive()) continue;
            return t;
        }
        return null;
    }
}

