/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chart.tag;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import jsbchart.core.Chart;
import jsbchart.listener.ChartEvent;
import jsbchart.tag.ChartTag;
import jsbugs.FrameChart;
import jsbugs.chart.properties.PropertiesTable;
import jsbugs.chart.tag.ChartTagPropertiesTableModel;
import jsbugs.uiutil.LimitedLengthDocument;

public class DialogChartTagList
extends SBDialog {
    private final DefaultListModel tagListModel = new DefaultListModel();
    private final ChartTagPropertiesTableModel tagTableModel;
    private final FrameChart parent;
    private final Chart chart;
    private JScrollPane spText;
    private JButton jButtonClose;
    private JButton jButtonHelp;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonRemove;
    private JButton jButtonResetPosition;
    private JLabel jLabelAnchor;
    private JLabel jLabelLocation;
    private JLabel jLabelSize;
    private JList<ChartTag> jListTags;
    private JPanel jPanel1;
    private JPanel jPanelTagSize;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTextArea jTextAreaAnnotationText;

    public DialogChartTagList(FrameChart parent, boolean modal, Chart chart) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.chart = chart;
        this.tagTableModel = new ChartTagPropertiesTableModel(parent, null);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Chart Annotations : " + this.chart.getTemplate().getName());
        this.updateAnnotationList();
        this.jPanel1.add(this.jPanelTagSize);
        this.jPanel1.add(Box.createVerticalStrut(5));
        this.spText = new JScrollPane(this.jTextAreaAnnotationText);
        this.spText.setPreferredSize(new Dimension(100, 100));
        this.spText.setVerticalScrollBarPolicy(22);
        this.jPanel1.add(this.spText);
        this.jPanel1.add(Box.createVerticalStrut(5));
        PropertiesTable table = new PropertiesTable();
        this.tagTableModel.setDialogMode();
        table.setModel(this.tagTableModel);
        JScrollPane spTable = new JScrollPane(table);
        this.jPanel1.add(spTable);
        this.jListTags.setCellRenderer(new ChartTagListRenderer());
        this.jListTags.addListSelectionListener(e -> this.onListSelectionChanged());
        this.jTextAreaAnnotationText.setDocument(new LimitedLengthDocument(1400));
        this.jTextAreaAnnotationText.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ DialogChartTagList this$0;
            {
                DialogChartTagList dialogChartTagList = this$0;
                Objects.requireNonNull(dialogChartTagList);
                this.this$0 = dialogChartTagList;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSelectedTag();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSelectedTag();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSelectedTag();
            }

            private void updateSelectedTag() {
                this.this$0.spText.revalidate();
                ChartTag tag = this.this$0.jListTags.getSelectedValue();
                if (tag != null) {
                    String text = this.this$0.jTextAreaAnnotationText.getText().trim();
                    tag.setText(text);
                    this.this$0.parent.fireChartMightHaveChanged();
                } else {
                    this.this$0.jTextAreaAnnotationText.setText("");
                }
                this.this$0.jListTags.repaint();
            }
        });
        if (this.tagListModel.getSize() > 0) {
            this.jListTags.setSelectedIndex(0);
        }
    }

    public void updateAnnotationList() {
        this.tagListModel.clear();
        if (this.chart == null) {
            return;
        }
        this.tagListModel.addAll(this.chart.getTags().stream().sorted(Comparator.comparing(ChartTag::getOrder)).toList());
    }

    private void onListSelectionChanged() {
        ChartTag tag = this.jListTags.getSelectedValue();
        if (tag != null) {
            this.jTextAreaAnnotationText.setText(tag.getText());
            this.jLabelLocation.setText("Location: x=" + Math.round(tag.getArea().x) + ", y=" + Math.round(tag.getArea().y));
            this.jLabelSize.setText("Size: w=" + Math.round(tag.getArea().width) + ", h=" + Math.round(tag.getArea().height));
            if (tag.getAnchorBlock() == null) {
                this.jLabelAnchor.setText("Anchor: not achored");
            } else {
                this.jLabelAnchor.setText("Anchor: " + tag.getAnchorBlock().toString());
            }
            this.tagTableModel.setTag(tag);
        } else {
            this.jTextAreaAnnotationText.setText("");
            this.jLabelLocation.setText("");
            this.jLabelSize.setText("");
            this.jLabelAnchor.setText("");
        }
        this.tagTableModel.fireTableDataChanged();
    }

    private void updateTagOrder() {
        for (int i = 0; i < this.tagListModel.getSize(); ++i) {
            ChartTag t = (ChartTag)((Object)this.tagListModel.get(i));
            t.setOrder(i);
        }
        this.parent.fireChartMightHaveChanged();
    }

    private void initComponents() {
        this.jPanelTagSize = new JPanel();
        this.jLabelSize = new JLabel();
        this.jLabelLocation = new JLabel();
        this.jLabelAnchor = new JLabel();
        this.jTextAreaAnnotationText = new JTextArea();
        this.jButtonClose = new JButton();
        this.jButtonRemove = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jListTags = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonResetPosition = new JButton();
        this.jPanelTagSize.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.jLabelSize.setForeground(new Color(153, 153, 153));
        this.jLabelSize.setText("Size:");
        this.jLabelLocation.setForeground(new Color(153, 153, 153));
        this.jLabelLocation.setHorizontalAlignment(2);
        this.jLabelLocation.setText("Location:");
        this.jLabelLocation.setMaximumSize(new Dimension(1000, 16));
        this.jLabelAnchor.setForeground(new Color(153, 153, 153));
        this.jLabelAnchor.setHorizontalAlignment(2);
        this.jLabelAnchor.setText("Anchor:");
        GroupLayout jPanelTagSizeLayout = new GroupLayout(this.jPanelTagSize);
        this.jPanelTagSize.setLayout(jPanelTagSizeLayout);
        jPanelTagSizeLayout.setHorizontalGroup(jPanelTagSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTagSizeLayout.createSequentialGroup().addGroup(jPanelTagSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSize).addComponent(this.jLabelLocation, -2, 209, -2).addComponent(this.jLabelAnchor)).addGap(0, 12, Short.MAX_VALUE)));
        jPanelTagSizeLayout.setVerticalGroup(jPanelTagSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTagSizeLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelLocation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabelAnchor).addContainerGap()));
        this.jTextAreaAnnotationText.setLineWrap(true);
        this.jTextAreaAnnotationText.setWrapStyleWord(true);
        this.setDefaultCloseOperation(2);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTagList this$0;
            {
                DialogChartTagList dialogChartTagList = this$0;
                Objects.requireNonNull(dialogChartTagList);
                this.this$0 = dialogChartTagList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.setToolTipText("Remove the selected annotation");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTagList this$0;
            {
                DialogChartTagList dialogChartTagList = this$0;
                Objects.requireNonNull(dialogChartTagList);
                this.this$0 = dialogChartTagList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setDividerSize(10);
        ((BasicSplitPaneUI)this.jSplitPane1.getUI()).getDivider().setBorder(null);
        this.jListTags.setModel(this.tagListModel);
        this.jListTags.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListTags);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.jButtonMoveUp.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/arrow_up.gif")));
        this.jButtonMoveUp.setToolTipText("Move up");
        this.jButtonMoveUp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTagList this$0;
            {
                DialogChartTagList dialogChartTagList = this$0;
                Objects.requireNonNull(dialogChartTagList);
                this.this$0 = dialogChartTagList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/resources/icon/arrow_down.gif")));
        this.jButtonMoveDown.setToolTipText("Move down");
        this.jButtonMoveDown.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTagList this$0;
            {
                DialogChartTagList dialogChartTagList = this$0;
                Objects.requireNonNull(dialogChartTagList);
                this.this$0 = dialogChartTagList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTagList this$0;
            {
                DialogChartTagList dialogChartTagList = this$0;
                Objects.requireNonNull(dialogChartTagList);
                this.this$0 = dialogChartTagList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonResetPosition.setText("Reset position");
        this.jButtonResetPosition.setToolTipText("Set the annotations's position to the top-left corner of its anchor block or the chart");
        this.jButtonResetPosition.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartTagList this$0;
            {
                DialogChartTagList dialogChartTagList = this$0;
                Objects.requireNonNull(dialogChartTagList);
                this.this$0 = dialogChartTagList;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonResetPositionActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane1).addGroup(layout.createSequentialGroup().addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonResetPosition, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveUp, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveDown, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 174, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose, -2, 73, -2))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp, this.jButtonRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 358, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonMoveUp, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonRemove).addComponent(this.jButtonHelp).addComponent(this.jButtonResetPosition)).addComponent(this.jButtonMoveDown, -1, -1, Short.MAX_VALUE)).addGap(9, 9, 9)));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        ChartTag t = this.jListTags.getSelectedValue();
        if (t != null && this.parent.getSelectedChart().getTags().contains((Object)t)) {
            this.parent.getSelectedChart().removeTag(t);
            this.updateAnnotationList();
            this.parent.fireChartMightHaveChanged();
            this.parent.getSelectedChart().onChartEvent(ChartEvent.createSoftChangeChartEvent(null));
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        if (this.jListTags.getSelectedIndex() == 0) {
            return;
        }
        int index = this.jListTags.getSelectedIndex();
        int newIndex = index - 1;
        this.tagListModel.add(newIndex, this.tagListModel.get(index));
        this.jListTags.setSelectedIndex(newIndex);
        this.tagListModel.remove(index + 1);
        this.updateTagOrder();
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        if (this.jListTags.getSelectedIndex() >= this.tagListModel.getSize() - 1) {
            return;
        }
        int index = this.jListTags.getSelectedIndex();
        int newIndex = index + 2;
        this.tagListModel.add(newIndex, this.tagListModel.get(index));
        this.jListTags.setSelectedIndex(newIndex);
        this.tagListModel.remove(index);
        this.updateTagOrder();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"chart-annotations.html");
    }

    private void jButtonResetPositionActionPerformed(ActionEvent evt) {
        ChartTag t = this.jListTags.getSelectedValue();
        if (t != null && this.parent.getSelectedChart().getTags().contains((Object)t)) {
            Rectangle2D.Float pos;
            t.x = 0.0f;
            t.y = 0.0f;
            if (t.getAnchorBlock() != null && (pos = this.parent.getSelectedChart().getBlockBounds(t.getAnchorBlock())) != null) {
                t.x = pos.x;
                t.y = pos.y;
            }
            this.parent.getSelectedChart().onChartEvent(ChartEvent.createSoftChangeChartEvent(null));
            this.parent.fireChartMightHaveChanged();
            this.tagTableModel.fireTableDataChanged();
            this.onListSelectionChanged();
        }
    }

    private static class ChartTagListRenderer
    extends JLabel
    implements ListCellRenderer<ChartTag> {
        private ChartTagListRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 16));
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ChartTag> jList, ChartTag tag, int index, boolean isSelected, boolean cellHasFocus) {
            String text = tag.getText();
            if (text == null || text.trim().isEmpty()) {
                this.setFont(this.getFont().deriveFont(2));
                text = "no text";
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            this.setText(text);
            this.setForeground(isSelected ? jList.getSelectionForeground() : jList.getForeground());
            this.setBackground(isSelected ? jList.getSelectionBackground() : jList.getBackground());
            return this;
        }
    }
}

