/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.chartgen;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartProperties;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbugs.ChartExporter;
import jsbugs.chartgen.ChartGenerationResult;
import jsbugs.chartgen.ParamDecoder;
import jsbugs.io.ImageFileType;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.project.Project;
import org.apache.commons.lang3.StringUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class ChartGenerator {
    private static final Logger LOGGER = Logger.getLogger(ChartGenerator.class.getName());
    private final ChartManager chartManager;
    private final SBdb sbdb;
    private final String urlTemplate;
    private Project project;
    private ChartTemplateBase template;
    private String filePath;
    private BlockProperties.ScaleType scaleType = BlockProperties.ScaleType.MD;
    private ChartProperties chartProperties;

    public ChartGenerator(ChartManager chartManager, SBdb sbdb, String filePath, String urlTemplate, BlockProperties.ScaleType scale) {
        this.setFilePath(filePath);
        this.chartManager = chartManager;
        this.sbdb = sbdb;
        this.filePath = filePath;
        this.urlTemplate = StringUtils.stripToNull((String)urlTemplate);
        this.scaleType = scale;
    }

    public ChartGenerationResult generateCharts() throws SQLException, SBException {
        ChartGenerationResult result = new ChartGenerationResult();
        Iterator<Well> it = this.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            if (well.getAcm() == 512 || well.getAcm() == 1024) continue;
            String filename = SB.makeFileName((String)well.getWellCode());
            File file = this.filePath.contains("<") ? this.getFile(filename) : new File(this.filePath + "\\" + filename + ".pdf");
            this.makeChart(well, file, result);
        }
        LOGGER.info("Chart generation completed successfully.");
        return result;
    }

    private void makeChart(Well well, File file, ChartGenerationResult result) throws SQLException {
        LOGGER.log(Level.INFO, "Processing well: {0}", well);
        BlockProperties bp = new BlockProperties(BlockProperties.ScaleType.MD);
        if (well.getHeader().getDefaultScale() > 0.0f) {
            bp.setScale(well.getHeader().getDefaultScale());
        } else {
            bp.setScale((float)WellBlock.getDefaultScale(well.getTopSampleDepth(), well.getBaseSampleDepth(), well.getWellUnits()));
        }
        bp.setUnits(well.getWellUnits());
        float[] depthBnds = ChartBlock.getDefaultDepthBounds(well, bp.getSingleScale());
        bp.setLimits(depthBnds[0], depthBnds[1]);
        try {
            Chart chart;
            if (this.scaleType == BlockProperties.ScaleType.AGE) {
                bp.setScale(20.0f);
                bp.setScaleType(BlockProperties.ScaleType.AGE);
            }
            well.loadInterps();
            WellInterp wellInterp = well.getInterp(0);
            well.loadInterp(wellInterp);
            wellInterp.loadLOC(well.getWellID());
            if (this.scaleType == BlockProperties.ScaleType.AGE) {
                bp.setMax((float)wellInterp.getLOC().getMaxAge());
                bp.setMin((float)wellInterp.getLOC().getMinAge());
            }
            ChartTemplate.BlockOcc bOcc = new ChartTemplate.BlockOcc(0, well.getWellID(), 0, 0, bp.getProperties(), null);
            if (this.template instanceof ChartTemplate) {
                chart = ChartFactory.createChart((ChartTemplate)this.template, this.sbdb, this.chartManager, bOcc);
            } else {
                chart = new Chart();
                if (this.chartProperties != null) {
                    chart.setProperties(this.chartProperties);
                }
                ChartBlockBase chartBlock = ChartFactory.createBlock(this.sbdb, (BlockTemplate)this.template, bOcc);
                if (wellInterp.getLOC() != null && wellInterp.getLOC().getMaxAge() > 0.0) {
                    ((ChartBlock)chartBlock).setAltMax((float)wellInterp.getLOC().getMaxAge() + 2.0f, BlockProperties.ScaleType.AGE);
                    ((ChartBlock)chartBlock).setAltMin(Math.max(0.0f, (float)wellInterp.getLOC().getMinAge() - 2.0f), BlockProperties.ScaleType.AGE);
                }
                chart.addBlock(chartBlock);
            }
            chart.setData();
            chart.doLayout();
            boolean chartWasNew = this.saveChart(chart, file, well);
            if (chartWasNew) {
                result.incrementCreated();
            } else {
                result.incrementUpdated();
            }
        }
        catch (IOException | RuntimeException | SQLException | InvalidFieldException | SBException e) {
            LOGGER.log(Level.WARNING, "Error saving chart - skipping this chart", e);
            result.incrementErrors();
        }
    }

    private boolean saveChart(Chart chart, File file, Well well) throws IOException, SQLException {
        boolean retval = false;
        if (!file.exists()) {
            retval = true;
        }
        ChartExporter.saveVectorImage(file, ImageFileType.PDF, chart, this.sbdb, false, true);
        if (this.urlTemplate != null) {
            String fileName = SB.makeFileName((String)well.getWellCode());
            String url = ParamDecoder.decodeParam(this.urlTemplate, fileName);
            String sql = "UPDATE " + this.sbdb.DBTableName("WELLS") + " SET CHART_URL=" + SB.DBString((String)url) + " WHERE WELL_CODE=" + SB.DBString((String)well.getWellCode());
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(sql);
                this.sbdb.commit();
            }
        }
        LOGGER.log(Level.INFO, "Saved chart of well: {0} in file: {1}", new Object[]{well.getWellName(), file.getName()});
        return retval;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProject(String projString) throws SQLException {
        if (StringUtils.isBlank((CharSequence)projString)) {
            LOGGER.warning("No project string supplied");
        }
        this.project = this.sbdb.getProject(projString);
        if (this.project != null) {
            LOGGER.log(Level.INFO, "Using project ''{0}''.", this.project.getName());
        } else {
            LOGGER.log(Level.WARNING, "Project ''{0}'' not found.", projString);
        }
    }

    private Iterator<Well> getWellIterator() throws SQLException, SBException {
        if (this.project != null) {
            return this.sbdb.getWellIterator(this.sbdb.getDefaultWellList(this.project.getID()).getID());
        }
        LinkedList<Well> allWells = new LinkedList<Well>();
        String sql = "SELECT well_id FROM " + this.sbdb.DBTableName("WELLS") + " ORDER BY well_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                try {
                    allWells.add(this.sbdb.getWell(wellID));
                }
                catch (SBException sbe) {
                    LOGGER.log(Level.WARNING, "Exception loading well with wellID: " + wellID, sbe);
                }
            }
        }
        this.sbdb.commit();
        return allWells.iterator();
    }

    private File getFile(String filename) {
        File file = new File(ParamDecoder.decodeParam(this.filePath, filename));
        LinkedList<File> parents = new LinkedList<File>();
        File parent = file;
        while (!(parent = parent.getParentFile()).exists()) {
            parents.push(parent);
        }
        while (!parents.isEmpty()) {
            parent = (File)parents.pop();
            boolean makeResult = parent.mkdir();
            if (makeResult) continue;
            throw new RuntimeException("Cannot create folder: " + parent.toString());
        }
        return file;
    }

    public Project getProject() {
        return this.project;
    }

    public void setTemplate(ChartTemplateBase template) {
        if (template == null) {
            throw new NullPointerException("Tried to set template to null");
        }
        this.template = template;
        LOGGER.log(Level.INFO, "Using chart template: {0}", template.getName());
    }

    public final void setFilePath(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            throw new IllegalArgumentException("File path cannot be blank");
        }
        this.filePath = filePath;
    }

    public void setChartProperties(ChartProperties chartProperties) {
        this.chartProperties = chartProperties;
    }

    public void setScaleType(BlockProperties.ScaleType type) {
        this.scaleType = type;
    }
}

