/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.igdunits;

import com.stratadata.model3.scheme.UnitEWBoundary;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.igdunits.PanelLithostratUnitEastWest;
import jsbugs.uiutil.ColourChooser;
import jsbugs.uiutil.ComboboxItem;
import jsbugs.uiutil.EnumCombo;
import jsbugs.uiutil.LithologyComboRenderer;
import jsbugs.userconnect.SbugsSession;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.Lithdesc;
import model3.Lithology;
import model3.LithostratUnit;
import model3.SBdb;
import util.InvalidFieldException;

public class DialogLithostratUnit
extends SBDialog {
    private final DefaultComboBoxModel modelHier = new DefaultComboBoxModel();
    private final DefaultComboBoxModel modelLithology = new DefaultComboBoxModel();
    private IGDScheme scheme = null;
    private LithostratUnit unit = null;
    private ColourChooser colourChooser1;
    private EnumCombo comboBoundaryE;
    private EnumCombo comboBoundaryW;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox<String> jComboBoxLithology;
    private JComboBox<String> jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelAbbr;
    private JLabel jLabelColour;
    private JLabel jLabelLithology;
    private JLabel jLabelName;
    private JLabel jLabelType;
    private JPanel jPanel1;
    private JTextField jTextFieldAbbreviation;
    private JTextField jTextFieldName;
    private PanelLithostratUnitEastWest panelLithostratUnitEWOldest;
    private PanelLithostratUnitEastWest panelLithostratUnitEWYoungest;

    public DialogLithostratUnit(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.jButtonOk);
        GroupLayout layout = (GroupLayout)this.getContentPane().getLayout();
        layout.linkSize(0, this.jButtonOk, this.jButtonCancel);
        this.jComboBoxLithology.setRenderer(new LithologyComboRenderer());
        this.panelLithostratUnitEWYoungest.setPosition(PanelLithostratUnitEastWest.Position.YONGEST);
        this.panelLithostratUnitEWOldest.setPosition(PanelLithostratUnitEastWest.Position.OLDEST);
        this.comboBoundaryE.init(UnitEWBoundary.class);
        this.comboBoundaryW.init(UnitEWBoundary.class);
    }

    public LithostratUnit.Builder getBuilder() {
        LithostratUnit.Builder builder = this.unit == null ? new LithostratUnit.Builder(SbugsSession.getDb()) : new LithostratUnit.Builder(SbugsSession.getDb(), this.unit);
        builder.name(this.jTextFieldName.getText());
        builder.abr(this.jTextFieldAbbreviation.getText());
        builder.hier((Integer)((ComboboxItem)this.jComboBoxType.getSelectedItem()).getValue());
        builder.lithology((Lithology)this.jComboBoxLithology.getSelectedItem());
        builder.colour(this.colourChooser1.getColour());
        this.panelLithostratUnitEWYoungest.updateBuilder(builder);
        this.panelLithostratUnitEWOldest.updateBuilder(builder);
        builder.EBnd((UnitEWBoundary)this.comboBoundaryE.getSelectedItem());
        builder.WBnd((UnitEWBoundary)this.comboBoundaryW.getSelectedItem());
        return builder;
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jLabelAbbr = new JLabel();
        this.jLabelType = new JLabel();
        this.jLabelLithology = new JLabel();
        this.jLabelColour = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldAbbreviation = new JTextField();
        this.jComboBoxType = new JComboBox();
        this.jComboBoxLithology = new JComboBox();
        this.panelLithostratUnitEWYoungest = new PanelLithostratUnitEastWest();
        this.panelLithostratUnitEWOldest = new PanelLithostratUnitEastWest();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.colourChooser1 = new ColourChooser();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboBoundaryW = new EnumCombo();
        this.comboBoundaryE = new EnumCombo();
        this.setDefaultCloseOperation(2);
        this.setTitle("Update Lithostrat Unit");
        this.setPreferredSize(new Dimension(300, 580));
        this.jLabelName.setText("Name");
        this.jLabelAbbr.setText("Abbreviation");
        this.jLabelType.setText("Type");
        this.jLabelLithology.setText("Lithology");
        this.jLabelColour.setText("Colour");
        this.jTextFieldName.setColumns(20);
        this.jTextFieldAbbreviation.setColumns(8);
        this.jComboBoxType.setModel(this.modelHier);
        this.jComboBoxLithology.setModel(this.modelLithology);
        this.panelLithostratUnitEWYoungest.setBorder(BorderFactory.createTitledBorder(null, "Youngest", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.panelLithostratUnitEWOldest.setBorder(BorderFactory.createTitledBorder(null, "Oldest", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLithostratUnit this$0;
            {
                DialogLithostratUnit dialogLithostratUnit = this$0;
                Objects.requireNonNull(dialogLithostratUnit);
                this.this$0 = dialogLithostratUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLithostratUnit this$0;
            {
                DialogLithostratUnit dialogLithostratUnit = this$0;
                Objects.requireNonNull(dialogLithostratUnit);
                this.this$0 = dialogLithostratUnit;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Shazam lines"));
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("West");
        this.jLabel1.setHorizontalTextPosition(4);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("East");
        this.jLabel2.setHorizontalTextPosition(4);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboBoundaryW, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.comboBoundaryE, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboBoundaryW, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboBoundaryE, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelAbbr).addComponent(this.jLabelName).addComponent(this.jLabelType).addComponent(this.jLabelLithology).addComponent(this.jLabelColour)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldName).addComponent(this.jComboBoxLithology, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.colourChooser1, -2, 82, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxType, -2, -1, -2).addComponent(this.jTextFieldAbbreviation, -2, 80, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.panelLithostratUnitEWOldest, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panelLithostratUnitEWYoungest, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAbbr).addComponent(this.jTextFieldAbbreviation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelType).addComponent(this.jComboBoxType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxLithology, -2, -1, -2).addComponent(this.jLabelLithology)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelColour).addComponent(this.colourChooser1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelLithostratUnitEWYoungest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelLithostratUnitEWOldest, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        boolean success = true;
        try {
            this.validateInputs();
            LithostratUnit.Builder builder = this.getBuilder();
            this.scheme.checkUpdatedUnit(builder);
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot update unit:\n" + e.getMessage(), this.getTitle(), 2);
            success = false;
        }
        if (success) {
            this.setIsOK(true);
            this.setVisible(false);
        }
    }

    public void setup(LithostratUnit.Builder lithBuilder, IGDScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme argument can't be null.");
        }
        this.unit = lithBuilder.getOriginal();
        this.scheme = scheme;
        this.populateLithoCombo();
        this.populateHierCombo();
        this.populateControlsFromBuilder(lithBuilder);
    }

    private void populateControlsFromBuilder(LithostratUnit.Builder builder) {
        this.jTextFieldName.setText(builder.getName());
        this.jTextFieldAbbreviation.setText(builder.getAbr());
        int hier = builder.getHier();
        this.jComboBoxType.setSelectedItem(new ComboboxItem<Integer>(hier, IGDIntervalZone.getHierName(this.scheme.getIGDType(), hier)));
        this.colourChooser1.setColour(builder.getColour());
        this.jComboBoxLithology.setSelectedItem(builder.getLithology());
        this.comboBoundaryE.setSelectedItem(builder.getEBnd());
        this.comboBoundaryW.setSelectedItem(builder.getWBnd());
        this.panelLithostratUnitEWOldest.populateFromBuilder(builder);
        this.panelLithostratUnitEWYoungest.populateFromBuilder(builder);
    }

    public void setup(LithostratUnit unit, IGDScheme scheme) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit argument can't be null.");
        }
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme argument can't be null.");
        }
        this.unit = unit;
        this.scheme = scheme;
        this.populateLithoCombo();
        this.populateHierCombo();
        this.populateControlsFromUnit();
    }

    private void populateControlsFromUnit() {
        this.jTextFieldName.setText(this.unit.getName());
        this.jTextFieldAbbreviation.setText(this.unit.getAbr());
        int hier = this.unit.getHier();
        this.jComboBoxType.setSelectedItem(new ComboboxItem<Integer>(hier, IGDIntervalZone.getHierName(this.scheme.getIGDType(), hier)));
        this.colourChooser1.setColour(this.unit.getColour());
        this.jComboBoxLithology.setSelectedItem(this.unit.getLithology());
        this.comboBoundaryE.setSelectedItem(this.unit.getEBnd());
        this.comboBoundaryW.setSelectedItem(this.unit.getWBnd());
        this.panelLithostratUnitEWOldest.populateFromUnit(this.unit);
        this.panelLithostratUnitEWYoungest.populateFromUnit(this.unit);
    }

    private SBdb getDB() {
        return SbugsSession.getDb();
    }

    private void populateLithoCombo() {
        try {
            this.modelLithology.addElement(null);
            for (Lithology lith : this.getDB().getLithdesc().getList(Lithdesc.LithType.MAIN)) {
                this.modelLithology.addElement(lith);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DialogLithostratUnit.class.getName()).log(Level.SEVERE, "Error occurred populating lithology combo box.", ex);
        }
    }

    private void populateHierCombo() {
        int nHier = IGDIntervalZone.getNHier(this.scheme.getIGDType(), true);
        for (int hier = 1; hier <= nHier; ++hier) {
            this.modelHier.addElement(new ComboboxItem<Integer>(hier, IGDIntervalZone.getHierName(this.scheme.getIGDType(), hier)));
        }
    }

    private void validateInputs() throws InvalidFieldException {
        if (this.jTextFieldName.getText().length() <= 0) {
            throw new InvalidFieldException("Unit name can't be empty.");
        }
        this.panelLithostratUnitEWYoungest.validateInputs();
        this.panelLithostratUnitEWOldest.validateInputs();
    }
}

